/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.jscomment.lexing;

import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;

public class MultiLineTerminatorMatcher
extends AbstractTextMatcher {
    public void addChildTypes() {
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        map.addCharacterMatcher('\r', target);
        map.addCharacterMatcher('\n', target);
        map.addWhitespaceMatcher(target);
    }

    public int match(char[] source, int offset, int eofset) {
        char c;
        int result = offset;
        while (result < eofset) {
            c = source[result];
            if (!Character.isWhitespace(c) || c == '\r' || c == '\n') break;
            ++result;
        }
        if (result < eofset && (source[result] == '\r' || source[result] == '\n')) {
            if (source[result] == '\r') {
                ++result;
            }
            if (result < eofset && source[result] == '\n') {
                ++result;
            }
            while (result < eofset) {
                c = source[result];
                if (!Character.isWhitespace(c) || c == '\r' || c == '\n') break;
                ++result;
            }
            if (this.token != null) {
                this.setMatchedToken(this.token);
            }
        } else {
            result = -1;
        }
        return result;
    }
}

