/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc;

import com.aptana.ide.editor.scriptdoc.Messages;
import com.aptana.ide.editor.scriptdoc.ScriptDocLanguageEnvironment;
import com.aptana.ide.editor.scriptdoc.ScriptDocOffsetMapper;
import com.aptana.ide.editors.unified.BaseFileLanguageService;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.IOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;

public class ScriptDocFileLanguageService
extends BaseFileLanguageService {
    private ScriptDocLanguageEnvironment languageEnvironment = ScriptDocLanguageEnvironment.getInstance();
    private boolean isProfileMember;
    private ScriptDocOffsetMapper offsetMapper;

    public ScriptDocFileLanguageService(FileService fileService, IParseState parseState, IParser parser, IParentOffsetMapper mapper) {
        super(fileService, parseState, parser, mapper);
        this.createOffsetMapper(mapper);
    }

    public String getDocumentationFromLexeme(Lexeme lexeme) {
        String result = null;
        switch (lexeme.typeIndex) {
            case 7: {
                result = Messages.ScriptDocFileLanguageService_Author;
                break;
            }
            case 26: {
                result = Messages.ScriptDocFileLanguageService_ClassDescription;
                break;
            }
            case 24: {
                result = Messages.ScriptDocFileLanguageService_Constructor;
                break;
            }
            case 17: {
                result = Messages.ScriptDocFileLanguageService_Deprecated;
                break;
            }
            case 29: {
                result = Messages.ScriptDocFileLanguageService_Exception;
                break;
            }
            case 20: {
                result = Messages.ScriptDocFileLanguageService_Internal;
                break;
            }
            case 27: {
                result = Messages.ScriptDocFileLanguageService_MemberOf;
                break;
            }
            case 25: {
                result = Messages.ScriptDocFileLanguageService_Method;
                break;
            }
            case 21: {
                result = Messages.ScriptDocFileLanguageService_Native;
                break;
            }
            case 28: {
                result = Messages.ScriptDocFileLanguageService_Param;
                break;
            }
            case 18: {
                result = Messages.ScriptDocFileLanguageService_Private;
                break;
            }
            case 14: {
                result = Messages.ScriptDocFileLanguageService_ProjectDescription;
                break;
            }
            case 46: {
                result = Messages.ScriptDocFileLanguageService_Property;
                break;
            }
            case 30: {
                result = Messages.ScriptDocFileLanguageService_Return;
                break;
            }
            case 12: {
                result = Messages.ScriptDocFileLanguageService_See;
                break;
            }
            case 11: {
                result = Messages.ScriptDocFileLanguageService_Since;
                break;
            }
            case 23: {
                result = Messages.ScriptDocFileLanguageService_Type;
                break;
            }
            case 8: {
                result = Messages.ScriptDocFileLanguageService_Version;
                break;
            }
        }
        return result;
    }

    public ScriptDocLanguageEnvironment getLanguageEnvironment() {
        return this.languageEnvironment;
    }

    public String getDefaultLanguage() {
        return "text/scriptdoc";
    }

    public IParseState getParseState() {
        return this.getParseState("text/scriptdoc");
    }

    public static ScriptDocFileLanguageService getScriptDocFileLanguageService(IFileService fileContext) {
        ScriptDocFileLanguageService languageService = (ScriptDocFileLanguageService)fileContext.getLanguageService("text/scriptdoc");
        if (languageService == null) {
            throw new IllegalStateException(Messages.ScriptDocFileLanguageService_NoScriptDocLanguageService);
        }
        return languageService;
    }

    public boolean isProfileMember() {
        return this.isProfileMember;
    }

    public void setProfileMember(boolean isProfileMember) {
        this.isProfileMember = isProfileMember;
    }

    public void reset(boolean resetFileIndex) {
    }

    public IOffsetMapper getOffsetMapper() {
        return this.offsetMapper;
    }

    public void createOffsetMapper(IParentOffsetMapper parent) {
        this.offsetMapper = new ScriptDocOffsetMapper(parent);
    }
}

