/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing;

import com.aptana.ide.editor.scriptdoc.lexing.ScriptDocTokenTypes;
import com.aptana.ide.editor.scriptdoc.parsing.DocumentationBase;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.Messages;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.ScriptDocParseNode;
import com.aptana.ide.editor.scriptdoc.parsing.ScriptDocParseState;
import com.aptana.ide.editor.scriptdoc.parsing.ScriptDocParserBase;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.unified.folding.GenericCommentNode;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.metadata.IDocumentation;
import com.aptana.ide.metadata.IDocumentationStore;
import com.aptana.ide.parsing.CodeLocation;
import com.aptana.ide.parsing.ErrorMessage;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.text.ParseException;

public class ScriptDocParser
extends ScriptDocParserBase {
    public static final String INDENT_GROUP = "indent";
    private IDocumentation _rootNode;
    private FunctionDocumentation _parsedObject;
    private IParseNode _curParent;
    private String _curScriptNamespace = "";

    public ScriptDocParser() throws ParserInitializationException {
        this("text/scriptdoc");
    }

    public ScriptDocParser(String mimeType) throws ParserInitializationException {
        super(mimeType);
    }

    public synchronized void parseAll(IParseNode parentNode) throws LexerException {
        this._curParent = parentNode;
        this.startingIndex = -1;
        this.endingIndex = -1;
        ILexer lexer = this.getLexer();
        lexer.setLanguageAndGroup(this.getLanguage(), "default");
        try {
            this._parsedObject = this.parseDocumentation();
        }
        catch (ParseException parseException) {
            lexer.setCurrentOffset(lexer.getEOFOffset());
        }
        IParseState parseState = this.getParseState();
        if (!(parseState instanceof ScriptDocParseState)) {
            throw new IllegalStateException(Messages.ScriptDocParser_MustHaveScriptDocParseState);
        }
        ScriptDocParseState scriptDocParseState = (ScriptDocParseState)parseState;
        LexemeList lexemes = this.getLexemeList();
        Lexeme lastLexeme = lexemes.get(lexemes.size() - 1);
        IDocumentationStore documentationStore = scriptDocParseState.getDocumentationStore();
        documentationStore.addScriptDocObject(lexer.getCurrentOffset(), lastLexeme, (IDocumentation)this._parsedObject);
        if (this.endingIndex != -1 && this.startingIndex != -1) {
            GenericCommentNode node = new GenericCommentNode(this.startingIndex, this.endingIndex, "SDCOMMENT", "text/javascript");
            this.getParseState().addCommentRegion((IParseNode)node);
        }
    }

    public FunctionDocumentation getParsedObject() {
        return this._parsedObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FunctionDocumentation parseDocumentation() throws ParseException, LexerException {
        FunctionDocumentation fd = new FunctionDocumentation();
        this._rootNode = fd;
        boolean wasNull = false;
        if (this.currentLexeme == null) {
            this.advance();
            wasNull = true;
        }
        if (this.currentLexeme == EOS) {
            this.advance();
            if (this.currentLexeme == null || this.currentLexeme == EOS) return fd;
            this._curNode = new ScriptDocParseNode(this.currentLexeme);
            this._curNode.includeLexemeInRange(this.currentLexeme);
        } else {
            this._curNode = new ScriptDocParseNode(this.currentLexeme);
            if (!wasNull) {
                this.advance();
            }
        }
        if (this.currentLexeme == EOS) return fd;
        if (this._curParent != null) {
            this._curParent.appendChild((IParseNode)this._curNode);
        }
        this._curNode.setDocument(this._parsedObject);
        this.assertAndAdvance(1);
        fd.setDescription(this.parseText());
        while (this._holderLexeme != EOS) {
            this.parseFunctionDocumentationSection(fd);
        }
        return fd;
    }

    public void setSource(String source) {
        this.getLexer().setSource(source);
    }

    private boolean parseBaseTags(DocumentationBase bd) throws LexerException {
        boolean result = false;
        if (this._holderLexeme.getCategoryIndex() == 3) {
            try {
                switch (this._holderLexeme.typeIndex) {
                    case 48: {
                        this.advance();
                        result = true;
                        break;
                    }
                    case 7: {
                        this.advance();
                        bd.setAuthor(this.parseText());
                        result = true;
                        break;
                    }
                    case 8: {
                        this.advance();
                        bd.setVersion(this.parseText());
                        result = true;
                        break;
                    }
                    case 12: {
                        this.advance();
                        bd.addSee(this.parseText());
                        result = true;
                        break;
                    }
                    case 13: {
                        this.advance();
                        bd.addSDocLocation(this.parseText());
                        result = true;
                        break;
                    }
                    case 22: {
                        this.advance();
                        this.parseNamespace();
                        result = true;
                        break;
                    }
                    case 9: {
                        this.advance();
                        this.parseText();
                        result = true;
                        break;
                    }
                    case 10: {
                        this.advance();
                        this.parseText();
                        result = true;
                        break;
                    }
                    case 45: {
                        this.advance();
                        bd.addExample(this.parseText());
                        result = true;
                        break;
                    }
                    case 47: {
                        this.advance();
                        this.parseText();
                        result = true;
                        break;
                    }
                    case 14: {
                        this.advance();
                        bd.setDescription(this.parseText());
                        bd.setDocumentType(2);
                        result = true;
                    }
                }
            }
            catch (ParseException e) {
                this.skipTag(e);
            }
        } else {
            try {
                String desc = this.parseText();
                if (!"".equals(desc)) {
                    bd.setDescription(desc);
                }
            }
            catch (ParseException e) {
                this.skipTag(e);
            }
        }
        return result;
    }

    private boolean parsePropertyTags(PropertyDocumentation pd) throws LexerException {
        boolean found = this.parseBaseTags(pd);
        if (found) {
            return true;
        }
        boolean result = false;
        if (!found && this._holderLexeme.getCategoryIndex() == 3) {
            try {
                switch (this._holderLexeme.typeIndex) {
                    case 27: {
                        this.advance();
                        this.parseMemberOf(pd);
                        result = true;
                        break;
                    }
                    case 16: {
                        this.advance();
                        pd.setIsIgnored(true);
                        result = true;
                        break;
                    }
                    case 23: {
                        this.advance();
                        this.parseTypeValue(pd);
                        pd.setDocumentType(1);
                        result = true;
                        break;
                    }
                    case 11: {
                        this.advance();
                        pd.setSince(this.parseText());
                        result = true;
                        break;
                    }
                    case 17: {
                        this.advance();
                        pd.setIsDeprecated(true);
                        pd.setDeprecatedDescription(this.parseText());
                        result = true;
                        break;
                    }
                    case 18: {
                        this.advance();
                        pd.setIsPrivate(true);
                        result = true;
                        break;
                    }
                    case 46: {
                        this.advance();
                        pd.setDocumentType(1);
                        break;
                    }
                    case 20: {
                        this.advance();
                        pd.setIsInternal(true);
                        result = true;
                        break;
                    }
                    case 21: {
                        this.advance();
                        pd.setIsNative(true);
                        result = true;
                        break;
                    }
                    case 6: {
                        this.advance();
                        this.parseAlias(pd);
                        result = true;
                        break;
                    }
                    case 15: {
                        this.advance();
                        this.parseID(pd);
                        result = true;
                        break;
                    }
                }
            }
            catch (ParseException e) {
                this.skipTag(e);
            }
        }
        return result;
    }

    private void parseFunctionDocumentationSection(FunctionDocumentation fd) throws LexerException {
        boolean found = this.parsePropertyTags(fd);
        if (found) {
            return;
        }
        if (this._holderLexeme.getCategoryIndex() == 3) {
            try {
                switch (this._holderLexeme.typeIndex) {
                    case 28: {
                        this.advance();
                        this.parseParams(fd);
                        fd.setDocumentType(0);
                        break;
                    }
                    case 30: {
                        this.advance();
                        this.parseReturnValue(fd);
                        fd.setDocumentType(0);
                        break;
                    }
                    case 29: {
                        this.advance();
                        this.parseException(fd);
                        break;
                    }
                    case 26: {
                        this.advance();
                        fd.setClassDescription(this.parseText());
                        break;
                    }
                    case 24: {
                        this.advance();
                        fd.setIsConstructor(true);
                        fd.setDocumentType(0);
                        break;
                    }
                    case 25: {
                        this.advance();
                        fd.setIsMethod(true);
                        fd.setDocumentType(0);
                        fd.setMethodName(this.parseText());
                        break;
                    }
                    case 31: {
                        this.advance();
                        this.parseExtends(fd);
                        fd.setDocumentType(0);
                        break;
                    }
                    case 16: {
                        this.advance();
                        fd.setIsIgnored(true);
                        break;
                    }
                    default: {
                        this.skipTag(new ParseException(String.valueOf(Messages.ScriptDocParser_InvalidSyntax) + this._holderLexeme.getType(), 0));
                        break;
                    }
                }
            }
            catch (ParseException e) {
                this.skipTag(e);
            }
        } else if (this._holderLexeme.typeIndex == 32) {
            this._curNode.includeLexemeInRange(this.currentLexeme);
            this.advance();
        } else {
            this.skipTag(new ParseException(String.valueOf(Messages.ScriptDocParser_InvalidSyntaxForStatement) + this._holderLexeme.getType(), 0));
        }
    }

    private void parseAlias(PropertyDocumentation pd) throws ParseException, LexerException {
        pd.getAliases().addType(this.getIdentifier());
    }

    private void parseID(PropertyDocumentation pd) throws ParseException, LexerException {
        LexemeList lexemes = this.getLexemeList();
        Lexeme start = this.currentLexeme;
        String id = this.getIdentifier();
        Lexeme end = lexemes.get(lexemes.size() - 1);
        String dot = this._curScriptNamespace.equals("") ? "" : ".";
        String fullname = String.valueOf(this._curScriptNamespace) + dot + id;
        String uri = FileContextManager.getURIFromFileIndex((int)this.getParseState().getFileIndex());
        pd.setID(fullname, new CodeLocation(uri, start, end));
    }

    private void parseNamespace() throws ParseException, LexerException {
        this._curScriptNamespace = this.getIdentifier();
        this.parseText();
    }

    private void parseReturnValue(PropertyDocumentation pd) throws ParseException, LexerException {
        this.parseIntoTypedDescription(pd.getReturn(), false);
    }

    private void parseTypeValue(PropertyDocumentation pd) throws ParseException, LexerException {
        boolean isIdent;
        boolean hasType = this._holderLexeme.typeIndex == 33;
        boolean bl = isIdent = this._holderLexeme.typeIndex == 39 || this._holderLexeme.typeIndex == 4 || this._holderLexeme.typeIndex == 41;
        if (hasType || !isIdent) {
            this.parseIntoTypedDescription(pd.getReturn(), false);
        } else {
            boolean hasFollowText;
            String type = this.getIdentifier();
            boolean bl2 = hasFollowText = this._holderLexeme.typeIndex == 39 || this._holderLexeme.typeIndex == 4;
            if (hasFollowText) {
                String text = String.valueOf(type) + this.parseText();
                pd.getReturn().setDescription(text);
            } else {
                pd.getReturn().addType(type);
            }
        }
    }

    private void parseParams(FunctionDocumentation fd) throws ParseException, LexerException {
        TypedDescription td = new TypedDescription();
        this.parseIntoTypedDescription(td, true);
        fd.addParam(td);
    }

    private void parseExtends(FunctionDocumentation fd) throws ParseException, LexerException {
        this.parseIntoTypedDescription(fd.getExtends(), false);
    }

    private void parseException(FunctionDocumentation fd) throws ParseException, LexerException {
        TypedDescription td = new TypedDescription();
        this.parseIntoTypedDescription(td, false);
        fd.addException(td);
    }

    private void parseMemberOf(PropertyDocumentation pd) throws ParseException, LexerException {
        this.parseIntoTypedDescription(pd.getMemberOf(), false);
    }

    private void parseIntoTypedDescription(TypedDescription td, boolean includeName) throws ParseException, LexerException {
        boolean hasType;
        boolean bl = hasType = this._holderLexeme.typeIndex == 33;
        if (hasType) {
            this.assertAndAdvance(33);
            if (this._holderLexeme.typeIndex == 39 || this._holderLexeme.typeIndex == 41) {
                td.addType(this.getIdentifier());
            } else {
                this.throwParseError(Messages.ScriptDocParser_InvalidID);
            }
            while (this._holderLexeme != EOS && (this._holderLexeme.typeIndex == 42 || this._holderLexeme.typeIndex == 43 || this._holderLexeme.typeIndex == 44)) {
                this.advance();
                td.addType(this.getIdentifier());
            }
            this.assertAndAdvance(40);
        }
        if (includeName) {
            td.setName(this.getIdentifier());
        }
        td.setDescription(this.parseText());
    }

    private String getIdentifier() throws ParseException, LexerException {
        String result = "";
        boolean isOptional = false;
        if (this._holderLexeme.typeIndex == 36) {
            isOptional = true;
            result = String.valueOf(result) + "[";
            this.advance();
        }
        if (this._holderLexeme.typeIndex == 39 || this._holderLexeme.typeIndex == 4) {
            result = String.valueOf(result) + this._holderLexeme.getText();
            this.advance();
        } else if (this._holderLexeme.typeIndex == 41) {
            result = this._holderLexeme.getText();
            this.advance();
        } else {
            this.throwParseError(Messages.ScriptDocParser_InvalidIdInComment);
        }
        if (isOptional) {
            result = String.valueOf(result) + "]";
            this.assertAndAdvance(37);
        }
        return result;
    }

    private String parseText() throws ParseException, LexerException {
        StringBuilder text = new StringBuilder();
        block6: while (this._holderLexeme != EOS) {
            switch (this._holderLexeme.getCategoryIndex()) {
                case 1: {
                    break;
                }
                case 5: {
                    String hText = this._holderLexeme.getText();
                    if (hText.startsWith("@")) break block6;
                    text.append(hText);
                    text.append(" ");
                    break;
                }
                case 3: {
                    if (this._holderLexeme.typeIndex != 5 && this._holderLexeme.typeIndex != 11) break block6;
                    text.append(this._holderLexeme.getText());
                    break;
                }
                case 4: {
                    if (this._holderLexeme.typeIndex == 32) {
                        this._curNode.includeLexemeInRange(this.currentLexeme);
                        break block6;
                    }
                    text.append(this._holderLexeme.getText());
                    text.append(" ");
                    break;
                }
                default: {
                    text.append(this._holderLexeme.getText());
                    text.append(" ");
                }
            }
            this.advance();
        }
        return text.toString();
    }

    private String getFollowText() {
        ILexer lexer = this.getLexer();
        if (lexer.getSource().length() > lexer.getCurrentOffset()) {
            int len = Math.min(6, lexer.getSource().length() - lexer.getCurrentOffset());
            return "\"" + lexer.getSource().substring(lexer.getCurrentOffset(), lexer.getCurrentOffset() + len) + "\"";
        }
        return "end of document";
    }

    private void assertAndAdvance(int type) throws ParseException, LexerException {
        this.assertType(type);
        this.advance();
    }

    private void assertType(int type) throws ParseException {
        if (this._holderLexeme.typeIndex != type) {
            String targetType = ScriptDocTokenTypes.getName(type);
            String actualType = ScriptDocTokenTypes.getName(this._holderLexeme.typeIndex);
            if (this._holderLexeme == EOS) {
                actualType = this.getFollowText();
            }
            this.throwParseError(String.valueOf(Messages.ScriptDocParser_Expected) + targetType + Messages.ScriptDocParser_Found + actualType);
        }
    }

    private void skipTag(ParseException e) throws LexerException {
        LexemeList lexemes = this.getLexemeList();
        Lexeme targetLexeme = null;
        if (this._holderLexeme == EOS && lexemes.size() > 1) {
            targetLexeme = lexemes.get(lexemes.size() - 2);
        } else {
            this.advance();
            while (this._holderLexeme != EOS) {
                targetLexeme = this._holderLexeme;
                if (this._holderLexeme.getCategoryIndex() != 3) {
                    this.advance();
                    continue;
                }
                if (this._holderLexeme.typeIndex != 5) break;
                this.advance();
            }
        }
        ErrorMessage en = new ErrorMessage(e.getMessage(), (IRange)targetLexeme);
        if (e != null) {
            this._rootNode.addError(en);
        }
    }

    protected void throwParseError(String message) throws ParseException {
        int lastValid;
        LexemeList lexemes = this.getLexemeList();
        int n = lastValid = this._holderLexeme == EOS ? lexemes.size() - 2 : lexemes.size() - 1;
        if (lastValid < 0) {
            message = Messages.ScriptDocParser_PrematureEndOfDoc;
        } else {
            String position = this._holderLexeme != EOS ? " [" + this._holderLexeme.getText() + "]" : " [" + this.getFollowText() + "]";
            message = String.valueOf(Messages.ScriptDocParser_ParseError) + position + ": " + message;
        }
        throw new ParseException(message, -1);
    }
}

