/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing.reader;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.scriptdoc.parsing.AliasEntry;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.ProjectDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.ScriptDoc;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ForeignScriptDocInfo;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ForeignScriptDocManager;
import com.aptana.ide.editor.scriptdoc.parsing.reader.Messages;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ScriptDocException;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ScriptDocInitializationException;
import com.aptana.ide.io.StreamUtils;
import com.aptana.ide.metadata.UserAgent;
import com.aptana.sax.NamespaceSniffer;
import com.aptana.sax.SchemaBuilder;
import com.aptana.sax.SchemaInitializationException;
import com.aptana.sax.ValidatingReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.Plugin;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ScriptDocReader
extends ValidatingReader {
    private ScriptDoc _documentation;
    private ProjectDocumentation _currentProject;
    private PropertyDocumentation _currentProperty;
    private TypedDescription _currentParameter;
    private FunctionDocumentation _currentClass;
    private FunctionDocumentation _currentMethod;
    private TypedDescription _currentValue;
    private boolean _inReturnType;
    private int _returnTypeCount;
    private boolean _currentException = false;
    private List<FunctionDocumentation> _functions;
    private List<PropertyDocumentation> _properties;
    private List<AliasEntry> _aliases;
    private List<String> _references;
    private boolean _bufferText;
    private String _textBuffer;
    private boolean _parsingCtors;
    private UserAgent _currentUserAgent;
    private boolean _sourceInstanceProperties;

    public ScriptDocReader() throws ScriptDocInitializationException {
        InputStream schemaStream = ScriptDocReader.class.getResourceAsStream("/com/aptana/ide/editor/scriptdoc/resources/DocumentationSchema.xml");
        try {
            try {
                this._schema = SchemaBuilder.fromXML((InputStream)schemaStream, (Object)((Object)this));
            }
            catch (SchemaInitializationException e) {
                String msg = Messages.ScriptDocReader_SchemaError;
                ScriptDocInitializationException ie = new ScriptDocInitializationException(msg, (Exception)((Object)e));
                throw ie;
            }
        }
        finally {
            try {
                schemaStream.close();
            }
            catch (IOException e) {
                String msg = Messages.ScriptDocReader_IOError;
                ScriptDocInitializationException ie = new ScriptDocInitializationException(msg, e);
                throw ie;
            }
        }
        this._functions = new ArrayList<FunctionDocumentation>();
        this._properties = new ArrayList<PropertyDocumentation>();
        this._aliases = new ArrayList<AliasEntry>();
        this._references = new ArrayList<String>();
    }

    public void characters(char[] buffer, int offset, int length) {
        if (this._bufferText) {
            this._textBuffer = String.valueOf(this._textBuffer) + new String(buffer, offset, length);
        }
    }

    public void enterAlias(String ns, String name, String qname, Attributes attributes) {
        String aliasName = attributes.getValue("name");
        String aliasType = attributes.getValue("type");
        if (aliasName != null && aliasName.length() > 0 && aliasType != null && aliasType.length() > 0) {
            this._aliases.add(new AliasEntry(aliasName, aliasType));
        }
    }

    public void enterBrowser(String ns, String name, String qname, Attributes attributes) {
        String osVersion;
        String os;
        UserAgent field = new UserAgent();
        String platform = attributes.getValue("platform");
        field.setPlatform(platform);
        String version = attributes.getValue("version");
        if (version != null) {
            field.setVersion(version);
        }
        if ((os = attributes.getValue("os")) != null) {
            field.setOs(os);
        }
        if ((osVersion = attributes.getValue("osVersion")) != null) {
            field.setOsVersion(osVersion);
        }
        this._currentUserAgent = field;
    }

    public void enterClass(String ns, String name, String qname, Attributes attributes) {
        FunctionDocumentation classDoc = new FunctionDocumentation();
        String type = attributes.getValue("type");
        String superclass = attributes.getValue("superclass");
        classDoc.setName(type);
        if (superclass != null && superclass.length() > 0) {
            String[] types;
            String[] stringArray = types = superclass.split("\\s+");
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String superType = stringArray[n2];
                if (type != null && type.length() > 0) {
                    classDoc.getExtends().addType(superType);
                }
                ++n2;
            }
        }
        this._currentClass = classDoc;
        this._functions.add(this._currentClass);
    }

    public void enterConstructors(String ns, String name, String qname, Attributes attributes) {
        this._parsingCtors = true;
    }

    public void enterException(String ns, String name, String qname, Attributes attributes) {
        this._currentException = true;
    }

    public void enterMethod(String ns, String name, String qname, Attributes attributes) {
        FunctionDocumentation methodDoc = new FunctionDocumentation();
        if (this._parsingCtors) {
            methodDoc.setExtends(this._currentClass.getExtends());
            methodDoc.setIsConstructor(true);
            methodDoc.setIsMethod(false);
        } else {
            methodDoc.setIsConstructor(false);
            methodDoc.setIsMethod(true);
        }
        String mname = attributes.getValue("name");
        if (mname == null) {
            methodDoc.setName("#ctor");
        } else {
            methodDoc.setName(mname);
        }
        String scope = attributes.getValue("scope");
        if (scope != null && scope.equals("instance")) {
            methodDoc.setIsInstance(true);
        } else if (scope.equals("invocation")) {
            methodDoc.setIsInvocationOnly(true);
        }
        String visibility = attributes.getValue("visibility");
        if (visibility != null && visibility.equals("internal")) {
            methodDoc.setIsInternal(true);
        }
        methodDoc.getMemberOf().addType(this._currentClass.getName());
        this._currentMethod = methodDoc;
        this._returnTypeCount = 0;
    }

    public void enterMixin(String ns, String name, String qname, Attributes attributes) {
        String scope = attributes.getValue("scope");
        String type = attributes.getValue("type");
        boolean targetInstanceProperties = "instance".equals(scope);
        this._currentClass.addMixin(type, this._sourceInstanceProperties, targetInstanceProperties);
    }

    public void enterMixins(String ns, String name, String qname, Attributes attributes) {
        String scope = attributes.getValue("scope");
        this._sourceInstanceProperties = "instance".equals(scope);
    }

    public void enterParameter(String ns, String name, String qname, Attributes attributes) {
        TypedDescription parameter = new TypedDescription();
        String pname = attributes.getValue("name");
        String type = attributes.getValue("type");
        parameter.setName(pname);
        parameter.addType(type);
        this._currentParameter = parameter;
    }

    public void enterProperty(String ns, String name, String qname, Attributes attributes) {
        String[] types;
        PropertyDocumentation propertyDoc = new PropertyDocumentation();
        String pname = attributes.getValue("name");
        String type = attributes.getValue("type");
        propertyDoc.setName(pname);
        String scope = attributes.getValue("scope");
        if (scope.equals("instance")) {
            propertyDoc.setIsInstance(true);
        } else if (scope.equals("invocation")) {
            propertyDoc.setIsInvocationOnly(true);
        }
        String[] stringArray = types = type.split("\\s*\\|\\s*");
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyType = stringArray[n2];
            if (propertyType != null && propertyType.length() > 0) {
                propertyDoc.getReturn().addType(propertyType);
            }
            ++n2;
        }
        propertyDoc.getMemberOf().addType(this._currentClass.getName());
        this._currentProperty = propertyDoc;
    }

    public void enterReference(String ns, String name, String qname, Attributes attributes) {
        String rname = attributes.getValue("name");
        this._references.add(rname);
    }

    public void enterReturnType(String ns, String name, String qname, Attributes attributes) {
        String type = attributes.getValue("type");
        this._currentMethod.getReturn().addType(type);
        this._inReturnType = true;
        ++this._returnTypeCount;
    }

    public void enterValue(String ns, String name, String qname, Attributes attributes) {
        TypedDescription field = new TypedDescription();
        String fieldName = attributes.getValue("name");
        field.setName(fieldName);
        String fieldType = attributes.getValue("description");
        field.setDescription(fieldType);
        this._currentValue = field;
    }

    public void exitBrowser(String ns, String name, String qname) {
        if (this._currentProperty != null) {
            this._currentProperty.addUserAgent(this._currentUserAgent);
        } else if (this._currentMethod != null) {
            this._currentMethod.addUserAgent(this._currentUserAgent);
        } else if (this._currentClass != null) {
            this._currentClass.addUserAgent(this._currentUserAgent);
        }
        this._currentUserAgent = null;
    }

    public void exitClass(String ns, String name, String qname) {
        this._currentClass = null;
    }

    public void exitConstructors(String ns, String name, String qname) {
        this._parsingCtors = false;
    }

    public void exitDeprecated(String ns, String name, String qname) {
        if (this._currentProperty != null) {
            this._currentProperty.setDeprecatedDescription(this._textBuffer);
        } else if (this._currentMethod != null) {
            this._currentMethod.setDeprecatedDescription(this._textBuffer);
        } else if (this._currentClass != null) {
            this._currentClass.setDeprecatedDescription(this._textBuffer);
        }
        this._textBuffer = "";
        this._bufferText = false;
    }

    public void exitDescription(String ns, String name, String qname) {
        if (this._currentParameter != null) {
            this._currentParameter.setDescription(this._textBuffer);
        } else if (this._currentException) {
            this._currentException = this._currentException;
        } else if (this._currentProperty != null) {
            this._currentProperty.setDescription(this._textBuffer);
        } else if (this._currentMethod != null) {
            if (this._inReturnType) {
                String description = this._currentMethod.getDescription();
                String[] returnTypes = this._currentMethod.getReturn().getTypes();
                String text = "";
                if (this._returnTypeCount == 1) {
                    text = "<b>Returns:</b><br>";
                }
                if (returnTypes != null && returnTypes.length > 0) {
                    String returnType = returnTypes[returnTypes.length - 1];
                    text = String.valueOf(text) + "<b>" + returnType + "</b>: " + this._textBuffer;
                } else {
                    text = String.valueOf(text) + this._textBuffer;
                }
                description = description != null && description.length() > 0 ? String.valueOf(description) + "<br><br>" + text : text;
                this._currentMethod.setDescription(description);
            } else {
                this._currentMethod.setDescription(this._textBuffer);
            }
        } else if (this._currentClass != null) {
            this._currentClass.setDescription(this._textBuffer);
        } else if (this._currentProject != null) {
            this._currentProject.setDescription(this._textBuffer);
        } else if (this._currentUserAgent != null) {
            this._currentUserAgent.setDescription(this._textBuffer);
        }
        this._textBuffer = "";
        this._bufferText = false;
    }

    public void exitExample(String ns, String name, String qname) {
        if (this._currentProperty != null) {
            this._currentProperty.addExample(this._textBuffer);
        } else if (this._currentMethod != null) {
            this._currentMethod.addExample(this._textBuffer);
        } else {
            this._currentClass.addExample(this._textBuffer);
        }
        this._textBuffer = "";
        this._bufferText = false;
    }

    public void exitException(String ns, String name, String qname) {
        this._currentException = false;
    }

    public void exitJavaScript(String ns, String name, String qname) {
        this._documentation = new ScriptDoc();
        this._documentation.setProject(this._currentProject);
        this._documentation.setFunctions(this._functions.toArray(new FunctionDocumentation[this._functions.size()]));
        this._documentation.setProperties(this._properties.toArray(new PropertyDocumentation[this._properties.size()]));
        this._documentation.setAliases(this._aliases.toArray(new AliasEntry[this._aliases.size()]));
        this._functions.clear();
    }

    public void exitMethod(String ns, String name, String qname) {
        this._functions.add(this._currentMethod);
        this._currentMethod = null;
    }

    public void exitParameter(String ns, String name, String qname) {
        if (this._currentParameter == null) {
            throw new IllegalArgumentException(Messages.ScriptDocReader_ParamNullError);
        }
        this._currentMethod.addParam(this._currentParameter);
        this._currentParameter = null;
    }

    public void exitProperty(String ns, String name, String qname) {
        if (this._currentProperty == null) {
            throw new IllegalArgumentException(Messages.ScriptDocReader_PropertyNullError);
        }
        this._properties.add(this._currentProperty);
        this._currentProperty = null;
    }

    public void exitRemarks(String ns, String name, String qname) {
        if (this._currentProperty != null) {
            this._currentProperty.setRemarks(this._textBuffer);
        } else if (this._currentMethod != null) {
            this._currentMethod.setRemarks(this._textBuffer);
        } else {
            this._currentClass.setRemarks(this._textBuffer);
        }
        this._textBuffer = "";
        this._bufferText = false;
    }

    public void exitReturnDescription(String ns, String name, String qname) {
        if (this._currentMethod != null) {
            this._currentMethod.getReturn().setDescription(this._textBuffer);
        }
        this._textBuffer = "";
        this._bufferText = false;
    }

    public void exitReturnType(String ns, String name, String qname) {
        this._inReturnType = false;
    }

    public void exitValue(String ns, String name, String qname) {
        this._currentParameter.addDefaultValue(this._currentValue);
        this._currentValue = null;
    }

    private InputStream getAptanaDocumentationStream(InputStream stream) {
        String source;
        block26: {
            block25: {
                source = null;
                try {
                    try {
                        source = StreamUtils.getText((InputStream)stream);
                    }
                    catch (IOException iOException) {
                        if (source == null) {
                            source = "";
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    if (source == null) {
                        source = "";
                    }
                    throw throwable;
                }
                if (source == null) {
                    source = "";
                }
            }
            ByteArrayInputStream input = new ByteArrayInputStream(source.getBytes());
            try {
                ForeignScriptDocInfo info;
                NamespaceSniffer sniffer = new NamespaceSniffer();
                sniffer.read((InputStream)input);
                String namespace = sniffer.getNamespace();
                if (namespace != null && namespace.length() > 0 && (info = ForeignScriptDocManager.getInstance().getInfo(namespace)) != null) {
                    InputStream stylesheetStream = info.getStylesheetInputStream();
                    if (stylesheetStream != null) {
                        source = this.transformToAptana(source, stylesheetStream);
                    } else {
                        IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("XSL Transform stylesheet for the {0} namespace does not exist: {1}", info.namespace, info.stylesheet.toString()));
                    }
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
                break block26;
            }
            catch (IOException iOException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException3) {}
                break block26;
            }
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {}
        }
        return new ByteArrayInputStream(source.getBytes());
    }

    public ScriptDoc getDocumentation() {
        return this._documentation;
    }

    private String transformToAptana(String source, InputStream stylesheetStream) {
        String result;
        block30: {
            result = null;
            TransformerFactory factor = TransformerFactory.newInstance();
            StreamSource stylesheetSource = new StreamSource(stylesheetStream);
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(source.getBytes());
            StreamSource sourceSource = new StreamSource(sourceStream);
            StringWriter sourceWriter = new StringWriter();
            StreamResult resultStream = new StreamResult(sourceWriter);
            try {
                Transformer transformer = factor.newTransformer(stylesheetSource);
                transformer.transform(sourceSource, resultStream);
                result = sourceWriter.toString();
            }
            catch (TransformerConfigurationException e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"XSL Transform configuration error", (Throwable)e);
                try {
                    stylesheetStream.close();
                }
                catch (IOException iOException) {}
                try {
                    ((InputStream)sourceStream).close();
                }
                catch (IOException iOException) {}
                try {
                    sourceWriter.close();
                }
                catch (IOException iOException) {}
                break block30;
            }
            catch (TransformerException e) {
                try {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"XSL Transformation error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        stylesheetStream.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        ((InputStream)sourceStream).close();
                    }
                    catch (IOException iOException) {}
                    try {
                        sourceWriter.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    stylesheetStream.close();
                }
                catch (IOException iOException) {}
                try {
                    ((InputStream)sourceStream).close();
                }
                catch (IOException iOException) {}
                try {
                    sourceWriter.close();
                }
                catch (IOException iOException) {}
                break block30;
            }
            try {
                stylesheetStream.close();
            }
            catch (IOException iOException) {}
            try {
                ((InputStream)sourceStream).close();
            }
            catch (IOException iOException) {}
            try {
                sourceWriter.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public void loadXML(InputStream stream1) throws ScriptDocException {
        InputStream stream = this.getAptanaDocumentationStream(stream1);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this._textBuffer = "";
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
            saxParser.parse(stream, (DefaultHandler)((Object)this));
        }
        catch (ParserConfigurationException e) {
            String msg = Messages.ScriptDocReader_SaxError;
            ScriptDocException de = new ScriptDocException(msg, e);
            throw de;
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            String msg = Messages.ScriptDocReader_ParseError;
            msg = ex != null ? String.valueOf(msg) + ex.getMessage() : String.valueOf(msg) + e.getMessage();
            ScriptDocException de = new ScriptDocException(msg, e);
            throw de;
        }
        catch (IOException e) {
            String msg = Messages.ScriptDocReader_IOParseError;
            ScriptDocException de = new ScriptDocException(msg, e);
            throw de;
        }
    }

    public void loadXML(String filename) throws ScriptDocException {
        FileInputStream fi = null;
        try {
            try {
                fi = new FileInputStream(filename);
                this.loadXML(fi);
            }
            catch (FileNotFoundException e) {
                String msg = String.valueOf(Messages.ScriptDocReader_XMLLocationError) + filename;
                ScriptDocException de = new ScriptDocException(msg, e);
                throw de;
            }
        }
        catch (Throwable throwable) {
            try {
                fi.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fi.close();
        }
        catch (IOException iOException) {}
    }

    public void startTextBuffer(String ns, String name, String qname, Attributes attributes) {
        this._bufferText = true;
    }
}

