/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDependencyGraph<T> {
    private Map<String, List<String>> _vertices = new HashMap<String, List<String>>();
    private Map<String, T> _nameMap = new HashMap<String, T>();

    public void addEdge(String from, String to) {
        List<String> children;
        if (this.hasVertex(from) && this.hasVertex(to) && !(children = this._vertices.get(from)).contains(to)) {
            children.add(to);
        }
    }

    public void addMapping(String name, T item) {
        this._nameMap.put(name, item);
    }

    public void addVertex(String name) {
        if (!this.hasVertex(name)) {
            ArrayList children = new ArrayList();
            this._vertices.put(name, children);
        }
    }

    public T getItem(String name) {
        return this._nameMap.get(name);
    }

    public boolean hasVertex(String name) {
        return this._vertices.containsKey(name);
    }

    public int size() {
        return this._vertices.size();
    }

    public String[] topologicalSort() {
        HashSet<String> processed = new HashSet<String>();
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this._vertices.keySet()) {
            Stack<String> visited = new Stack<String>();
            Stack<String> active = new Stack<String>();
            active.push(name);
            while (!active.isEmpty()) {
                String current = (String)active.pop();
                if (processed.contains(current)) continue;
                processed.add(current);
                visited.add(current);
                List<String> children = this._vertices.get(current);
                int i = children.size() - 1;
                while (i >= 0) {
                    active.push(children.get(i));
                    --i;
                }
            }
            while (!visited.isEmpty()) {
                result.add((String)visited.pop());
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

