/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.ftp;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.URLEncoder;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.InfiniteProgressMonitor;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ide.core.io.vfs.ExtendedFileInfo;
import com.aptana.ide.core.io.vfs.IConnectionFileManager;
import com.aptana.ide.core.io.vfs.IExtendedFileInfo;
import com.aptana.ide.filesystem.ftp.ExpiringMap;
import com.aptana.ide.filesystem.ftp.FTPPlugin;
import com.aptana.ide.filesystem.ftp.Messages;
import com.aptana.ide.filesystem.ftp.Policy;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public abstract class BaseFTPConnectionFileManager
implements IConnectionFileManager {
    protected static final int TIMEOUT = 20000;
    protected static final int RETRY = 3;
    protected static final int RETRY_DELAY = 5000;
    protected static final int KEEPALIVE_INTERVAL = 15000;
    protected static final int TRANSFER_BUFFER_SIZE = 32768;
    protected static final int CHECK_CONNECTION_TIMEOUT = 30000;
    protected static final int CACHE_TTL = 60000;
    protected static final String TMP_UPLOAD_PREFIX = "_tmp_upload.";
    protected static final Pattern PASS_COMMAND_PATTERN = Pattern.compile("^(.*PASS ).+$");
    protected String host;
    protected int port;
    protected String login;
    protected char[] password = new char[0];
    protected IPath basePath;
    protected String authId;
    private long lastOperationTime;
    private Map<IPath, ExtendedFileInfo> fileInfoCache;
    private Map<IPath, ExtendedFileInfo[]> fileInfosCache;

    protected void promptPassword(String title, String message) {
        this.password = CoreIOPlugin.getAuthenticationManager().promptPassword(this.authId, this.login, title, message);
        if (this.password == null) {
            this.password = new char[0];
            throw new OperationCanceledException();
        }
    }

    protected void getOrPromptPassword(String title, String message) {
        this.password = CoreIOPlugin.getAuthenticationManager().getPassword(this.authId);
        if (this.password == null) {
            this.password = new char[0];
            this.promptPassword(title, message);
        }
    }

    protected synchronized void setCaching(boolean enabled) {
        if (this.fileInfoCache != null == enabled) {
            return;
        }
        if (enabled) {
            this.fileInfoCache = new ExpiringMap<IPath, ExtendedFileInfo>(60000L);
            this.fileInfosCache = new ExpiringMap<IPath, ExtendedFileInfo[]>(60000L);
        } else {
            this.fileInfoCache = null;
            this.fileInfosCache = null;
        }
    }

    public synchronized IExtendedFileInfo fetchInfo(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(StringUtils.format((String)Messages.BaseFTPConnectionFileManager_gethering_details, (String)path.toPortableString()), 2);
        try {
            ExtendedFileInfo fileInfo = this.getCachedFileInfo(path);
            if (fileInfo == null) {
                this.testOrConnect(monitor);
                try {
                    fileInfo = this.fetchAndCacheFileInfo(path, options, monitor);
                }
                finally {
                    this.setLastOperationTime();
                }
            }
            IExtendedFileInfo iExtendedFileInfo = (IExtendedFileInfo)fileInfo.clone();
            return iExtendedFileInfo;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized IExtendedFileInfo[] childInfos(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(StringUtils.format((String)Messages.BaseFTPConnectionFileManager_gethering_details, (String)path.toPortableString()), 2);
        options &= 0x400;
        try {
            ExtendedFileInfo[] fileInfos = this.getCachedFileInfos(path);
            if (fileInfos == null) {
                this.testOrConnect(monitor);
                try {
                    try {
                        ExtendedFileInfo[] extendedFileInfoArray = fileInfos = this.cache(path, this.fetchFiles(this.basePath.append(path), options, monitor));
                        int n = fileInfos.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ExtendedFileInfo fileInfo = extendedFileInfoArray[n2];
                            this.postProcessFileInfo(fileInfo, path, options, monitor);
                            this.cache(path.append(fileInfo.getName()), fileInfo);
                            ++n2;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        IExtendedFileInfo[] iExtendedFileInfoArray = new IExtendedFileInfo[]{};
                        this.setLastOperationTime();
                        monitor.done();
                        return iExtendedFileInfoArray;
                    }
                }
                finally {
                    this.setLastOperationTime();
                }
            }
            IExtendedFileInfo[] iExtendedFileInfoArray = (IExtendedFileInfo[])fileInfos.clone();
            return iExtendedFileInfoArray;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized String[] childNames(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(StringUtils.format((String)Messages.BaseFTPConnectionFileManager_listing_directory, (String)path.toPortableString()), 2);
        try {
            ExtendedFileInfo[] fileInfos = this.getCachedFileInfos(path);
            if (fileInfos != null) {
                ArrayList<String> list = new ArrayList<String>();
                ExtendedFileInfo[] extendedFileInfoArray = fileInfos;
                int n = fileInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    ExtendedFileInfo fileInfo = extendedFileInfoArray[n2];
                    list.add(fileInfo.getName());
                    ++n2;
                }
                String[] stringArray = list.toArray(new String[list.size()]);
                return stringArray;
            }
            this.testOrConnect(monitor);
            try {
                String[] stringArray = this.listDirectory(this.basePath.append(path), monitor);
                this.setLastOperationTime();
                return stringArray;
            }
            catch (Throwable throwable) {
                try {
                    this.setLastOperationTime();
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String[] stringArray = new String[]{};
                    return stringArray;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public synchronized InputStream openInputStream(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(StringUtils.format((String)Messages.BaseFTPConnectionFileManager_opening_file, (String)path.toPortableString()), 3);
        this.testOrConnect(monitor);
        try {
            ExtendedFileInfo fileInfo = this.fetchAndCacheFileInfo(path, Policy.subMonitorFor(monitor, 1));
            if (!fileInfo.exists()) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_no_such_file, (Throwable)new FileNotFoundException(path.toPortableString())));
            }
            if (fileInfo.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_file_is_directory, (Throwable)new FileNotFoundException(path.toPortableString())));
            }
            if (fileInfo.getLength() == 0L) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                return byteArrayInputStream;
            }
            InputStream inputStream = this.readFile(this.basePath.append(path), Policy.subMonitorFor(monitor, 1));
            return inputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_no_such_file, (Throwable)new FileNotFoundException(path.toPortableString())));
        }
        finally {
            this.setLastOperationTime();
            monitor.done();
        }
    }

    public synchronized OutputStream openOutputStream(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(StringUtils.format((String)Messages.BaseFTPConnectionFileManager_opening_file, (String)path.toPortableString()), 3);
        this.testOrConnect(monitor);
        try {
            ExtendedFileInfo fileInfo = this.fetchAndCacheFileInfo(path, Policy.subMonitorFor(monitor, 1));
            if (fileInfo.exists() && fileInfo.isDirectory()) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_file_is_directory, (Throwable)new FileNotFoundException(path.toPortableString())));
            }
            this.clearCache(path);
            long permissions = fileInfo.exists() ? fileInfo.getPermissions() : PreferenceUtils.getFilePermissions();
            OutputStream outputStream = this.writeFile(this.basePath.append(path), permissions, Policy.subMonitorFor(monitor, 1));
            return outputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_parent_doesnt_exist, (Throwable)new FileNotFoundException(path.toPortableString())));
        }
        finally {
            this.setLastOperationTime();
            monitor.done();
        }
    }

    public synchronized void delete(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        block12: {
            monitor = Policy.monitorFor(monitor);
            monitor = new InfiniteProgressMonitor(monitor);
            monitor.beginTask(Messages.BaseFTPConnectionFileManager_deleting, 20);
            this.testOrConnect(monitor);
            try {
                ExtendedFileInfo fileInfo = this.getCachedFileInfo(path);
                if (fileInfo == null) {
                    fileInfo = this.fetchAndCacheFileInfo(path, Policy.subMonitorFor(monitor, 1));
                }
                if (!fileInfo.exists()) {
                    return;
                }
                Policy.checkCanceled(monitor);
                try {
                    try {
                        if (fileInfo.isDirectory()) {
                            this.deleteDirectory(this.basePath.append(path), monitor);
                            break block12;
                        }
                        this.deleteFile(this.basePath.append(path), monitor);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.clearCache(path);
                    }
                }
                finally {
                    this.clearCache(path);
                }
            }
            finally {
                this.setLastOperationTime();
                monitor.done();
            }
        }
    }

    public synchronized void mkdir(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(StringUtils.format((String)Messages.BaseFTPConnectionFileManager_creating_folder, (String)path.toPortableString()), 3);
        this.testOrConnect(monitor);
        try {
            ExtendedFileInfo fileInfo = this.fetchAndCacheFileInfo(path, Policy.subMonitorFor(monitor, 1));
            if (fileInfo.exists()) {
                if (!fileInfo.isDirectory()) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_file_already_exists, (Throwable)new FileNotFoundException(path.toPortableString())));
                }
                return;
            }
            try {
                if ((options & 4) != 0 && path.segmentCount() > 1) {
                    fileInfo = this.fetchAndCacheFileInfo(path.removeLastSegments(1), Policy.subMonitorFor(monitor, 1));
                    if (!fileInfo.exists()) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_parent_doesnt_exist, (Throwable)new FileNotFoundException(path.toPortableString())));
                    }
                    if (!fileInfo.isDirectory()) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_parent_is_not_directory, (Throwable)new FileNotFoundException(path.toPortableString())));
                    }
                    this.createDirectory(this.basePath.append(path), Policy.subMonitorFor(monitor, 1));
                } else if (path.segmentCount() == 1) {
                    this.createDirectory(this.basePath.append(path), Policy.subMonitorFor(monitor, 1));
                } else {
                    IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 1);
                    subMonitor.beginTask(Messages.BaseFTPConnectionFileManager_creating_folders, path.segmentCount());
                    int i = path.segmentCount() - 1;
                    while (i >= 0) {
                        this.createDirectory(this.basePath.append(path).removeLastSegments(i), subMonitor);
                        subMonitor.worked(1);
                        --i;
                    }
                    subMonitor.done();
                }
            }
            catch (FileNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_parent_doesnt_exist, (Throwable)e));
            }
        }
        finally {
            this.setLastOperationTime();
            monitor.done();
        }
    }

    public synchronized void putInfo(IPath path, IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(StringUtils.format((String)Messages.BaseFTPConnectionFileManager_putting_changes, (String)path.toPortableString()), 5);
        this.testOrConnect(monitor);
        try {
            try {
                ExtendedFileInfo fileInfo;
                if ((options & 0x800) != 0) {
                    this.setModificationTime(this.basePath.append(path), info.getLastModified(), Policy.subMonitorFor(monitor, 1));
                }
                if ((options & 0x400) != 0 && (options & 0x10000) == 0 && (fileInfo = this.fetchAndCacheFileInfo(path, Policy.subMonitorFor(monitor, 1))).exists()) {
                    long permissions = fileInfo.getPermissions();
                    permissions = !info.getAttribute(2) ? (permissions |= 0x80L) : (permissions &= 0xFFFFFFFFFFFFFF7FL);
                    permissions = info.getAttribute(4) ? (permissions |= 0x40L) : (permissions &= 0xFFFFFFFFFFFFFFBFL);
                    this.changeFilePermissions(this.basePath.append(path), permissions, Policy.subMonitorFor(monitor, 1));
                }
                if (info instanceof IExtendedFileInfo) {
                    IExtendedFileInfo extInfo = (IExtendedFileInfo)info;
                    if ((options & 0x10000) != 0) {
                        this.changeFilePermissions(this.basePath.append(path), extInfo.getPermissions(), Policy.subMonitorFor(monitor, 1));
                    }
                    if ((options & 0x20000) != 0) {
                        this.changeFileGroup(this.basePath.append(path), extInfo.getGroup(), Policy.subMonitorFor(monitor, 1));
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_no_such_file, (Throwable)new FileNotFoundException(path.toPortableString())));
            }
        }
        finally {
            this.clearCache(path);
            this.setLastOperationTime();
            monitor.done();
        }
    }

    public synchronized void move(IPath sourcePath, IPath destinationPath, int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(StringUtils.format((String)Messages.BaseFTPConnectionFileManager_moving, (String)sourcePath.toPortableString()), 5);
        this.testOrConnect(monitor);
        try {
            try {
                ExtendedFileInfo fileInfo = this.fetchAndCacheFileInfo(sourcePath, Policy.subMonitorFor(monitor, 1));
                if (!fileInfo.exists()) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_no_such_file, (Throwable)new FileNotFoundException(sourcePath.toPortableString())));
                }
                boolean isDirectory = fileInfo.isDirectory();
                fileInfo = this.fetchAndCacheFileInfo(destinationPath, Policy.subMonitorFor(monitor, 1));
                if (fileInfo.exists()) {
                    if ((options & 2) == 0) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_file_already_exists, (Throwable)new FileNotFoundException(destinationPath.toPortableString())));
                    }
                    if (fileInfo.isDirectory() != isDirectory) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_cant_move));
                    }
                } else {
                    fileInfo = this.fetchAndCacheFileInfo(destinationPath.removeLastSegments(1), Policy.subMonitorFor(monitor, 1));
                    if (!fileInfo.exists()) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_parent_doesnt_exist, (Throwable)new FileNotFoundException(destinationPath.toPortableString())));
                    }
                }
                this.clearCache(sourcePath);
                this.clearCache(destinationPath);
                this.renameFile(this.basePath.append(sourcePath), this.basePath.append(destinationPath), Policy.subMonitorFor(monitor, 2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.ftp", Messages.BaseFTPConnectionFileManager_no_such_file, (Throwable)new FileNotFoundException(sourcePath.toPortableString())));
            }
        }
        finally {
            this.setLastOperationTime();
            monitor.done();
        }
    }

    public URI getCanonicalURI(IPath path) {
        return this.getRootCanonicalURI().resolve(URLEncoder.encode((String)this.basePath.append(path).toPortableString(), null, null));
    }

    protected abstract void checkConnected() throws Exception;

    protected abstract URI getRootCanonicalURI();

    protected abstract ExtendedFileInfo fetchFile(IPath var1, int var2, IProgressMonitor var3) throws CoreException, FileNotFoundException;

    protected abstract ExtendedFileInfo[] fetchFiles(IPath var1, int var2, IProgressMonitor var3) throws CoreException, FileNotFoundException;

    protected abstract String[] listDirectory(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException;

    protected abstract InputStream readFile(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException;

    protected abstract OutputStream writeFile(IPath var1, long var2, IProgressMonitor var4) throws CoreException, FileNotFoundException;

    protected abstract void deleteFile(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException;

    protected abstract void deleteDirectory(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException;

    protected abstract void createDirectory(IPath var1, IProgressMonitor var2) throws CoreException, FileNotFoundException;

    protected abstract void renameFile(IPath var1, IPath var2, IProgressMonitor var3) throws CoreException, FileNotFoundException;

    protected abstract void setModificationTime(IPath var1, long var2, IProgressMonitor var4) throws CoreException, FileNotFoundException;

    protected abstract void changeFilePermissions(IPath var1, long var2, IProgressMonitor var4) throws CoreException, FileNotFoundException;

    protected abstract void changeFileGroup(IPath var1, String var2, IProgressMonitor var3) throws CoreException, FileNotFoundException;

    private ExtendedFileInfo fetchAndCacheFileInfo(IPath path, IProgressMonitor monitor) throws CoreException {
        return this.fetchAndCacheFileInfo(path, 0, monitor);
    }

    private ExtendedFileInfo fetchAndCacheFileInfo(IPath path, int options, IProgressMonitor monitor) throws CoreException {
        ExtendedFileInfo fileInfo;
        try {
            fileInfo = this.fetchFile(this.basePath.append(path), options, monitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ExtendedFileInfo fileInfo2 = new ExtendedFileInfo(path.segmentCount() > 0 ? path.lastSegment() : Path.ROOT.toPortableString());
            fileInfo2.setExists(false);
            return fileInfo2;
        }
        if (path.segmentCount() == 0) {
            fileInfo.setName(Path.ROOT.toPortableString());
        }
        this.postProcessFileInfo(fileInfo, path, options, monitor);
        return this.cache(path, fileInfo);
    }

    private void postProcessFileInfo(ExtendedFileInfo fileInfo, IPath dirPath, int options, IProgressMonitor monitor) throws CoreException {
        long permissions;
        if (fileInfo.getAttribute(32)) {
            ExtendedFileInfo targetFileInfo = this.resolveSymlink(dirPath, fileInfo.getStringAttribute(64), options, monitor);
            fileInfo.setExists(targetFileInfo.exists());
            if (targetFileInfo.exists()) {
                fileInfo.setDirectory(targetFileInfo.isDirectory());
                fileInfo.setLength(targetFileInfo.getLength());
                fileInfo.setLastModified(targetFileInfo.getLastModified());
                fileInfo.setOwner(targetFileInfo.getOwner());
                fileInfo.setGroup(targetFileInfo.getGroup());
                fileInfo.setPermissions(targetFileInfo.getPermissions());
            }
        }
        fileInfo.setAttribute(2, ((permissions = fileInfo.getPermissions()) & 0x80L) == 0L);
        fileInfo.setAttribute(4, (permissions & 0x40L) != 0L);
    }

    private ExtendedFileInfo resolveSymlink(IPath dirPath, String linkTarget, int options, IProgressMonitor monitor) throws CoreException {
        HashSet<IPath> visited = new HashSet<IPath>();
        visited.add(dirPath);
        while (linkTarget != null && linkTarget.length() > 0) {
            IPath targetPath = Path.fromPortableString((String)linkTarget);
            if (!targetPath.isAbsolute()) {
                targetPath = dirPath.append(targetPath);
            }
            if (visited.contains(targetPath)) break;
            visited.add(targetPath);
            ExtendedFileInfo targetFileInfo = this.getCachedFileInfo(targetPath);
            if (targetFileInfo == null) {
                try {
                    Policy.checkCanceled(monitor);
                    targetFileInfo = this.cache(targetPath, this.fetchFile(targetPath, options, Policy.subMonitorFor(monitor, 1)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    targetFileInfo = new ExtendedFileInfo();
                }
            }
            this.cache(targetPath, targetFileInfo);
            if (targetFileInfo.getAttribute(32)) {
                linkTarget = targetFileInfo.getStringAttribute(64);
                dirPath = targetPath.removeLastSegments(1);
                continue;
            }
            return targetFileInfo;
        }
        return new ExtendedFileInfo();
    }

    private ExtendedFileInfo getCachedFileInfo(IPath path) {
        return this.fileInfoCache != null ? this.fileInfoCache.get(path) : null;
    }

    private ExtendedFileInfo[] getCachedFileInfos(IPath path) {
        return this.fileInfosCache != null ? this.fileInfosCache.get(path) : null;
    }

    protected ExtendedFileInfo cache(IPath path, ExtendedFileInfo fileInfo) {
        if (this.fileInfoCache != null && fileInfo.exists()) {
            this.fileInfoCache.put(path, fileInfo);
        }
        return fileInfo;
    }

    protected ExtendedFileInfo[] cache(IPath path, ExtendedFileInfo[] fileInfos) {
        if (this.fileInfosCache != null) {
            this.fileInfosCache.put(path, fileInfos);
        }
        return fileInfos;
    }

    protected void clearCache(IPath path) {
        int segments = path.segmentCount();
        if (this.fileInfoCache != null) {
            for (IPath p : new ArrayList<IPath>(this.fileInfoCache.keySet())) {
                if (p.segmentCount() < segments || path.matchingFirstSegments(p) != segments) continue;
                this.fileInfoCache.remove(p);
            }
        }
        if (this.fileInfosCache != null) {
            for (IPath p : new ArrayList<IPath>(this.fileInfosCache.keySet())) {
                if (p.segmentCount() < segments || path.matchingFirstSegments(p) != segments) continue;
                this.fileInfosCache.remove(p);
            }
        }
    }

    protected void cleanup() {
        if (this.fileInfoCache != null) {
            this.fileInfoCache.clear();
        }
        if (this.fileInfosCache != null) {
            this.fileInfosCache.clear();
        }
    }

    protected void testOrConnect(IProgressMonitor monitor) throws CoreException {
        Policy.checkCanceled(monitor);
        this.testConnection();
        if (!this.isConnected()) {
            this.connect(Policy.subMonitorFor(monitor, 1));
            Policy.checkCanceled(monitor);
        }
    }

    private void testConnection() {
        if (!this.isConnected()) {
            return;
        }
        if (System.currentTimeMillis() - this.lastOperationTime > 30000L) {
            try {
                this.checkConnected();
            }
            catch (Exception e) {
                IdeLog.logImportant((Plugin)FTPPlugin.getDefault(), (String)Messages.BaseFTPConnectionFileManager_connection_check_failed, (Throwable)e);
            }
        }
        if (this.isConnected()) {
            this.setLastOperationTime();
        }
    }

    private void setLastOperationTime() {
        this.lastOperationTime = System.currentTimeMillis();
    }
}

