/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.ftp;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringMap<K, V>
implements Map<K, V> {
    private LinkedHashMap<K, Item> map = new LinkedHashMap();
    private long maxObjectTTL;

    public ExpiringMap(long maxObjectTTL) {
        this.maxObjectTTL = maxObjectTTL;
    }

    private boolean hasExpired(Object key, Item item) {
        long now = System.currentTimeMillis();
        if (item.creationTime + this.maxObjectTTL < now) {
            this.map.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        Item v = this.map.get(key);
        if (v != null && !this.hasExpired(key, v)) {
            return v.object;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        Item v = this.map.put(key, new Item(value));
        if (v != null) {
            return v.object;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        LinkedHashMap<K, Item> all = new LinkedHashMap<K, Item>();
        for (Map.Entry<K, V> i : t.entrySet()) {
            all.put(i.getKey(), new Item(i.getValue()));
        }
        this.map.putAll(all);
    }

    @Override
    public V remove(Object key) {
        Item v = (Item)this.map.remove(key);
        if (v != null && !this.hasExpired(key, v)) {
            return v.object;
        }
        return null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Item {
        protected V object;
        protected long creationTime;

        public Item(V object) {
            this.object = object;
            this.creationTime = System.currentTimeMillis();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                return this.object == ((Item)obj).object || this.object != null && this.object.equals(((Item)obj).object);
            }
            return false;
        }

        public int hashCode() {
            return this.object != null ? this.object.hashCode() : 0;
        }
    }
}

