/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import java.io.IOException;
import java.io.InputStream;

class FTPFileDownloadInputStream
extends InputStream {
    private FTPClient ftpClient;
    private FileTransferInputStream ftpInputStream;

    public FTPFileDownloadInputStream(FTPClient ftpClient, FileTransferInputStream ftpInputStream) {
        this.ftpClient = ftpClient;
        this.ftpInputStream = ftpInputStream;
    }

    private void safeQuit() {
        this.ftpClient.setMessageListener(null);
        try {
            if (this.ftpClient.connected()) {
                this.ftpClient.quit();
            }
        }
        catch (Exception exception) {
            try {
                this.ftpClient.quitImmediately();
            }
            catch (Exception exception2) {}
        }
    }

    public int read() throws IOException {
        try {
            return this.ftpInputStream.read();
        }
        catch (IOException e) {
            this.safeQuit();
            throw e;
        }
    }

    public int available() throws IOException {
        try {
            return this.ftpInputStream.available();
        }
        catch (IOException e) {
            this.safeQuit();
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            this.ftpInputStream.close();
        }
        finally {
            this.safeQuit();
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.ftpInputStream.read(b, off, len);
        }
        catch (IOException e) {
            this.safeQuit();
            throw e;
        }
    }
}

