/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.samples.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.wizards.BaseWizard;
import com.aptana.ide.samples.model.SamplesEntry;
import com.aptana.ide.samples.model.SamplesInfo;
import com.aptana.ide.samples.ui.SamplesUIPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class SamplesProjectWizard
extends BaseWizard {
    public static final String ID = "com.aptana.ide.samples.SamplesProjectWizard";
    private SamplesEntry entry;

    public SamplesProjectWizard(SamplesEntry entry) {
        this.entry = entry;
    }

    public void addPages() {
        super.addPages();
        if (this.projectPage != null && this.entry.getFile() != null) {
            File file = this.entry.getFile();
            IWorkspace workspace = ResourcesPlugin.getWorkspace().getRoot().getWorkspace();
            IStatus nameStatus = workspace.validateName(file.getName(), 4);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(file.getName());
            if (nameStatus.isOK() && !project.exists() && !file.getName().equals("")) {
                this.projectPage.setInitialProjectName(file.getName());
            }
        }
    }

    public String[] getFileNamesToSelect() {
        return new String[]{"index.html"};
    }

    public IFile getFileToOpenOnFinish() {
        IFile index = this.getProjectHandle().getFile("index.html");
        if (index != null && index.exists()) {
            return index;
        }
        return null;
    }

    public String getID() {
        return ID;
    }

    private static void createNestedFiles(IFolder folder, File file, IProgressMonitor monitor) {
        File[] nest = file.listFiles();
        int i = 0;
        while (i < nest.length) {
            IResource createdFile = SamplesProjectWizard.createFile(folder, nest[i], monitor);
            if (createdFile instanceof IFolder) {
                SamplesProjectWizard.createNestedFiles((IFolder)createdFile, nest[i], monitor);
            }
            ++i;
        }
    }

    private static void createNestedEntries(IFolder folder, SamplesEntry entry, IProgressMonitor monitor) {
        List nest = entry.getSubEntries();
        int i = 0;
        while (i < nest.size()) {
            SamplesEntry sub = (SamplesEntry)nest.get(i);
            IResource createdFile = SamplesProjectWizard.createFile(folder, sub.getFile(), monitor);
            if (createdFile instanceof IFolder) {
                SamplesProjectWizard.createNestedEntries((IFolder)createdFile, sub, monitor);
            }
            ++i;
        }
    }

    protected IProjectDescription createProjectDescription(String name, IPath path) {
        IProjectDescription description = super.createProjectDescription(name, path);
        File projectDefFile = new File(this.entry.getFile(), ".project");
        if (projectDefFile.exists()) {
            try {
                ProjectDescriptionReader reader = new ProjectDescriptionReader();
                ProjectDescription projectDescription = reader.read(Path.fromOSString((String)projectDefFile.getAbsolutePath()));
                if (projectDescription != null) {
                    description.setNatureIds(projectDescription.getNatureIds());
                    description.setBuildSpec(projectDescription.getBuildSpec());
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)"Error parsing the sample's .project file", (Throwable)e);
            }
        } else {
            SamplesInfo info = this.entry.getParent();
            String[] natures = info.getNatures();
            if (natures != null && natures.length > 0) {
                description.setNatureIds(info.getNatures());
            }
        }
        return description;
    }

    public boolean performFinish() {
        boolean rc = super.performFinish();
        SamplesInfo info = this.entry.getParent();
        if (info.getCreationHandler() != null) {
            info.getCreationHandler().projectCreated(this.getProjectHandle());
        }
        return rc;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void finishProjectCreation() {
        IResource createdFile;
        File file;
        IProject projectHandler = this.getProjectHandle();
        IProgressMonitor monitor = this.getFinishProgressMonitor();
        List entries = this.entry.getSubEntries();
        int i = 0;
        while (i < entries.size()) {
            SamplesEntry sub = (SamplesEntry)entries.get(i);
            file = sub.getFile();
            createdFile = SamplesProjectWizard.createFile(projectHandler, file, monitor);
            if (createdFile instanceof IFolder) {
                SamplesProjectWizard.createNestedEntries((IFolder)createdFile, sub, monitor);
            }
            ++i;
        }
        List includes = this.entry.getParent().getIncludePaths();
        int i2 = 0;
        while (i2 < includes.size()) {
            String include = (String)includes.get(i2);
            file = new File(include);
            createdFile = SamplesProjectWizard.createFile(projectHandler, file, monitor);
            if (createdFile instanceof IFolder) {
                SamplesProjectWizard.createNestedFiles((IFolder)createdFile, file, monitor);
            }
            ++i2;
        }
    }

    private static IResource createFile(IFolder folder, File file, IProgressMonitor monitor) {
        if (file.isDirectory()) {
            IFolder subFolder = folder.getFolder(file.getName());
            try {
                if (!subFolder.exists()) {
                    subFolder.create(true, true, monitor);
                }
                return subFolder;
            }
            catch (CoreException coreException) {}
        } else {
            IFile iFile = folder.getFile(file.getName());
            try {
                iFile.create((InputStream)new FileInputStream(file), true, monitor);
                return iFile;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private static IResource createFile(IProject project, File file, IProgressMonitor monitor) {
        if (file.isDirectory()) {
            IFolder folder = project.getFolder(file.getName());
            try {
                if (!folder.exists()) {
                    folder.create(true, true, monitor);
                }
                return folder;
            }
            catch (CoreException coreException) {}
        } else {
            IFile iFile = project.getFile(file.getName());
            try {
                iFile.create((InputStream)new FileInputStream(file), true, monitor);
                return iFile;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (CoreException coreException) {}
        }
        return null;
    }
}

