/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ssh.impl.preferences;

import com.aptana.ide.ssh.Activator;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class SSHPreferences
extends AbstractPreferenceInitializer {
    public static final String SSH_COMMAND = "ssh";
    private static String defaultSSHCommand = "";

    static {
        if ("macosx".equals(Platform.getOS())) {
            defaultSSHCommand = "/usr/bin/osascript \"{terminal.scpt}\" {user@host}";
        } else if ("win32".equals(Platform.getOS())) {
            defaultSSHCommand = "cmd /C start \"\\\"ssh\\\"\" \"{putty.exe}\" \"{user@host}\"";
        } else if ("linux".equals(Platform.getOS())) {
            defaultSSHCommand = new File("/usr/bin/gnome-terminal").exists() ? "/usr/bin/gnome-terminal -x /usr/bin/ssh \"{user@host}\"" : (new File("/usr/bin/Konsole").exists() ? "/usr/bin/Konsole -x /usr/bin/ssh \"{user@host}\"" : "/usr/bin/xterm -e /usr/bin/ssh \"{user@host}\"");
        } else if ("solaris".equals(Platform.getOS())) {
            defaultSSHCommand = "/usr/bin/xterm -e /usr/bin/ssh \"{user@host}\"";
        }
    }

    public static String getSSHCommand() {
        return Activator.getDefault().getPluginPreferences().getString(SSH_COMMAND);
    }

    public static void setSSHCommand(String SSHCommand) {
        Activator.getDefault().getPluginPreferences().setValue(SSH_COMMAND, SSHCommand);
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences node = new DefaultScope().getNode(Activator.getDefault().getBundle().getSymbolicName());
        node.put(SSH_COMMAND, defaultSSHCommand);
    }
}

