/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core.impl.servers;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IModule;
import com.aptana.ide.server.core.IModuleType;
import com.aptana.ide.server.core.IPublishOperation;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerLocator;
import com.aptana.ide.server.core.IServerManager;
import com.aptana.ide.server.core.IServerManagerListener;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.ServerManagerEvent;
import com.aptana.ide.server.core.impl.Configuration;
import com.aptana.ide.server.core.impl.PreferencesConfiguration;
import com.aptana.ide.server.core.impl.RegistryLazyObject;
import com.aptana.ide.server.core.impl.RegistryObjectCollection;
import com.aptana.ide.server.core.impl.servers.InitializerLazyObject;
import com.aptana.ide.server.core.impl.servers.InitializerRegistry;
import com.aptana.ide.server.core.impl.servers.ServerProvider;
import com.aptana.ide.server.core.impl.servers.ServerTypeRegistry;
import com.aptana.ide.server.core.model.IServerProviderDelegate;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;

public final class ServerManager
implements IServerManager {
    private static final int EXCEPTION_WHILE_LOADING_SERVERS_STATUS_CODE = 333;
    private static final String SERVER_COUNT = "serverCount";
    private static final String KEY_SERVERS = "servers";
    static ServerManager instance;
    private ArrayList<IServerManagerListener> listeners = new ArrayList();
    private ArrayList<IServer> servers = new ArrayList();
    private ArrayList<IServer> externalservers = new ArrayList();
    private HashMap<IServer, IServerProviderDelegate> fSrvToProvider = new HashMap();
    private ArrayList<RegistryLazyObject> serverTypes = new ArrayList();
    private ArrayList<RegistryLazyObject> moduleTypes = new ArrayList();
    private ArrayList<RegistryLazyObject> serverLocators = new ArrayList();
    private ArrayList<RegistryLazyObject> publishOperations = new ArrayList();
    static PreferencesConfiguration config;

    static {
        config = new PreferencesConfiguration(ServerCore.getDefault().getPluginPreferences(), "serverManager");
    }

    private ServerManager() {
    }

    void load() {
        this.serverTypes.addAll(Arrays.asList(ServerTypeRegistry.getServerTypeRegistry().getAll()));
        this.moduleTypes.addAll(Arrays.asList(ServerTypeRegistry.getServerTypeRegistry().getAll()));
        this.serverLocators.addAll(Arrays.asList(ServerTypeRegistry.getServerTypeRegistry().getAll()));
        this.publishOperations.addAll(Arrays.asList(ServerTypeRegistry.getServerTypeRegistry().getAll()));
        this.loadExternals();
        this.loadServers();
    }

    private void loadExternals() {
        RegistryLazyObject o;
        RegistryLazyObject[] all = new RegistryObjectCollection("com.aptana.ide.server.serverProvider"){

            protected RegistryLazyObject createObject(IConfigurationElement configurationElement) {
                return new ServerProvider(configurationElement);
            }
        }.getAll();
        ArrayList<RegistryLazyObject> objects = new ArrayList<RegistryLazyObject>();
        RegistryLazyObject[] registryLazyObjectArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            o = registryLazyObjectArray[n2];
            objects.add(o);
            ++n2;
        }
        Collections.sort(objects, new Comparator<RegistryLazyObject>(){

            @Override
            public int compare(RegistryLazyObject o1, RegistryLazyObject o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        registryLazyObjectArray = all = objects.toArray(new RegistryLazyObject[0]);
        n = all.length;
        n2 = 0;
        while (n2 < n) {
            o = registryLazyObjectArray[n2];
            try {
                final IServerProviderDelegate pd = ((ServerProvider)o).getDelegate();
                if (pd != null) {
                    IServer[] servers2;
                    pd.addServerChangeListener(new IServerManagerListener(){

                        public void serversChanged(ServerManagerEvent event) {
                            IServer server = event.getServer();
                            if (event.getKind() == 0) {
                                ServerManager.this.externalservers.add(server);
                                ServerManager.this.fSrvToProvider.put(server, pd);
                            }
                            if (event.getKind() == 1) {
                                ServerManager.this.externalservers.remove(server);
                                ServerManager.this.fSrvToProvider.remove(server);
                            }
                            ServerManager.this.fireChange(event);
                        }
                    });
                    IServer[] iServerArray = servers2 = pd.getServers();
                    int n3 = servers2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IServer s = iServerArray[n4];
                        this.externalservers.add(s);
                        this.fSrvToProvider.put(s, pd);
                        ++n4;
                    }
                }
            }
            catch (Throwable e) {
                this.handleError(e, o);
            }
            ++n2;
        }
    }

    public void reload() {
        this.servers.clear();
        this.loadServers();
    }

    private void loadServers() {
        String[] stringArrayAttribute = config.getStringArrayAttribute(KEY_SERVERS);
        int a = 0;
        while (a < stringArrayAttribute.length) {
            block6: {
                try {
                    IAbstractConfiguration subConfiguration = config.getSubConfiguration(stringArrayAttribute[a]);
                    try {
                        String stringAttribute = subConfiguration.getStringAttribute("type");
                        IServerType object = (IServerType)((Object)ServerTypeRegistry.getServerTypeRegistry().getObject(stringAttribute));
                        if (object != null) {
                            IServer create = object.create(subConfiguration);
                            this.servers.add(create);
                            break block6;
                        }
                        IdeLog.logError((Plugin)ServerCore.getDefault(), (String)StringUtils.format((String)"Server with id {0} not found", (String)stringAttribute));
                    }
                    catch (Throwable e) {
                        this.internalHandleError(e, subConfiguration.getStringAttribute("name"));
                    }
                }
                catch (Throwable e) {
                    this.internalHandleError(e, "Server Storage");
                }
            }
            ++a;
        }
    }

    private void handleError(Throwable e, RegistryLazyObject o) {
        this.internalHandleError(e, o.getName());
    }

    private void internalHandleError(Throwable e, String name) {
        IStatusHandler statusHandler;
        CoreException ee;
        if (e instanceof CoreException) {
            ee = (CoreException)e;
            statusHandler = DebugPlugin.getDefault().getStatusHandler(ee.getStatus());
            if (statusHandler != null) {
                try {
                    statusHandler.handleStatus(ee.getStatus(), (Object)name);
                }
                catch (Throwable e1) {
                    IdeLog.logError((Plugin)ServerCore.getDefault(), (String)e.getMessage(), (Throwable)e1);
                }
            }
        }
        ee = new Status(4, "com.aptana.ide.server", 333, "Exception while loading servers", e);
        statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)ee);
        try {
            statusHandler.handleStatus((IStatus)ee, (Object)name);
        }
        catch (Throwable e1) {
            IdeLog.logError((Plugin)ServerCore.getDefault(), (String)e.getMessage(), (Throwable)e1);
        }
        IdeLog.logError((Plugin)ServerCore.getDefault(), (String)e.getMessage(), (Throwable)e);
    }

    void storeServers(boolean allInfo) {
        try {
            String[] ids = new String[this.servers.size()];
            ArrayList<String> savedIds = new ArrayList<String>();
            int a = 0;
            while (a < ids.length) {
                IServer server = this.servers.get(a);
                if (!server.isTransient()) {
                    ids[a] = server.getId();
                    savedIds.add(ids[a]);
                    if (allInfo) {
                        IAbstractConfiguration configuration = this.getConfiguration(server);
                        server.storeConfiguration(configuration);
                        configuration.setStringAttribute("type", server.getServerType().getId());
                    }
                }
                ++a;
            }
            config.setStringArrayAttribute(KEY_SERVERS, savedIds.toArray(new String[0]));
            ServerCore.getDefault().savePluginPreferences();
        }
        catch (Throwable e) {
            IdeLog.log((Plugin)ServerCore.getDefault(), (int)0, (String)"exception while storing servers", (Throwable)e);
        }
    }

    IAbstractConfiguration getConfiguration(IServer srv) {
        IAbstractConfiguration subConfiguration = config.getSubConfiguration(srv.getId());
        return subConfiguration;
    }

    void serverChanged(IServer server) {
        if (server != null) {
            if (!this.servers.contains(server)) {
                this.fireChange(new ServerManagerEvent(server, 2));
                return;
            }
            IAbstractConfiguration configuration = this.getConfiguration(server);
            server.storeConfiguration(configuration);
            ServerCore default1 = ServerCore.getDefault();
            if (default1 != null) {
                default1.savePluginPreferences();
            }
            this.fireChange(new ServerManagerEvent(server, 2));
        }
    }

    public void addServer(IServer server) {
        if (server == null) {
            throw new IllegalArgumentException("server should not be null");
        }
        if (this.servers.contains(server)) {
            throw new IllegalArgumentException("servers should  be unique");
        }
        this.servers.add(server);
        IAbstractConfiguration configuration = this.getConfiguration(server);
        server.storeConfiguration(configuration);
        configuration.setStringAttribute("type", server.getServerType().getId());
        this.storeServers(false);
        this.fireChange(new ServerManagerEvent(server, 0));
    }

    public void removeServer(IServer server) {
        IServerProviderDelegate serverProviderDelegate = this.fSrvToProvider.get(server);
        if (serverProviderDelegate != null) {
            serverProviderDelegate.removeServer(server);
        }
        IAbstractConfiguration configuration = this.getConfiguration(server);
        String[] propertyNames = configuration.propertyNames();
        int a = 0;
        while (a < propertyNames.length) {
            configuration.removeAttribute(propertyNames[a]);
            ++a;
        }
        boolean remove = this.servers.remove(server);
        this.storeServers(false);
        if (remove) {
            this.fireChange(new ServerManagerEvent(server, 1));
        }
    }

    public synchronized void addServerManagerListener(IServerManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener should not be null");
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public synchronized IProject[] getProjects(IServer server) {
        HashSet<IProject> resultSet = new HashSet<IProject>();
        IModule[] modules = server.getModules();
        int b = 0;
        while (b < modules.length) {
            resultSet.add(modules[b].getProject());
            ++b;
        }
        IProject[] result = new IProject[resultSet.size()];
        resultSet.toArray(result);
        return result;
    }

    public synchronized IServerType[] getServerTypes() {
        IServerType[] result = new IServerType[this.serverTypes.size()];
        this.serverTypes.toArray(result);
        return result;
    }

    public synchronized IServer[] getServers() {
        ArrayList<IServer> combined = new ArrayList<IServer>();
        combined.addAll(this.servers);
        combined.addAll(this.externalservers);
        IServer[] result = new IServer[combined.size()];
        combined.toArray(result);
        return result;
    }

    public synchronized IServer findServer(String id) {
        IServer[] servers = ServerCore.getServerManager().getServers();
        int i = 0;
        while (i < servers.length) {
            IServer server = servers[i];
            if (server.getId().equals(id)) {
                return server;
            }
            ++i;
        }
        return null;
    }

    public synchronized IServer[] getServers(IProject project) {
        ArrayList<IServer> resultList = new ArrayList<IServer>();
        int a = 0;
        while (a < this.servers.size()) {
            IServer srv = this.servers.get(a);
            IModule[] modules = srv.getModules();
            int b = 0;
            while (b < modules.length) {
                if (modules[b].getProject().equals((Object)project)) {
                    resultList.add(srv);
                    break;
                }
                ++b;
            }
            ++a;
        }
        IServer[] result = new IServer[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    protected void fireChange(ServerManagerEvent event) {
        int a = 0;
        while (a < this.listeners.size()) {
            IServerManagerListener listener = this.listeners.get(a);
            try {
                listener.serversChanged(event);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)ServerCore.getDefault(), (String)StringUtils.format((String)"error while notifying listener {0}", (String)listener.toString()), (Throwable)e);
            }
            ++a;
        }
    }

    public synchronized void removeServerManagerListener(IServerManagerListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized IModule[] getModules(IProject project) {
        ArrayList<IModule> resultList = new ArrayList<IModule>();
        int a = 0;
        while (a < this.servers.size()) {
            IServer srv = this.servers.get(a);
            IModule[] modules = srv.getModules();
            int b = 0;
            while (b < modules.length) {
                if (modules[b].getProject().equals((Object)project)) {
                    resultList.add(modules[b]);
                }
                ++b;
            }
            ++a;
        }
        IModule[] result = new IModule[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public synchronized boolean exists(IServer server) {
        return this.servers.contains(server);
    }

    public IModuleType[] getModuleTypes() {
        IModuleType[] result = new IModuleType[this.moduleTypes.size()];
        this.moduleTypes.toArray(result);
        return result;
    }

    public synchronized IServerLocator[] getServerLocators() {
        IServerLocator[] result = new IServerLocator[this.serverLocators.size()];
        this.serverLocators.toArray(result);
        return result;
    }

    public synchronized IPublishOperation getPublishOperation(IServerType server, IModuleType type, String id) {
        int a = 0;
        while (a < this.publishOperations.size()) {
            IPublishOperation op = (IPublishOperation)((Object)this.publishOperations.get(a));
            if (op.supports(server, type)) {
                return op;
            }
            ++a;
        }
        return null;
    }

    public synchronized IPublishOperation[] getPublishOperations() {
        IPublishOperation[] result = new IPublishOperation[this.publishOperations.size()];
        this.publishOperations.toArray(result);
        return result;
    }

    public static String getFreeId() {
        int intAttribute = config.getIntAttribute(SERVER_COUNT);
        DecimalFormat dFormat = new DecimalFormat("000000000");
        String format = StringUtils.format((String)"server{0}", (String)dFormat.format(intAttribute));
        config.setIntAttribute(SERVER_COUNT, ++intAttribute);
        ServerCore.getDefault().savePluginPreferences();
        return format;
    }

    public IServer addServer(IAbstractConfiguration configuration) throws CoreException {
        try {
            String stringAttribute = configuration.getStringAttribute("type");
            IServerType tpe = (IServerType)((Object)ServerTypeRegistry.getServerTypeRegistry().getObject(stringAttribute));
            IServer create = tpe.create(configuration);
            this.addServer(create);
            return create;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.server", 4, "exception while adding server", e));
        }
    }

    public void clearAll() {
        this.servers.clear();
        config.setStringArrayAttribute(KEY_SERVERS, new String[0]);
    }

    public IAbstractConfiguration getInitialServerConfiguration(String serverTypeId) {
        Configuration config = new Configuration();
        InitializerLazyObject initializer = InitializerRegistry.getInstance().getInitializer(serverTypeId);
        config.setStringAttribute("id", ServerManager.getFreeId());
        config.setStringAttribute("type", serverTypeId);
        if (initializer != null) {
            initializer.initializeConfiguration(config);
        }
        return config;
    }

    public IServerType getServerType(String id) {
        return (IServerType)((Object)ServerTypeRegistry.getServerTypeRegistry().getObject(id));
    }

    public static ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
            instance.load();
        }
        return instance;
    }

    public static int findFreePort(int[] portRange) {
        return ServerManager.findFreePort(portRange[0], portRange[1]);
    }

    public static int findFreePort(int startRange, int endRange) {
        return ServerManager.findFreePort(startRange, endRange, null);
    }

    public static int findFreePort(int startRange, int endRange, int[] excluding) {
        int port = -1;
        ServerSocket socket = null;
        int i = startRange;
        while (i <= endRange) {
            boolean valid = true;
            if (excluding != null && excluding.length > 0) {
                int e = 0;
                while (e < excluding.length) {
                    if (i == excluding[e]) {
                        valid = false;
                        break;
                    }
                    ++e;
                }
            }
            if (valid) {
                try {
                    socket = new ServerSocket(i);
                    socket.close();
                    socket = new ServerSocket();
                    socket.setReuseAddress(false);
                    socket.bind(new InetSocketAddress("127.0.0.1", i));
                    socket.close();
                    port = i;
                    break;
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return port;
    }
}

