/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.portal.comet;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.PartListenerAdapter;
import com.aptana.ide.server.jetty.comet.CometClient;
import dojox.cometd.Channel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorHistoryItem;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentFilesClient
extends CometClient {
    public static final String LIST_RECENT_FILES = "listRecentFiles";
    public static final String RECENT_FILES_CHANNEL = "/portal/recentFiles";
    public static final String PROJECTS = "projects";
    public static final String FILES = "files";
    public static final String NAME = "name";
    public static final String OPEN_FILE = "openFile";
    public static final String PROJECT = "project";
    public static final String FILE = "file";
    private IPartListener partListener = new PartListenerAdapter(){

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                RecentFilesClient.this.publishRecentFiles();
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                RecentFilesClient.this.publishRecentFiles();
            }
        }
    };
    private IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.removePartListener(RecentFilesClient.this.partListener);
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.addPartListener(RecentFilesClient.this.partListener);
            }
        }
    };

    public RecentFilesClient() {
        this.init();
    }

    private void init() {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = workbenchWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            IPartService partService = workbenchWindow.getPartService();
            if (partService != null) {
                partService.addPartListener(this.partListener);
            }
            ++n2;
        }
        PlatformUI.getWorkbench().addWindowListener(this.windowListener);
    }

    public void destroy() {
        IWorkbenchWindow[] workbenchWindows;
        super.destroy();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = workbenchWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            IPartService partService = workbenchWindow.getPartService();
            if (partService != null) {
                partService.removePartListener(this.partListener);
            }
            ++n2;
        }
        this.partListener = null;
        PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
        this.windowListener = null;
    }

    protected Object getResponse(String toChannel, Object request) {
        if (RECENT_FILES_CHANNEL.equals(toChannel)) {
            Map requestData = (Map)request;
            if (LIST_RECENT_FILES.equals(requestData.get("request"))) {
                return this.listRecentFiles();
            }
            if (OPEN_FILE.equals(requestData.get("request"))) {
                String project = (String)requestData.get(PROJECT);
                String file = (String)requestData.get(FILE);
                if (project != null && file != null) {
                    this.openFile(project, file);
                }
            }
        }
        return null;
    }

    protected void publishRecentFiles() {
        if (this.bayeux == null) {
            return;
        }
        Channel listChannel = this.bayeux.getChannel(this.getRecentFilesChannel(), true);
        listChannel.publish(this.client, this.listRecentFiles(), Long.toString(System.currentTimeMillis()));
    }

    protected Map<Object, Object> listRecentFiles() {
        HashMap<Object, Object> returnData = new HashMap<Object, Object>();
        returnData.put("response", LIST_RECENT_FILES);
        HashMap<String, LinkedList<String>> projectFilesMap = new HashMap<String, LinkedList<String>>();
        EditorHistory editorHistory = this.getEditorHistory();
        if (editorHistory != null) {
            EditorHistoryItem[] editorHistoryItems;
            EditorHistoryItem[] editorHistoryItemArray = editorHistoryItems = editorHistory.getItems();
            int n = editorHistoryItems.length;
            int n2 = 0;
            while (n2 < n) {
                FileEditorInput fileEditorInput;
                Object file;
                IEditorInput editorInput;
                EditorHistoryItem editorHistoryItem = editorHistoryItemArray[n2];
                try {
                    if (!editorHistoryItem.isRestored()) {
                        editorHistoryItem.restoreState();
                    }
                }
                catch (Exception exception) {}
                if ((editorInput = editorHistoryItem.getInput()) instanceof FileEditorInput && (file = (fileEditorInput = (FileEditorInput)editorInput).getFile()) != null) {
                    IProject project = file.getProject();
                    String projectName = project.getName();
                    LinkedList<String> list = (LinkedList<String>)projectFilesMap.get(projectName);
                    if (list == null) {
                        list = new LinkedList<String>();
                        projectFilesMap.put(projectName, list);
                    }
                    list.add(editorHistoryItem.getName());
                }
                ++n2;
            }
        }
        LinkedList projectMapsList = new LinkedList();
        Set projectNames = projectFilesMap.keySet();
        for (String projectName : projectNames) {
            HashMap<String, Object> projectMap = new HashMap<String, Object>();
            projectMap.put(NAME, projectName);
            LinkedList fileMapsList = new LinkedList();
            List projectFiles = (List)projectFilesMap.get(projectName);
            for (Object file : projectFiles) {
                HashMap<String, IFile> fileMap = new HashMap<String, IFile>();
                fileMap.put(NAME, (IFile)file);
                fileMapsList.add(fileMap);
            }
            projectMap.put(FILES, fileMapsList);
            projectMapsList.add(projectMap);
        }
        returnData.put(PROJECTS, projectMapsList);
        return returnData;
    }

    private void openFile(String project, String file) {
        EditorHistory editorHistory = this.getEditorHistory();
        if (editorHistory != null) {
            EditorHistoryItem[] editorHistoryItems;
            EditorHistoryItem[] editorHistoryItemArray = editorHistoryItems = editorHistory.getItems();
            int n = editorHistoryItems.length;
            int n2 = 0;
            while (n2 < n) {
                IProject fileEditorInputFileProject;
                FileEditorInput fileEditorInput;
                IFile fileEditorInputFile;
                IEditorInput editorInput;
                EditorHistoryItem editorHistoryItem = editorHistoryItemArray[n2];
                if (editorHistoryItem.getName().equals(file) && (editorInput = editorHistoryItem.getInput()) instanceof FileEditorInput && (fileEditorInputFile = (fileEditorInput = (FileEditorInput)editorInput).getFile()) != null && (fileEditorInputFileProject = fileEditorInputFile.getProject()).getName().equals(project)) {
                    this.open(editorHistory, editorHistoryItem);
                }
                ++n2;
            }
        }
    }

    protected String getRecentFilesChannel() {
        return RECENT_FILES_CHANNEL;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{this.getRecentFilesChannel()};
    }

    protected String getID(String msgId) {
        return Long.toString(System.currentTimeMillis());
    }

    private EditorHistory getEditorHistory() {
        return ((Workbench)PlatformUI.getWorkbench()).getEditorHistory();
    }

    private void open(final EditorHistory history, final EditorHistoryItem item) {
        UIJob uiJob = new UIJob("Opening file."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page = CoreUIUtils.getActivePage();
                if (page != null) {
                    try {
                        item.getName();
                        if (!item.isRestored()) {
                            item.restoreState();
                        }
                        IEditorInput input = item.getInput();
                        IEditorDescriptor desc = item.getDescriptor();
                        if (input == null || desc == null) {
                            history.remove(item);
                        } else {
                            page.openEditor(input, desc.getId());
                        }
                    }
                    catch (PartInitException pe) {
                        CoreUIUtils.showError((String)pe.getMessage(), (Exception)((Object)pe));
                        history.remove(item);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.setPriority(10);
        uiJob.schedule();
    }
}

