/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css;

import com.aptana.ide.editor.css.CSSPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowserExtensionLoader {
    private static List<IConfigurationElement> browserList = null;
    private static List<String> allBrowsers = null;
    private static List<IConfigurationElement> showList = new ArrayList<IConfigurationElement>();
    private static IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("com.aptana.ide.editor.css.BROWSER_PREVIEW_PREFERENCE".equals(event.getProperty())) {
                BrowserExtensionLoader.computeShowList();
            }
        }
    };
    private static String OS = Platform.getOS();

    private BrowserExtensionLoader() {
    }

    public static String getBrowserLabel(IConfigurationElement browserElement) {
        String label = null;
        boolean found = false;
        IConfigurationElement[] ce = browserElement.getChildren("label");
        int k = 0;
        while (k < ce.length && !found) {
            if (ce[k].getAttribute("os") != null && ce[k].getAttribute("value") != null && OS.equals(ce[k].getAttribute("os"))) {
                label = ce[k].getAttribute("value");
                found = true;
            }
            ++k;
        }
        return label;
    }

    private static void computeShowList() {
        IConfigurationElement element;
        showList.clear();
        String browserString = CSSPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.css.BROWSER_PREVIEW_PREFERENCE");
        String[] browsers_names = browserString.split(",");
        IConfigurationElement safari = null;
        int size = browserList.size();
        int i = 0;
        while (i < size) {
            element = browserList.get(i);
            String name = BrowserExtensionLoader.getBrowserLabel(element);
            if (safari == null && "Safari".equals(name)) {
                safari = element;
            }
            if (name != null) {
                boolean show = false;
                int k = 0;
                while (k < browsers_names.length && !show) {
                    if (name.equals(browsers_names[k])) {
                        show = true;
                    }
                    ++k;
                }
                if (show) {
                    showList.add(element);
                }
            }
            ++i;
        }
        if (OS.equals("macosx") && showList.size() == 1) {
            element = showList.get(0);
            IPreferenceStore store = CSSPlugin.getDefault().getPreferenceStore();
            store.removePropertyChangeListener(propertyChangeListener);
            if (BrowserExtensionLoader.getBrowserLabel(element).equals("Firefox")) {
                if (safari != null) {
                    showList.add(0, safari);
                    store.setValue("com.aptana.ide.editor.css.BROWSER_PREVIEW_PREFERENCE", String.valueOf(browserString) + ",Safari");
                } else {
                    showList.clear();
                    store.setValue("com.aptana.ide.editor.css.BROWSER_PREVIEW_PREFERENCE", "");
                }
            }
            store.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public static List<IConfigurationElement> loadBrowsers() {
        if (browserList == null) {
            browserList = new ArrayList<IConfigurationElement>();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
            IExtension[] extensions = ep.getExtensions();
            CSSPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(propertyChangeListener);
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] ce = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    String browserClass = ce[j].getAttribute("class");
                    String browserName = BrowserExtensionLoader.getBrowserLabel(ce[j]);
                    if (browserClass != null && browserName != null) {
                        browserList.add(ce[j]);
                    }
                    ++j;
                }
                ++i;
            }
            Collections.sort(browserList, new Comparator<IConfigurationElement>(){

                @Override
                public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                    String name1 = BrowserExtensionLoader.getBrowserLabel(o1);
                    String name2 = BrowserExtensionLoader.getBrowserLabel(o2);
                    if (name1 != null && name2 != null) {
                        if (Platform.getOS().equals("macosx")) {
                            return name2.compareTo(name1);
                        }
                        return name1.compareTo(name2);
                    }
                    return 0;
                }
            });
            BrowserExtensionLoader.computeShowList();
        }
        return showList;
    }

    public static List<String> getAllBrowserLabels() {
        if (allBrowsers == null) {
            allBrowsers = new ArrayList<String>();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] ce = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    String browserClass = ce[j].getAttribute("class");
                    String browserName = BrowserExtensionLoader.getBrowserLabel(ce[j]);
                    if (browserClass != null && browserName != null) {
                        allBrowsers.add(browserName);
                    }
                    ++j;
                }
                ++i;
            }
            Collections.sort(allBrowsers, new Comparator<String>(){

                @Override
                public int compare(String name1, String name2) {
                    if (name1 != null && name2 != null) {
                        return name1.compareTo(name2);
                    }
                    return 0;
                }
            });
        }
        return allBrowsers;
    }
}

