/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.css.CSSContributor;
import com.aptana.ide.editor.css.CSSDocumentProvider;
import com.aptana.ide.editor.css.CSSFileServiceFactory;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.css.Messages;
import com.aptana.ide.editor.css.MultiPageCSSEditor;
import com.aptana.ide.editor.css.context.CSSContextAwareness;
import com.aptana.ide.editors.unified.DocumentSourceProvider;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.editors.unified.context.IContextAwareness;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CSSEditor
extends UnifiedEditor {
    private ActivationListener fActivationListener;
    private boolean isDisposing = false;

    public CSSEditor() {
        this.addPluginToPreferenceStore(CSSPlugin.getDefault());
    }

    protected IUnifiedEditorContributor createLocalContributor() {
        return new CSSContributor();
    }

    public IFileServiceFactory getFileServiceFactory() {
        return CSSFileServiceFactory.getInstance();
    }

    public IContextAwareness getContextAwareness() {
        return CSSContextAwareness.getInstance((IUnifiedEditor)this);
    }

    public String getDefaultFileExtension() {
        return "css";
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
    }

    public void dispose() {
        if (this.isDisposing) {
            return;
        }
        this.isDisposing = true;
        if (this.fActivationListener != null) {
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        super.dispose();
    }

    public File getTempFile() {
        IEditorInput in = this.getEditorInput();
        File outFile = null;
        if (in instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
            IPath path = CoreUIUtils.getPathOfIFileLocation((IFile)file);
            if (path != null) {
                File f = path.makeAbsolute().toFile();
                String location = this.getTempFileLocation(f, String.valueOf(file.getName()) + ".html");
                outFile = new File(location);
            }
        } else if (in instanceof NonExistingFileEditorInput) {
            NonExistingFileEditorInput nin = (NonExistingFileEditorInput)in;
            IPath path = nin.getPath((Object)nin);
            String spath = path.toOSString();
            File f = new File(spath);
            String location = this.getTempFileLocation(f, String.valueOf(path.lastSegment()) + ".html");
            outFile = new File(location);
        } else if (in instanceof IPathEditorInput) {
            IPathEditorInput pin = (IPathEditorInput)in;
            File path = pin.getPath().toFile();
            String location = this.getTempFileLocation(path, String.valueOf(pin.getName()) + ".html");
            outFile = new File(location);
        } else if (in instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)in).getURI();
            String location = "file".equals(uri.getScheme()) ? this.getTempFileLocation(new File(uri), Path.fromPortableString((String)uri.getPath()).lastSegment()) : this.getTempFileLocation(null, Path.fromPortableString((String)uri.getPath()).lastSegment());
            outFile = new File(location);
        }
        if (outFile != null) {
            outFile.deleteOnExit();
        }
        return outFile;
    }

    public String getTempFileLocation(File file, String name) {
        if (CSSPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editor.css.USE_TEMP_FILES_FOR_PREVIEW")) {
            if (file == null) {
                try {
                    return File.createTempFile(".tmp_" + name, "~").getAbsolutePath();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            file = file.getParentFile();
            return file + File.separator + ".tmp_" + name + (int)(Math.random() * 100000.0) + "~";
        }
        return String.valueOf(FileUtils.systemTempDir) + File.separator + ".tmp_" + name + "~";
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"com.aptana.ide.editor.css.preferences.GeneralPreferencePage", "com.aptana.ide.editor.css.preferences.ColorizationPreferencePage", "com.aptana.ide.editor.css.preferences.FoldingPreferencePage", "com.aptana.ide.editor.css.preferences.ProblemsPreferencePage", "com.aptana.ide.editor.css.preferences.PreviewPreferencePage", "com.aptana.ide.editor.css.preferences.FormattingPreferencePage", "com.aptana.ide.editor.css.preferences.CodeAssistPreferencePage", "com.aptana.ide.editor.css.preferences.TypingPreferencePage", "org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.editors.preferencePages.QuickDiff", "org.eclipse.ui.editors.preferencePages.Accessibility", "org.eclipse.ui.editors.preferencePages.Spelling", "org.eclipse.ui.editors.preferencePages.LinkedModePreferencePage"};
    }

    protected boolean isNewInput(IEditorInput input) {
        CSSDocumentProvider.CSSFileInfo cuInfo = this.getCSSFileInfo(input);
        if (cuInfo == null) {
            throw new RuntimeException(Messages.CSSEditor_cuInfo_Null_At_DoSetInput);
        }
        CSSDocumentProvider dp = (CSSDocumentProvider)this.getDocumentProvider();
        IDocument document = dp.getDocument(input);
        DocumentSourceProvider provider = new DocumentSourceProvider(document, input);
        if (provider == null) {
            throw new RuntimeException(Messages.CSSEditor_Provider_Null);
        }
        return cuInfo.sourceProvider == null || !cuInfo.sourceProvider.equals(provider);
    }

    private CSSDocumentProvider.CSSFileInfo getCSSFileInfo(IEditorInput input) {
        CSSDocumentProvider dp = (CSSDocumentProvider)this.getDocumentProvider();
        if (dp == null) {
            throw new RuntimeException(Messages.CSSEditor_Document_Provier_Null);
        }
        return (CSSDocumentProvider.CSSFileInfo)dp.getFileInfoPublic(input);
    }

    protected void updateFileInfo(IEditorInput input, DocumentSourceProvider provider, IDocument document) {
        super.updateFileInfo(input, provider, document);
        if (this.isNewInput(input)) {
            this.getCSSFileInfo((IEditorInput)input).sourceProvider = provider;
        }
    }

    public IDocumentProvider createDocumentProvider() {
        return CSSDocumentProvider.getInstance();
    }

    private class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part instanceof MultiPageCSSEditor ? ((MultiPageCSSEditor)part).getEditor() : part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        private void handleActivation() {
            if (this.fIsHandlingActivation) {
                return;
            }
            if (this.fActivePart == CSSEditor.this) {
                this.fIsHandlingActivation = true;
                try {
                    CSSEditor.this.safelySanityCheckState(CSSEditor.this.getEditorInput());
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == CSSEditor.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ActivationListener.this.handleActivation();
                    }
                });
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

