/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.context;

import com.aptana.ide.editor.css.context.CSSContextItem;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.context.ContextItem;
import com.aptana.ide.editors.unified.context.IContextAwareness;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;

public class CSSContextAwareness
implements IContextAwareness {
    private ContextItem fileContext = new ContextItem("global");
    private static CSSContextAwareness instance;

    public CSSContextAwareness(IUnifiedEditor editor) {
    }

    public void update(IFileService context) {
        CSSContextItem currentStyle = null;
        this.fileContext.clearAll();
        LexemeList lexemeList = context.getLexemeList();
        if (lexemeList == null) {
            return;
        }
        int lexemeListSize = lexemeList.size();
        int lexc = 0;
        while (lexc < lexemeListSize) {
            Lexeme lexeme = lexemeList.get(lexc);
            if (lexeme.getLanguage().equals("text/css")) {
                if (lexeme.typeIndex == 4 || lexeme.typeIndex == 9 || lexeme.typeIndex == 47 || lexeme.typeIndex == 48 || lexeme.typeIndex == 8) {
                    currentStyle = new CSSContextItem();
                    lexc = this.consumeName(lexemeList, lexc, currentStyle);
                } else if (lexeme.typeIndex == 31) {
                    lexc = this.consumeStyleElements(lexemeList, lexc + 1, currentStyle);
                }
            }
            ++lexc;
        }
    }

    private int consumeName(LexemeList lexemeList, int lexc, ContextItem item) {
        Lexeme lexeme = lexemeList.get(lexc);
        String name = String.valueOf(lexeme.getText()) + " ";
        item.setOffset(lexeme.offset);
        item.setLength(lexeme.length);
        int lexemeListSize = lexemeList.size();
        while (lexeme.typeIndex != 31 && lexc < lexemeListSize) {
            if (++lexc >= lexemeListSize || !(lexeme = lexemeList.get(lexc)).getLanguage().equals("text/css") || lexeme.typeIndex == 31 || lexeme.typeIndex == 3) continue;
            name = String.valueOf(name) + lexeme.getText();
        }
        item.setName(name.trim());
        this.fileContext.addItem(item);
        return --lexc;
    }

    private int consumeStyleElements(LexemeList lexemeList, int lexc, ContextItem item) {
        int lexemeListSize = lexemeList.size();
        String name = null;
        String value = "";
        while (lexc < lexemeListSize) {
            Lexeme lexeme = lexemeList.get(lexc);
            if (lexeme.getLanguage().equals("text/css")) {
                if (lexeme.typeIndex == 32) {
                    if (name != null) {
                        item.values.put(name, value);
                    }
                    return lexc++;
                }
                if (name == null && (lexeme.typeIndex == 4 || lexeme.typeIndex == 47 || lexeme.typeIndex == 48)) {
                    name = lexeme.getText();
                } else if (name != null && lexeme.typeIndex == 29) {
                    if (++lexc >= lexemeListSize) {
                        return lexc;
                    }
                    lexeme = lexemeList.get(lexc);
                    while (lexc < lexemeListSize && lexeme.typeIndex != 32 && lexeme.typeIndex != 30) {
                        value = String.valueOf(value) + lexeme.getText();
                        value = String.valueOf(value) + " ";
                        lexeme = lexemeList.get(++lexc);
                    }
                    --lexc;
                    item.values.put(name, value.trim());
                    name = null;
                    value = "";
                }
            }
            ++lexc;
        }
        return lexc;
    }

    public ContextItem getFileContext() {
        return this.fileContext;
    }

    public static CSSContextAwareness getInstance(IUnifiedEditor editor) {
        if (instance == null) {
            instance = new CSSContextAwareness(editor);
        }
        return instance;
    }
}

