/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.preview;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.css.preview.Messages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class CSSPreviewPropertyPage
extends PropertyPage {
    public static final String CSS_PREVIEW_PATH = "CSS_PREVIEW_PATH";
    public static final String CSS_PREVIEW_TYPE = "CSS_PREVIEW_TYPE";
    public static final String URL_TYPE = "URL_TYPE";
    public static final String PROJECT_TYPE = "PROJECT_TYPE";
    public static final String CSS_PREVIEW_OVERRIDE = "CSS_PREVIEW_OVERRIDE";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private IEditorRegistry registry = WorkbenchPlugin.getDefault().getEditorRegistry();
    private Map<IEditorDescriptor, Image> images = new HashMap<IEditorDescriptor, Image>();
    private Table projectFiles;
    private Button override;
    private Group preview;
    private Button useProjectFile;
    private Button useURL;
    private Label urlLabel;
    private Text urlText;
    private Button browseButton;
    private IResource resource;

    protected Control createContents(Composite parent) {
        Composite composite;
        block11: {
            composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, true);
            composite.setLayout((Layout)layout);
            GridData data = new GridData(4, 4, true, true);
            composite.setLayoutData((Object)data);
            Composite top = new Composite(composite, 0);
            GridLayout topLayout = new GridLayout(2, false);
            topLayout.marginHeight = 0;
            topLayout.marginWidth = 0;
            top.setLayout((Layout)topLayout);
            top.setLayoutData((Object)new GridData(4, 4, true, false));
            this.override = new Button(top, 32);
            this.override.setLayoutData((Object)new GridData(4, 4, true, false));
            this.override.setSelection(false);
            this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean ov = CSSPreviewPropertyPage.this.override.getSelection();
                    CSSPreviewPropertyPage.this.useProjectFile.setEnabled(ov);
                    CSSPreviewPropertyPage.this.useURL.setEnabled(ov);
                    if (ov) {
                        if (CSSPreviewPropertyPage.this.useProjectFile.getSelection()) {
                            CSSPreviewPropertyPage.this.projectFiles.setEnabled(true);
                        } else if (CSSPreviewPropertyPage.this.useURL.getSelection()) {
                            CSSPreviewPropertyPage.this.urlText.setEnabled(true);
                            CSSPreviewPropertyPage.this.browseButton.setEnabled(true);
                        }
                    } else {
                        CSSPreviewPropertyPage.this.urlText.setEnabled(false);
                        CSSPreviewPropertyPage.this.browseButton.setEnabled(false);
                        CSSPreviewPropertyPage.this.projectFiles.setEnabled(false);
                    }
                }
            });
            Link goToParent = new Link(top, 0);
            goToParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CSSPreviewPropertyPage.this.resource != null) {
                        if (CSSPreviewPropertyPage.this.resource instanceof IProject) {
                            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.editor.css.preferences.PreviewPreferencePage", (String[])new String[]{"com.aptana.ide.editor.css.preferences.PreviewPreferencePage"}, null);
                            dialog.open();
                        } else if (CSSPreviewPropertyPage.this.resource instanceof IFile) {
                            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)Display.getDefault().getActiveShell(), (IAdaptable)CSSPreviewPropertyPage.this.resource.getProject(), (String)"com.aptana.ide.editor.css.preview.cssPreviewPropertyPage", (String[])new String[]{"com.aptana.ide.editor.css.preview.cssPreviewPropertyPage"}, null);
                            dialog.open();
                        }
                    }
                }
            });
            goToParent.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
            this.preview = new Group(composite, 0);
            this.preview.setText(Messages.CSSPreviewPropertyPage_PreviewText);
            GridLayout pLayout = new GridLayout(1, true);
            pLayout.marginHeight = 10;
            this.preview.setLayout((Layout)pLayout);
            this.preview.setLayoutData((Object)new GridData(4, 4, true, true));
            this.useProjectFile = new Button((Composite)this.preview, 16);
            this.useProjectFile.setText(Messages.CSSPreviewPropertyPage_UseProjectFileText);
            this.useProjectFile.setSelection(true);
            this.useProjectFile.setEnabled(false);
            this.useProjectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CSSPreviewPropertyPage.this.projectFiles.setEnabled(true);
                    CSSPreviewPropertyPage.this.urlText.setEnabled(false);
                    CSSPreviewPropertyPage.this.browseButton.setEnabled(false);
                }
            });
            Group projectGroup = new Group((Composite)this.preview, 0);
            projectGroup.setText(Messages.CSSPreviewPropertyPage_ProjectFilesText);
            GridLayout pgLayout = new GridLayout(1, true);
            pgLayout.marginHeight = 0;
            pgLayout.marginWidth = 0;
            projectGroup.setLayout((Layout)pgLayout);
            GridData pgData = new GridData(4, 4, true, true);
            pgData.horizontalIndent = 10;
            projectGroup.setLayoutData((Object)pgData);
            this.projectFiles = new Table((Composite)projectGroup, 67620);
            this.projectFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 32) {
                        TableItem[] items = CSSPreviewPropertyPage.this.projectFiles.getItems();
                        int i = 0;
                        while (i < items.length) {
                            TableItem item = items[i];
                            if (item != e.item) {
                                item.setChecked(false);
                            }
                            ++i;
                        }
                    }
                }
            });
            this.projectFiles.setLayoutData((Object)new GridData(4, 4, true, true));
            this.projectFiles.setLinesVisible(true);
            new TableColumn(this.projectFiles, 16384);
            this.projectFiles.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    ScrollBar vScrolls;
                    TableColumn c = CSSPreviewPropertyPage.this.projectFiles.getColumn(0);
                    Point size = CSSPreviewPropertyPage.this.projectFiles.getSize();
                    if (Platform.getOS().equals("macosx") && (vScrolls = CSSPreviewPropertyPage.this.projectFiles.getVerticalBar()) != null) {
                        size.x = size.x - vScrolls.getSize().x - 5;
                    }
                    c.setWidth(size.x - 6);
                }
            });
            this.projectFiles.setEnabled(false);
            this.useURL = new Button((Composite)this.preview, 16);
            this.useURL.setText(Messages.CSSPreviewPropertyPage_UseURLText);
            this.useURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CSSPreviewPropertyPage.this.projectFiles.setEnabled(false);
                    CSSPreviewPropertyPage.this.urlText.setEnabled(true);
                    CSSPreviewPropertyPage.this.browseButton.setEnabled(true);
                }
            });
            this.useURL.setSelection(false);
            this.useURL.setEnabled(false);
            Composite url = new Composite((Composite)this.preview, 0);
            GridLayout urlLayout = new GridLayout(3, false);
            urlLayout.marginHeight = 0;
            urlLayout.marginWidth = 0;
            url.setLayout((Layout)urlLayout);
            GridData uData = new GridData(4, 4, true, false);
            uData.horizontalIndent = 17;
            url.setLayoutData((Object)uData);
            this.urlLabel = new Label(url, 16384);
            this.urlLabel.setText(Messages.CSSPreviewPropertyPage_URLText);
            this.urlText = new Text(url, 2052);
            this.urlText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.urlText.setEnabled(false);
            this.browseButton = new Button(url, 8);
            this.browseButton.setText(Messages.CSSPreviewPropertyPage_BrowseText);
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(CSSPreviewPropertyPage.this.browseButton.getShell(), 4096);
                    String file = dialog.open();
                    if (file != null) {
                        CSSPreviewPropertyPage.this.urlText.setText(file);
                    }
                }
            });
            this.browseButton.setEnabled(false);
            try {
                this.resource = (IResource)this.getElement();
                String override = this.resource.getPersistentProperty(new QualifiedName("", CSS_PREVIEW_OVERRIDE));
                String previewPath = this.resource.getPersistentProperty(new QualifiedName("", CSS_PREVIEW_PATH));
                String previewType = this.resource.getPersistentProperty(new QualifiedName("", CSS_PREVIEW_TYPE));
                IProject project = null;
                if (this.resource instanceof IProject) {
                    project = (IProject)this.resource;
                    this.override.setText(Messages.CSSPreviewPropertyPage_OverrideWorkspaceText);
                    goToParent.setText("<a>" + Messages.CSSPreviewPropertyPage_OverrideWorkspaceLinkText + "</a>");
                } else if (this.resource instanceof IFile) {
                    project = this.resource.getProject();
                    this.override.setText(Messages.CSSPreviewPropertyPage_OverrideProjectText);
                    goToParent.setText("<a>" + Messages.CSSPreviewPropertyPage_OverrideProjectLinkText + "</a>");
                }
                if (project != null) {
                    this.buildTable((IResource)project);
                }
                if (!TRUE.equals(override)) break block11;
                this.override.setSelection(true);
                this.useURL.setEnabled(true);
                this.useProjectFile.setEnabled(true);
                if (URL_TYPE.equals(previewType)) {
                    this.useURL.setSelection(true);
                    this.useProjectFile.setSelection(false);
                    this.urlText.setEnabled(true);
                    this.browseButton.setEnabled(true);
                    this.urlText.setText(previewPath);
                    break block11;
                }
                this.useURL.setSelection(false);
                this.useProjectFile.setSelection(true);
                this.projectFiles.setEnabled(true);
                if (project == null || previewPath == null) break block11;
                IFile[] candidates = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(previewPath));
                IFile resource = null;
                int i = 0;
                while (i < candidates.length) {
                    if (project.equals((Object)candidates[i].getProject())) {
                        resource = candidates[i];
                        break;
                    }
                    ++i;
                }
                if (resource == null || !resource.exists()) break block11;
                TableItem[] items = this.projectFiles.getItems();
                int i2 = 0;
                while (i2 < items.length) {
                    IResource file = (IResource)items[i2].getData();
                    if (resource.equals((Object)file)) {
                        items[i2].setChecked(true);
                        break;
                    }
                    ++i2;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Error getting element", (Throwable)e);
            }
        }
        return composite;
    }

    private void buildTable(IResource root) {
        if (root instanceof IContainer) {
            try {
                IResource[] members = ((IContainer)root).members();
                int i = 0;
                while (i < members.length) {
                    if (members[i] instanceof IFile) {
                        TableItem item = new TableItem(this.projectFiles, 0);
                        item.setData((Object)members[i]);
                        item.setText(members[i].getProjectRelativePath().toString());
                        IEditorDescriptor desc = this.registry.getDefaultEditor(members[i].getName());
                        if (desc == null || desc.getImageDescriptor() == null) {
                            IWorkbench workbench = PlatformUI.getWorkbench();
                            ISharedImages sharedImages = workbench.getSharedImages();
                            sharedImages.getImage("IMG_OBJ_FILE");
                        } else {
                            Image image = null;
                            if (this.images.containsKey(desc)) {
                                image = this.images.get(desc);
                            } else {
                                image = desc.getImageDescriptor().createImage();
                                this.images.put(desc, image);
                            }
                            item.setImage(image);
                        }
                    } else {
                        this.buildTable(members[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Error retrieving project files", (Throwable)e);
            }
        }
    }

    protected void performDefaults() {
    }

    public void dispose() {
        super.dispose();
        Iterator<Image> iter = this.images.values().iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
    }

    public boolean performOk() {
        if (this.resource != null) {
            if (this.override.getSelection()) {
                try {
                    this.resource.setPersistentProperty(new QualifiedName("", CSS_PREVIEW_OVERRIDE), TRUE);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Error saving preview preferences", (Throwable)e);
                }
                if (this.useURL.getSelection()) {
                    try {
                        this.resource.setPersistentProperty(new QualifiedName("", CSS_PREVIEW_PATH), this.urlText.getText());
                        this.resource.setPersistentProperty(new QualifiedName("", CSS_PREVIEW_TYPE), URL_TYPE);
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Error saving preview preferences", (Throwable)e);
                    }
                } else if (this.useProjectFile.getSelection()) {
                    try {
                        TableItem[] items = this.projectFiles.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i].getChecked()) {
                                IResource file = (IResource)items[i].getData();
                                this.resource.setPersistentProperty(new QualifiedName("", CSS_PREVIEW_PATH), file.getLocation().makeAbsolute().toOSString());
                                this.resource.setPersistentProperty(new QualifiedName("", CSS_PREVIEW_TYPE), PROJECT_TYPE);
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Error saving preview preferences", (Throwable)e);
                    }
                }
            } else {
                try {
                    this.resource.setPersistentProperty(new QualifiedName("", CSS_PREVIEW_PATH), null);
                    this.resource.setPersistentProperty(new QualifiedName("", CSS_PREVIEW_TYPE), null);
                    this.resource.setPersistentProperty(new QualifiedName("", CSS_PREVIEW_OVERRIDE), FALSE);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Error saving preview preferences", (Throwable)e);
                }
            }
        }
        return true;
    }
}

