/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.preview;

import com.aptana.ide.editor.css.BrowserExtensionLoader;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.css.MultiPageCSSEditor;
import com.aptana.ide.editor.css.preview.Messages;
import com.aptana.ide.editors.unified.ContributedBrowser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PreviewConfigurationPage {
    private Composite displayArea;
    private Composite browserArea;
    private Composite editArea;
    private Button currentPageButton;
    private Button startUrlButton;
    private Text startUrlText;
    private Button internalServerButton;
    private Button customServerButton;
    private Text baseUrlText;
    private Button addProjectNameButton;
    private Button save;
    private Button cancel;
    private String title = Messages.PreviewConfigurationPage_Title;
    private String browserLabel = "";
    private Label nameLabel;
    private Text nameText;
    private ContributedBrowser browser;
    private MultiPageCSSEditor editor;
    private int index = -1;
    private String url;
    private Map<String, Button> buttons = new HashMap<String, Button>();

    public PreviewConfigurationPage(MultiPageCSSEditor editor) {
        this.editor = editor;
        this.url = this.editor.getURL();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, false);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editArea = new Composite(this.displayArea, 0);
        GridLayout eaLayout = new GridLayout(1, false);
        eaLayout.marginWidth = 0;
        eaLayout.marginHeight = 0;
        this.editArea.setLayout((Layout)eaLayout);
        this.editArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browserArea = new Composite(this.displayArea, 0);
        GridData baData = new GridData(4, 4, true, true);
        baData.exclude = true;
        GridLayout baLayout = new GridLayout(1, false);
        baLayout.marginHeight = 0;
        baLayout.marginWidth = 0;
        this.browserArea.setLayout((Layout)baLayout);
        this.browserArea.setLayoutData((Object)baData);
        this.browserArea.setVisible(false);
        this.createButtonSection(this.editArea);
        this.createConfigurationSection(this.editArea);
        this.createBrowserSection(this.editArea);
        this.createStartActionSection(this.editArea);
        this.createServerSection(this.editArea);
    }

    public String getBrowserLabel() {
        return this.browserLabel;
    }

    public void setBrowser(ContributedBrowser browser, String label) {
        Button button = this.buttons.get(label);
        if (button != null && !button.isDisposed()) {
            button.setSelection(true);
            for (Button other : this.buttons.values()) {
                if (other == button || other == null) continue;
                other.setSelection(false);
            }
        }
        if (this.browser != null) {
            this.browser.dispose();
        }
        this.browserLabel = label;
        this.browser = browser;
        this.browser.createControl(this.browserArea);
    }

    public void setTitle(String title) {
        if (this.nameText != null && !this.nameText.isDisposed()) {
            this.nameText.setText(title);
        } else {
            this.title = title;
        }
    }

    public void showEditArea() {
        GridData eaData = (GridData)this.editArea.getLayoutData();
        eaData.exclude = false;
        GridData baData = (GridData)this.browserArea.getLayoutData();
        baData.exclude = true;
        this.browserArea.setVisible(false);
        this.editArea.setVisible(true);
        this.displayArea.layout(true, true);
    }

    public void showBrowserArea() {
        GridData eaData = (GridData)this.editArea.getLayoutData();
        eaData.exclude = true;
        GridData baData = (GridData)this.browserArea.getLayoutData();
        baData.exclude = false;
        this.browserArea.setVisible(true);
        this.editArea.setVisible(false);
        this.displayArea.layout(true, true);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        if (this.browser != null) {
            if (this.currentPageButton.getSelection()) {
                this.browser.setURL(url);
            } else {
                this.browser.setURL(this.startUrlText.getText());
            }
        }
        this.url = url;
    }

    private void save() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
        IExtension[] extensions = ep.getExtensions();
        boolean found = false;
        int i = 0;
        while (i < extensions.length && !found) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length && !found) {
                String browserClass = ce[j].getAttribute("class");
                String browserName = BrowserExtensionLoader.getBrowserLabel(ce[j]);
                if (browserClass != null && browserName != null && browserName.equals(this.browserLabel)) {
                    found = true;
                    try {
                        Object obj = ce[j].createExecutableExtension("class");
                        if (obj instanceof ContributedBrowser) {
                            this.setBrowser((ContributedBrowser)obj, browserName);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++j;
            }
            ++i;
        }
        this.editor.setPreviewPageText(this.index, this.title);
        this.setURL(this.url);
        this.editor.savePreviewsPages();
        this.showBrowserArea();
    }

    private void createButtonSection(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout bLayout = new GridLayout(2, false);
        bLayout.marginHeight = 0;
        bLayout.marginWidth = 0;
        buttons.setLayout((Layout)bLayout);
        GridData bData = new GridData(4, 4, true, false);
        buttons.setLayoutData((Object)bData);
        this.save = new Button(buttons, 8);
        this.save.setToolTipText(Messages.PreviewConfigurationPage_SaveText);
        this.save.setImage(CSSPlugin.getImage("icons/save.gif"));
        this.save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewConfigurationPage.this.save();
            }
        });
        this.save.setLayoutData((Object)new GridData(4, 4, false, false));
        this.cancel = new Button(buttons, 8);
        this.cancel.setText(Messages.PreviewConfigurationPage_CancelText);
        this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewConfigurationPage.this.showBrowserArea();
            }
        });
        this.cancel.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    private void createConfigurationSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.PreviewConfigurationPage_GroupTitle);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight *= 2;
        layout.marginWidth *= 2;
        group.setLayout((Layout)layout);
        this.nameLabel = new Label((Composite)group, 16384);
        this.nameLabel.setText(Messages.PreviewConfigurationPage_NameLabel);
        this.nameText = new Text((Composite)group, 2052);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nameText.setText(this.title);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PreviewConfigurationPage.this.title = PreviewConfigurationPage.this.nameText.getText();
            }
        });
    }

    private void createBrowserSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.PreviewConfigurationPage_BrowserGroupText);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight *= 2;
        layout.marginWidth *= 2;
        group.setLayout((Layout)layout);
        List<String> labels = BrowserExtensionLoader.getAllBrowserLabels();
        int i = 0;
        while (i < labels.size()) {
            String label = labels.get(i);
            final Button browserButton = new Button((Composite)group, 16);
            browserButton.setText(label);
            if (i == 0) {
                this.browserLabel = label;
                browserButton.setSelection(true);
            }
            this.buttons.put(label, browserButton);
            browserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (browserButton.getSelection()) {
                        PreviewConfigurationPage.this.browserLabel = browserButton.getText();
                    }
                }
            });
            ++i;
        }
    }

    public String getTitle() {
        return this.title;
    }

    private void createStartActionSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.PreviewConfigurationPage_StartActionGroupText);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight *= 2;
        layout.marginWidth *= 2;
        group.setLayout((Layout)layout);
        this.currentPageButton = new Button((Composite)group, 16);
        this.currentPageButton.setText(Messages.PreviewConfigurationPage_CurrentPageText);
        GridData data = new GridData(16384, 0x1000000, true, false);
        data.horizontalSpan = 2;
        this.currentPageButton.setLayoutData((Object)data);
        this.currentPageButton.setSelection(true);
        this.startUrlButton = new Button((Composite)group, 16);
        this.startUrlButton.setText(Messages.PreviewConfigurationPage_StartUrlText);
        data = new GridData(16384, 0x1000000, false, false);
        this.startUrlButton.setLayoutData((Object)data);
        this.startUrlText = new Text((Composite)group, 2052);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 1;
        this.startUrlText.setLayoutData((Object)data);
    }

    private void createServerSection(Composite parent) {
        Group group = new Group(parent, 0x800000);
        group.setText(Messages.PreviewConfigurationPage_ServerGroupTitle);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight *= 2;
        layout.marginWidth *= 2;
        group.setLayout((Layout)layout);
        this.internalServerButton = new Button((Composite)group, 16);
        this.internalServerButton.setText(Messages.PreviewConfigurationPage_InternalServerText);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 2;
        this.internalServerButton.setLayoutData((Object)data);
        this.internalServerButton.setSelection(true);
        this.customServerButton = new Button((Composite)group, 16);
        this.customServerButton.setText(Messages.PreviewConfigurationPage_ExternalServerText);
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 2;
        this.customServerButton.setLayoutData((Object)data);
        Label baseUrlLabel = new Label((Composite)group, 0);
        baseUrlLabel.setText(Messages.PreviewConfigurationPage_BaseUrlLabel);
        baseUrlLabel.setAlignment(131072);
        data = new GridData(131072, 0x1000000, false, false);
        data.horizontalIndent = 50;
        baseUrlLabel.setLayoutData((Object)data);
        this.baseUrlText = new Text((Composite)group, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.baseUrlText.setLayoutData((Object)data);
        Label dummyLabel = new Label((Composite)group, 0);
        dummyLabel.setLayoutData((Object)new GridData());
        this.addProjectNameButton = new Button((Composite)group, 32);
        this.addProjectNameButton.setText(Messages.PreviewConfigurationPage_AddProjectText);
        this.addProjectNameButton.setLayoutData((Object)new GridData());
    }

    public Control getControl() {
        return this.displayArea;
    }

    public void dispose() {
        if (this.browser != null) {
            this.browser.dispose();
        }
    }
}

