/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.toolbar;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editors.toolbar.IToolBarMember;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EyeDropper
implements IToolBarMember {
    protected int lastX;
    protected int lastY;

    public void execute(IUnifiedEditor editor, String string) {
        ITextSelection sel = (ITextSelection)editor.getViewer().getSelectionProvider().getSelection();
        if (sel.isEmpty()) {
            return;
        }
        try {
            String replacement = this.getUserColor();
            if (replacement == null) {
                return;
            }
            int offset = sel.getOffset();
            int len = sel.getLength();
            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            doc.replace(offset, len, replacement);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)e.getMessage());
        }
    }

    private String getUserColor() {
        final Display display = Display.getCurrent();
        final Shell shell = new Shell(display, 147464);
        shell.setFullScreen(true);
        Rectangle rect = display.getPrimaryMonitor().getClientArea();
        shell.setBounds(rect);
        shell.setLocation(rect.x - 5, rect.y - 5);
        shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                switch (event.detail) {
                    case 2: {
                        shell.close();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            }
        });
        shell.setLayout((Layout)new GridLayout(1, true));
        final Canvas canvas = new Canvas((Composite)shell, 0);
        canvas.setLayoutData((Object)new GridData(rect.width, rect.height));
        final Image image = this.takeScreenshot(display, rect);
        canvas.setBackgroundImage(image);
        Image cursorImage = CSSPlugin.getImage("icons/eyedropper.gif");
        ImageData cursordata = cursorImage.getImageData();
        Cursor cursor = new Cursor((Device)display, cursordata, 0, 15);
        canvas.setCursor(cursor);
        canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                canvas.redraw(EyeDropper.this.lastX + 9, EyeDropper.this.lastY + -61, 52, 52, false);
                canvas.update();
                EyeDropper.this.lastX = e.x;
                EyeDropper.this.lastY = e.y;
                RGB rgb = EyeDropper.this.getColor(image, e);
                Color bg = new Color((Device)display, rgb);
                int total = rgb.blue + rgb.green + rgb.red;
                Color fg = total < 384 ? new Color((Device)display, 255, 255, 255) : new Color((Device)display, 0, 0, 0);
                GC gc = new GC((Drawable)canvas);
                gc.setBackground(bg);
                gc.setForeground(fg);
                gc.drawRectangle(e.x + 9, e.y + -61, 51, 51);
                gc.fillRectangle(e.x + 10, e.y + -60, 50, 50);
                gc.drawString(EyeDropper.this.toHex(rgb), e.x + 10, e.y + -42);
                bg.dispose();
                fg.dispose();
                gc.dispose();
            }
        });
        final String[] result = new String[1];
        canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                RGB rgb = EyeDropper.this.getColor(image, e);
                result[0] = EyeDropper.this.toHex(rgb);
                image.dispose();
                shell.close();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        cursor.dispose();
        if (result[0] != null) {
            return "#" + result[0];
        }
        return null;
    }

    private Image takeScreenshot(Display display, Rectangle rect) {
        Image snap = new Image((Device)display, rect);
        GC gc = new GC((Drawable)display);
        gc.copyArea(snap, 0, 0);
        gc.dispose();
        return snap;
    }

    private String toHex(RGB selectedcolor) {
        return String.valueOf(this.twoDigitHex(selectedcolor.red)) + this.twoDigitHex(selectedcolor.green) + this.twoDigitHex(selectedcolor.blue);
    }

    private String twoDigitHex(int color) {
        return this.pad(Integer.toHexString(color));
    }

    private String pad(String str) {
        if (str.length() == 0) {
            return "00";
        }
        if (str.length() == 1) {
            return "0" + str;
        }
        return str;
    }

    protected RGB getColor(Image image, MouseEvent e) {
        return this.getColor(image, e.x, e.y);
    }

    protected RGB getColor(Image image, int x, int y) {
        int pixel = image.getImageData().getPixel(x, y);
        return image.getImageData().palette.getRGB(pixel);
    }
}

