/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.validator.properties;

import com.aptana.ide.editor.css.validator.AptanaCSSInheritanceProperties;
import com.aptana.ide.editor.css.validator.AptanaCSSStyle;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;

public abstract class CustomCSSProperty
extends CssProperty {
    private final String propertyName;

    public CustomCSSProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        AptanaCSSStyle aptanaStyle = (AptanaCSSStyle)style;
        if (aptanaStyle.getProperty(this.getPropertyName()) != null) {
            aptanaStyle.addRedefinitionWarning(ac, this);
        }
        aptanaStyle.setProperty(this.getPropertyName(), this);
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        AptanaCSSStyle aptanaStyle = (AptanaCSSStyle)style;
        if (resolve) {
            return aptanaStyle.getPropertyCascadingOrder(this.getPropertyName());
        }
        return aptanaStyle.getProperty(this.getPropertyName());
    }

    public boolean Inherited() {
        return AptanaCSSInheritanceProperties.getInheritance(this);
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public boolean equals(CssProperty property) {
        if (this.get() == null) {
            return false;
        }
        return this.get().equals(property.get());
    }

    public String toString() {
        if (this.get() == null) {
            return null;
        }
        return this.get().toString();
    }

    protected String getPropertyNameNoMinus() {
        String propertyName = this.getPropertyName();
        if (propertyName == null) {
            return propertyName;
        }
        if (propertyName.startsWith("-")) {
            return propertyName.substring(1);
        }
        return propertyName;
    }
}

