/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.validator.properties;

import com.aptana.ide.editor.css.validator.properties.CSSValueTypeConverter;
import com.aptana.ide.editor.css.validator.properties.CSSValueValidator;
import com.aptana.ide.editor.css.validator.properties.CustomCSSProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;

public class PlugableCSSProperty
extends CustomCSSProperty {
    private final CssValue value;

    public PlugableCSSProperty(String propertyName) {
        super(propertyName);
        this.value = null;
    }

    public PlugableCSSProperty(String propertyName, Class[] types, CSSValueTypeConverter[] converters, CSSValueValidator[] validators, ApplContext context, CssExpression expression, boolean check) throws InvalidParamException {
        super(propertyName);
        if (check && expression.getCount() != 1) {
            throw new InvalidParamException("unrecognize", context);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        int i = 0;
        while (i < types.length) {
            Class type = types[i];
            if (type.isInstance(val)) {
                expression.next();
                if (converters != null && converters.length != 0) {
                    int j = 0;
                    while (j < converters.length) {
                        CssValue convertedValue = converters[j].convert(val);
                        if (convertedValue != null) {
                            val = convertedValue;
                            break;
                        }
                        ++j;
                    }
                }
                if (validators != null && validators.length != 0) {
                    int k = 0;
                    while (k < validators.length) {
                        if (validators[k].canValidate(val) && !validators[k].isValid(val)) {
                            throw new InvalidParamException("value", (Object)val.toString(), (Object)this.getPropertyNameNoMinus(), context);
                        }
                        ++k;
                    }
                }
                this.value = val;
                return;
            }
            ++i;
        }
        throw new InvalidParamException("value", (Object)val.toString(), (Object)this.getPropertyNameNoMinus(), context);
    }

    public PlugableCSSProperty(String propertyName, Class[] types, CSSValueTypeConverter[] converters, CSSValueValidator[] validators, ApplContext context, CssExpression expression) throws InvalidParamException {
        this(propertyName, types, converters, validators, context, expression, false);
    }

    public Object get() {
        return this.value;
    }

    public boolean isDefault() {
        return false;
    }
}

