/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.eclipse;

import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.LexerPlugin;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.lexer.matcher.MatcherLexerBuilder;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.eclipse.InstanceCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public abstract class ParsingRegistry {
    private static final String TOKEN_LIST_ID = "com.aptana.ide.editors.tokenList";
    private static final String PARSER_ID = "com.aptana.ide.editors.parser";
    private static final String SCANNER_ID = "com.aptana.ide.editors.scanner";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_RESOURCE = "resource";
    private static final String ATTR_EXTENSION = "extension";
    private static final String TAG_PARSER = "parser";
    private static final String TAG_SCANNER = "scanner";
    private static final String TAG_TOKEN_LIST = "tokenList";
    private static final String TAG_TEXT_MATCHER = "textMatcher";
    private static Map<String, InstanceCreator> languageTokenLists = new HashMap<String, InstanceCreator>();
    private static Map<String, InstanceCreator> extensionTokenLists = new HashMap<String, InstanceCreator>();
    private static Map<String, InstanceCreator> languageParsers = new HashMap<String, InstanceCreator>();
    private static Map<String, InstanceCreator> languageScanners = new HashMap<String, InstanceCreator>();

    static {
        ParsingRegistry.loadAll();
    }

    public static void clearAll() {
        languageTokenLists.clear();
        extensionTokenLists.clear();
    }

    public static void loadAll() {
        ParsingRegistry.loadTokenLists();
        ParsingRegistry.loadParsers();
        ParsingRegistry.loadScanners();
    }

    public static void reloadAll() {
        ParsingRegistry.clearAll();
        ParsingRegistry.loadAll();
    }

    public static IParser getParser(String language) {
        if (!languageParsers.containsKey(language)) {
            return null;
        }
        InstanceCreator creator = languageParsers.get(language);
        return (IParser)creator.getCachedInstance();
    }

    public static IParser getScanner(String language) {
        if (!languageScanners.containsKey(language)) {
            return null;
        }
        InstanceCreator creator = languageScanners.get(language);
        return (IParser)creator.getCachedInstance();
    }

    public static TokenList getTokenList(String language) {
        if (!languageTokenLists.containsKey(language)) {
            return null;
        }
        InstanceCreator creator = languageTokenLists.get(language);
        return (TokenList)creator.getCachedInstance();
    }

    public static TokenList getTokenListByExtension(String extension) {
        if (extension == null || extension.length() <= 0) {
            return null;
        }
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        if (!extensionTokenLists.containsKey(extension)) {
            return null;
        }
        InstanceCreator creator = extensionTokenLists.get(extension);
        return (TokenList)creator.getCachedInstance();
    }

    public static IParser createParser(String language) {
        if (!languageParsers.containsKey(language)) {
            return null;
        }
        InstanceCreator creator = languageParsers.get(language);
        return (IParser)creator.createInstance();
    }

    public static IParser createScanner(String language) {
        if (!languageScanners.containsKey(language)) {
            return null;
        }
        InstanceCreator creator = languageScanners.get(language);
        return (IParser)creator.createInstance();
    }

    public static TokenList createTokenList(InputStream input) throws LexerException {
        if (input == null) {
            return null;
        }
        MatcherLexerBuilder builder = new MatcherLexerBuilder();
        builder.loadXML(input);
        ILexer lexer = builder.buildLexer();
        String[] languages = lexer.getLanguages();
        if (languages != null && languages.length > 0) {
            return (TokenList)lexer.getTokenList(languages[0]);
        }
        return null;
    }

    public static TokenList createTokenList(String language) {
        if (!languageTokenLists.containsKey(language)) {
            return null;
        }
        InstanceCreator creator = languageTokenLists.get(language);
        return (TokenList)creator.createInstance();
    }

    public static boolean hasParser(String language) {
        return languageParsers.containsKey(language);
    }

    public static boolean hasScanner(String language) {
        return languageScanners.containsKey(language);
    }

    public static boolean hasTokenList(String language) {
        return languageTokenLists.containsKey(language);
    }

    private static void loadTokenLists() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(TOKEN_LIST_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    InstanceCreator instance = null;
                    String language = null;
                    String fileExtension = null;
                    if (ParsingRegistry.isActivityEnabled(element)) {
                        if (elementName.equals(TAG_TOKEN_LIST) && LexerPlugin.useCodeBasedLexer()) {
                            String tokenListClass = element.getAttribute(ATTR_CLASS);
                            language = element.getAttribute(ATTR_LANGUAGE);
                            fileExtension = element.getAttribute(ATTR_EXTENSION);
                            if (fileExtension != null && fileExtension.startsWith(".")) {
                                fileExtension = fileExtension.substring(1);
                            }
                            if (tokenListClass != null && language != null && language.length() > 0) {
                                instance = new InstanceCreator(element, ATTR_CLASS);
                            }
                        } else if (elementName.equals(TAG_TEXT_MATCHER) && LexerPlugin.useMatcherLexer()) {
                            String resourceName = element.getAttribute(ATTR_RESOURCE);
                            language = element.getAttribute(ATTR_LANGUAGE);
                            fileExtension = element.getAttribute(ATTR_EXTENSION);
                            if (fileExtension != null && fileExtension.startsWith(".")) {
                                fileExtension = fileExtension.substring(1);
                            }
                            if (resourceName != null && language != null && language.length() > 0) {
                                instance = new InstanceCreator(element, resourceName){

                                    public Object createInstance() {
                                        IExtension ext = this.element.getDeclaringExtension();
                                        String pluginId = ext.getNamespaceIdentifier();
                                        Bundle bundle = Platform.getBundle((String)pluginId);
                                        URL resource = bundle.getResource(this.attributeName);
                                        if (resource == null) {
                                            resource = bundle.getEntry(this.attributeName);
                                        }
                                        try {
                                            InputStream input = resource.openStream();
                                            return ParsingRegistry.createTokenList(input);
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                        catch (LexerException e) {
                                            e.printStackTrace();
                                        }
                                        return null;
                                    }
                                };
                            }
                        }
                        if (instance != null) {
                            languageTokenLists.put(language, instance);
                            if (fileExtension != null) {
                                extensionTokenLists.put(fileExtension, instance);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static boolean isActivityEnabled(IConfigurationElement element) {
        return true;
    }

    private static void loadParsers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(PARSER_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (ParsingRegistry.isActivityEnabled(element) && elementName.equals(TAG_PARSER)) {
                        String parserClass = element.getAttribute(ATTR_CLASS);
                        String language = element.getAttribute(ATTR_LANGUAGE);
                        if (parserClass != null && language != null && language.length() > 0) {
                            InstanceCreator creator = new InstanceCreator(element, ATTR_CLASS);
                            languageParsers.put(language, creator);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void loadScanners() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(SCANNER_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (ParsingRegistry.isActivityEnabled(element) && elementName.equals(TAG_SCANNER)) {
                        String parserClass = element.getAttribute(ATTR_CLASS);
                        String language = element.getAttribute(ATTR_LANGUAGE);
                        if (parserClass != null && language != null && language.length() > 0) {
                            InstanceCreator creator = new InstanceCreator(element, ATTR_CLASS);
                            languageScanners.put(language, creator);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static void registerParser(String language, IParser parser) {
        if (!languageParsers.containsKey(language)) {
            InstanceCreator creator = new InstanceCreator(null, null);
            creator.setCache(parser);
            languageParsers.put(language, creator);
        } else {
            InstanceCreator creator = languageParsers.get(language);
            creator.setCache(parser);
        }
    }

    public static void registerScanner(String language, IParser parser) {
        if (!languageScanners.containsKey(language)) {
            InstanceCreator creator = new InstanceCreator(null, null);
            creator.setCache(parser);
            languageScanners.put(language, creator);
        } else {
            InstanceCreator creator = languageScanners.get(language);
            creator.setCache(parser);
        }
    }

    public static void registerTokenList(TokenList tokenList) {
        ParsingRegistry.registerTokenList(tokenList, null);
    }

    public static void registerTokenList(TokenList tokenList, String fileExtension) {
        InstanceCreator creator;
        String language = tokenList.getLanguage();
        if (!languageTokenLists.containsKey(language)) {
            creator = new InstanceCreator(null, null);
            creator.setCache(tokenList);
            languageTokenLists.put(language, creator);
        } else {
            creator = languageTokenLists.get(language);
            creator.setCache(tokenList);
        }
        if (fileExtension != null && fileExtension.length() > 0) {
            if (fileExtension.startsWith(".")) {
                fileExtension = fileExtension.substring(1);
            }
            if (!extensionTokenLists.containsKey(fileExtension)) {
                creator = new InstanceCreator(null, null);
                creator.setCache(tokenList);
                extensionTokenLists.put(fileExtension, creator);
            } else {
                creator = extensionTokenLists.get(fileExtension);
                creator.setCache(tokenList);
            }
        }
    }

    public static void unregisterParser(String language) {
        languageParsers.remove(language);
    }

    public static void unregisterScanner(String language) {
        languageScanners.remove(language);
    }

    public static void clearTokenList(String language) {
        if (languageTokenLists.containsKey(language)) {
            InstanceCreator creator = languageTokenLists.get(language);
            creator.setCache(null);
        }
    }

    public static void unregisterTokenList(TokenList tokenList) {
        languageTokenLists.remove(tokenList.getLanguage());
    }
}

