/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.eclipseplugin.editors;

import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.GraphPanel;
import com.horstmann.violet.framework.gui.sidebar.SideBar;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JScrollPane;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DiagramComposite
extends Composite {
    private DiagramPanel UMLDiagramPanel;
    private Frame frame;

    public DiagramComposite(Composite parent, DiagramPanel UMLDiagramPanel) {
        super(parent, 0x1000800);
        this.UMLDiagramPanel = UMLDiagramPanel;
        this.fixLayoutProblem(this.UMLDiagramPanel);
        this.initializePanel(this.UMLDiagramPanel, parent);
        this.frame = SWT_AWT.new_Frame((Composite)this);
        this.frame.setVisible(true);
        this.frame.add(UMLDiagramPanel);
        this.frame.pack();
        GridData gridData2 = new GridData(1808);
        this.setLayoutData(gridData2);
    }

    private void initializePanel(DiagramPanel diagramPanel, Composite parent) {
        final GraphPanel graphPanel = diagramPanel.getGraphPanel();
        Graph graph = graphPanel.getGraph();
        final SideBar sideBar = diagramPanel.getSideBar(graph);
        this.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 127) {
                    graphPanel.removeSelected();
                }
            }
        });
        this.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if (event.count > 0) {
                    sideBar.getSideToolPanel().selectPreviousButton();
                }
                if (event.count < 0) {
                    sideBar.getSideToolPanel().selectNextButton();
                }
            }
        });
        this.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                DiagramComposite.this.setFocus();
            }
        });
    }

    private void fixLayoutProblem(DiagramPanel diagramPanel) {
        GraphPanel graphPanel = diagramPanel.getGraphPanel();
        Graph graph = graphPanel.getGraph();
        final SideBar sideBar = diagramPanel.getSideBar(graph);
        final JScrollPane scrollPane = diagramPanel.getScrollableGraphPanel(graph, sideBar);
        sideBar.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                sideBar.validate();
                scrollPane.validate();
            }
        });
    }
}

