/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.eclipseplugin.editors;

import com.horstmann.violet.framework.gui.DialogFactory;
import com.horstmann.violet.framework.gui.DialogFactoryListener;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import java.awt.Container;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DialogManager {
    private static DialogManager dialogManager;

    private DialogManager() {
        DialogFactory dialogFactory = DialogFactory.getInstance();
        dialogFactory.setDialogMode(1);
        dialogFactory.setListener(new DialogFactoryListener(){

            @Override
            public void mustDisplayPanel(JOptionPane optionPane, String title, boolean isModal) {
                DialogManager.this.displayOptionPane(optionPane, title, isModal);
            }
        });
    }

    public static void createSingleton() {
        if (dialogManager == null) {
            dialogManager = new DialogManager();
        }
    }

    private void displayOptionPane(final JOptionPane optionPane, final String title, boolean isModal) {
        final Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = d.getActiveShell();
                final Composite awtContainer = new Composite((Composite)shell, 0x1000000);
                Frame frame = SWT_AWT.new_Frame((Composite)awtContainer);
                frame.setVisible(false);
                final JDialog dialog = new JDialog(frame);
                dialog.setTitle(title);
                Container contentPane = dialog.getContentPane();
                contentPane.setBackground(ThemeManager.getInstance().getTheme().getBACKGROUND_COLOR());
                contentPane.add(optionPane);
                dialog.pack();
                int x = shell.getLocation().x + shell.getBounds().width / 2 - dialog.getWidth() / 2;
                int y = shell.getLocation().y + shell.getBounds().height / 2 - dialog.getHeight() / 2;
                dialog.setLocation(x, y);
                dialog.setVisible(true);
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if (dialog.isVisible() && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                            dialog.dispose();
                            d.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    awtContainer.dispose();
                                }
                            });
                        }
                    }
                });
            }
        });
    }
}

