/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.diagram.ArrowHead;
import com.horstmann.violet.framework.diagram.LineStyle;
import com.horstmann.violet.framework.diagram.ShapeEdge;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JLabel;

public abstract class SegmentedLineEdge
extends ShapeEdge {
    private LineStyle lineStyle = LineStyle.SOLID;
    private ArrowHead startArrowHead = ArrowHead.NONE;
    private ArrowHead endArrowHead = ArrowHead.NONE;
    private String startLabel = "";
    private String middleLabel = "";
    private String endLabel = "";
    private static JLabel label = new JLabel();

    public void setLineStyle(LineStyle newValue) {
        this.lineStyle = newValue;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setStartArrowHead(ArrowHead newValue) {
        this.startArrowHead = newValue;
    }

    public ArrowHead getStartArrowHead() {
        return this.startArrowHead;
    }

    public void setEndArrowHead(ArrowHead newValue) {
        this.endArrowHead = newValue;
    }

    public ArrowHead getEndArrowHead() {
        return this.endArrowHead;
    }

    public void setStartLabel(String newValue) {
        this.startLabel = newValue;
    }

    public String getStartLabel() {
        return this.startLabel;
    }

    public void setMiddleLabel(String newValue) {
        this.middleLabel = newValue;
    }

    public String getMiddleLabel() {
        return this.middleLabel;
    }

    public void setEndLabel(String newValue) {
        this.endLabel = newValue;
    }

    public String getEndLabel() {
        return this.endLabel;
    }

    @Override
    public void draw(Graphics2D g2) {
        ArrayList<Point2D> points = this.getPoints();
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.lineStyle.getStroke());
        g2.draw(this.getSegmentPath());
        g2.setStroke(oldStroke);
        this.startArrowHead.draw(g2, points.get(1), points.get(0));
        this.endArrowHead.draw(g2, points.get(points.size() - 2), points.get(points.size() - 1));
        this.drawString(g2, points.get(1), points.get(0), this.startArrowHead, this.startLabel, false);
        this.drawString(g2, points.get(points.size() / 2 - 1), points.get(points.size() / 2), null, this.middleLabel, true);
        this.drawString(g2, points.get(points.size() - 2), points.get(points.size() - 1), this.endArrowHead, this.endLabel, false);
    }

    private void drawString(Graphics2D g2, Point2D p, Point2D q, ArrowHead arrow, String s, boolean center) {
        if (s == null || s.length() == 0) {
            return;
        }
        label.setText("<html>" + s + "</html>");
        label.setFont(g2.getFont());
        Dimension d = label.getPreferredSize();
        label.setBounds(0, 0, d.width, d.height);
        Rectangle2D b = SegmentedLineEdge.getStringBounds(g2, p, q, arrow, s, center);
        g2.translate(b.getX(), b.getY());
        label.paint(g2);
        g2.translate(-b.getX(), -b.getY());
    }

    private static Point2D getAttachmentPoint(Graphics2D g2, Point2D p, Point2D q, ArrowHead arrow, Dimension d, boolean center) {
        int GAP = 3;
        double xoff = 3.0;
        double yoff = -3.0 - d.getHeight();
        Point2D attach = q;
        if (center) {
            if (p.getX() > q.getX()) {
                return SegmentedLineEdge.getAttachmentPoint(g2, q, p, arrow, d, center);
            }
            attach = new Point2D.Double((p.getX() + q.getX()) / 2.0, (p.getY() + q.getY()) / 2.0);
            if (p.getY() < q.getY()) {
                yoff = -3.0 - d.getHeight();
            } else if (p.getY() == q.getY()) {
                xoff = -d.getWidth() / 2.0;
            } else {
                yoff = 3.0;
            }
        } else {
            if (p.getX() < q.getX()) {
                xoff = -3.0 - d.getWidth();
            }
            if (p.getY() > q.getY()) {
                yoff = 3.0;
            }
            if (arrow != null) {
                Rectangle2D arrowBounds = arrow.getPath(p, q).getBounds2D();
                xoff = p.getX() < q.getX() ? (xoff -= arrowBounds.getWidth()) : (xoff += arrowBounds.getWidth());
            }
        }
        return new Point2D.Double(attach.getX() + xoff, attach.getY() + yoff);
    }

    private static Rectangle2D getStringBounds(Graphics2D g2, Point2D p, Point2D q, ArrowHead arrow, String s, boolean center) {
        if (g2 == null) {
            return new Rectangle2D.Double();
        }
        if (s == null || s.equals("")) {
            return new Rectangle2D.Double(q.getX(), q.getY(), 0.0, 0.0);
        }
        label.setText("<html>" + s + "</html>");
        label.setFont(g2.getFont());
        Dimension d = label.getPreferredSize();
        Point2D a = SegmentedLineEdge.getAttachmentPoint(g2, p, q, arrow, d, center);
        return new Rectangle2D.Double(a.getX(), a.getY(), d.getWidth(), d.getHeight());
    }

    @Override
    public Rectangle2D getBounds(Graphics2D g2) {
        ArrayList<Point2D> points = this.getPoints();
        Rectangle2D r = super.getBounds(g2);
        r.add(SegmentedLineEdge.getStringBounds(g2, points.get(1), points.get(0), this.startArrowHead, this.startLabel, false));
        r.add(SegmentedLineEdge.getStringBounds(g2, points.get(points.size() / 2 - 1), points.get(points.size() / 2), null, this.middleLabel, true));
        r.add(SegmentedLineEdge.getStringBounds(g2, points.get(points.size() - 2), points.get(points.size() - 1), this.endArrowHead, this.endLabel, false));
        return r;
    }

    @Override
    public Shape getShape() {
        GeneralPath path = this.getSegmentPath();
        ArrayList<Point2D> points = this.getPoints();
        path.append(this.startArrowHead.getPath(points.get(1), points.get(0)), false);
        path.append(this.endArrowHead.getPath(points.get(points.size() - 2), points.get(points.size() - 1)), false);
        return path;
    }

    private GeneralPath getSegmentPath() {
        ArrayList<Point2D> points = this.getPoints();
        GeneralPath path = new GeneralPath();
        Point2D p = points.get(points.size() - 1);
        path.moveTo((float)p.getX(), (float)p.getY());
        for (int i = points.size() - 2; i >= 0; --i) {
            p = points.get(i);
            path.lineTo((float)p.getX(), (float)p.getY());
        }
        return path;
    }

    @Override
    public Line2D getConnectionPoints() {
        ArrayList<Point2D> points = this.getPoints();
        return new Line2D.Double(points.get(0), points.get(points.size() - 1));
    }

    public abstract ArrayList<Point2D> getPoints();
}

