/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.file;

import java.io.File;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class ExtensionFilter
extends FileFilter {
    private String description;
    private String[] extensions;

    public ExtensionFilter(String description, String[] extensions) {
        this.description = description;
        this.extensions = extensions;
    }

    public ExtensionFilter(String description, String extensions) {
        this.description = description;
        StringTokenizer tokenizer = new StringTokenizer(extensions, "|");
        this.extensions = new String[tokenizer.countTokens()];
        for (int i = 0; i < this.extensions.length; ++i) {
            this.extensions[i] = tokenizer.nextToken();
        }
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fname = f.getName().toLowerCase();
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!fname.endsWith(this.extensions[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String[] getExtensions() {
        return this.extensions;
    }
}

