/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.framework.gui.sidebar.SideBar;
import com.horstmann.violet.framework.gui.sidebar.SideToolPanel;
import com.horstmann.violet.framework.gui.sidebar.Tool;
import com.horstmann.violet.framework.gui.theme.Theme;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.resources.ResourceFactory;
import com.horstmann.violet.framework.swingextension.CollapsiblePane;
import com.horstmann.violet.framework.swingextension.CustomToggleButton;
import com.horstmann.violet.framework.swingextension.LinkButtonUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public class StatusBar
extends JPanel {
    private ResourceFactory resourceFactory;
    private static final int DIAGRAMTOOL_VIEWER_WIDTH = 350;

    public StatusBar(SideBar sideBar) {
        this.setLayout(new GridBagLayout());
        JPanel toolViewer = this.getDiagramToolViewer(sideBar.getSideToolPanel());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(2, 4, 3, 5);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)toolViewer, c);
        JButton sideBarLink = this.getSideBarLink(sideBar);
        c = new GridBagConstraints();
        c.anchor = 13;
        c.insets = new Insets(2, 5, 3, 5);
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)sideBarLink, c);
        Theme cLAF = ThemeManager.getInstance().getTheme();
        this.setBackground(cLAF.getSTATUSBAR_BACKGROUND_COLOR());
        this.setBorder(new MatteBorder(1, 0, 0, 0, cLAF.getSTATUSBAR_BORDER_COLOR()));
    }

    private JButton getSideBarLink(final CollapsiblePane collapsiblePane) {
        JButton link = this.getResourceFactory().createButton("sidebarlink");
        link.setUI(new LinkButtonUI());
        link.setForeground(ThemeManager.getInstance().getTheme().getMENUBAR_FOREGROUND_COLOR());
        link.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                collapsiblePane.setCollapsed();
            }
        });
        return link;
    }

    private JPanel getDiagramToolViewer(SideToolPanel sideToolPanel) {
        Tool selectedTool = sideToolPanel.getSelectedTool();
        Theme cLAF = ThemeManager.getInstance().getTheme();
        final CustomToggleButton button = new CustomToggleButton(selectedTool.getLabel(), selectedTool.getIcon(), cLAF.getTOGGLEBUTTON_SELECTED_COLOR(), cLAF.getTOGGLEBUTTON_SELECTED_BORDER_COLOR(), cLAF.getTOGGLEBUTTON_UNSELECTED_COLOR());
        button.setSelected(true);
        button.setPreferredSize(new Dimension(350, (int)button.getPreferredSize().getHeight()));
        sideToolPanel.addListener(new SideToolPanel.Listener(){

            @Override
            public void toolSelectionChanged(Tool tool) {
                String text = tool.getLabel();
                Icon icon = tool.getIcon();
                button.setText(text);
                button.setIcon(icon);
                button.setToolTipText(text);
                button.repaint();
            }
        });
        return button;
    }

    private ResourceFactory getResourceFactory() {
        if (this.resourceFactory == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("properties.StatusBarStrings", Locale.getDefault());
            this.resourceFactory = new ResourceFactory(resourceBundle);
        }
        return this.resourceFactory;
    }
}

