/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.menu;

import com.horstmann.violet.framework.gui.EditorFrame;
import com.horstmann.violet.framework.gui.menu.EditMenu;
import com.horstmann.violet.framework.gui.menu.FileMenu;
import com.horstmann.violet.framework.gui.menu.HelpMenu;
import com.horstmann.violet.framework.gui.menu.ViewMenu;
import com.horstmann.violet.framework.resources.ResourceFactory;
import java.util.Locale;
import java.util.ResourceBundle;

public class MenuFactory {
    private ResourceFactory resourceFactory;
    private ResourceBundle resourceBundle;
    private EditMenu editMenu;
    private FileMenu fileMenu;
    private HelpMenu helpMenu;
    private ViewMenu viewMenu;

    public EditMenu getEditMenu(EditorFrame editorFrame) {
        if (this.editMenu == null) {
            this.editMenu = new EditMenu(editorFrame, this.getResourceFactory());
        }
        return this.editMenu;
    }

    public FileMenu getFileMenu(EditorFrame editorFrame) {
        if (this.fileMenu == null) {
            this.fileMenu = new FileMenu(editorFrame, this.getResourceFactory());
        }
        return this.fileMenu;
    }

    public HelpMenu getHelpMenu(EditorFrame editorFrame) {
        if (this.helpMenu == null) {
            this.helpMenu = new HelpMenu(editorFrame, this.getResourceFactory());
        }
        return this.helpMenu;
    }

    public ViewMenu getViewMenu(EditorFrame editorFrame) {
        if (this.viewMenu == null) {
            this.viewMenu = new ViewMenu(editorFrame, this.getResourceBundle(), this.getResourceFactory());
        }
        return this.viewMenu;
    }

    private ResourceFactory getResourceFactory() {
        if (this.resourceFactory == null) {
            ResourceBundle rs = this.getResourceBundle();
            this.resourceFactory = new ResourceFactory(rs);
        }
        return this.resourceFactory;
    }

    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle("properties.MenuStrings", Locale.getDefault());
        }
        return this.resourceBundle;
    }
}

