/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.network.config;

import com.horstmann.violet.framework.network.NetworkConstant;
import com.horstmann.violet.framework.network.config.IGuestNetworkConfig;
import com.horstmann.violet.framework.preference.PreferencesConstant;
import com.horstmann.violet.framework.preference.PreferencesService;
import com.horstmann.violet.framework.preference.PreferencesServiceFactory;
import java.net.MalformedURLException;
import java.net.URL;

public class HTTPGuestConfig
implements IGuestNetworkConfig {
    private String userID;
    private String localIpPort;
    private String localIpAddress;
    private String serverIpAddress;
    private String serverIpPort = "9090";

    @Override
    public void loadPreferedValues() {
        PreferencesService preferencesService = PreferencesServiceFactory.getInstance();
        String userID = preferencesService.get(PreferencesConstant.NETWORK_GUESTCONFIG_USERID, "username");
        String localURL = preferencesService.get(PreferencesConstant.NETWORK_GUESTCONFIG_HTTP_LOCALURL, NetworkConstant.DEFAULT_HTTP_LOCAL_URL.toString());
        this.setUserID(userID);
        try {
            URL url = new URL(localURL);
            this.setLocalIpAddress(url.getHost());
            this.setLocalIpPort(url.getPort() + "");
        }
        catch (MalformedURLException e) {
            this.setLocalIpPort("9090");
        }
        String serverURL = preferencesService.get(PreferencesConstant.NETWORK_GUESTCONFIG_HTTP_SERVERURL, null);
        try {
            URL url = new URL(serverURL);
            this.setServerIpAddress(url.getHost());
            this.setServerIpPort(url.getPort() + "");
        }
        catch (MalformedURLException e1) {
            this.setServerIpPort("9090");
        }
    }

    @Override
    public void savePreferedValues() {
        PreferencesService preferencesService = PreferencesServiceFactory.getInstance();
        preferencesService.put(PreferencesConstant.NETWORK_GUESTCONFIG_USERID, this.getUserID());
        preferencesService.put(PreferencesConstant.NETWORK_GUESTCONFIG_HTTP_LOCALURL, this.getLocalURL().toString());
        preferencesService.put(PreferencesConstant.NETWORK_GUESTCONFIG_HTTP_SERVERURL, this.getServerURL().toString());
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getLocalIpAddress() {
        return this.localIpAddress;
    }

    public void setLocalIpAddress(String ipAddress) {
        this.localIpAddress = ipAddress;
    }

    public String getLocalIpPort() {
        return this.localIpPort;
    }

    public void setLocalIpPort(String ipPort) {
        this.localIpPort = ipPort;
    }

    @Override
    public URL getLocalURL() {
        try {
            URL url = new URL("http://" + this.getLocalIpAddress() + ":" + this.getLocalIpPort() + "/");
            return url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while building local network URL", e);
        }
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }

    public void setServerIpAddress(String serverIpAddress) {
        this.serverIpAddress = serverIpAddress;
    }

    public String getServerIpPort() {
        return this.serverIpPort;
    }

    public void setServerIpPort(String serverPort) {
        this.serverIpPort = serverPort;
    }

    @Override
    public URL getServerURL() {
        try {
            URL url = new URL("http://" + this.getServerIpAddress() + ":" + this.getServerIpPort() + "/");
            return url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while building server network URL", e);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        HTTPGuestConfig clone = new HTTPGuestConfig();
        String emptyString = "";
        if (this.userID != null) {
            clone.userID = this.userID + emptyString;
        }
        if (this.localIpAddress != null) {
            clone.localIpAddress = this.localIpAddress + emptyString;
        }
        if (this.localIpPort != null) {
            clone.localIpPort = this.localIpPort + emptyString;
        }
        if (this.serverIpAddress != null) {
            clone.serverIpAddress = this.localIpAddress + emptyString;
        }
        if (this.serverIpPort != null) {
            clone.serverIpPort = this.serverIpPort + emptyString;
        }
        return clone;
    }
}

