/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.network.receiver;

import com.horstmann.violet.framework.diagram.GraphService;
import com.horstmann.violet.framework.network.NetworkMessage;
import com.horstmann.violet.framework.network.receiver.IReceiver;
import com.horstmann.violet.framework.network.receiver.IReceiverListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class HTTPReceiver
implements IReceiver {
    private EventListenerList listeners;
    private URL url;

    public HTTPReceiver(URL receiverURL) {
        this.url = receiverURL;
        this.listeners = new EventListenerList();
    }

    public void performReceivedMessage(String message) {
        try {
            NetworkMessage msg = this.getNetworkMessage(message);
            this.fireEvent(msg);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addReceptionListener(IReceiverListener listener) {
        this.listeners.add(IReceiverListener.class, listener);
    }

    @Override
    public void removeAllListener() {
        EventListener[] l = this.listeners.getListeners(IReceiverListener.class);
        for (int i = 0; i < l.length; ++i) {
            this.listeners.remove(IReceiverListener.class, (IReceiverListener)l[i]);
        }
    }

    @Override
    public void removeListener(IReceiverListener listener) {
        this.listeners.remove(IReceiverListener.class, listener);
    }

    public IReceiverListener[] getReceptionListeners() {
        return (IReceiverListener[])this.listeners.getListeners(IReceiverListener.class);
    }

    @Override
    public boolean hasNoListener() {
        return this.listeners.getListenerCount() == 0;
    }

    private void fireEvent(NetworkMessage msg) {
        IReceiverListener[] listeners = this.getReceptionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[0].messageReceived(msg);
        }
    }

    private NetworkMessage getNetworkMessage(String message) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(message.getBytes());
        NetworkMessage msg = GraphService.readNetworkMessage(bis);
        return msg;
    }

    @Override
    public URL getURL() {
        return this.url;
    }
}

