/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.resources;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class ResourceFactory {
    private ResourceBundle bundle;

    public ResourceFactory(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public JMenuItem createMenuItem(String prefix) {
        String text = this.bundle.getString(prefix + ".text");
        JMenuItem menuItem = new JMenuItem(text);
        this.updateMenuItem(menuItem, prefix);
        return menuItem;
    }

    public JMenuItem createCheckBoxMenuItem(String prefix) {
        String text = this.bundle.getString(prefix + ".text");
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(text);
        this.updateMenuItem(menuItem, prefix);
        return menuItem;
    }

    public JMenuItem createRadioButtonMenuItem(String prefix) {
        String text = this.bundle.getString(prefix + ".text");
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(text);
        this.updateMenuItem(menuItem, prefix);
        return menuItem;
    }

    private void updateMenuItem(JMenuItem menuItem, String prefix) {
        try {
            String text = this.bundle.getString(prefix + ".text");
            menuItem.setText(text);
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
        try {
            String mnemonic = this.bundle.getString(prefix + ".mnemonic");
            menuItem.setMnemonic(mnemonic.charAt(0));
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
        try {
            String accelerator = this.bundle.getString(prefix + ".accelerator");
            menuItem.setAccelerator(KeyStroke.getKeyStroke(accelerator));
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
        try {
            String tooltip = this.bundle.getString(prefix + ".tooltip");
            menuItem.setToolTipText(tooltip);
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
        try {
            String iconPath = this.bundle.getString(prefix + ".icon");
            if (iconPath != null) {
                ImageIcon icon = new ImageIcon(this.getClass().getResource(iconPath));
                menuItem.setIcon(icon);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public JMenu createMenu(String prefix) {
        String text = this.bundle.getString(prefix + ".text");
        JMenu menu = new JMenu(text);
        this.configureMenu(menu, prefix);
        return menu;
    }

    public void configureMenu(JMenu menu, String prefix) {
        String text = this.bundle.getString(prefix + ".text");
        menu.setText(text);
        try {
            String mnemonic = this.bundle.getString(prefix + ".mnemonic");
            menu.setMnemonic(mnemonic.charAt(0));
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
        try {
            String tooltip = this.bundle.getString(prefix + ".tooltip");
            menu.setToolTipText(tooltip);
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
        try {
            String iconPath = this.bundle.getString(prefix + ".icon");
            if (iconPath != null) {
                ImageIcon icon = new ImageIcon(this.getClass().getResource(iconPath));
                menu.setIcon(icon);
            }
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
    }

    public JButton createButton(String prefix) {
        JButton button = new JButton();
        try {
            String text = this.bundle.getString(prefix + ".text");
            button.setText(text);
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
        try {
            ImageIcon icon = new ImageIcon(this.getClass().getResource(this.bundle.getString(prefix + ".icon")));
            button.setIcon(icon);
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
        try {
            String mnemonic = this.bundle.getString(prefix + ".mnemonic");
            button.setMnemonic(mnemonic.charAt(0));
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
        try {
            String tooltip = this.bundle.getString(prefix + ".tooltip");
            button.setToolTipText(tooltip);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return button;
    }

    public Font createFont(String fontResource) {
        try {
            InputStream is = this.getClass().getResourceAsStream(this.bundle.getString(fontResource));
            Font ttfBase = Font.createFont(0, is);
            return ttfBase;
        }
        catch (FontFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Image createImage(String resourceName) {
        ImageIcon icon = this.createIcon(resourceName);
        return icon.getImage();
    }

    public ImageIcon createIcon(String resourceName) {
        return new ImageIcon(this.getClass().getResource(this.bundle.getString(resourceName)));
    }
}

