/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.swingextension;

import com.horstmann.violet.framework.swingextension.PercentLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class CollapsiblePane
extends JPanel {
    public static final String ANIMATION_STATE_KEY = "animationState";
    public static final String COLLAPSE_ICON = "collapseIcon";
    public static final String EXPAND_ICON = "expandIcon";
    private boolean collapsed = false;
    private Timer animateTimer;
    private AnimationListener animator;
    private int currentWidth = -1;
    private WrapperContainer wrapper;
    private boolean useAnimation = true;
    private AnimationParams animationParams;

    public CollapsiblePane() {
        super.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new PercentLayout(0, 2));
        this.setContentPane(panel);
        this.setDoubleBuffered(true);
        this.animator = new AnimationListener();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    public void setContentPane(Container contentPanel) {
        if (contentPanel == null) {
            throw new IllegalArgumentException("Content pane can't be null");
        }
        if (this.wrapper != null) {
            super.remove(this.wrapper);
        }
        this.wrapper = new WrapperContainer(contentPanel);
        super.addImpl(this.wrapper, "Center", -1);
    }

    public Container getContentPane() {
        return this.wrapper.c;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.wrapper != null) {
            this.getContentPane().setLayout(mgr);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.getContentPane().add(comp, constraints, index);
    }

    @Override
    public void remove(Component comp) {
        this.getContentPane().remove(comp);
    }

    @Override
    public void remove(int index) {
        this.getContentPane().remove(index);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    public void setAnimated(boolean animated) {
        if (animated != this.useAnimation) {
            this.useAnimation = animated;
            this.firePropertyChange("animated", !this.useAnimation, this.useAnimation);
        }
    }

    public boolean isAnimated() {
        return this.useAnimation;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed() {
        boolean bl = this.collapsed = !this.collapsed;
        if (this.isAnimated()) {
            if (this.collapsed) {
                this.setAnimationParams(new AnimationParams(24, Math.max(8, this.wrapper.getWidth() / 24), 1.0f, 0.01f));
                this.animator.reinit(this.wrapper.getWidth(), 0);
                this.animateTimer.start();
            } else {
                this.setAnimationParams(new AnimationParams(24, Math.max(8, this.getContentPane().getPreferredSize().width / 24), 0.01f, 1.0f));
                this.animator.reinit(this.wrapper.getWidth(), this.getContentPane().getPreferredSize().width);
                this.animateTimer.start();
            }
        } else {
            this.wrapper.c.setVisible(!this.collapsed);
            this.invalidate();
            this.doLayout();
        }
        this.repaint();
        this.firePropertyChange("collapsed", !this.collapsed, this.collapsed);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim;
        if (!this.isAnimated()) {
            dim = this.getContentPane().isVisible() ? this.getContentPane().getPreferredSize() : super.getPreferredSize();
        } else {
            dim = new Dimension(this.getContentPane().getPreferredSize());
            if (!this.getContentPane().isVisible() && this.currentWidth != -1) {
                dim.width = this.currentWidth;
            }
        }
        return dim;
    }

    private void setAnimationParams(AnimationParams params) {
        if (params == null) {
            throw new IllegalArgumentException("params can't be null");
        }
        if (this.animateTimer != null) {
            this.animateTimer.stop();
        }
        this.animationParams = params;
        this.animateTimer = new Timer(this.animationParams.waitTime, this.animator);
        this.animateTimer.setInitialDelay(0);
    }

    private final class WrapperContainer
    extends JPanel {
        private BufferedImage img;
        private Container c;
        float alpha;

        public WrapperContainer(Container c) {
            super(new BorderLayout());
            this.alpha = 1.0f;
            this.c = c;
            this.add((Component)c, "Center");
            if (c instanceof JComponent && !((JComponent)c).isOpaque()) {
                ((JComponent)c).setOpaque(true);
            }
            this.setOpaque(false);
            this.setDoubleBuffered(true);
        }

        public void showImage() {
            this.makeImage();
            this.c.setVisible(false);
        }

        public void showContent() {
            CollapsiblePane.this.currentWidth = -1;
            this.c.setVisible(true);
        }

        void makeImage() {
            if (this.getGraphicsConfiguration() != null && this.getWidth() > 0) {
                Dimension dim = this.c.getPreferredSize();
                if (dim.width > 0) {
                    this.img = this.getGraphicsConfiguration().createCompatibleImage(dim.width, this.getHeight());
                    this.c.setSize(dim.width, this.getHeight());
                    this.c.paint(this.img.getGraphics());
                } else {
                    this.img = null;
                }
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            if (!CollapsiblePane.this.useAnimation || this.c.isVisible()) {
                super.paintComponent(g);
            } else {
                if (this.img == null) {
                    this.makeImage();
                }
                if (g != null && this.img != null && this.img.getWidth() >= this.getWidth() && this.img.getHeight() >= this.getHeight()) {
                    g.drawImage(this.img, 0, 0, null);
                }
            }
        }
    }

    private final class AnimationListener
    implements ActionListener {
        private final Object ANIMATION_MUTEX = "Animation Synchronization Mutex";
        private int startWidth = 0;
        private int finalWidth = 0;
        private float animateAlpha = 1.0f;

        private AnimationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                if (this.startWidth == this.finalWidth) {
                    CollapsiblePane.this.animateTimer.stop();
                    this.animateAlpha = ((CollapsiblePane)CollapsiblePane.this).animationParams.alphaEnd;
                    if (this.finalWidth > 0) {
                        CollapsiblePane.this.wrapper.showContent();
                        this.validate();
                        CollapsiblePane.this.firePropertyChange(CollapsiblePane.ANIMATION_STATE_KEY, null, "expanded");
                        return;
                    }
                }
                boolean contracting = this.startWidth > this.finalWidth;
                int delta_x = contracting ? -1 * ((CollapsiblePane)CollapsiblePane.this).animationParams.deltaX : ((CollapsiblePane)CollapsiblePane.this).animationParams.deltaX;
                int newWidth = CollapsiblePane.this.wrapper.getWidth() + delta_x;
                if (contracting) {
                    if (newWidth < this.finalWidth) {
                        newWidth = this.finalWidth;
                    }
                } else if (newWidth > this.finalWidth) {
                    newWidth = this.finalWidth;
                }
                this.animateAlpha = (float)newWidth / (float)((WrapperContainer)((CollapsiblePane)CollapsiblePane.this).wrapper).c.getPreferredSize().width;
                Rectangle bounds = CollapsiblePane.this.wrapper.getBounds();
                int oldWidth = bounds.width;
                bounds.width = newWidth;
                CollapsiblePane.this.wrapper.setBounds(bounds);
                bounds = CollapsiblePane.this.getBounds();
                bounds.width = bounds.width - oldWidth + newWidth;
                CollapsiblePane.this.currentWidth = bounds.width;
                CollapsiblePane.this.setBounds(bounds);
                this.startWidth = newWidth;
                if (contracting) {
                    if (this.animateAlpha < ((CollapsiblePane)CollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((CollapsiblePane)CollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha > ((CollapsiblePane)CollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((CollapsiblePane)CollapsiblePane.this).animationParams.alphaStart;
                    }
                } else {
                    if (this.animateAlpha > ((CollapsiblePane)CollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((CollapsiblePane)CollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha < ((CollapsiblePane)CollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((CollapsiblePane)CollapsiblePane.this).animationParams.alphaStart;
                    }
                }
                ((CollapsiblePane)CollapsiblePane.this).wrapper.alpha = this.animateAlpha;
                this.validate();
            }
        }

        void validate() {
            Container parent = SwingUtilities.getAncestorOfClass(JCollapsiblePaneContainer.class, CollapsiblePane.this);
            parent = parent != null ? ((JCollapsiblePaneContainer)((Object)parent)).getValidatingContainer() : CollapsiblePane.this.getParent();
            if (parent != null) {
                if (parent instanceof JComponent) {
                    ((JComponent)parent).revalidate();
                } else {
                    parent.invalidate();
                }
                parent.doLayout();
                parent.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit(int startWidth, int stopWidth) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                CollapsiblePane.this.firePropertyChange(CollapsiblePane.ANIMATION_STATE_KEY, null, "reinit");
                this.startWidth = startWidth;
                this.finalWidth = stopWidth;
                this.animateAlpha = ((CollapsiblePane)CollapsiblePane.this).animationParams.alphaStart;
                CollapsiblePane.this.currentWidth = -1;
                CollapsiblePane.this.wrapper.showImage();
            }
        }
    }

    private static class AnimationParams {
        final int waitTime;
        final int deltaX;
        final float alphaStart;
        final float alphaEnd;

        public AnimationParams(int waitTime, int deltaX, float alphaStart, float alphaEnd) {
            this.waitTime = waitTime;
            this.deltaX = deltaX;
            this.alphaStart = alphaStart;
            this.alphaEnd = alphaEnd;
        }
    }

    public static interface JCollapsiblePaneContainer {
        public Container getValidatingContainer();
    }
}

