/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.swingextension;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicButtonUI;

public class IconButtonUI
extends BasicButtonUI {
    private Icon baseIcon;
    private Icon darkerIcon;
    private Icon brighterIcon;

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        b.setBorderPainted(false);
        b.setRolloverEnabled(true);
        b.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.prepareIcons(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (model.isArmed() && model.isPressed()) {
            b.setIcon(this.darkerIcon);
        } else if (model.isRollover()) {
            b.setIcon(this.brighterIcon);
        } else {
            b.setIcon(this.baseIcon);
        }
        super.paint(g, c);
    }

    private void prepareIcons(AbstractButton b) {
        this.baseIcon = b.getIcon();
        Image baseImage = this.getImage(this.baseIcon);
        Image brightenImage = this.changeBrightness(baseImage, true, 30);
        Image darkenImage = this.changeBrightness(baseImage, false, 20);
        this.brighterIcon = this.getIcon(brightenImage);
        this.darkerIcon = this.getIcon(darkenImage);
    }

    private Image getImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage buffer = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = buffer.getGraphics();
        icon.paintIcon(new JLabel(), g, 0, 0);
        g.dispose();
        return buffer;
    }

    private Icon getIcon(Image img) {
        return new IconUIResource(new ImageIcon(img));
    }

    private Image changeBrightness(Image img, final boolean brighten, final int percent) {
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                return rgb & 0xFF000000 | this.filter(rgb >> 16) << 16 | this.filter(rgb >> 8) << 8 | this.filter(rgb);
            }

            private int filter(int color) {
                color &= 0xFF;
                color = brighten ? 255 - (255 - color) * (100 - percent) / 100 : color * (100 - percent) / 100;
                if (color < 0) {
                    color = 0;
                }
                if (color > 255) {
                    color = 255;
                }
                return color;
            }
        };
        FilteredImageSource prod = new FilteredImageSource(img.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }
}

