/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.util;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ClipboardPipe
implements Transferable {
    private Image image;
    private String text;

    public ClipboardPipe(Image image) {
        this.image = image;
    }

    public ClipboardPipe(String text) {
        this.text = text;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.image != null) {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }
        if (this.text != null) {
            return new DataFlavor[]{DataFlavor.stringFlavor};
        }
        return new DataFlavor[0];
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (this.image != null) {
            return DataFlavor.imageFlavor.equals(flavor);
        }
        if (this.text != null) {
            return DataFlavor.stringFlavor.equals(flavor);
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.imageFlavor.equals(flavor) && this.image != null) {
            return this.image;
        }
        if (DataFlavor.stringFlavor.equals(flavor) && this.text != null) {
            return this.text;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

