/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.io.IOException;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.IndentationTarget;
import org.apache.ws.jaxme.js.JavaComment;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceObject;

public class JavaField
extends JavaSourceObject
implements DirectAccessible {
    private boolean isTransient;
    private boolean isNullable = true;

    JavaField(String pName, JavaQName pType, JavaSource.Protection pProtection) {
        super(pName, pType, pProtection);
    }

    public void setTransient(boolean pTransient) {
        this.isTransient = pTransient;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void write(IndentationTarget pTarget) throws IOException {
        pTarget.indent(0);
        this.writeNoEol(pTarget);
        pTarget.write();
    }

    protected void writeNoEol(IndentationTarget pTarget) throws IOException {
        JavaSource.Protection protection;
        if (pTarget.isInterface()) {
            return;
        }
        JavaComment jcon = this.getComment();
        if (jcon != null) {
            jcon.write(pTarget);
            pTarget.indent(0);
        }
        if ((protection = this.getProtection()) != null && !protection.equals(JavaSource.DEFAULT_PROTECTION)) {
            pTarget.write(protection.toString());
            pTarget.write(" ");
        }
        if (this.isFinal()) {
            pTarget.write("final ");
        }
        if (this.isStatic()) {
            pTarget.write("static ");
        }
        if (this.isTransient()) {
            pTarget.write("transient ");
        }
        pTarget.write(pTarget.asString(this.getType()));
        pTarget.write(" ");
        pTarget.write(this.getName());
        if (this.isEmpty()) {
            pTarget.write(";");
        } else {
            pTarget.write(" = ");
            MyTarget mt = new MyTarget(pTarget);
            super.write(mt);
            String result = mt.getResult();
            if (result.endsWith("\r\n")) {
                result = result.substring(0, result.length() - 2);
            } else if (result.endsWith("\n")) {
                result = result.substring(0, result.length() - 1);
            }
            pTarget.write(result);
            if (!result.endsWith(";")) {
                pTarget.write(";");
            }
        }
    }

    public void setValue(Object pValue) {
        this.clear();
        this.addLine(pValue);
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean pNullable) {
        this.isNullable = pNullable;
    }

    private class MyTarget
    implements IndentationTarget {
        private StringBuffer sb = new StringBuffer();
        private IndentationTarget actualTarget;

        private MyTarget(IndentationTarget pActualTarget) {
            this.actualTarget = pActualTarget;
        }

        public boolean isInterface() {
            return this.actualTarget.isInterface();
        }

        public String asString(JavaQName pQName) {
            return this.actualTarget.asString(pQName);
        }

        public void write(String pValue) {
            this.sb.append(pValue);
        }

        public void write() {
            this.sb.append("\n");
        }

        public void indent(int i) {
        }

        public String getResult() {
            return this.sb.toString();
        }
    }
}

