/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.ws.jaxme.logging.Logger;

public class LoggerImpl
implements Logger {
    private final String cName;
    private boolean loggingTime;
    private boolean loggingThread;

    public LoggerImpl(String pCName) {
        this.cName = pCName;
    }

    public boolean isLoggingTime() {
        return this.loggingTime;
    }

    public boolean isLoggingThread() {
        return this.loggingThread;
    }

    public void setLoggingTime(boolean pLoggingTime) {
        this.loggingTime = pLoggingTime;
    }

    public void setLoggingThread(boolean pLoggingThread) {
        this.loggingThread = pLoggingThread;
    }

    protected void log(String pMsg) {
        System.err.println(pMsg);
    }

    protected void log(String pLevel, String pCName, String pMName, String pMsg) {
        this.log(pLevel, pCName, pMName, new Object[]{pMsg});
    }

    protected void log(String pLevel, String pCName, String pMName, String pMsg, Object[] pDetails) {
        if (pDetails == null) {
            this.log(pLevel, pCName, pMName, new Object[]{pMsg});
        } else {
            Object[] o = new Object[pDetails.length + 1];
            o[0] = pMsg;
            for (int i = 0; i < pDetails.length; ++i) {
                o[i + 1] = pDetails[i];
            }
            this.log(pLevel, pCName, pMName, o);
        }
    }

    protected void log(String pLevel, String pCName, String pMName, Object[] pDetails) {
        StringBuffer sb = new StringBuffer();
        if (this.loggingTime) {
            sb.append(new Date());
            sb.append(", ");
        }
        if (this.loggingThread) {
            sb.append(Thread.currentThread().getName());
            sb.append(", ");
        }
        sb.append(": ");
        sb.append(pLevel).append(", ").append(pMName).append(", ");
        if (pDetails != null) {
            for (int i = 0; i < pDetails.length; ++i) {
                sb.append(", ").append(pDetails[i]);
            }
        }
        this.log(sb.toString());
    }

    public boolean isFinestEnabled() {
        return true;
    }

    public boolean isFinerEnabled() {
        return true;
    }

    public boolean isFineEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void finest(String mName, String pMsg, Object[] pDetails) {
        this.log("FINEST", this.cName, mName, pMsg, pDetails);
    }

    public void finest(String mName, String pMsg) {
        this.log("FINEST", this.cName, mName, pMsg);
    }

    public void finest(String mName, String pMsg, Object pDetails) {
        this.log("FINEST", this.cName, mName, new Object[]{pMsg, pDetails});
    }

    public void finer(String mName, String pMsg, Object[] pDetails) {
        this.log("FINER", this.cName, mName, pMsg, pDetails);
    }

    public void finer(String mName, String pMsg) {
        this.log("FINER", this.cName, mName, pMsg);
    }

    public void finer(String mName, String pMsg, Object pDetails) {
        this.log("FINER", this.cName, mName, new Object[]{pMsg, pDetails});
    }

    public void fine(String mName, String pMsg, Object[] pDetails) {
        this.log("FINE", this.cName, mName, pMsg, pDetails);
    }

    public void fine(String mName, String pMsg) {
        this.log("FINE", this.cName, mName, pMsg);
    }

    public void fine(String mName, String pMsg, Object pDetails) {
        this.log("FINE", this.cName, mName, new Object[]{pMsg, pDetails});
    }

    public void info(String mName, String pMsg, Object[] pDetails) {
        this.log("INFO", this.cName, mName, pMsg, pDetails);
    }

    public void info(String mName, String pMsg) {
        this.log("INFO", this.cName, mName, pMsg);
    }

    public void info(String mName, String pMsg, Object pDetails) {
        this.log("INFO", this.cName, mName, new Object[]{pMsg, pDetails});
    }

    public void warn(String mName, String pMsg, Object[] pDetails) {
        this.log("WARN", this.cName, mName, pMsg, pDetails);
    }

    public void warn(String mName, String pMsg) {
        this.log("WARN", this.cName, mName, pMsg);
    }

    public void warn(String mName, String pMsg, Object pDetails) {
        this.log("WARN", this.cName, mName, new Object[]{pMsg, pDetails});
    }

    public void error(String mName, String pMsg, Object[] pDetails) {
        this.log("ERROR", this.cName, mName, pMsg, pDetails);
    }

    public void error(String mName, String pMsg) {
        this.log("ERROR", this.cName, mName, pMsg);
    }

    public void error(String mName, String pMsg, Object pDetails) {
        this.log("ERROR", this.cName, mName, new Object[]{pMsg, pDetails});
    }

    public void entering(String mName, Object[] pDetails) {
        this.log("->", this.cName, mName, pDetails);
    }

    public void entering(String mName) {
        this.log("->", this.cName, mName, (Object[])null);
    }

    public void entering(String mName, Object pDetails) {
        this.log("->", this.cName, mName, new Object[]{pDetails});
    }

    public void exiting(String mName, Object[] pDetails) {
        this.log("<-", this.cName, mName, pDetails);
    }

    public void exiting(String mName) {
        this.log("<-", this.cName, mName, (Object[])null);
    }

    public void exiting(String mName, Object pDetails) {
        this.log("<-", this.cName, mName, new Object[]{pDetails});
    }

    public void throwing(String mName, Throwable pThrowable) {
        StringWriter sw = new StringWriter();
        pThrowable.printStackTrace(new PrintWriter(sw));
        this.log("THROWABLE", this.cName, mName, sw.toString());
    }
}

