/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.Case;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.DeleteStatement;
import org.apache.ws.jaxme.sqls.Expression;
import org.apache.ws.jaxme.sqls.Function;
import org.apache.ws.jaxme.sqls.InsertStatement;
import org.apache.ws.jaxme.sqls.JoinReference;
import org.apache.ws.jaxme.sqls.Parts;
import org.apache.ws.jaxme.sqls.RawSQLCode;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.SetStatement;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.TableReference;
import org.apache.ws.jaxme.sqls.UpdateStatement;
import org.apache.ws.jaxme.sqls.Value;
import org.apache.ws.jaxme.sqls.impl.ViewImpl;
import org.apache.ws.jaxme.sqls.impl.VirtualColumn;

public class StatementMetaData {
    private final Map aliases = new HashMap();
    private final Map columnNames = new HashMap();
    private final List tables = new ArrayList();

    public StatementMetaData(DeleteStatement pQuery) {
        this.addTable(pQuery.getTableReference());
        this.addCombinedConstraint(pQuery.getWhere());
        this.createTableAliases();
        this.createColumnNames();
    }

    public StatementMetaData(UpdateStatement pQuery, ColumnReference[] pColumns) {
        this.addSetStatement(pQuery, pColumns);
        this.addCombinedConstraint(pQuery.getWhere());
        this.createTableAliases();
        this.createColumnNames();
    }

    public StatementMetaData(InsertStatement pQuery, ColumnReference[] pColumns) {
        this.addSetStatement(pQuery, pColumns);
        SelectStatement subSelect = pQuery.getSubSelect();
        if (subSelect != null) {
            this.addSelectStatement(subSelect);
        }
        this.createTableAliases();
        this.createColumnNames();
    }

    public StatementMetaData(SelectStatement pQuery) {
        this.addSelectStatement(pQuery);
        this.createTableAliases();
        this.createColumnNames();
    }

    protected void addSetStatement(SetStatement pQuery, ColumnReference[] pColumns) {
        this.addTable(pQuery.getTableReference());
        for (int i = 0; i < pColumns.length; ++i) {
            this.addColumn(pColumns[i]);
        }
        Iterator iter = pQuery.getSetValues();
        while (iter.hasNext()) {
            SetStatement.SetValue setValue = (SetStatement.SetValue)iter.next();
            this.addPart(setValue.getValue());
            this.addPart(setValue.getColumnReference());
        }
    }

    protected void addTable(TableReference pTableReference) {
        Table t = pTableReference.getTable();
        Table.Name alias = pTableReference.getAlias();
        if (alias != null) {
            if (this.aliases.containsKey(alias.getName())) {
                throw new IllegalStateException("The alias " + alias + " is used twice ");
            }
            this.aliases.put(alias.getName(), pTableReference);
        }
        this.tables.add(pTableReference);
        if (t instanceof ViewImpl) {
            ViewImpl v = (ViewImpl)t;
            this.addSelectStatement(v.getViewStatement());
        }
        if (pTableReference instanceof JoinReference) {
            this.addCombinedConstraint(((JoinReference)pTableReference).getOn());
        }
    }

    protected void addSelectStatement(SelectStatement pQuery) {
        Iterator tableIter = pQuery.getSelectTableReferences();
        while (tableIter.hasNext()) {
            TableReference ref = (TableReference)tableIter.next();
            this.addTable(ref);
        }
        this.addCombinedConstraint(pQuery.getWhere());
        Iterator iter = pQuery.getResultColumns();
        while (iter.hasNext()) {
            this.addPart(iter.next());
        }
        iter = pQuery.getOrderColumns();
        while (iter.hasNext()) {
            SelectStatement.OrderColumn orderColumn = (SelectStatement.OrderColumn)iter.next();
            this.addPart(orderColumn.getColumn());
        }
    }

    protected void addColumn(ColumnReference pColumn) {
        if (pColumn instanceof VirtualColumn) {
            VirtualColumn vc = (VirtualColumn)pColumn;
            Object o = vc.getValue();
            if (o instanceof SelectStatement) {
                this.addSelectStatement((SelectStatement)o);
            } else if (o instanceof Function) {
                this.addParts((Function)o);
            } else if (!(o instanceof String)) {
                throw new IllegalStateException("Invalid type of VirtualColumn: " + o);
            }
            this.addColumnName(vc.getName());
        }
    }

    private void addColumnName(Column.Name pName) {
        String key = pName.toString().toUpperCase();
        Integer num = (Integer)this.columnNames.get(key);
        num = num == null ? new Integer(1) : new Integer(num + 1);
        this.columnNames.put(key, num);
    }

    protected void addCombinedConstraint(CombinedConstraint pConstraint) {
        Iterator iter = pConstraint.getParts();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof CombinedConstraint) {
                this.addCombinedConstraint((CombinedConstraint)o);
                continue;
            }
            if (o instanceof BooleanConstraint) {
                this.addBooleanConstraint((BooleanConstraint)o);
                continue;
            }
            throw new IllegalStateException("Invalid part type in CombinedConstraint: " + o);
        }
    }

    protected void addPart(Object pPart) {
        if (pPart instanceof SelectStatement) {
            this.addSelectStatement((SelectStatement)pPart);
        } else if (pPart instanceof CombinedConstraint) {
            this.addCombinedConstraint((CombinedConstraint)pPart);
        } else if (pPart instanceof Function) {
            this.addParts((Function)pPart);
        } else if (pPart instanceof Expression) {
            this.addParts((Expression)pPart);
        } else if (!(pPart instanceof ColumnReference || pPart instanceof Value || pPart instanceof RawSQLCode)) {
            if (pPart instanceof Case) {
                Case casePart = (Case)pPart;
                this.addPart(casePart.getCheckedValue());
                Object o = casePart.getElseValue();
                if (o != null) {
                    this.addPart(o);
                }
                Case.When[] whens = casePart.getWhens();
                for (int i = 0; i < whens.length; ++i) {
                    Case.When when = whens[i];
                    this.addPart(when.getCondition());
                    this.addPart(when.getValue());
                }
            } else if (pPart.getClass().isArray()) {
                Object[] o = (Object[])pPart;
                for (int i = 0; i < o.length; ++i) {
                    this.addPart(o[i]);
                }
            } else {
                throw new IllegalStateException("Invalid part type: " + pPart);
            }
        }
    }

    protected void addParts(Parts pParts) {
        Iterator iter = pParts.getParts();
        while (iter.hasNext()) {
            this.addPart(iter.next());
        }
    }

    protected void addBooleanConstraint(BooleanConstraint pConstraint) {
        BooleanConstraint.Type type = pConstraint.getType();
        if (!(BooleanConstraint.Type.EQ.equals(type) || BooleanConstraint.Type.EXISTS.equals(type) || BooleanConstraint.Type.GE.equals(type) || BooleanConstraint.Type.GT.equals(type) || BooleanConstraint.Type.IN.equals(type) || BooleanConstraint.Type.ISNULL.equals(type) || BooleanConstraint.Type.LE.equals(type) || BooleanConstraint.Type.LIKE.equals(type) || BooleanConstraint.Type.LT.equals(type) || BooleanConstraint.Type.NE.equals(type) || BooleanConstraint.Type.BETWEEN.equals(type))) {
            throw new IllegalStateException("Invalid part type in BooleanConstraint: " + type);
        }
        this.addParts(pConstraint);
    }

    protected String getUniqueAlias(String pSuggestion, Map pAliases) {
        String s;
        char c;
        String prefix = pSuggestion == null ? "" : pSuggestion;
        if (!pAliases.containsKey(prefix)) {
            return prefix;
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            s = prefix + c;
            if (pAliases.containsKey(s)) continue;
            return s;
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            s = prefix + c;
            if (pAliases.containsKey(s)) continue;
            return s;
        }
        return this.getUniqueAlias(prefix + '0', pAliases);
    }

    protected void createTableAliases() {
        if (this.tables.size() > 1) {
            Iterator iter = this.tables.iterator();
            while (iter.hasNext()) {
                TableReference tableReference = (TableReference)iter.next();
                if (tableReference.getAlias() != null) continue;
                String alias = this.getUniqueAlias(tableReference.getTable().getName().getName(), this.aliases);
                this.aliases.put(alias, tableReference);
                if (alias.equals(tableReference.getTable().getName().getName())) continue;
                tableReference.setAlias(alias);
            }
        }
    }

    protected void createColumnNames() {
        for (int i = 0; i < this.tables.size(); ++i) {
            TableReference table = (TableReference)this.tables.get(i);
            Iterator iter = table.getTable().getColumns();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                this.addColumnName(col.getName());
            }
        }
    }

    public Map getColumnNames() {
        return this.columnNames;
    }

    public static class LocalData {
        private boolean hasWhereClause;

        public boolean hasWhereClause() {
            return this.hasWhereClause;
        }

        public void setWhereClause(boolean pHasWhereClause) {
            this.hasWhereClause = pHasWhereClause;
        }
    }
}

