/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.junit;

import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.SQLFactory;
import org.apache.ws.jaxme.sqls.SQLGenerator;
import org.apache.ws.jaxme.sqls.SelectTableReference;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.junit.CreateTest;
import org.apache.ws.jaxme.sqls.oracle.OraColumnReference;
import org.apache.ws.jaxme.sqls.oracle.OraSQLFactoryImpl;
import org.apache.ws.jaxme.sqls.oracle.OraSQLGeneratorImpl;
import org.apache.ws.jaxme.sqls.oracle.OraSelectStatement;

public class Oracle8Test
extends CreateTest {
    public Oracle8Test(String pName) {
        super(pName);
    }

    protected SQLFactory newSQLFactory() {
        return new OraSQLFactoryImpl();
    }

    protected SQLGenerator newSQLGenerator() {
        OraSQLGeneratorImpl gen = new OraSQLGeneratorImpl();
        gen.setOracle8Compatibility(true);
        return gen;
    }

    protected String getTestJoinResult() {
        return "SELECT OtherTable.MyIndex, RefIndex, Company FROM MySchema.OtherTable, MySchema.MyTable WHERE RefIndex=MyTable.MyIndex AND OtherTable.MyIndex=?";
    }

    protected String getTestLeftOuterJoinResult() {
        return "SELECT OtherTable.MyIndex, RefIndex, Company FROM MySchema.OtherTable, MySchema.MyTable WHERE RefIndex=MyTable.MyIndex(+) AND OtherTable.MyIndex=?";
    }

    public void testConnectByPrior() {
        Table table = this.getBasicTable();
        OraSelectStatement selectStatement = (OraSelectStatement)table.getSelectStatement();
        SelectTableReference ref = selectStatement.getSelectTableReference();
        CombinedConstraint startWith = selectStatement.getStartWith();
        BooleanConstraint bc = startWith.createEQ();
        bc.addPart(ref.newColumnReference("MyIndex"));
        bc.addPart(1);
        CombinedConstraint connectByPrior = selectStatement.getConnectBy();
        bc = connectByPrior.createEQ();
        OraColumnReference oraRef = (OraColumnReference)ref.newColumnReference("MyIndex");
        oraRef.setPrior(true);
        bc.addPart(oraRef);
        bc.addPart(ref.newColumnReference("MyName"));
        SQLGenerator gen = this.getSQLGenerator();
        String query = gen.getQuery(selectStatement);
        Oracle8Test.assertEquals((String)"SELECT MyIndex, MyName, MyDate FROM MySchema.MyTable START WITH MyIndex=1 CONNECT BY PRIOR MyIndex=MyName", (String)query);
    }

    protected String getBulkInsertResult() {
        return "INSERT INTO MySchema.MyTable (MyTable.MyIndex, MyTable.MyName, MyTable.MyDate) (SELECT MyTable0.MyIndex, MyTable0.MyName, MyTable0.MyDate FROM MySchema.MyTable MyTable0)";
    }
}

