/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator;

import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.ssa.AstJavaInvokeInstruction;
import com.ibm.wala.cast.java.ssa.AstJavaNewEnclosingInstruction;
import com.ibm.wala.cast.java.ssa.EnclosingObjectReference;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cast.tree.visit.CAstVisitor;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

public class JavaCAst2IRTranslator
extends AstTranslator {
    private final CAstEntity fSourceEntity;

    public JavaCAst2IRTranslator(CAstEntity cAstEntity, JavaSourceLoaderImpl javaSourceLoaderImpl) {
        super((IClassLoader)javaSourceLoaderImpl);
        this.fSourceEntity = cAstEntity;
    }

    public void translate() {
        this.translate(this.fSourceEntity, this.fSourceEntity.getName());
    }

    public CAstEntity sourceFileEntity() {
        return this.fSourceEntity;
    }

    public JavaSourceLoaderImpl loader() {
        return (JavaSourceLoaderImpl)this.loader;
    }

    protected boolean useDefaultInitValues() {
        return true;
    }

    protected boolean hasImplicitGlobals() {
        return false;
    }

    protected TypeReference defaultCatchType() {
        return TypeReference.JavaLangException;
    }

    protected TypeReference makeType(CAstType cAstType) {
        return TypeReference.findOrCreate((ClassLoaderReference)this.loader.getReference(), (TypeName)TypeName.string2TypeName((String)cAstType.getName()));
    }

    protected boolean treatGlobalsAsLexicallyScoped() {
        Assertions.UNREACHABLE();
        return false;
    }

    protected boolean useLocalValuesForLexicalVars() {
        return true;
    }

    protected void doThrow(AstTranslator.WalkContext walkContext, int n) {
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.ThrowInstruction(n));
    }

    public void doArrayRead(AstTranslator.WalkContext walkContext, int n, int n2, CAstNode cAstNode, int[] nArray) {
        TypeReference typeReference = (TypeReference)cAstNode.getChild(1).getValue();
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.ArrayLoadInstruction(n, n2, nArray[0], typeReference));
        this.processExceptions(cAstNode, walkContext);
    }

    public void doArrayWrite(AstTranslator.WalkContext walkContext, int n, CAstNode cAstNode, int[] nArray, int n2) {
        TypeReference typeReference = cAstNode.getKind() == 117 ? ((TypeReference)cAstNode.getChild(0).getChild(0).getValue()).getArrayElementType() : (TypeReference)cAstNode.getChild(1).getValue();
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.ArrayStoreInstruction(n, nArray[0], n2, typeReference));
        this.processExceptions(cAstNode, walkContext);
    }

    protected void doFieldRead(AstTranslator.WalkContext walkContext, int n, int n2, CAstNode cAstNode, CAstNode cAstNode2) {
        FieldReference fieldReference = (FieldReference)cAstNode.getValue();
        if (n2 == -1) {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.GetInstruction(n, fieldReference));
        } else {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.GetInstruction(n, n2, fieldReference));
            this.processExceptions(cAstNode2, walkContext);
        }
    }

    protected void doFieldWrite(AstTranslator.WalkContext walkContext, int n, CAstNode cAstNode, CAstNode cAstNode2, int n2) {
        FieldReference fieldReference = (FieldReference)cAstNode.getValue();
        if (n == -1) {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.PutInstruction(n2, fieldReference));
        } else {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.PutInstruction(n, n2, fieldReference));
            this.processExceptions(cAstNode2, walkContext);
        }
    }

    protected void doMaterializeFunction(CAstNode cAstNode, AstTranslator.WalkContext walkContext, int n, int n2, CAstEntity cAstEntity) {
        Assertions.UNREACHABLE((String)"Real functions in Java??? I don't think so!");
    }

    protected void doNewObject(AstTranslator.WalkContext walkContext, CAstNode cAstNode, int n, Object object, int[] nArray) {
        TypeReference typeReference = (TypeReference)object;
        NewSiteReference newSiteReference = NewSiteReference.make((int)walkContext.cfg().getCurrentInstruction(), (TypeReference)typeReference);
        if (cAstNode.getKind() == 130) {
            walkContext.cfg().addInstruction((SSAInstruction)new AstJavaNewEnclosingInstruction(n, newSiteReference, nArray[0]));
        } else {
            walkContext.cfg().addInstruction((SSAInstruction)(nArray == null ? this.insts.NewInstruction(n, newSiteReference) : this.insts.NewInstruction(n, newSiteReference, nArray)));
        }
        this.processExceptions(cAstNode, walkContext);
    }

    private void processExceptions(CAstNode cAstNode, AstTranslator.WalkContext walkContext) {
        walkContext.cfg().addPreNode(cAstNode, walkContext.getUnwindState());
        walkContext.cfg().newBlock(true);
        Collection collection = walkContext.getControlFlow().getTargetLabels(cAstNode);
        for (Object e : collection) {
            CAstNode cAstNode2 = walkContext.getControlFlow().getTarget(cAstNode, e);
            if (cAstNode2 == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                walkContext.cfg().addPreEdgeToExit(cAstNode, true);
                continue;
            }
            walkContext.cfg().addPreEdge(cAstNode, cAstNode2, true);
        }
    }

    protected void doCall(AstTranslator.WalkContext walkContext, CAstNode cAstNode, int n, int n2, CAstNode cAstNode2, int n3, int[] nArray) {
        CallSiteReference callSiteReference;
        int[] nArray2;
        assert (cAstNode2.getKind() == 300);
        CallSiteReference callSiteReference2 = (CallSiteReference)cAstNode2.getValue();
        int n4 = walkContext.cfg().getCurrentInstruction();
        boolean bl = n3 == -1;
        int[] nArray3 = nArray2 = bl ? nArray : new int[nArray.length + 1];
        if (!bl) {
            nArray2[0] = n3;
            System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        }
        if ((callSiteReference = CallSiteReference.make((int)n4, (MethodReference)callSiteReference2.getDeclaredTarget(), (IInvokeInstruction.IDispatch)callSiteReference2.getInvocationCode())).getDeclaredTarget().getReturnType().equals((Object)TypeReference.Void)) {
            walkContext.cfg().addInstruction((SSAInstruction)new AstJavaInvokeInstruction(nArray2, n2, callSiteReference));
        } else {
            walkContext.cfg().addInstruction((SSAInstruction)new AstJavaInvokeInstruction(n, nArray2, n2, callSiteReference));
        }
        this.processExceptions(cAstNode, walkContext);
    }

    protected void doGlobalRead(AstTranslator.WalkContext walkContext, int n, String string) {
        Assertions.UNREACHABLE((String)"doGlobalRead() called for Java code???");
    }

    protected void doGlobalWrite(AstTranslator.WalkContext walkContext, String string, int n) {
        Assertions.UNREACHABLE((String)"doGlobalWrite() called for Java code???");
    }

    protected void defineField(CAstEntity cAstEntity, AstTranslator.WalkContext walkContext, CAstEntity cAstEntity2) {
        assert (cAstEntity.getKind() == 3);
        assert (cAstEntity2.getKind() == 4);
        IClass iClass = this.loader.lookupClass(this.makeType(cAstEntity.getType()).getName());
        if (iClass == null) assert (iClass != null) : this.makeType(cAstEntity.getType()).getName() + " not found in " + this.loader;
        ((JavaSourceLoaderImpl)this.loader).defineField(cAstEntity2, iClass);
    }

    protected void declareFunction(CAstEntity cAstEntity, AstTranslator.WalkContext walkContext) {
        CAstType.Method method = (CAstType.Method)cAstEntity.getType();
        CAstType cAstType = method.getDeclaringType();
        IClass iClass = this.loader.lookupClass(this.makeType(cAstType).getName());
        if (iClass == null) assert (iClass != null) : String.valueOf(this.makeType(cAstType).getName().toString()) + " not found in " + this.loader;
        ((JavaSourceLoaderImpl)this.loader).defineAbstractFunction(cAstEntity, iClass);
    }

    protected void defineFunction(CAstEntity cAstEntity, AstTranslator.WalkContext walkContext, AbstractCFG abstractCFG, SymbolTable symbolTable, boolean bl, TypeReference[][] typeReferenceArray, boolean bl2, AstTranslator.AstLexicalInformation astLexicalInformation, AstMethod.DebuggingInformation debuggingInformation) {
        CAstType.Method method = (CAstType.Method)cAstEntity.getType();
        CAstType cAstType = method.getDeclaringType();
        TypeName typeName = this.makeType(cAstType).getName();
        IClass iClass = this.loader.lookupClass(typeName);
        if (iClass == null) assert (iClass != null) : String.valueOf(typeName.toString()) + " not found in " + this.loader;
        symbolTable.getConstant(0);
        symbolTable.getNullConstant();
        ((JavaSourceLoaderImpl)this.loader).defineFunction(cAstEntity, iClass, abstractCFG, symbolTable, bl, typeReferenceArray, bl2, astLexicalInformation, debuggingInformation);
    }

    protected void doPrimitive(int n, AstTranslator.WalkContext walkContext, CAstNode cAstNode) {
        Assertions.UNREACHABLE((String)"doPrimitive() called for Java code???");
    }

    protected String composeEntityName(AstTranslator.WalkContext walkContext, CAstEntity cAstEntity) {
        switch (cAstEntity.getKind()) {
            case 3: {
                return walkContext.getName().length() == 0 ? cAstEntity.getName() : String.valueOf(walkContext.getName()) + "/" + cAstEntity.getName();
            }
            case 1: {
                return String.valueOf(walkContext.getName()) + "/" + cAstEntity.getSignature();
            }
        }
        return walkContext.getName();
    }

    private CAstEntity getEnclosingType(CAstEntity cAstEntity) {
        if (cAstEntity.getQualifiers().contains(CAstQualifier.STATIC)) {
            return null;
        }
        return this.getEnclosingTypeInternal(this.getParent(cAstEntity));
    }

    private CAstEntity getEnclosingTypeInternal(CAstEntity cAstEntity) {
        switch (cAstEntity.getKind()) {
            case 3: {
                return cAstEntity;
            }
            case 1: {
                if (cAstEntity.getQualifiers().contains(CAstQualifier.STATIC)) {
                    return null;
                }
                return this.getEnclosingTypeInternal(this.getParent(cAstEntity));
            }
            case 5: {
                return null;
            }
        }
        return this.getEnclosingTypeInternal(this.getParent(cAstEntity));
    }

    protected void defineType(CAstEntity cAstEntity, AstTranslator.WalkContext walkContext) {
        CAstEntity cAstEntity2 = this.getEnclosingType(cAstEntity);
        ((JavaSourceLoaderImpl)this.loader).defineType(cAstEntity, cAstEntity.getType().getName(), cAstEntity2);
    }

    protected void leaveThis(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        if (cAstNode.getChildCount() == 0) {
            super.leaveThis(cAstNode, context, cAstVisitor);
        } else {
            AstTranslator.WalkContext walkContext = (AstTranslator.WalkContext)context;
            int n = walkContext.currentScope().allocateTempValue();
            this.setValue(cAstNode, n);
            walkContext.cfg().addInstruction((SSAInstruction)new EnclosingObjectReference(n, (TypeReference)cAstNode.getChild(0).getValue()));
        }
    }

    protected boolean visitCast(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        AstTranslator.WalkContext walkContext = (AstTranslator.WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        return false;
    }

    protected void leaveCast(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        AstTranslator.WalkContext walkContext = (AstTranslator.WalkContext)context;
        int n = this.getValue(cAstNode);
        CAstType cAstType = (CAstType)cAstNode.getChild(0).getValue();
        TypeReference typeReference = this.makeType(cAstType);
        CAstType cAstType2 = (CAstType)cAstNode.getChild(2).getValue();
        TypeReference typeReference2 = this.makeType(cAstType2);
        if (typeReference.isPrimitiveType()) {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.ConversionInstruction(n, this.getValue(cAstNode.getChild(1)), typeReference2, typeReference, false));
        } else {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.CheckCastInstruction(n, this.getValue(cAstNode.getChild(1)), typeReference));
            this.processExceptions(cAstNode, walkContext);
        }
    }

    protected boolean visitInstanceOf(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        AstTranslator.WalkContext walkContext = (AstTranslator.WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        return false;
    }

    protected void leaveInstanceOf(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        AstTranslator.WalkContext walkContext = (AstTranslator.WalkContext)context;
        int n = this.getValue(cAstNode);
        CAstType cAstType = (CAstType)cAstNode.getChild(0).getValue();
        TypeReference typeReference = this.makeType(cAstType);
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.InstanceofInstruction(n, this.getValue(cAstNode.getChild(1)), typeReference));
    }

    protected boolean doVisit(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        AstTranslator.WalkContext walkContext = (AstTranslator.WalkContext)context;
        if (cAstNode.getKind() == 23) {
            cAstVisitor.visit(cAstNode.getChild(0), (CAstVisitor.Context)walkContext, cAstVisitor);
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.MonitorInstruction(this.getValue(cAstNode.getChild(0)), true));
            this.processExceptions(cAstNode, walkContext);
            return true;
        }
        if (cAstNode.getKind() == 24) {
            cAstVisitor.visit(cAstNode.getChild(0), (CAstVisitor.Context)walkContext, cAstVisitor);
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.MonitorInstruction(this.getValue(cAstNode.getChild(0)), false));
            this.processExceptions(cAstNode, walkContext);
            return true;
        }
        return super.doVisit(cAstNode, (CAstVisitor.Context)walkContext, cAstVisitor);
    }
}

