/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.AstCallGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptEntryPoints
implements Iterable<Entrypoint> {
    private final IClassHierarchy cha;
    private final IClass scriptType;

    public ScriptEntryPoints(IClassHierarchy iClassHierarchy, IClass iClass) {
        this.cha = iClassHierarchy;
        this.scriptType = iClass;
    }

    protected abstract CallSiteReference makeScriptSite(IMethod var1, int var2);

    protected boolean keep(IMethod iMethod) {
        return true;
    }

    @Override
    public Iterator<Entrypoint> iterator() {
        HashSet hashSet = HashSetFactory.make();
        Iterator iterator = this.scriptType.getClassLoader().iterateAllClasses();
        while (iterator.hasNext()) {
            IClass iClass = (IClass)iterator.next();
            if (!this.cha.isSubclassOf(iClass, this.scriptType) || iClass.isAbstract()) continue;
            for (IMethod iMethod : iClass.getDeclaredMethods()) {
                if (!this.keep(iMethod)) continue;
                hashSet.add(new ScriptEntryPoint(iMethod));
            }
        }
        return hashSet.iterator();
    }

    private class ScriptEntryPoint
    extends Entrypoint {
        ScriptEntryPoint(IMethod iMethod) {
            super(iMethod);
        }

        public CallSiteReference makeSite(int n) {
            return ScriptEntryPoints.this.makeScriptSite(this.getMethod(), n);
        }

        public TypeReference[] getParameterTypes(int n) {
            assert (n == 0);
            if (this.getMethod().isStatic()) {
                return new TypeReference[0];
            }
            return new TypeReference[]{this.getMethod().getDeclaringClass().getReference()};
        }

        public int getNumberOfParameters() {
            return this.getMethod().isStatic() ? 0 : 1;
        }

        public SSAAbstractInvokeInstruction addCall(AbstractRootMethod abstractRootMethod) {
            CallSiteReference callSiteReference = this.makeSite(0);
            if (callSiteReference == null) {
                return null;
            }
            int n = this.getMethod().isStatic() ? -1 : this.makeArgument(abstractRootMethod, 0);
            int[] nArray = new int[Math.max(0, this.getNumberOfParameters() - 1)];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = this.makeArgument(abstractRootMethod, n2 + 1);
                ++n2;
            }
            return ((AstCallGraph.ScriptFakeRoot)abstractRootMethod).addDirectCall(n, nArray, callSiteReference);
        }
    }
}

