/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.CAstAnalysisScope;
import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.loader.SingleClassLoaderFactory;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;

public class Util {
    public static SourceFileModule makeSourceModule(URL uRL, String string, String string2) {
        return Util.makeSourceModule(uRL, String.valueOf(string) + "/" + string2);
    }

    public static SourceFileModule makeSourceModule(URL uRL, String string) {
        String string2 = uRL.getFile().replaceAll("%5c", "/").replaceAll("%20", " ");
        File file = new File(string2);
        assert (string2.endsWith(string)) : String.valueOf(string) + " does not match file " + uRL.getFile();
        return new SourceFileModule(file, string);
    }

    public static AnalysisScope makeScope(String[] stringArray, SingleClassLoaderFactory singleClassLoaderFactory, Language language) throws IOException {
        CAstAnalysisScope cAstAnalysisScope = new CAstAnalysisScope(stringArray, singleClassLoaderFactory, Collections.singleton(language));
        return cAstAnalysisScope;
    }

    public static AnalysisScope makeScope(SourceFileModule[] sourceFileModuleArray, SingleClassLoaderFactory singleClassLoaderFactory, Language language) throws IOException {
        CAstAnalysisScope cAstAnalysisScope = new CAstAnalysisScope((Module[])sourceFileModuleArray, singleClassLoaderFactory, Collections.singleton(language));
        return cAstAnalysisScope;
    }

    public static AnalysisScope makeScope(URL[] uRLArray, SingleClassLoaderFactory singleClassLoaderFactory, Language language) throws IOException {
        CAstAnalysisScope cAstAnalysisScope = new CAstAnalysisScope(uRLArray, singleClassLoaderFactory, Collections.singleton(language));
        return cAstAnalysisScope;
    }

    public static AnalysisCache makeCache() {
        return new AnalysisCache(AstIRFactory.makeDefaultFactory());
    }

    public static void dumpCG(PropagationCallGraphBuilder propagationCallGraphBuilder, CallGraph callGraph) {
        for (CGNode cGNode : callGraph) {
            System.err.println("\ncallees of node " + cGNode.getMethod() + " " + cGNode.getGraphNodeId());
            Iterator iterator = callGraph.getSuccNodes((Object)cGNode);
            while (iterator.hasNext()) {
                System.err.println("\n  " + ((CGNode)iterator.next()).getGraphNodeId());
            }
            System.err.println("\nIR of node " + cGNode.getGraphNodeId());
            iterator = cGNode.getIR();
            if (iterator != null) {
                System.err.println(iterator);
                continue;
            }
            System.err.println("no IR!");
        }
    }

    public static SourceFileModule[] handleFileNames(String[] stringArray) {
        SourceFileModule[] sourceFileModuleArray = new SourceFileModule[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (new File(stringArray[n]).exists()) {
                try {
                    sourceFileModuleArray[n] = Util.makeSourceModule(new File(stringArray[n]).toURI().toURL(), stringArray[n]);
                }
                catch (MalformedURLException malformedURLException) {
                    Assertions.UNREACHABLE((String)malformedURLException.toString());
                }
            } else {
                URL uRL = Util.class.getClassLoader().getResource(stringArray[n]);
                sourceFileModuleArray[n] = Util.makeSourceModule(uRL, stringArray[n]);
            }
            ++n;
        }
        return sourceFileModuleArray;
    }
}

