/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.SSAConversion;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.DefaultIRFactory;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAIndirectionData;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstIRFactory
implements IRFactory {
    public ControlFlowGraph makeCFG(IMethod iMethod, Context context) {
        return ((AstMethod)iMethod).getControlFlowGraph();
    }

    public IR makeIR(IMethod iMethod, Context context, SSAOptions sSAOptions) {
        assert (iMethod instanceof AstMethod) : iMethod.toString();
        AbstractCFG abstractCFG = ((AstMethod)iMethod).cfg();
        SSAInstruction[] sSAInstructionArray = (SSAInstruction[])abstractCFG.getInstructions();
        SSAInstruction[] sSAInstructionArray2 = new SSAInstruction[sSAInstructionArray.length];
        System.arraycopy(sSAInstructionArray, 0, sSAInstructionArray2, 0, sSAInstructionArray2.length);
        AstIR astIR = new AstIR((AstMethod)iMethod, sSAInstructionArray2, ((AstMethod)iMethod).symbolTable().copy(), new SSACFG(iMethod, abstractCFG, sSAInstructionArray2), sSAOptions);
        return astIR;
    }

    public static IRFactory<IMethod> makeDefaultFactory() {
        return new DefaultIRFactory(){
            private final AstIRFactory astFactory = new AstIRFactory();

            public IR makeIR(IMethod iMethod, Context context, SSAOptions sSAOptions) {
                if (iMethod instanceof AstMethod) {
                    return this.astFactory.makeIR(iMethod, context, sSAOptions);
                }
                return super.makeIR(iMethod, context, sSAOptions);
            }

            public ControlFlowGraph makeCFG(IMethod iMethod, Context context) {
                if (iMethod instanceof AstMethod) {
                    return this.astFactory.makeCFG(iMethod, context);
                }
                return super.makeCFG(iMethod, context);
            }
        };
    }

    public boolean contextIsIrrelevant(IMethod iMethod) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AstIR
    extends IR {
        private final AstMethod.LexicalInformation lexicalInfo;
        private final IR.SSA2LocalMap localMap;

        public AstMethod.LexicalInformation lexicalInfo() {
            return this.lexicalInfo;
        }

        private void setCatchInstructions(SSACFG sSACFG, AbstractCFG abstractCFG) {
            int n = 0;
            while (n < abstractCFG.getNumberOfNodes()) {
                if (abstractCFG.isCatchBlock(n)) {
                    SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)sSACFG.getNode(n);
                    exceptionHandlerBasicBlock.setCatchInstruction((SSAGetCaughtExceptionInstruction)this.getInstructions()[exceptionHandlerBasicBlock.getFirstInstructionIndex()]);
                    this.getInstructions()[exceptionHandlerBasicBlock.getFirstInstructionIndex()] = null;
                }
                ++n;
            }
        }

        private void setupCatchTypes(SSACFG sSACFG, TypeReference[][] typeReferenceArray) {
            int n = 0;
            while (n < typeReferenceArray.length) {
                if (typeReferenceArray[n] != null) {
                    SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)sSACFG.getNode(n);
                    int n2 = 0;
                    while (n2 < typeReferenceArray[n].length) {
                        exceptionHandlerBasicBlock.addCaughtExceptionType(typeReferenceArray[n][n2]);
                        ++n2;
                    }
                }
                ++n;
            }
        }

        protected IR.SSA2LocalMap getLocalMap() {
            return this.localMap;
        }

        protected String instructionPosition(int n) {
            CAstSourcePositionMap.Position position = ((AstMethod)this.getMethod()).getSourcePosition(n);
            if (position == null) {
                return "";
            }
            return position.toString();
        }

        private AstIR(AstMethod astMethod, SSAInstruction[] sSAInstructionArray, SymbolTable symbolTable, SSACFG sSACFG, SSAOptions sSAOptions) {
            super((IMethod)astMethod, sSAInstructionArray, symbolTable, sSACFG, sSAOptions);
            this.lexicalInfo = astMethod.cloneLexicalInfo();
            this.localMap = SSAConversion.convert(astMethod, this, sSAOptions);
            this.setCatchInstructions(this.getControlFlowGraph(), astMethod.cfg());
            this.setupCatchTypes(this.getControlFlowGraph(), astMethod.catchTypes());
            this.setupLocationMap();
        }

        protected SSAIndirectionData<SSAIndirectionData.Name> getIndirectionData() {
            return null;
        }
    }
}

