/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.translator;

import com.ibm.wala.cast.ir.ssa.AssignInstruction;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstConstants;
import com.ibm.wala.cast.ir.ssa.AstEchoInstruction;
import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.EachElementGetInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementHasNextInstruction;
import com.ibm.wala.cast.ir.translator.ArrayOpHandler;
import com.ibm.wala.cast.ir.translator.TranslatorToIR;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.CAstSymbol;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cast.tree.impl.CAstBasicRewriter;
import com.ibm.wala.cast.tree.impl.CAstCloner;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.cast.tree.impl.CAstOperator;
import com.ibm.wala.cast.tree.impl.CAstRewriter;
import com.ibm.wala.cast.tree.impl.CAstSymbolImpl;
import com.ibm.wala.cast.tree.impl.CAstSymbolImplBase;
import com.ibm.wala.cast.tree.visit.CAstVisitor;
import com.ibm.wala.cast.types.AstTypeReference;
import com.ibm.wala.cast.util.CAstPrinter;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.graph.impl.SparseNumberedGraph;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstTranslator
extends CAstVisitor
implements ArrayOpHandler,
TranslatorToIR {
    private ArrayOpHandler arrayOpHandler;
    protected final IClassLoader loader;
    protected final Map namedEntityResolver;
    protected final SSAInstructionFactory insts;
    public static final boolean DEBUG_ALL = false;
    public static final boolean DEBUG_TOP = false;
    public static final boolean DEBUG_CFG = false;
    public static final boolean DEBUG_NAMES = false;
    public static final boolean DEBUG_LEXICAL = false;
    protected static final int TYPE_LOCAL = 1;
    protected static final int TYPE_GLOBAL = 2;
    protected static final int TYPE_SCRIPT = 3;
    protected static final int TYPE_FUNCTION = 4;
    protected static final int TYPE_TYPE = 5;
    private static final boolean DEBUG = false;
    private final Stack<Map<CAstNode, Integer>> resultStack = new Stack();
    private Map<CAstNode, Integer> results = new LinkedHashMap<CAstNode, Integer>();
    private final Map<CAstEntity, String> entityNames = new LinkedHashMap<CAstEntity, String>();
    private final Map<CAstEntity, LinkedHashSet<Pair<Pair<String, String>, Integer>>> exposedNames = new LinkedHashMap<CAstEntity, LinkedHashSet<Pair<Pair<String, String>, Integer>>>();
    private final Map<CAstEntity, LinkedHashSet<AstLexicalAccess.Access>> accesses = new LinkedHashMap<CAstEntity, LinkedHashSet<AstLexicalAccess.Access>>();
    private final Stack<CAstSourcePositionMap.Position> positions = new Stack();
    private Map<CAstNode, Boolean> popPositionM = new LinkedHashMap<CAstNode, Boolean>();
    private CAstSourcePositionMap inlinedSourceMap;
    private final Scope globalScope = this.makeGlobalScope();

    protected abstract boolean useDefaultInitValues();

    protected abstract boolean treatGlobalsAsLexicallyScoped();

    protected abstract boolean useLocalValuesForLexicalVars();

    protected abstract TypeReference defaultCatchType();

    protected abstract TypeReference makeType(CAstType var1);

    protected abstract void defineType(CAstEntity var1, WalkContext var2);

    protected abstract void declareFunction(CAstEntity var1, WalkContext var2);

    protected abstract void defineFunction(CAstEntity var1, WalkContext var2, AbstractCFG var3, SymbolTable var4, boolean var5, TypeReference[][] var6, boolean var7, AstLexicalInformation var8, AstMethod.DebuggingInformation var9);

    protected abstract void defineField(CAstEntity var1, WalkContext var2, CAstEntity var3);

    protected abstract String composeEntityName(WalkContext var1, CAstEntity var2);

    protected abstract void doThrow(WalkContext var1, int var2);

    @Override
    public abstract void doArrayRead(WalkContext var1, int var2, int var3, CAstNode var4, int[] var5);

    @Override
    public abstract void doArrayWrite(WalkContext var1, int var2, CAstNode var3, int[] var4, int var5);

    protected abstract void doFieldRead(WalkContext var1, int var2, int var3, CAstNode var4, CAstNode var5);

    protected abstract void doFieldWrite(WalkContext var1, int var2, CAstNode var3, CAstNode var4, int var5);

    protected abstract void doMaterializeFunction(CAstNode var1, WalkContext var2, int var3, int var4, CAstEntity var5);

    protected abstract void doNewObject(WalkContext var1, CAstNode var2, int var3, Object var4, int[] var5);

    protected abstract void doCall(WalkContext var1, CAstNode var2, int var3, int var4, CAstNode var5, int var6, int[] var7);

    protected boolean isExceptionLabel(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return false;
        }
        if (object instanceof Number) {
            return false;
        }
        return object != CAstControlFlowMap.SWITCH_DEFAULT;
    }

    protected boolean hasImplicitGlobals() {
        return false;
    }

    protected boolean hasSpecialUndeclaredVariables() {
        return false;
    }

    protected void handleUnspecifiedLiteralKey(WalkContext walkContext, CAstNode cAstNode, int n, CAstVisitor cAstVisitor) {
        Assertions.UNREACHABLE();
    }

    protected void doPrologue(WalkContext walkContext) {
        if (this.useLocalValuesForLexicalVars()) {
            walkContext.cfg().addInstruction(new AstLexicalRead(new AstLexicalAccess.Access[0]));
        }
    }

    protected abstract void doPrimitive(int var1, WalkContext var2, CAstNode var3);

    protected int doLocalRead(WalkContext walkContext, String string) {
        return walkContext.currentScope().lookup(string).valueNumber();
    }

    protected void doLocalWrite(WalkContext walkContext, String string, int n) {
        int n2 = walkContext.currentScope().lookup(string).valueNumber();
        if (n2 != n) {
            walkContext.cfg().addInstruction((SSAInstruction)new AssignInstruction(n2, n));
        }
    }

    protected int doLexicallyScopedRead(CAstNode cAstNode, WalkContext walkContext, String string) {
        Symbol symbol = walkContext.currentScope().lookup(string);
        int n = symbol.valueNumber();
        CAstEntity cAstEntity = symbol.getDefiningScope().getEntity();
        this.addExposedName(cAstEntity, cAstEntity, string, symbol.getDefiningScope().lookup(string).valueNumber());
        if (this.useLocalValuesForLexicalVars()) {
            AstLexicalAccess.Access access = new AstLexicalAccess.Access(string, this.getEntityName(cAstEntity), n);
            this.addExposedName(walkContext.top(), cAstEntity, string, n);
            this.addAccess(walkContext.top(), access);
            return n;
        }
        int n2 = walkContext.currentScope().allocateTempValue();
        AstLexicalAccess.Access access = new AstLexicalAccess.Access(string, this.getEntityName(cAstEntity), n2);
        walkContext.cfg().addInstruction(new AstLexicalRead(access));
        return n2;
    }

    protected void doLexicallyScopedWrite(WalkContext walkContext, String string, int n) {
        Symbol symbol = walkContext.currentScope().lookup(string);
        CAstEntity cAstEntity = symbol.getDefiningScope().getEntity();
        this.addExposedName(cAstEntity, cAstEntity, string, symbol.getDefiningScope().lookup(string).valueNumber());
        if (this.useLocalValuesForLexicalVars()) {
            int n2 = symbol.valueNumber();
            AstLexicalAccess.Access access = new AstLexicalAccess.Access(string, this.getEntityName(cAstEntity), n2);
            this.addExposedName(walkContext.top(), cAstEntity, string, n2);
            this.addAccess(walkContext.top(), access);
            walkContext.cfg().addInstruction((SSAInstruction)new AssignInstruction(n2, n));
            walkContext.cfg().addInstruction(new AstLexicalWrite(access));
        } else {
            AstLexicalAccess.Access access = new AstLexicalAccess.Access(string, this.getEntityName(cAstEntity), n);
            walkContext.cfg().addInstruction(new AstLexicalWrite(access));
        }
    }

    protected int doGlobalRead(CAstNode cAstNode, WalkContext walkContext, String string) {
        Symbol symbol = walkContext.currentScope().lookup(string);
        if (this.treatGlobalsAsLexicallyScoped()) {
            if (this.useLocalValuesForLexicalVars()) {
                int n = symbol.valueNumber();
                AstLexicalAccess.Access access = new AstLexicalAccess.Access(string, null, n);
                this.addExposedName(walkContext.top(), null, string, n);
                this.addAccess(walkContext.top(), access);
                return n;
            }
            int n = walkContext.currentScope().allocateTempValue();
            AstLexicalAccess.Access access = new AstLexicalAccess.Access(string, null, n);
            walkContext.cfg().addInstruction(new AstLexicalRead(access));
            return n;
        }
        int n = walkContext.currentScope().allocateTempValue();
        FieldReference fieldReference = this.makeGlobalRef(string);
        walkContext.cfg().addInstruction((SSAInstruction)new AstGlobalRead(n, fieldReference));
        return n;
    }

    protected void doGlobalWrite(WalkContext walkContext, String string, int n) {
        Symbol symbol = walkContext.currentScope().lookup(string);
        if (this.treatGlobalsAsLexicallyScoped()) {
            if (this.useLocalValuesForLexicalVars()) {
                int n2 = symbol.valueNumber();
                AstLexicalAccess.Access access = new AstLexicalAccess.Access(string, null, n2);
                this.addExposedName(walkContext.top(), null, string, n2);
                this.addAccess(walkContext.top(), access);
                walkContext.cfg().addInstruction((SSAInstruction)new AssignInstruction(n2, n));
                walkContext.cfg().addInstruction(new AstLexicalWrite(access));
            } else {
                AstLexicalAccess.Access access = new AstLexicalAccess.Access(string, null, n);
                walkContext.cfg().addInstruction(new AstLexicalWrite(access));
            }
        } else {
            FieldReference fieldReference = this.makeGlobalRef(string);
            walkContext.cfg().addInstruction((SSAInstruction)new AstGlobalWrite(fieldReference, n));
        }
    }

    protected void doIsFieldDefined(WalkContext walkContext, int n, int n2, CAstNode cAstNode) {
        Assertions.UNREACHABLE();
    }

    protected FieldReference makeGlobalRef(String string) {
        return FieldReference.findOrCreate((TypeReference)TypeReference.findOrCreate((ClassLoaderReference)this.loader.getReference(), (TypeName)AstTypeReference.rootTypeName), (Atom)Atom.findOrCreateUnicodeAtom((String)("global " + string)), (TypeReference)TypeReference.findOrCreate((ClassLoaderReference)this.loader.getReference(), (TypeName)AstTypeReference.rootTypeName));
    }

    protected AstTranslator(IClassLoader iClassLoader, Map map) {
        this.loader = iClassLoader;
        this.namedEntityResolver = map;
        this.arrayOpHandler = this;
        this.insts = iClassLoader.getInstructionFactory();
    }

    protected AstTranslator(IClassLoader iClassLoader) {
        this(iClassLoader, null);
    }

    public void setArrayOpHandler(ArrayOpHandler arrayOpHandler) {
        this.arrayOpHandler = arrayOpHandler;
    }

    private AbstractScope makeScriptScope(final CAstEntity cAstEntity, Scope scope) {
        return new AbstractScope(scope){
            SymbolTable scriptGlobalSymtab;
            {
                super(scope);
                this.scriptGlobalSymtab = new SymbolTable(cAstEntity2.getArgumentCount());
            }

            public SymbolTable getUnderlyingSymtab() {
                return this.scriptGlobalSymtab;
            }

            protected AbstractScope getEntityScope() {
                return this;
            }

            public boolean isLexicallyScoped(Symbol symbol) {
                if (this.isGlobal(symbol)) {
                    return false;
                }
                return ((AbstractScope)symbol.getDefiningScope()).getEntityScope() != this;
            }

            public CAstEntity getEntity() {
                return cAstEntity;
            }

            public int type() {
                return 3;
            }

            protected Symbol makeSymbol(final String string, boolean bl, final boolean bl2, Object object, int n, Scope scope) {
                int n2;
                int n3 = n2 = n == -1 ? this.getUnderlyingSymtab().newSymbol() : n;
                if (AstTranslator.this.useDefaultInitValues() && object != null && this.getUnderlyingSymtab().getValue(n2) == null) {
                    AstTranslator.this.setDefaultValue(this.getUnderlyingSymtab(), n2, object);
                }
                return new AbstractSymbol(scope, bl, object){

                    public String toString() {
                        return String.valueOf(string) + ":" + System.identityHashCode(this);
                    }

                    public int valueNumber() {
                        return n2;
                    }

                    public boolean isInternalName() {
                        return bl2;
                    }

                    public boolean isParameter() {
                        return false;
                    }
                };
            }
        };
    }

    private AbstractScope makeFunctionScope(final CAstEntity cAstEntity, Scope scope) {
        return new AbstractScope(scope){
            private final String[] params;
            private final SymbolTable functionSymtab;
            {
                super(scope);
                this.params = cAstEntity2.getArgumentNames();
                this.functionSymtab = new SymbolTable(cAstEntity2.getArgumentCount());
                int n = 0;
                while (n < cAstEntity2.getArgumentCount()) {
                    final int n2 = n++;
                    this.declare(new CAstSymbol(){

                        public String name() {
                            return cAstEntity2.getArgumentNames()[n2];
                        }

                        public boolean isFinal() {
                            return false;
                        }

                        public boolean isCaseInsensitive() {
                            return false;
                        }

                        public boolean isInternalName() {
                            return false;
                        }

                        public Object defaultInitValue() {
                            return null;
                        }
                    });
                }
            }

            public SymbolTable getUnderlyingSymtab() {
                return this.functionSymtab;
            }

            protected AbstractScope getEntityScope() {
                return this;
            }

            public boolean isLexicallyScoped(Symbol symbol) {
                if (this.isGlobal(symbol)) {
                    return false;
                }
                return ((AbstractScope)symbol.getDefiningScope()).getEntityScope() != this;
            }

            public CAstEntity getEntity() {
                return cAstEntity;
            }

            public int type() {
                return 4;
            }

            private int find(String string) {
                int n = 0;
                while (n < this.params.length) {
                    if (string.equals(this.params[n])) {
                        return n + 1;
                    }
                    ++n;
                }
                return -1;
            }

            protected Symbol makeSymbol(final String string, boolean bl, final boolean bl2, Object object, int n, Scope scope) {
                return new AbstractSymbol(scope, bl, object, n, object){
                    final int vn;
                    {
                        super(scope, bl, object);
                        int n2 = this.find(string2);
                        if (n2 != -1) {
                            if (!$assertionsDisabled && n != -1) {
                                throw new AssertionError();
                            }
                            this.vn = n2;
                        } else {
                            this.vn = n != -1 ? n : this.getUnderlyingSymtab().newSymbol();
                        }
                        if (AstTranslator.this.useDefaultInitValues() && object2 != null && this.getUnderlyingSymtab().getValue(this.vn) == null) {
                            AstTranslator.this.setDefaultValue(this.getUnderlyingSymtab(), this.vn, object2);
                        }
                    }

                    public String toString() {
                        return String.valueOf(string) + ":" + System.identityHashCode(this);
                    }

                    public int valueNumber() {
                        return this.vn;
                    }

                    public boolean isInternalName() {
                        return bl2;
                    }

                    public boolean isParameter() {
                        return this.vn <= params.length;
                    }
                };
            }
        };
    }

    private Scope makeLocalScope(CAstNode cAstNode, final Scope scope) {
        return new AbstractScope(scope){

            public int type() {
                return 1;
            }

            public SymbolTable getUnderlyingSymtab() {
                return ((AbstractScope)scope).getUnderlyingSymtab();
            }

            protected AbstractScope getEntityScope() {
                return ((AbstractScope)scope).getEntityScope();
            }

            public boolean isLexicallyScoped(Symbol symbol) {
                return this.getEntityScope().isLexicallyScoped(symbol);
            }

            public CAstEntity getEntity() {
                return this.getEntityScope().getEntity();
            }

            protected Symbol makeSymbol(final String string, boolean bl, final boolean bl2, Object object, int n, Scope scope2) {
                int n2;
                int n3 = n2 = n == -1 ? this.getUnderlyingSymtab().newSymbol() : n;
                if (AstTranslator.this.useDefaultInitValues() && object != null && this.getUnderlyingSymtab().getValue(n2) == null) {
                    AstTranslator.this.setDefaultValue(this.getUnderlyingSymtab(), n2, object);
                }
                return new AbstractSymbol(scope2, bl, object){

                    public String toString() {
                        return String.valueOf(string) + ":" + System.identityHashCode(this);
                    }

                    public int valueNumber() {
                        return n2;
                    }

                    public boolean isInternalName() {
                        return bl2;
                    }

                    public boolean isParameter() {
                        return false;
                    }
                };
            }
        };
    }

    private Scope makeGlobalScope() {
        final LinkedHashMap linkedHashMap = new LinkedHashMap();
        final LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        return new Scope(){

            private final String mapName(String string) {
                String string2 = (String)linkedHashMap2.get(string.toLowerCase());
                return string2 == null ? string : string2;
            }

            @Override
            public Scope getParent() {
                return null;
            }

            @Override
            public boolean isGlobal(Symbol symbol) {
                return true;
            }

            @Override
            public boolean isLexicallyScoped(Symbol symbol) {
                return false;
            }

            @Override
            public CAstEntity getEntity() {
                return null;
            }

            @Override
            public int size() {
                return linkedHashMap.size();
            }

            @Override
            public Iterator<String> getAllNames() {
                return linkedHashMap.keySet().iterator();
            }

            @Override
            public int allocateTempValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getConstantValue(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isConstant(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getConstantObject(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int type() {
                return 2;
            }

            @Override
            public boolean contains(String string) {
                return AstTranslator.this.hasImplicitGlobals() || linkedHashMap.containsKey(this.mapName(string));
            }

            @Override
            public boolean isCaseInsensitive(String string) {
                return linkedHashMap2.containsKey(string.toLowerCase());
            }

            @Override
            public Symbol lookup(final String string) {
                if (!linkedHashMap.containsKey(this.mapName(string))) {
                    if (AstTranslator.this.hasImplicitGlobals()) {
                        this.declare(new CAstSymbol(){

                            public String name() {
                                return string;
                            }

                            public boolean isFinal() {
                                return false;
                            }

                            public boolean isCaseInsensitive() {
                                return false;
                            }

                            public boolean isInternalName() {
                                return false;
                            }

                            public Object defaultInitValue() {
                                return null;
                            }
                        });
                    } else {
                        if (AstTranslator.this.hasSpecialUndeclaredVariables()) {
                            return null;
                        }
                        throw new Error("cannot find " + string);
                    }
                }
                return (Symbol)linkedHashMap.get(this.mapName(string));
            }

            @Override
            public void declare(CAstSymbol cAstSymbol, int n) {
                if (!$assertionsDisabled && n != -1) {
                    throw new AssertionError();
                }
                this.declare(cAstSymbol);
            }

            @Override
            public void declare(final CAstSymbol cAstSymbol) {
                final String string = cAstSymbol.name();
                if (cAstSymbol.isCaseInsensitive()) {
                    linkedHashMap2.put(string.toLowerCase(), string);
                }
                linkedHashMap.put(string, new AbstractSymbol(this, cAstSymbol.isFinal(), cAstSymbol.defaultInitValue()){

                    public String toString() {
                        return String.valueOf(string) + ":" + System.identityHashCode(this);
                    }

                    public boolean isParameter() {
                        return false;
                    }

                    public boolean isInternalName() {
                        return cAstSymbol.isInternalName();
                    }

                    public int valueNumber() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
    }

    protected Scope makeTypeScope(final CAstEntity cAstEntity, final Scope scope) {
        final LinkedHashMap linkedHashMap = new LinkedHashMap();
        final LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        return new Scope(){

            private final String mapName(String string) {
                String string2 = (String)linkedHashMap2.get(string.toLowerCase());
                return string2 == null ? string : string2;
            }

            @Override
            public Scope getParent() {
                return scope;
            }

            @Override
            public boolean isGlobal(Symbol symbol) {
                return false;
            }

            @Override
            public boolean isLexicallyScoped(Symbol symbol) {
                return false;
            }

            @Override
            public CAstEntity getEntity() {
                return cAstEntity;
            }

            @Override
            public int size() {
                return linkedHashMap.size();
            }

            @Override
            public Iterator<String> getAllNames() {
                return linkedHashMap.keySet().iterator();
            }

            @Override
            public int allocateTempValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getConstantValue(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isConstant(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getConstantObject(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int type() {
                return 5;
            }

            @Override
            public boolean contains(String string) {
                return linkedHashMap.containsKey(this.mapName(string));
            }

            @Override
            public boolean isCaseInsensitive(String string) {
                return linkedHashMap2.containsKey(string.toLowerCase());
            }

            @Override
            public Symbol lookup(String string) {
                if (linkedHashMap.containsKey(this.mapName(string))) {
                    return (Symbol)linkedHashMap.get(this.mapName(string));
                }
                return scope.lookup(string);
            }

            @Override
            public void declare(CAstSymbol cAstSymbol, int n) {
                if (!$assertionsDisabled && n != -1) {
                    throw new AssertionError();
                }
                this.declare(cAstSymbol);
            }

            @Override
            public void declare(final CAstSymbol cAstSymbol) {
                final String string = cAstSymbol.name();
                if (!$assertionsDisabled && cAstSymbol.isFinal()) {
                    throw new AssertionError();
                }
                if (cAstSymbol.isCaseInsensitive()) {
                    linkedHashMap2.put(string.toLowerCase(), string);
                }
                linkedHashMap.put(string, new AbstractSymbol(this, cAstSymbol.isFinal(), cAstSymbol.defaultInitValue()){

                    public String toString() {
                        return String.valueOf(string) + ":" + System.identityHashCode(this);
                    }

                    public boolean isParameter() {
                        return false;
                    }

                    public boolean isInternalName() {
                        return cAstSymbol.isInternalName();
                    }

                    public int valueNumber() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        };
    }

    protected boolean hasValue(CAstNode cAstNode) {
        return this.results.containsKey(cAstNode);
    }

    public final int setValue(CAstNode cAstNode, int n) {
        this.results.put(cAstNode, new Integer(n));
        return n;
    }

    public final int getValue(CAstNode cAstNode) {
        if (this.results.containsKey(cAstNode)) {
            return this.results.get(cAstNode);
        }
        return -1;
    }

    private void addEntityName(CAstEntity cAstEntity, String string) {
        this.entityNames.put(cAstEntity, string);
    }

    private void addAccess(CAstEntity cAstEntity, AstLexicalAccess.Access access) {
        if (!this.accesses.containsKey(cAstEntity)) {
            this.accesses.put(cAstEntity, new LinkedHashSet());
        }
        this.accesses.get(cAstEntity).add(access);
    }

    private void addExposedName(CAstEntity cAstEntity, CAstEntity cAstEntity2, String string, int n) {
        if (!this.exposedNames.containsKey(cAstEntity)) {
            this.exposedNames.put(cAstEntity, new LinkedHashSet());
        }
        this.exposedNames.get(cAstEntity).add((Pair<Pair<String, String>, Integer>)Pair.make((Object)Pair.make((Object)string, (Object)this.getEntityName(cAstEntity2)), (Object)new Integer(n)));
    }

    private String getEntityName(CAstEntity cAstEntity) {
        if (cAstEntity == null) {
            return null;
        }
        assert (this.entityNames.containsKey(cAstEntity));
        return "L" + this.entityNames.get(cAstEntity);
    }

    private void setDefaultValue(SymbolTable symbolTable, int n, Object object) {
        if (object == CAstSymbol.NULL_DEFAULT_VALUE) {
            symbolTable.setDefaultValue(n, null);
        } else {
            symbolTable.setDefaultValue(n, object);
        }
    }

    protected IUnaryOpInstruction.IOperator translateUnaryOpcode(CAstNode cAstNode) {
        if (cAstNode == CAstOperator.OP_BITNOT) {
            return AstConstants.UnaryOp.BITNOT;
        }
        if (cAstNode == CAstOperator.OP_NOT) {
            return IUnaryOpInstruction.Operator.NEG;
        }
        if (cAstNode == CAstOperator.OP_SUB) {
            return AstConstants.UnaryOp.MINUS;
        }
        if (cAstNode == CAstOperator.OP_ADD) {
            return AstConstants.UnaryOp.PLUS;
        }
        Assertions.UNREACHABLE((String)("cannot translate " + CAstPrinter.print(cAstNode)));
        return null;
    }

    protected IBinaryOpInstruction.IOperator translateBinaryOpcode(CAstNode cAstNode) {
        if (cAstNode == CAstOperator.OP_ADD) {
            return IBinaryOpInstruction.Operator.ADD;
        }
        if (cAstNode == CAstOperator.OP_DIV) {
            return IBinaryOpInstruction.Operator.DIV;
        }
        if (cAstNode == CAstOperator.OP_LSH) {
            return IShiftInstruction.Operator.SHL;
        }
        if (cAstNode == CAstOperator.OP_MOD) {
            return IBinaryOpInstruction.Operator.REM;
        }
        if (cAstNode == CAstOperator.OP_MUL) {
            return IBinaryOpInstruction.Operator.MUL;
        }
        if (cAstNode == CAstOperator.OP_RSH) {
            return IShiftInstruction.Operator.SHR;
        }
        if (cAstNode == CAstOperator.OP_SUB) {
            return IBinaryOpInstruction.Operator.SUB;
        }
        if (cAstNode == CAstOperator.OP_URSH) {
            return IShiftInstruction.Operator.USHR;
        }
        if (cAstNode == CAstOperator.OP_BIT_AND) {
            return IBinaryOpInstruction.Operator.AND;
        }
        if (cAstNode == CAstOperator.OP_BIT_OR) {
            return IBinaryOpInstruction.Operator.OR;
        }
        if (cAstNode == CAstOperator.OP_BIT_XOR) {
            return IBinaryOpInstruction.Operator.XOR;
        }
        if (cAstNode == CAstOperator.OP_CONCAT) {
            return AstConstants.BinaryOp.CONCAT;
        }
        if (cAstNode == CAstOperator.OP_EQ) {
            return AstConstants.BinaryOp.EQ;
        }
        if (cAstNode == CAstOperator.OP_STRICT_EQ) {
            return AstConstants.BinaryOp.STRICT_EQ;
        }
        if (cAstNode == CAstOperator.OP_GE) {
            return AstConstants.BinaryOp.GE;
        }
        if (cAstNode == CAstOperator.OP_GT) {
            return AstConstants.BinaryOp.GT;
        }
        if (cAstNode == CAstOperator.OP_LE) {
            return AstConstants.BinaryOp.LE;
        }
        if (cAstNode == CAstOperator.OP_LT) {
            return AstConstants.BinaryOp.LT;
        }
        if (cAstNode == CAstOperator.OP_NE) {
            return AstConstants.BinaryOp.NE;
        }
        if (cAstNode == CAstOperator.OP_STRICT_NE) {
            return AstConstants.BinaryOp.STRICT_NE;
        }
        Assertions.UNREACHABLE((String)("cannot translate " + CAstPrinter.print(cAstNode)));
        return null;
    }

    protected IConditionalBranchInstruction.IOperator translateConditionOpcode(CAstNode cAstNode) {
        if (cAstNode == CAstOperator.OP_EQ) {
            return IConditionalBranchInstruction.Operator.EQ;
        }
        if (cAstNode == CAstOperator.OP_GE) {
            return IConditionalBranchInstruction.Operator.GE;
        }
        if (cAstNode == CAstOperator.OP_GT) {
            return IConditionalBranchInstruction.Operator.GT;
        }
        if (cAstNode == CAstOperator.OP_LE) {
            return IConditionalBranchInstruction.Operator.LE;
        }
        if (cAstNode == CAstOperator.OP_LT) {
            return IConditionalBranchInstruction.Operator.LT;
        }
        if (cAstNode == CAstOperator.OP_NE) {
            return IConditionalBranchInstruction.Operator.NE;
        }
        Assertions.UNREACHABLE((String)("cannot translate " + CAstPrinter.print(cAstNode)));
        return null;
    }

    private String[] makeNameMap(CAstEntity cAstEntity, Set<Scope> set) {
        String[] stringArray = new String[set.iterator().next().size() + 1];
        for (Scope scope : set) {
            Iterator<String> iterator = scope.getAllNames();
            while (iterator.hasNext()) {
                String string = iterator.next();
                Symbol symbol = scope.lookup(string);
                if (symbol.isInternalName() || scope.isConstant(symbol.valueNumber())) continue;
                assert (stringArray[symbol.valueNumber()] == null || stringArray[symbol.valueNumber()].equals(string)) : "value number " + symbol.valueNumber() + " mapped to multiple names in " + cAstEntity.getName() + ": " + string + " and " + stringArray[symbol.valueNumber()];
                stringArray[symbol.valueNumber()] = string;
            }
        }
        return stringArray;
    }

    protected final CAstType getTypeForNode(WalkContext walkContext, CAstNode cAstNode) {
        if (walkContext.top().getNodeTypeMap() != null) {
            return walkContext.top().getNodeTypeMap().getNodeType(cAstNode);
        }
        return null;
    }

    private void patchLexicalAccesses(SSAInstruction[] sSAInstructionArray, Set<AstLexicalAccess.Access> set) {
        AstLexicalAccess.Access[] accessArray = set == null ? null : set.toArray(new AstLexicalAccess.Access[set.size()]);
        int n = 0;
        while (n < sSAInstructionArray.length) {
            if (sSAInstructionArray[n] instanceof AstLexicalAccess && ((AstLexicalAccess)sSAInstructionArray[n]).getAccessCount() == 0) {
                if (accessArray != null) {
                    ((AstLexicalAccess)sSAInstructionArray[n]).setAccesses(accessArray);
                } else {
                    sSAInstructionArray[n] = null;
                }
            }
            ++n;
        }
    }

    @Override
    protected CAstVisitor.Context makeFileContext(CAstVisitor.Context context, CAstEntity cAstEntity) {
        return new FileContext((WalkContext)context, cAstEntity.getName());
    }

    @Override
    protected CAstVisitor.Context makeTypeContext(CAstVisitor.Context context, CAstEntity cAstEntity) {
        return new TypeContext((WalkContext)context, cAstEntity);
    }

    @Override
    protected CAstVisitor.Context makeCodeContext(CAstVisitor.Context context, CAstEntity cAstEntity) {
        WalkContext walkContext = (WalkContext)context;
        AbstractScope abstractScope = cAstEntity.getKind() == 2 ? this.makeScriptScope(cAstEntity, walkContext.currentScope()) : this.makeFunctionScope(cAstEntity, walkContext.currentScope());
        return new CodeEntityContext(walkContext, abstractScope, cAstEntity);
    }

    @Override
    protected boolean enterEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected boolean visitFileEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor.Context context2, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveFileEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor.Context context2, CAstVisitor cAstVisitor) {
    }

    @Override
    protected boolean visitFieldEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveFieldEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        CAstEntity cAstEntity2 = context.top();
        assert (cAstEntity2.getKind() == 3) : "Parent of field entity is not a type???";
        this.defineField(cAstEntity2, (WalkContext)context, cAstEntity);
    }

    @Override
    protected boolean visitGlobalEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveGlobalEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.getGlobalScope().declare(new CAstSymbolImpl(cAstEntity.getName()));
    }

    @Override
    protected boolean visitTypeEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor.Context context2, CAstVisitor cAstVisitor) {
        this.defineType(cAstEntity, (WalkContext)context);
        return false;
    }

    @Override
    protected void leaveTypeEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor.Context context2, CAstVisitor cAstVisitor) {
    }

    @Override
    protected boolean visitFunctionEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor.Context context2, CAstVisitor cAstVisitor) {
        if (cAstEntity.getAST() == null) {
            this.declareFunction(cAstEntity, (WalkContext)context);
        } else {
            this.initFunctionEntity(cAstEntity, (WalkContext)context, (WalkContext)context2);
        }
        return false;
    }

    @Override
    protected void leaveFunctionEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor.Context context2, CAstVisitor cAstVisitor) {
        if (cAstEntity.getAST() != null) {
            this.closeFunctionEntity(cAstEntity, (WalkContext)context, (WalkContext)context2);
        }
    }

    @Override
    protected boolean visitMacroEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor.Context context2, CAstVisitor cAstVisitor) {
        return true;
    }

    @Override
    protected boolean visitScriptEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor.Context context2, CAstVisitor cAstVisitor) {
        this.declareFunction(cAstEntity, (WalkContext)context2);
        this.initFunctionEntity(cAstEntity, (WalkContext)context, (WalkContext)context2);
        return false;
    }

    @Override
    protected void leaveScriptEntity(CAstEntity cAstEntity, CAstVisitor.Context context, CAstVisitor.Context context2, CAstVisitor cAstVisitor) {
        this.closeFunctionEntity(cAstEntity, (WalkContext)context, (WalkContext)context2);
    }

    public void initFunctionEntity(CAstEntity cAstEntity, WalkContext walkContext, WalkContext walkContext2) {
        this.resultStack.push(this.results);
        this.results = new LinkedHashMap<CAstNode, Integer>();
        walkContext2.cfg().makeEntryBlock(walkContext2.cfg().newBlock(false));
        walkContext2.cfg().newBlock(true);
        this.doPrologue(walkContext2);
    }

    public void closeFunctionEntity(CAstEntity cAstEntity, WalkContext walkContext, WalkContext walkContext2) {
        walkContext2.cfg().makeExitBlock(walkContext2.cfg().newBlock(true));
        SymbolTable symbolTable = ((AbstractScope)walkContext2.currentScope()).getUnderlyingSymtab();
        TypeReference[][] typeReferenceArray = walkContext2.getCatchTypes();
        AstCFG astCFG = new AstCFG(cAstEntity, walkContext2.cfg(), symbolTable);
        CAstSourcePositionMap.Position[] positionArray = walkContext2.cfg().getLinePositionMap();
        boolean bl = walkContext2.cfg().hasCatchBlock();
        boolean bl2 = walkContext2.cfg().hasMonitorOp();
        String[] stringArray = this.makeNameMap(cAstEntity, walkContext2.entityScopes());
        this.patchLexicalAccesses(astCFG.getInstructions(), (Set<AstLexicalAccess.Access>)this.accesses.get(cAstEntity));
        AstLexicalInformation astLexicalInformation = new AstLexicalInformation((AbstractScope)walkContext2.currentScope(), astCFG.getInstructions(), (Set<Pair<Pair<String, String>, Integer>>)this.exposedNames.get(cAstEntity), this.accesses.get(cAstEntity));
        AstDebuggingInformation astDebuggingInformation = new AstDebuggingInformation(cAstEntity.getPosition(), positionArray, stringArray);
        this.defineFunction(cAstEntity, walkContext, astCFG, symbolTable, bl, typeReferenceArray, bl2, astLexicalInformation, astDebuggingInformation);
        this.results = this.resultStack.pop();
    }

    @Override
    protected CAstVisitor.Context makeLocalContext(CAstVisitor.Context context, CAstNode cAstNode) {
        return new LocalContext((WalkContext)context, this.makeLocalScope(cAstNode, ((WalkContext)context).currentScope()));
    }

    @Override
    protected CAstVisitor.Context makeUnwindContext(CAstVisitor.Context context, CAstNode cAstNode, CAstVisitor cAstVisitor) {
        return new UnwindContext(cAstNode, (WalkContext)context, cAstVisitor);
    }

    @Override
    protected boolean enterNode(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        CAstSourcePositionMap.Position position;
        WalkContext walkContext = (WalkContext)context;
        boolean bl = false;
        if (walkContext.getSourceMap() != null && (position = walkContext.getSourceMap().getPosition(cAstNode)) != null) {
            if (walkContext.cfg().getCurrentPosition() != null) {
                this.positions.push(walkContext.cfg().getCurrentPosition());
                bl = true;
            }
            walkContext.cfg().setCurrentPosition(position);
        }
        if (bl) {
            this.popPositionM.put(cAstNode, Boolean.TRUE);
        }
        return false;
    }

    @Override
    protected void postProcessNode(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        if (this.popPositionM.get(cAstNode) != null) {
            this.popPositionM.remove(cAstNode);
            walkContext.cfg().setCurrentPosition(this.positions.pop());
        }
    }

    protected int processFunctionExpr(CAstNode cAstNode, CAstVisitor.Context context) {
        WalkContext walkContext = (WalkContext)context;
        CAstEntity cAstEntity = (CAstEntity)cAstNode.getChild(0).getValue();
        this.declareFunction(cAstEntity, walkContext);
        int n = walkContext.currentScope().allocateTempValue();
        int n2 = walkContext.currentScope().allocateTempValue();
        this.doMaterializeFunction(cAstNode, walkContext, n, n2, cAstEntity);
        return n;
    }

    @Override
    protected boolean visitFunctionExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveFunctionExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        int n = this.processFunctionExpr(cAstNode, context);
        this.setValue(cAstNode, n);
    }

    @Override
    protected boolean visitFunctionStmt(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveFunctionStmt(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.processFunctionExpr(cAstNode, context);
        CAstEntity cAstEntity = (CAstEntity)cAstNode.getChild(0).getValue();
        Symbol symbol = walkContext.currentScope().lookup(cAstEntity.getName());
        if (!walkContext.currentScope().contains(cAstEntity.getName())) {
            walkContext.currentScope().declare(new FinalCAstSymbol(cAstEntity.getName()), n);
        } else {
            this.assignValue(cAstNode, walkContext, symbol, cAstEntity.getName(), n);
        }
    }

    @Override
    protected boolean visitLocalScope(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveLocalScope(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.setValue(cAstNode, this.getValue(cAstNode.getChild(0)));
    }

    @Override
    protected boolean visitBlockExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveBlockExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.setValue(cAstNode, this.getValue(cAstNode.getChild(cAstNode.getChildCount() - 1)));
    }

    @Override
    protected boolean visitBlockStmt(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveBlockStmt(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected boolean visitLoop(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        PreBasicBlock preBasicBlock;
        WalkContext walkContext = (WalkContext)context;
        walkContext.cfg().newBlock(true);
        PreBasicBlock preBasicBlock2 = walkContext.cfg().getCurrentBlock();
        cAstVisitor.visit(cAstNode.getChild(0), walkContext, cAstVisitor);
        assert (this.getValue(cAstNode.getChild(0)) != -1) : "error in loop test " + CAstPrinter.print(cAstNode.getChild(0), walkContext.top().getSourceMap()) + " of loop " + CAstPrinter.print(cAstNode, walkContext.top().getSourceMap());
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.ConditionalBranchInstruction(this.translateConditionOpcode(CAstOperator.OP_EQ), null, this.getValue(cAstNode.getChild(0)), walkContext.currentScope().getConstantValue(new Integer(0))));
        PreBasicBlock preBasicBlock3 = walkContext.cfg().getCurrentBlock();
        walkContext.cfg().newBlock(true);
        cAstVisitor.visit(cAstNode.getChild(1), walkContext, cAstVisitor);
        if (!walkContext.cfg().isDeadBlock(walkContext.cfg().getCurrentBlock())) {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction());
            preBasicBlock = walkContext.cfg().getCurrentBlock();
            walkContext.cfg().addEdge(preBasicBlock, preBasicBlock2);
            walkContext.cfg().newBlock(false);
        }
        preBasicBlock = walkContext.cfg().getCurrentBlock();
        walkContext.cfg().addEdge(preBasicBlock3, preBasicBlock);
        return true;
    }

    @Override
    protected final void leaveLoopHeader(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected final void leaveLoop(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected boolean visitGetCaughtException(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveGetCaughtException(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        String string = (String)cAstNode.getChild(0).getValue();
        walkContext.currentScope().declare(new FinalCAstSymbol(string));
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.GetCaughtExceptionInstruction(walkContext.cfg().getCurrentBlock().getNumber(), walkContext.currentScope().lookup(string).valueNumber()));
    }

    @Override
    protected boolean visitThis(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveThis(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.setValue(cAstNode, 1);
    }

    @Override
    protected boolean visitSuper(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveSuper(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.setValue(cAstNode, 1);
    }

    @Override
    protected boolean visitCall(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        return false;
    }

    @Override
    protected void leaveCall(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.getValue(cAstNode);
        int n2 = walkContext.currentScope().allocateTempValue();
        int n3 = this.getValue(cAstNode.getChild(0));
        CAstNode cAstNode2 = cAstNode.getChild(1);
        int[] nArray = new int[cAstNode.getChildCount() - 2];
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = this.getValue(cAstNode.getChild(n4 + 2));
            ++n4;
        }
        this.doCall(walkContext, cAstNode, n, n2, cAstNode2, n3, nArray);
    }

    @Override
    protected boolean visitVar(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveVar(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        String string = (String)cAstNode.getChild(0).getValue();
        assert (string != null) : "cannot find var for " + CAstPrinter.print(cAstNode, walkContext.getSourceMap());
        Symbol symbol = walkContext.currentScope().lookup(string);
        assert (symbol != null) : "cannot find symbol for " + string + " at " + CAstPrinter.print(cAstNode, walkContext.getSourceMap());
        if (walkContext.currentScope().isGlobal(symbol)) {
            this.setValue(cAstNode, this.doGlobalRead(cAstNode, walkContext, string));
        } else if (walkContext.currentScope().isLexicallyScoped(symbol)) {
            this.setValue(cAstNode, this.doLexicallyScopedRead(cAstNode, walkContext, string));
        } else {
            this.setValue(cAstNode, this.doLocalRead(walkContext, string));
        }
    }

    @Override
    protected boolean visitConstant(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveConstant(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        this.setValue(cAstNode, walkContext.currentScope().getConstantValue(cAstNode.getValue()));
    }

    @Override
    protected boolean visitBinaryExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        return false;
    }

    private boolean handleBinaryOpThrow(CAstNode cAstNode, CAstNode cAstNode2, WalkContext walkContext) {
        boolean bl = false;
        Collection<Object> collection = walkContext.getControlFlow().getTargetLabels(cAstNode);
        if (!collection.isEmpty()) {
            walkContext.cfg().addPreNode(cAstNode, walkContext.getUnwindState());
            bl = true;
            assert (cAstNode2 == CAstOperator.OP_DIV || cAstNode2 == CAstOperator.OP_MOD) : CAstPrinter.print(cAstNode);
            for (Object object : collection) {
                CAstNode cAstNode3 = walkContext.getControlFlow().getTarget(cAstNode, object);
                if (cAstNode3 == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                    walkContext.cfg().addPreEdgeToExit(cAstNode, true);
                    continue;
                }
                walkContext.cfg().addPreEdge(cAstNode, cAstNode3, true);
            }
        }
        return bl;
    }

    @Override
    protected void leaveBinaryExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.getValue(cAstNode);
        CAstNode cAstNode2 = cAstNode.getChild(1);
        CAstNode cAstNode3 = cAstNode.getChild(2);
        assert (this.getValue(cAstNode3) != -1) : CAstPrinter.print(cAstNode);
        assert (this.getValue(cAstNode2) != -1) : CAstPrinter.print(cAstNode);
        boolean bl = this.handleBinaryOpThrow(cAstNode, cAstNode.getChild(0), walkContext);
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.BinaryOpInstruction(this.translateBinaryOpcode(cAstNode.getChild(0)), false, false, n, this.getValue(cAstNode2), this.getValue(cAstNode3), bl));
        if (bl) {
            walkContext.cfg().newBlock(true);
        }
    }

    @Override
    protected boolean visitUnaryExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        return false;
    }

    @Override
    protected void leaveUnaryExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.getValue(cAstNode);
        CAstNode cAstNode2 = cAstNode.getChild(1);
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.UnaryOpInstruction(this.translateUnaryOpcode(cAstNode.getChild(0)), n, this.getValue(cAstNode2)));
    }

    @Override
    protected boolean visitArrayLength(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        return false;
    }

    @Override
    protected void leaveArrayLength(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.getValue(cAstNode);
        int n2 = this.getValue(cAstNode.getChild(0));
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.ArrayLengthInstruction(n, n2));
    }

    @Override
    protected boolean visitArrayRef(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveArrayRef(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.getValue(cAstNode.getChild(0));
        int n2 = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n2);
        this.arrayOpHandler.doArrayRead(walkContext, n2, n, cAstNode, this.gatherArrayDims(cAstNode));
    }

    @Override
    protected boolean visitDeclStmt(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveDeclStmt(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        CAstSymbol cAstSymbol = (CAstSymbol)cAstNode.getChild(0).getValue();
        String string = cAstSymbol.name();
        Scope scope = walkContext.currentScope();
        if (cAstNode.getChildCount() == 2) {
            CAstNode cAstNode2 = cAstNode.getChild(1);
            if (scope.contains(string) && scope.lookup(string).getDefiningScope() == scope) {
                assert (!cAstSymbol.isFinal());
                walkContext.cfg().addInstruction((SSAInstruction)new AssignInstruction(scope.lookup(string).valueNumber(), this.getValue(cAstNode2)));
            } else if (cAstNode2.getKind() != 300 && cAstNode2.getKind() != 111 && cAstNode2.getKind() != 116) {
                scope.declare(cAstSymbol, this.getValue(cAstNode2));
            } else {
                scope.declare(cAstSymbol);
                walkContext.cfg().addInstruction((SSAInstruction)new AssignInstruction(walkContext.currentScope().lookup(string).valueNumber(), this.getValue(cAstNode2)));
            }
        } else {
            walkContext.currentScope().declare(cAstSymbol);
        }
    }

    @Override
    protected boolean visitReturn(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveReturn(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        if (cAstNode.getChildCount() > 0) {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.ReturnInstruction(this.getValue(cAstNode.getChild(0)), false));
        } else {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.ReturnInstruction());
        }
        walkContext.cfg().addPreNode(cAstNode, walkContext.getUnwindState());
        walkContext.cfg().newBlock(false);
        walkContext.cfg().addPreEdgeToExit(cAstNode, false);
    }

    @Override
    protected boolean visitIfgoto(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveIfgoto(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        if (cAstNode.getChildCount() == 1) {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.ConditionalBranchInstruction(this.translateConditionOpcode(CAstOperator.OP_NE), null, this.getValue(cAstNode.getChild(0)), walkContext.currentScope().getConstantValue(new Integer(0))));
        } else if (cAstNode.getChildCount() == 3) {
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.ConditionalBranchInstruction(this.translateConditionOpcode(cAstNode.getChild(0)), null, this.getValue(cAstNode.getChild(1)), this.getValue(cAstNode.getChild(2))));
        } else {
            Assertions.UNREACHABLE();
        }
        walkContext.cfg().addPreNode(cAstNode, walkContext.getUnwindState());
        walkContext.cfg().newBlock(true);
        walkContext.cfg().addPreEdge(cAstNode, walkContext.getControlFlow().getTarget(cAstNode, Boolean.TRUE), false);
    }

    @Override
    protected boolean visitGoto(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveGoto(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        walkContext.cfg().addPreNode(cAstNode, walkContext.getUnwindState());
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction());
        walkContext.cfg().newBlock(false);
        if (walkContext.getControlFlow().getTarget(cAstNode, null) == null) assert (walkContext.getControlFlow().getTarget(cAstNode, null) != null) : walkContext.getControlFlow() + " does not map " + cAstNode + " (" + walkContext.getSourceMap().getPosition(cAstNode) + ")";
        walkContext.cfg().addPreEdge(cAstNode, walkContext.getControlFlow().getTarget(cAstNode, null), false);
    }

    @Override
    protected boolean visitLabelStmt(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        if (!walkContext.getControlFlow().getSourceNodes(cAstNode).isEmpty()) {
            walkContext.cfg().newBlock(true);
            walkContext.cfg().addPreNode(cAstNode, walkContext.getUnwindState());
        }
        return false;
    }

    @Override
    protected void leaveLabelStmt(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    protected void processIf(CAstNode cAstNode, boolean bl, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        PreBasicBlock preBasicBlock = null;
        PreBasicBlock preBasicBlock2 = null;
        CAstNode cAstNode2 = cAstNode.getChild(0);
        cAstVisitor.visit(cAstNode2, walkContext, cAstVisitor);
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.ConditionalBranchInstruction(this.translateConditionOpcode(CAstOperator.OP_EQ), null, this.getValue(cAstNode2), walkContext.currentScope().getConstantValue(new Integer(0))));
        PreBasicBlock preBasicBlock3 = walkContext.cfg().getCurrentBlock();
        walkContext.cfg().newBlock(true);
        CAstNode cAstNode3 = cAstNode.getChild(1);
        cAstVisitor.visit(cAstNode3, walkContext, cAstVisitor);
        if (bl) {
            walkContext.cfg().addInstruction((SSAInstruction)new AssignInstruction(this.getValue(cAstNode), this.getValue(cAstNode3)));
        }
        if (cAstNode.getChildCount() == 3) {
            if (!walkContext.cfg().isDeadBlock(walkContext.cfg().getCurrentBlock())) {
                walkContext.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction());
                preBasicBlock = walkContext.cfg().getCurrentBlock();
                walkContext.cfg().newBlock(false);
            }
            preBasicBlock2 = walkContext.cfg().getCurrentBlock();
            CAstNode cAstNode4 = cAstNode.getChild(2);
            cAstVisitor.visit(cAstNode4, walkContext, cAstVisitor);
            if (bl) {
                walkContext.cfg().addInstruction((SSAInstruction)new AssignInstruction(this.getValue(cAstNode), this.getValue(cAstNode4)));
            }
        }
        walkContext.cfg().newBlock(true);
        if (cAstNode.getChildCount() == 3) {
            if (preBasicBlock != null) {
                walkContext.cfg().addEdge(preBasicBlock, walkContext.cfg().getCurrentBlock());
            }
            walkContext.cfg().addEdge(preBasicBlock3, preBasicBlock2);
        } else {
            walkContext.cfg().addEdge(preBasicBlock3, walkContext.cfg().getCurrentBlock());
        }
    }

    @Override
    protected final void leaveIfStmtCondition(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected final void leaveIfStmtTrueClause(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected final void leaveIfStmt(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected final void leaveIfExprCondition(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected final void leaveIfExprTrueClause(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected final void leaveIfExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected boolean visitIfStmt(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.processIf(cAstNode, false, context, cAstVisitor);
        return true;
    }

    @Override
    protected boolean visitIfExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        this.processIf(cAstNode, true, context, cAstVisitor);
        return true;
    }

    @Override
    protected boolean visitNew(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveNew(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        int[] nArray;
        WalkContext walkContext = (WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        if (cAstNode.getChildCount() <= 1) {
            nArray = null;
        } else {
            nArray = new int[cAstNode.getChildCount() - 1];
            int n2 = 1;
            while (n2 < cAstNode.getChildCount()) {
                nArray[n2 - 1] = this.getValue(cAstNode.getChild(n2));
                ++n2;
            }
        }
        this.doNewObject(walkContext, cAstNode, n, cAstNode.getChild(0).getValue(), nArray);
    }

    @Override
    protected boolean visitObjectLiteral(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveObjectLiteralFieldInit(CAstNode cAstNode, int n, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        if (cAstNode.getChild(n).getKind() == 19) {
            this.handleUnspecifiedLiteralKey(walkContext, cAstNode, n, cAstVisitor);
        }
        this.doFieldWrite(walkContext, this.getValue(cAstNode.getChild(0)), cAstNode.getChild(n), cAstNode, this.getValue(cAstNode.getChild(n + 1)));
    }

    @Override
    protected void leaveObjectLiteral(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.setValue(cAstNode, this.getValue(cAstNode.getChild(0)));
    }

    @Override
    protected boolean visitArrayLiteral(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveArrayLiteralObject(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.setValue(cAstNode, this.getValue(cAstNode.getChild(0)));
    }

    @Override
    protected void leaveArrayLiteralInitElement(CAstNode cAstNode, int n, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        this.arrayOpHandler.doArrayWrite(walkContext, this.getValue(cAstNode.getChild(0)), cAstNode, new int[]{walkContext.currentScope().getConstantValue(new Integer(n - 1))}, this.getValue(cAstNode.getChild(n)));
    }

    @Override
    protected void leaveArrayLiteral(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected boolean visitObjectRef(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        return false;
    }

    @Override
    protected void leaveObjectRef(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.getValue(cAstNode);
        CAstNode cAstNode2 = cAstNode.getChild(1);
        this.doFieldRead(walkContext, n, this.getValue(cAstNode.getChild(0)), cAstNode2, cAstNode);
    }

    @Override
    public boolean visitAssign(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    public void leaveAssign(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        if (cAstNode.getKind() == 14) {
            this.setValue(cAstNode, this.getValue(cAstNode.getChild(1)));
        } else {
            this.setValue(cAstNode, this.getValue(cAstNode.getChild(0)));
        }
    }

    private int[] gatherArrayDims(CAstNode cAstNode) {
        int n = cAstNode.getChildCount() - 2;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.getValue(cAstNode.getChild(n2 + 2));
            ++n2;
        }
        return nArray;
    }

    protected int processAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, int n, boolean bl, CAstVisitor.Context context) {
        WalkContext walkContext = (WalkContext)context;
        int n2 = this.getValue(cAstNode2);
        CAstNode cAstNode4 = cAstNode3.getChild(2);
        int n3 = walkContext.currentScope().allocateTempValue();
        boolean bl2 = this.handleBinaryOpThrow(cAstNode3, cAstNode4, walkContext);
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.BinaryOpInstruction(this.translateBinaryOpcode(cAstNode4), false, false, n3, n, n2, bl2));
        if (bl2) {
            walkContext.cfg().newBlock(true);
        }
        return n3;
    }

    @Override
    protected boolean visitArrayRefAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveArrayRefAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.getValue(cAstNode2);
        this.setValue(cAstNode, n);
        this.arrayOpHandler.doArrayWrite(walkContext, this.getValue(cAstNode.getChild(0)), cAstNode, this.gatherArrayDims(cAstNode), n);
    }

    @Override
    protected boolean visitArrayRefAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveArrayRefAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        int[] nArray = this.gatherArrayDims(cAstNode);
        this.arrayOpHandler.doArrayRead(walkContext, n, this.getValue(cAstNode.getChild(0)), cAstNode, nArray);
        int n2 = this.processAssignOp(cAstNode, cAstNode2, cAstNode3, n, !bl, context);
        this.setValue(cAstNode, bl ? n2 : n);
        this.arrayOpHandler.doArrayWrite(walkContext, this.getValue(cAstNode.getChild(0)), cAstNode, nArray, n2);
    }

    @Override
    protected boolean visitObjectRefAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveObjectRefAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.getValue(cAstNode2);
        this.setValue(cAstNode, n);
        this.doFieldWrite(walkContext, this.getValue(cAstNode.getChild(0)), cAstNode.getChild(1), cAstNode, n);
    }

    protected void processObjectRefAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor.Context context) {
    }

    @Override
    protected boolean visitObjectRefAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveObjectRefAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.doFieldRead(walkContext, n, this.getValue(cAstNode.getChild(0)), cAstNode.getChild(1), cAstNode);
        int n2 = this.processAssignOp(cAstNode, cAstNode2, cAstNode3, n, !bl, context);
        this.setValue(cAstNode, bl ? n2 : n);
        this.doFieldWrite(walkContext, this.getValue(cAstNode.getChild(0)), cAstNode.getChild(1), cAstNode, n2);
    }

    @Override
    protected boolean visitBlockExprAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveBlockExprAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.setValue(cAstNode, this.getValue(cAstNode.getChild(cAstNode.getChildCount() - 1)));
    }

    @Override
    protected boolean visitBlockExprAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveBlockExprAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.setValue(cAstNode, this.getValue(cAstNode.getChild(cAstNode.getChildCount() - 1)));
    }

    @Override
    protected boolean visitVarAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void assignValue(CAstNode cAstNode, WalkContext walkContext, Symbol symbol, String string, int n) {
        if (walkContext.currentScope().isGlobal(symbol)) {
            this.doGlobalWrite(walkContext, string, n);
        } else if (walkContext.currentScope().isLexicallyScoped(symbol)) {
            this.doLexicallyScopedWrite(walkContext, string, n);
        } else {
            assert (n != -1) : CAstPrinter.print(cAstNode, walkContext.top().getSourceMap());
            this.doLocalWrite(walkContext, string, n);
        }
    }

    @Override
    protected void leaveVarAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.getValue(cAstNode2);
        String string = (String)cAstNode.getChild(0).getValue();
        Symbol symbol = walkContext.currentScope().lookup(string);
        this.setValue(cAstNode, n);
        this.assignValue(cAstNode, walkContext, symbol, string, n);
    }

    @Override
    protected boolean visitVarAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveVarAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        int n;
        WalkContext walkContext = (WalkContext)context;
        String string = (String)cAstNode.getChild(0).getValue();
        Symbol symbol = walkContext.currentScope().lookup(string);
        int n2 = walkContext.currentScope().isGlobal(symbol) ? this.doGlobalRead(cAstNode, walkContext, string) : (walkContext.currentScope().isLexicallyScoped(symbol) ? this.doLexicallyScopedRead(cAstNode, walkContext, string) : this.doLocalRead(walkContext, string));
        if (!bl) {
            n = walkContext.currentScope().allocateTempValue();
            walkContext.cfg().addInstruction((SSAInstruction)new AssignInstruction(n, n2));
            this.setValue(cAstNode, n);
        }
        n = this.processAssignOp(cAstNode, cAstNode2, cAstNode3, n2, !bl, context);
        if (bl) {
            this.setValue(cAstNode, n);
        }
        if (walkContext.currentScope().isGlobal(symbol)) {
            this.doGlobalWrite(walkContext, string, n);
        } else if (walkContext.currentScope().isLexicallyScoped(symbol)) {
            this.doLexicallyScopedWrite(walkContext, string, n);
        } else {
            this.doLocalWrite(walkContext, string, n);
        }
    }

    private boolean isSimpleSwitch(CAstNode cAstNode, WalkContext walkContext, CAstVisitor cAstVisitor) {
        CAstControlFlowMap cAstControlFlowMap = walkContext.getControlFlow();
        Collection<Object> collection = cAstControlFlowMap.getTargetLabels(cAstNode);
        for (Object object : collection) {
            if (object == CAstControlFlowMap.SWITCH_DEFAULT) continue;
            CAstNode cAstNode2 = (CAstNode)object;
            if (cAstNode2.getKind() == 300) {
                Number number;
                Object object2;
                cAstVisitor.visit(cAstNode2, walkContext, cAstVisitor);
                if (this.getValue(cAstNode2) != -1 && walkContext.currentScope().isConstant(this.getValue(cAstNode2)) && (object2 = walkContext.currentScope().getConstantObject(this.getValue(cAstNode2))) instanceof Number && (double)(number = (Number)object2).intValue() == number.doubleValue()) continue;
            }
            return false;
        }
        return true;
    }

    private void doSimpleSwitch(CAstNode cAstNode, WalkContext walkContext, CAstVisitor cAstVisitor) {
        PreBasicBlock preBasicBlock = null;
        CAstControlFlowMap cAstControlFlowMap = walkContext.getControlFlow();
        CAstNode cAstNode2 = cAstNode.getChild(0);
        cAstVisitor.visit(cAstNode2, walkContext, cAstVisitor);
        int n = this.getValue(cAstNode2);
        boolean bl = cAstControlFlowMap.getTarget(cAstNode, CAstControlFlowMap.SWITCH_DEFAULT) != null;
        Collection<Object> collection = cAstControlFlowMap.getTargetLabels(cAstNode);
        int n2 = collection.size();
        if (bl) {
            --n2;
        }
        int[] nArray = new int[n2 * 2];
        int n3 = walkContext.cfg().getCurrentBlock().getGraphNodeId() + 1;
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.SwitchInstruction(n, n3, nArray));
        walkContext.cfg().addPreNode(cAstNode, walkContext.getUnwindState());
        walkContext.cfg().newBlock(true);
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction());
        preBasicBlock = walkContext.cfg().getCurrentBlock();
        walkContext.cfg().newBlock(false);
        CAstNode cAstNode3 = cAstNode.getChild(1);
        cAstVisitor.visit(cAstNode3, walkContext, cAstVisitor);
        walkContext.cfg().newBlock(true);
        if (!bl) {
            walkContext.cfg().addEdge(preBasicBlock, walkContext.cfg().getCurrentBlock());
        }
        int n4 = 0;
        for (Object object : collection) {
            CAstNode cAstNode4 = cAstControlFlowMap.getTarget(cAstNode, object);
            if (object == CAstControlFlowMap.SWITCH_DEFAULT) {
                walkContext.cfg().addEdge(preBasicBlock, walkContext.cfg().getBlock(cAstNode4));
                continue;
            }
            Number number = (Number)walkContext.currentScope().getConstantObject(this.getValue((CAstNode)object));
            nArray[2 * n4] = number.intValue();
            nArray[2 * n4 + 1] = walkContext.cfg().getBlock(cAstNode4).getGraphNodeId();
            ++n4;
            walkContext.cfg().addPreEdge(cAstNode, cAstNode4, false);
        }
    }

    private void doIfConvertSwitch(CAstNode cAstNode, WalkContext walkContext, CAstVisitor cAstVisitor) {
        Object object2;
        CAstControlFlowMap cAstControlFlowMap = walkContext.getControlFlow();
        walkContext.cfg().addPreNode(cAstNode, walkContext.getUnwindState());
        CAstNode cAstNode2 = cAstNode.getChild(0);
        cAstVisitor.visit(cAstNode2, walkContext, cAstVisitor);
        int n = this.getValue(cAstNode2);
        Collection<Object> collection = cAstControlFlowMap.getTargetLabels(cAstNode);
        LinkedHashMap<Object, PreBasicBlock> linkedHashMap = new LinkedHashMap<Object, PreBasicBlock>();
        for (Object object2 : collection) {
            if (object2 == CAstControlFlowMap.SWITCH_DEFAULT) continue;
            cAstVisitor.visit((CAstNode)object2, walkContext, cAstVisitor);
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.ConditionalBranchInstruction(this.translateConditionOpcode(CAstOperator.OP_EQ), null, n, this.getValue((CAstNode)object2)));
            linkedHashMap.put(object2, walkContext.cfg().getCurrentBlock());
            walkContext.cfg().newBlock(true);
        }
        PreBasicBlock preBasicBlock = walkContext.cfg().getCurrentBlock();
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction());
        walkContext.cfg().newBlock(false);
        object2 = cAstNode.getChild(1);
        cAstVisitor.visit((CAstNode)object2, walkContext, cAstVisitor);
        walkContext.cfg().newBlock(true);
        for (Object object3 : collection) {
            if (object3 == CAstControlFlowMap.SWITCH_DEFAULT) continue;
            CAstNode cAstNode3 = cAstControlFlowMap.getTarget(cAstNode, object3);
            walkContext.cfg().addEdge((PreBasicBlock)linkedHashMap.get(object3), walkContext.cfg().getBlock(cAstNode3));
        }
        if (cAstControlFlowMap.getTarget(cAstNode, CAstControlFlowMap.SWITCH_DEFAULT) == null) {
            walkContext.cfg().addEdge(preBasicBlock, walkContext.cfg().getCurrentBlock());
        } else {
            CAstNode cAstNode4 = cAstControlFlowMap.getTarget(cAstNode, CAstControlFlowMap.SWITCH_DEFAULT);
            walkContext.cfg().addEdge(preBasicBlock, walkContext.cfg().getBlock(cAstNode4));
        }
    }

    @Override
    protected boolean visitSwitch(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        if (this.isSimpleSwitch(cAstNode, walkContext, cAstVisitor)) {
            this.doSimpleSwitch(cAstNode, walkContext, cAstVisitor);
        } else {
            this.doIfConvertSwitch(cAstNode, walkContext, cAstVisitor);
        }
        return true;
    }

    @Override
    protected final void leaveSwitchValue(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected final void leaveSwitch(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected boolean visitThrow(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveThrow(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        this.doThrow(walkContext, this.getValue(cAstNode.getChild(0)));
        walkContext.cfg().addPreNode(cAstNode, walkContext.getUnwindState());
        walkContext.cfg().newBlock(false);
        Collection<Object> collection = walkContext.getControlFlow().getTargetLabels(cAstNode);
        for (Object object : collection) {
            CAstNode cAstNode2 = walkContext.getControlFlow().getTarget(cAstNode, object);
            if (cAstNode2 == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                walkContext.cfg().addPreEdgeToExit(cAstNode, true);
                continue;
            }
            walkContext.cfg().addPreEdge(cAstNode, cAstNode2, true);
        }
    }

    @Override
    protected boolean visitCatch(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        if (walkContext.getControlFlow().getSourceNodes(cAstNode).isEmpty()) {
            return true;
        }
        String string = (String)cAstNode.getChild(0).getValue();
        walkContext.cfg().setCurrentBlockAsHandler();
        if (!walkContext.currentScope().contains(string)) {
            walkContext.currentScope().declare(new FinalCAstSymbol(string));
        }
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.GetCaughtExceptionInstruction(walkContext.cfg().getCurrentBlock().getNumber(), walkContext.currentScope().lookup(string).valueNumber()));
        walkContext.cfg().addPreNode(cAstNode, walkContext.getUnwindState());
        CAstType cAstType = this.getTypeForNode(walkContext, cAstNode);
        if (cAstType != null) {
            TypeReference typeReference = this.makeType(cAstType);
            walkContext.setCatchType(cAstNode, typeReference);
        } else {
            walkContext.setCatchType(cAstNode, this.defaultCatchType());
        }
        return false;
    }

    @Override
    protected void leaveCatch(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected boolean visitUnwind(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveUnwind(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected boolean visitTry(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        boolean bl = false;
        cAstVisitor.visit(cAstNode.getChild(0), walkContext, cAstVisitor);
        PreBasicBlock preBasicBlock = walkContext.cfg().getCurrentBlock();
        if (!walkContext.cfg().isDeadBlock(walkContext.cfg().getCurrentBlock())) {
            bl = true;
            walkContext.cfg().addInstruction((SSAInstruction)this.insts.GotoInstruction());
            walkContext.cfg().newBlock(false);
        }
        walkContext.cfg().noteCatchBlock();
        cAstVisitor.visit(cAstNode.getChild(1), walkContext, cAstVisitor);
        if (!walkContext.cfg().isDeadBlock(walkContext.cfg().getCurrentBlock())) {
            walkContext.cfg().newBlock(true);
        }
        if (bl) {
            PreBasicBlock preBasicBlock2 = walkContext.cfg().getCurrentBlock();
            walkContext.cfg().addEdge(preBasicBlock, preBasicBlock2);
        }
        return true;
    }

    @Override
    protected final void leaveTryBlock(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected final void leaveTry(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
    }

    @Override
    protected boolean visitEmpty(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveEmpty(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        this.setValue(cAstNode, walkContext.currentScope().getConstantValue(null));
    }

    @Override
    protected boolean visitPrimitive(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leavePrimitive(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        this.doPrimitive(n, walkContext, cAstNode);
    }

    @Override
    protected boolean visitVoid(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveVoid(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        this.setValue(cAstNode, -1);
    }

    @Override
    protected boolean visitAssert(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveAssert(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        boolean bl = true;
        int n = this.getValue(cAstNode.getChild(0));
        if (cAstNode.getChildCount() == 2) {
            assert (cAstNode.getChild(1).getKind() == 300);
            assert (cAstNode.getChild(1).getValue() instanceof Boolean);
            bl = cAstNode.getChild(1).getValue().equals(Boolean.TRUE);
        }
        walkContext.cfg().addInstruction(new AstAssertInstruction(n, bl));
    }

    @Override
    protected boolean visitEachElementGet(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveEachElementGet(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        int n = ((WalkContext)context).currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        ((WalkContext)context).cfg().addInstruction((SSAInstruction)new EachElementGetInstruction(n, this.getValue(cAstNode.getChild(0))));
    }

    @Override
    protected boolean visitEachElementHasNext(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveEachElementHasNext(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        int n = ((WalkContext)context).currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        ((WalkContext)context).cfg().addInstruction((SSAInstruction)new EachElementHasNextInstruction(n, this.getValue(cAstNode.getChild(0))));
    }

    @Override
    protected boolean visitTypeLiteralExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveTypeLiteralExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        assert (cAstNode.getChild(0).getKind() == 300);
        String string = (String)cAstNode.getChild(0).getValue();
        TypeName typeName = TypeName.string2TypeName((String)string);
        TypeReference typeReference = TypeReference.findOrCreate((ClassLoaderReference)this.loader.getReference(), (TypeName)typeName);
        int n = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n);
        walkContext.cfg().addInstruction((SSAInstruction)this.insts.LoadMetadataInstruction(n, this.loader.getLanguage().getConstantType((Object)typeReference), (Object)typeReference));
    }

    @Override
    protected boolean visitIsDefinedExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveIsDefinedExpr(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int n = this.getValue(cAstNode.getChild(0));
        int n2 = walkContext.currentScope().allocateTempValue();
        this.setValue(cAstNode, n2);
        if (cAstNode.getChildCount() == 1) {
            walkContext.cfg().addInstruction(new AstIsDefinedInstruction(n2, n));
        } else {
            this.doIsFieldDefined(walkContext, n2, n, cAstNode.getChild(1));
        }
    }

    @Override
    protected boolean visitEcho(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    @Override
    protected void leaveEcho(CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        int[] nArray = new int[cAstNode.getChildCount()];
        int n = 0;
        while (n < cAstNode.getChildCount()) {
            nArray[n] = this.getValue(cAstNode.getChild(n));
            ++n;
        }
        walkContext.cfg().addInstruction(new AstEchoInstruction(nArray));
    }

    public CAstEntity getIncludedEntity(CAstNode cAstNode) {
        if (cAstNode.getChild(0).getKind() == 405) {
            assert (this.namedEntityResolver != null);
            return (CAstEntity)this.namedEntityResolver.get(cAstNode.getChild(0).getChild(0).getValue());
        }
        return (CAstEntity)cAstNode.getChild(0).getValue();
    }

    @Override
    protected void leaveInclude(final CAstNode cAstNode, CAstVisitor.Context context, CAstVisitor cAstVisitor) {
        WalkContext walkContext = (WalkContext)context;
        CAstEntity cAstEntity = this.getIncludedEntity(cAstNode);
        if (cAstEntity == null) {
            System.err.println("cannot find include for " + CAstPrinter.print(cAstNode));
            System.err.println("from:\n" + this.namedEntityResolver);
        } else {
            final boolean bl = cAstEntity.getKind() == 7;
            System.err.println("found " + cAstEntity.getName() + " for " + CAstPrinter.print(cAstNode));
            final CAstEntity cAstEntity2 = new CAstCloner(new CAstImpl(), true){

                private CAstNode copyIncludeExpr(CAstNode cAstNode2) {
                    if (cAstNode2.getValue() != null) {
                        return this.Ast.makeConstant(cAstNode2.getValue());
                    }
                    if (cAstNode2 instanceof CAstOperator) {
                        return cAstNode2;
                    }
                    CAstNode[] cAstNodeArray = new CAstNode[cAstNode2.getChildCount()];
                    int n = 0;
                    while (n < cAstNode2.getChildCount()) {
                        cAstNodeArray[n] = this.copyIncludeExpr(cAstNode2.getChild(n));
                        ++n;
                    }
                    return this.Ast.makeNode(cAstNode2.getKind(), cAstNodeArray);
                }

                protected CAstNode copyNodes(CAstNode cAstNode3, CAstBasicRewriter.NonCopyingContext nonCopyingContext, Map map) {
                    if (bl && cAstNode3.getKind() == 129) {
                        int n = ((Number)cAstNode3.getChild(0).getValue()).intValue();
                        CAstNode cAstNode2 = this.copyIncludeExpr(cAstNode.getChild(n));
                        map.put(Pair.make((Object)cAstNode3, (Object)nonCopyingContext.key()), cAstNode2);
                        return cAstNode2;
                    }
                    return super.copyNodesHackForEclipse(cAstNode3, nonCopyingContext, map);
                }
            }.rewrite(cAstEntity);
            if (cAstEntity2.getAST() == null) {
                System.err.println(String.valueOf(cAstEntity2.getName()) + " has no AST");
            } else {
                this.visit(cAstEntity2.getAST(), new DelegatingContext(walkContext){

                    public CAstSourcePositionMap getSourceMap() {
                        return cAstEntity2.getSourceMap();
                    }

                    public CAstControlFlowMap getControlFlow() {
                        return cAstEntity2.getControlFlow();
                    }
                }, cAstVisitor);
                cAstVisitor.visitScopedEntities(cAstEntity2, cAstEntity2.getAllScopedEntities(), (CAstVisitor.Context)walkContext, cAstVisitor);
            }
        }
    }

    protected final void walkEntities(CAstEntity cAstEntity, CAstVisitor.Context context) {
        this.visitEntities(cAstEntity, context, this);
    }

    @Override
    public void translate(CAstEntity cAstEntity, String string) {
        this.walkEntities(cAstEntity, new DefaultContext(this, cAstEntity, string));
    }

    protected Scope getGlobalScope() {
        return this.globalScope;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractScope
    implements Scope {
        private final Scope parent;
        private final Map<String, Symbol> values = new LinkedHashMap<String, Symbol>();
        private final Map<String, String> caseInsensitiveNames = new LinkedHashMap<String, String>();

        protected abstract SymbolTable getUnderlyingSymtab();

        @Override
        public Scope getParent() {
            return this.parent;
        }

        @Override
        public int size() {
            return this.getUnderlyingSymtab().getMaxValueNumber() + 1;
        }

        @Override
        public Iterator<String> getAllNames() {
            return this.values.keySet().iterator();
        }

        @Override
        public int allocateTempValue() {
            return this.getUnderlyingSymtab().newSymbol();
        }

        @Override
        public int getConstantValue(Object object) {
            if (object instanceof Integer) {
                return this.getUnderlyingSymtab().getConstant(((Integer)object).intValue());
            }
            if (object instanceof Float) {
                return this.getUnderlyingSymtab().getConstant(((Float)object).floatValue());
            }
            if (object instanceof Double) {
                return this.getUnderlyingSymtab().getConstant(((Double)object).doubleValue());
            }
            if (object instanceof Long) {
                return this.getUnderlyingSymtab().getConstant(((Long)object).longValue());
            }
            if (object instanceof String) {
                return this.getUnderlyingSymtab().getConstant((String)object);
            }
            if (object instanceof Boolean) {
                return this.getUnderlyingSymtab().getConstant(((Boolean)object).booleanValue());
            }
            if (object instanceof Character) {
                return this.getUnderlyingSymtab().getConstant((int)((Character)object).charValue());
            }
            if (object instanceof Byte) {
                return this.getUnderlyingSymtab().getConstant((int)((Byte)object).byteValue());
            }
            if (object instanceof Short) {
                return this.getUnderlyingSymtab().getConstant((int)((Short)object).shortValue());
            }
            if (object == null) {
                return this.getUnderlyingSymtab().getNullConstant();
            }
            if (object == CAstControlFlowMap.SWITCH_DEFAULT) {
                return this.getUnderlyingSymtab().getConstant("__default label");
            }
            System.err.println("cannot handle constant " + object);
            Assertions.UNREACHABLE();
            return -1;
        }

        @Override
        public boolean isConstant(int n) {
            return this.getUnderlyingSymtab().isConstant(n);
        }

        @Override
        public Object getConstantObject(int n) {
            return this.getUnderlyingSymtab().getConstantValue(n);
        }

        @Override
        public void declare(CAstSymbol cAstSymbol, int n) {
            String string = cAstSymbol.name();
            assert (!this.contains(string)) : string;
            if (cAstSymbol.isCaseInsensitive()) {
                this.caseInsensitiveNames.put(string.toLowerCase(), string);
            }
            this.values.put(string, this.makeSymbol(cAstSymbol, n));
        }

        @Override
        public void declare(CAstSymbol cAstSymbol) {
            String string = cAstSymbol.name();
            if (!this.contains(string) || this.lookup(string).getDefiningScope() != this) {
                if (cAstSymbol.isCaseInsensitive()) {
                    this.caseInsensitiveNames.put(string.toLowerCase(), string);
                }
                this.values.put(string, this.makeSymbol(cAstSymbol));
            } else assert (!cAstSymbol.isFinal()) : "trying to redeclare " + string;
        }

        AbstractScope(Scope scope) {
            this.parent = scope;
        }

        private final String mapName(String string) {
            String string2 = this.caseInsensitiveNames.get(string.toLowerCase());
            return string2 == null ? string : string2;
        }

        protected Symbol makeSymbol(CAstSymbol cAstSymbol) {
            return this.makeSymbol(cAstSymbol.name(), cAstSymbol.isFinal(), cAstSymbol.isInternalName(), cAstSymbol.defaultInitValue(), -1, this);
        }

        protected Symbol makeSymbol(CAstSymbol cAstSymbol, int n) {
            return this.makeSymbol(cAstSymbol.name(), cAstSymbol.isFinal(), cAstSymbol.isInternalName(), cAstSymbol.defaultInitValue(), n, this);
        }

        protected abstract Symbol makeSymbol(String var1, boolean var2, boolean var3, Object var4, int var5, Scope var6);

        @Override
        public boolean isCaseInsensitive(String string) {
            return this.caseInsensitiveNames.containsKey(string.toLowerCase());
        }

        @Override
        public Symbol lookup(String string) {
            if (this.contains(string)) {
                return this.values.get(this.mapName(string));
            }
            Symbol symbol = this.parent.lookup(string);
            if (symbol != null && this.getEntityScope() == this && (this.isGlobal(symbol) || this.isLexicallyScoped(symbol))) {
                this.values.put(string, this.makeSymbol(string, symbol.isFinal(), symbol.isInternalName(), symbol.defaultInitValue(), -1, symbol.getDefiningScope()));
                if (symbol.getDefiningScope().isCaseInsensitive(string)) {
                    this.caseInsensitiveNames.put(string.toLowerCase(), string);
                }
                return this.values.get(string);
            }
            return symbol;
        }

        @Override
        public boolean contains(String string) {
            String string2 = this.caseInsensitiveNames.get(string.toLowerCase());
            return this.values.containsKey(string2 == null ? string : string2);
        }

        @Override
        public boolean isGlobal(Symbol symbol) {
            return symbol.getDefiningScope() == AstTranslator.this.globalScope;
        }

        @Override
        public abstract boolean isLexicallyScoped(Symbol var1);

        protected abstract AbstractScope getEntityScope();

        @Override
        public abstract CAstEntity getEntity();
    }

    private static abstract class AbstractSymbol
    implements Symbol {
        private Object constantValue;
        private boolean isFinalValue;
        private final Scope definingScope;
        private Object defaultValue;

        AbstractSymbol(Scope scope, boolean bl, Object object) {
            this.definingScope = scope;
            this.isFinalValue = bl;
            this.defaultValue = object;
        }

        public boolean isFinal() {
            return this.isFinalValue;
        }

        public Object defaultInitValue() {
            return this.defaultValue;
        }

        public Object constant() {
            return this.constantValue;
        }

        public void setConstant(Object object) {
            this.constantValue = object;
        }

        public Scope getDefiningScope() {
            return this.definingScope;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class AstCFG
    extends AbstractCFG<SSAInstruction, PreBasicBlock> {
        private final SSAInstruction[] instructions;
        private final int[] instructionToBlockMap;
        private final String functionName;
        private final SymbolTable symtab;

        AstCFG(CAstEntity cAstEntity, IncipientCFG incipientCFG, SymbolTable symbolTable) {
            super(null);
            Object object;
            PreBasicBlock preBasicBlock;
            List list = incipientCFG.blocks;
            this.symtab = symbolTable;
            this.functionName = cAstEntity.getName();
            this.instructionToBlockMap = new int[list.size()];
            int n = 0;
            while (n < list.size()) {
                this.instructionToBlockMap[n] = ((PreBasicBlock)list.get(n)).getLastInstructionIndex();
                ++n;
            }
            n = 0;
            while (n < list.size()) {
                preBasicBlock = (PreBasicBlock)list.get(n);
                this.addNode(preBasicBlock);
                if (preBasicBlock.isCatchBlock()) {
                    this.setCatchBlock(n);
                }
                ++n;
            }
            this.init();
            n = 0;
            while (n < list.size()) {
                preBasicBlock = (PreBasicBlock)list.get(n);
                object = incipientCFG.getSuccNodes(preBasicBlock);
                while (object.hasNext()) {
                    PreBasicBlock preBasicBlock2 = (PreBasicBlock)object.next();
                    if (this.isCatchBlock(preBasicBlock2.getNumber()) || preBasicBlock2.isExitBlock() && incipientCFG.exceptionalToExit.contains(preBasicBlock)) {
                        this.addExceptionalEdge(preBasicBlock, preBasicBlock2);
                    }
                    if (!(preBasicBlock2.isExitBlock() ? incipientCFG.normalToExit.contains(preBasicBlock) : !this.isCatchBlock(preBasicBlock2.getNumber()))) continue;
                    this.addNormalEdge(preBasicBlock, preBasicBlock2);
                }
                ++n;
            }
            n = 0;
            this.instructions = new SSAInstruction[incipientCFG.currentInstruction];
            int n2 = 0;
            while (n2 < list.size()) {
                object = ((PreBasicBlock)list.get(n2)).instructions();
                int n3 = 0;
                while (n3 < object.size()) {
                    this.instructions[n++] = (SSAInstruction)object.get(n3);
                    ++n3;
                }
                ++n2;
            }
        }

        public int hashCode() {
            return this.functionName.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof AstCFG && this.functionName.equals(((AstCFG)((Object)object)).functionName);
        }

        public PreBasicBlock getBlockForInstruction(int n) {
            int n2 = 1;
            while (n2 < this.getNumberOfNodes() - 1) {
                if (n <= this.instructionToBlockMap[n2]) {
                    return (PreBasicBlock)this.getNode(n2);
                }
                ++n2;
            }
            return null;
        }

        public SSAInstruction[] getInstructions() {
            return this.instructions;
        }

        public int getProgramCounter(int n) {
            return n;
        }

        public String toString() {
            SSAInstruction[] sSAInstructionArray = this.getInstructions();
            StringBuffer stringBuffer = new StringBuffer("CAst CFG of " + this.functionName);
            int[] nArray = this.symtab.getParameterValueNumbers();
            int n = 0;
            while (n < nArray.length) {
                stringBuffer.append(" ").append(nArray[n]);
                ++n;
            }
            stringBuffer.append("\n");
            n = 0;
            while (n < this.getNumberOfNodes()) {
                PreBasicBlock preBasicBlock = (PreBasicBlock)this.getNode(n);
                stringBuffer.append(preBasicBlock).append("\n");
                Iterator iterator = this.getSuccNodes(preBasicBlock);
                while (iterator.hasNext()) {
                    stringBuffer.append("    -->" + iterator.next() + "\n");
                }
                int n2 = preBasicBlock.getFirstInstructionIndex();
                while (n2 <= preBasicBlock.getLastInstructionIndex()) {
                    if (sSAInstructionArray[n2] != null) {
                        stringBuffer.append("  " + sSAInstructionArray[n2].toString(this.symtab) + "\n");
                    }
                    ++n2;
                }
                ++n;
            }
            stringBuffer.append("-- END --");
            return stringBuffer.toString();
        }
    }

    private static class AstDebuggingInformation
    implements AstMethod.DebuggingInformation {
        private CAstSourcePositionMap.Position codeBodyPosition;
        private String[][] valueNumberNames;
        private CAstSourcePositionMap.Position[] instructionPositions;

        AstDebuggingInformation(CAstSourcePositionMap.Position position, CAstSourcePositionMap.Position[] positionArray, String[] stringArray) {
            this.codeBodyPosition = position;
            this.instructionPositions = positionArray;
            this.valueNumberNames = new String[stringArray.length][];
            int n = 0;
            while (n < stringArray.length) {
                this.valueNumberNames[n] = stringArray[n] != null ? new String[]{stringArray[n]} : new String[0];
                ++n;
            }
        }

        public CAstSourcePositionMap.Position getCodeBodyPosition() {
            return this.codeBodyPosition;
        }

        public CAstSourcePositionMap.Position getInstructionPosition(int n) {
            return this.instructionPositions[n];
        }

        public String[][] getSourceNamesForValues() {
            return this.valueNumberNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AstLexicalInformation
    implements AstMethod.LexicalInformation {
        private final Pair[] exposedNames;
        private final int[][] instructionLexicalUses;
        private final int[] exitLexicalUses;
        private final String[] scopingParents;
        private MutableIntSet allExposedUses = null;

        public AstLexicalInformation(AstLexicalInformation astLexicalInformation) {
            int n;
            if (astLexicalInformation.exposedNames != null) {
                this.exposedNames = new Pair[astLexicalInformation.exposedNames.length];
                n = 0;
                while (n < this.exposedNames.length) {
                    this.exposedNames[n] = Pair.make((Object)astLexicalInformation.exposedNames[n].fst, (Object)astLexicalInformation.exposedNames[n].snd);
                    ++n;
                }
            } else {
                this.exposedNames = null;
            }
            this.instructionLexicalUses = new int[astLexicalInformation.instructionLexicalUses.length][];
            n = 0;
            while (n < this.instructionLexicalUses.length) {
                int[] nArray = astLexicalInformation.instructionLexicalUses[n];
                if (nArray != null) {
                    this.instructionLexicalUses[n] = new int[nArray.length];
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        this.instructionLexicalUses[n][n2] = nArray[n2];
                        ++n2;
                    }
                }
                ++n;
            }
            if (astLexicalInformation.exitLexicalUses != null) {
                this.exitLexicalUses = new int[astLexicalInformation.exitLexicalUses.length];
                n = 0;
                while (n < this.exitLexicalUses.length) {
                    this.exitLexicalUses[n] = astLexicalInformation.exitLexicalUses[n];
                    ++n;
                }
            } else {
                this.exitLexicalUses = null;
            }
            if (astLexicalInformation.scopingParents != null) {
                this.scopingParents = new String[astLexicalInformation.scopingParents.length];
                n = 0;
                while (n < this.scopingParents.length) {
                    this.scopingParents[n] = astLexicalInformation.scopingParents[n];
                    ++n;
                }
            } else {
                this.scopingParents = null;
            }
        }

        private int[] buildLexicalUseArray(Pair[] pairArray) {
            if (pairArray != null) {
                int[] nArray = new int[pairArray.length];
                int n = 0;
                while (n < pairArray.length) {
                    nArray[n] = (Integer)pairArray[n].snd;
                    ++n;
                }
                return nArray;
            }
            return null;
        }

        private Pair[] buildLexicalNamesArray(Pair[] pairArray) {
            if (pairArray != null) {
                Pair[] pairArray2 = new Pair[pairArray.length];
                int n = 0;
                while (n < pairArray.length) {
                    pairArray2[n] = (Pair)pairArray[n].fst;
                    ++n;
                }
                return pairArray2;
            }
            return null;
        }

        AstLexicalInformation(Scope scope, SSAInstruction[] sSAInstructionArray, Set<Pair<Pair<String, String>, Integer>> set, Set set2) {
            Pair[] pairArray = null;
            if (set != null) {
                pairArray = set.toArray(new Pair[set.size()]);
            }
            this.exposedNames = this.buildLexicalNamesArray(pairArray);
            this.exitLexicalUses = this.buildLexicalUseArray(pairArray);
            this.instructionLexicalUses = new int[sSAInstructionArray.length][];
            int n = 0;
            while (n < sSAInstructionArray.length) {
                if (sSAInstructionArray[n] instanceof SSAAbstractInvokeInstruction) {
                    this.instructionLexicalUses[n] = this.buildLexicalUseArray(pairArray);
                }
                ++n;
            }
            if (set2 != null) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                for (AstLexicalAccess.Access access : set2) {
                    if (access.variableDefiner == null) continue;
                    linkedHashSet.add(access.variableDefiner);
                }
                this.scopingParents = linkedHashSet.toArray(new String[linkedHashSet.size()]);
            } else {
                this.scopingParents = null;
            }
        }

        @Override
        public int[] getExitExposedUses() {
            return this.exitLexicalUses;
        }

        @Override
        public int[] getExposedUses(int n) {
            return this.instructionLexicalUses[n];
        }

        @Override
        public IntSet getAllExposedUses() {
            if (this.allExposedUses == null) {
                int n;
                this.allExposedUses = IntSetUtil.make();
                if (this.exitLexicalUses != null) {
                    n = 0;
                    while (n < this.exitLexicalUses.length) {
                        this.allExposedUses.add(this.exitLexicalUses[n]);
                        ++n;
                    }
                }
                if (this.instructionLexicalUses != null) {
                    n = 0;
                    while (n < this.instructionLexicalUses.length) {
                        if (this.instructionLexicalUses[n] != null) {
                            int n2 = 0;
                            while (n2 < this.instructionLexicalUses[n].length) {
                                if (this.instructionLexicalUses[n][n2] > 0) {
                                    this.allExposedUses.add(this.instructionLexicalUses[n][n2]);
                                }
                                ++n2;
                            }
                        }
                        ++n;
                    }
                }
            }
            return this.allExposedUses;
        }

        @Override
        public Pair[] getExposedNames() {
            return this.exposedNames;
        }

        @Override
        public String[] getScopingParents() {
            return this.scopingParents;
        }

        @Override
        public void handleAlteration() {
            this.allExposedUses = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CodeEntityContext
    extends EntityContext {
        private final Scope topEntityScope;
        private final Set<Scope> allEntityScopes;
        private final IncipientCFG cfg;
        private TypeReference[][] catchTypes;

        CodeEntityContext(WalkContext walkContext, Scope scope, CAstEntity cAstEntity) {
            super(walkContext, cAstEntity);
            this.catchTypes = new TypeReference[0][];
            this.topEntityScope = scope;
            this.allEntityScopes = HashSetFactory.make();
            this.allEntityScopes.add(scope);
            this.cfg = new IncipientCFG();
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            return this.top().getControlFlow();
        }

        @Override
        public IncipientCFG cfg() {
            return this.cfg;
        }

        @Override
        public Scope currentScope() {
            return this.topEntityScope;
        }

        @Override
        public Set<Scope> entityScopes() {
            return this.allEntityScopes;
        }

        @Override
        public UnwindState getUnwindState() {
            return null;
        }

        @Override
        public void setCatchType(CAstNode cAstNode, TypeReference typeReference) {
            this.setCatchType(this.cfg.getBlock(cAstNode).getNumber(), typeReference);
        }

        @Override
        public void setCatchType(int n, TypeReference typeReference) {
            TypeReference[][] typeReferenceArrayArray;
            if (this.catchTypes.length <= n) {
                typeReferenceArrayArray = new TypeReference[n + 1][];
                System.arraycopy(this.catchTypes, 0, typeReferenceArrayArray, 0, this.catchTypes.length);
                this.catchTypes = typeReferenceArrayArray;
            }
            if (this.catchTypes[n] == null) {
                this.catchTypes[n] = new TypeReference[]{typeReference};
            } else {
                typeReferenceArrayArray = this.catchTypes[n];
                int n2 = 0;
                while (n2 < typeReferenceArrayArray.length) {
                    if (typeReferenceArrayArray[n2] == typeReference) {
                        return;
                    }
                    ++n2;
                }
                TypeReference[] typeReferenceArray = new TypeReference[typeReferenceArrayArray.length + 1];
                System.arraycopy(typeReferenceArrayArray, 0, typeReferenceArray, 0, typeReferenceArrayArray.length);
                typeReferenceArray[typeReferenceArrayArray.length] = typeReference;
                this.catchTypes[n] = typeReferenceArray;
            }
        }

        @Override
        public TypeReference[][] getCatchTypes() {
            return this.catchTypes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DefaultContext
    implements WalkContext {
        private final AstTranslator t;
        private final CAstEntity N;
        private final String nm;

        public DefaultContext(AstTranslator astTranslator2, CAstEntity cAstEntity, String string) {
            this.t = astTranslator2;
            this.N = cAstEntity;
            this.nm = string;
        }

        @Override
        public String file() {
            return this.nm;
        }

        @Override
        public CAstEntity top() {
            return this.N;
        }

        @Override
        public Scope currentScope() {
            return this.t.globalScope;
        }

        @Override
        public Set<Scope> entityScopes() {
            return Collections.singleton(this.t.globalScope);
        }

        @Override
        public CAstSourcePositionMap getSourceMap() {
            return this.N.getSourceMap();
        }

        public CAstSourcePositionMap getInlinedSourceMap() {
            return AstTranslator.this.inlinedSourceMap;
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            return this.N.getControlFlow();
        }

        @Override
        public IncipientCFG cfg() {
            return null;
        }

        @Override
        public UnwindState getUnwindState() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void setCatchType(int n, TypeReference typeReference) {
        }

        @Override
        public void setCatchType(CAstNode cAstNode, TypeReference typeReference) {
        }

        @Override
        public TypeReference[][] getCatchTypes() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DelegatingContext
    implements WalkContext {
        private final WalkContext parent;

        DelegatingContext(WalkContext walkContext) {
            this.parent = walkContext;
        }

        @Override
        public String getName() {
            return this.parent.getName();
        }

        @Override
        public String file() {
            return this.parent.file();
        }

        @Override
        public CAstEntity top() {
            return this.parent.top();
        }

        @Override
        public CAstSourcePositionMap getSourceMap() {
            return this.parent.getSourceMap();
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            return this.parent.getControlFlow();
        }

        @Override
        public Scope currentScope() {
            return this.parent.currentScope();
        }

        @Override
        public Set<Scope> entityScopes() {
            return this.parent.entityScopes();
        }

        @Override
        public IncipientCFG cfg() {
            return this.parent.cfg();
        }

        @Override
        public UnwindState getUnwindState() {
            return this.parent.getUnwindState();
        }

        @Override
        public void setCatchType(int n, TypeReference typeReference) {
            this.parent.setCatchType(n, typeReference);
        }

        @Override
        public void setCatchType(CAstNode cAstNode, TypeReference typeReference) {
            this.parent.setCatchType(cAstNode, typeReference);
        }

        @Override
        public TypeReference[][] getCatchTypes() {
            return this.parent.getCatchTypes();
        }
    }

    private abstract class EntityContext
    extends DelegatingContext {
        protected final CAstEntity topNode;
        protected final String name;

        EntityContext(WalkContext walkContext, CAstEntity cAstEntity) {
            super(walkContext);
            this.topNode = cAstEntity;
            this.name = AstTranslator.this.composeEntityName(walkContext, cAstEntity);
            AstTranslator.this.addEntityName(cAstEntity, this.name);
        }

        public String getName() {
            return this.name;
        }

        public CAstEntity top() {
            return this.topNode;
        }

        public CAstSourcePositionMap getSourceMap() {
            return this.top().getSourceMap();
        }
    }

    private class FileContext
    extends DelegatingContext {
        private final String fUnitName;

        public FileContext(WalkContext walkContext, String string) {
            super(walkContext);
            this.fUnitName = string;
        }

        public String getName() {
            return this.fUnitName;
        }
    }

    protected class FinalCAstSymbol
    implements CAstSymbol {
        private final String _name;

        private FinalCAstSymbol(String string) {
            this._name = string;
        }

        public String name() {
            return this._name;
        }

        public boolean isFinal() {
            return true;
        }

        public boolean isCaseInsensitive() {
            return false;
        }

        public boolean isInternalName() {
            return false;
        }

        public Object defaultInitValue() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class IncipientCFG
    extends SparseNumberedGraph<PreBasicBlock> {
        private Unwind unwind = null;
        private final List<PreBasicBlock> blocks = new ArrayList<PreBasicBlock>();
        private final Map<CAstNode, PreBasicBlock> nodeToBlock = new LinkedHashMap<CAstNode, PreBasicBlock>();
        private final Map<Object, Set<Pair<PreBasicBlock, Boolean>>> delayedEdges = new LinkedHashMap<Object, Set<Pair<PreBasicBlock, Boolean>>>();
        private final Object exitMarker = new Object();
        private final Set<PreBasicBlock> deadBlocks = new LinkedHashSet<PreBasicBlock>();
        private final Set<PreBasicBlock> normalToExit = new LinkedHashSet<PreBasicBlock>();
        private final Set<PreBasicBlock> exceptionalToExit = new LinkedHashSet<PreBasicBlock>();
        private CAstSourcePositionMap.Position[] linePositions = new CAstSourcePositionMap.Position[10];
        private boolean hasCatchBlock = false;
        private boolean hasMonitorOp = false;
        private int currentInstruction = 0;
        private CAstSourcePositionMap.Position currentPosition = null;
        private PreBasicBlock currentBlock;

        public int getCurrentInstruction() {
            return this.currentInstruction;
        }

        public PreBasicBlock getCurrentBlock() {
            return this.currentBlock;
        }

        boolean hasCatchBlock() {
            return this.hasCatchBlock;
        }

        boolean hasMonitorOp() {
            return this.hasMonitorOp;
        }

        void noteCatchBlock() {
            this.hasCatchBlock = true;
        }

        void setCurrentPosition(CAstSourcePositionMap.Position position) {
            this.currentPosition = position;
        }

        CAstSourcePositionMap.Position getCurrentPosition() {
            return this.currentPosition;
        }

        CAstSourcePositionMap.Position[] getLinePositionMap() {
            return this.linePositions;
        }

        public PreBasicBlock newBlock(boolean bl) {
            if (bl && !this.currentBlock.isEntryBlock() && this.currentBlock.instructions().size() == 0) {
                return this.currentBlock;
            }
            PreBasicBlock preBasicBlock = this.currentBlock;
            this.currentBlock = new PreBasicBlock();
            this.addNode(this.currentBlock);
            this.blocks.add(this.currentBlock);
            if (bl) {
                this.addEdge(preBasicBlock, this.currentBlock);
            } else {
                this.deadBlocks.add(this.currentBlock);
            }
            return this.currentBlock;
        }

        private void addDelayedEdge(PreBasicBlock preBasicBlock, Object object, boolean bl) {
            Pair pair = Pair.make((Object)preBasicBlock, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
            if (this.delayedEdges.containsKey(object)) {
                this.delayedEdges.get(object).add((Pair<PreBasicBlock, Boolean>)pair);
            } else {
                LinkedHashSet<Pair> linkedHashSet = new LinkedHashSet<Pair>();
                linkedHashSet.add(pair);
                this.delayedEdges.put(object, linkedHashSet);
            }
        }

        void makeEntryBlock(PreBasicBlock preBasicBlock) {
            preBasicBlock.makeEntryBlock();
        }

        void makeExitBlock(PreBasicBlock preBasicBlock) {
            preBasicBlock.makeExitBlock();
            Iterator iterator = this.getPredNodes(preBasicBlock);
            while (iterator.hasNext()) {
                this.normalToExit.add((PreBasicBlock)iterator.next());
            }
            this.checkForRealizedExitEdges(preBasicBlock);
        }

        void setCurrentBlockAsHandler() {
            this.currentBlock.makeHandlerBlock();
        }

        private void checkForRealizedEdges(CAstNode cAstNode) {
            if (this.delayedEdges.containsKey(cAstNode)) {
                for (Pair<PreBasicBlock, Boolean> pair : this.delayedEdges.get(cAstNode)) {
                    PreBasicBlock preBasicBlock = (PreBasicBlock)pair.fst;
                    boolean bl = (Boolean)pair.snd;
                    if (this.unwind == null) {
                        this.addEdge(preBasicBlock, this.nodeToBlock.get(cAstNode));
                        continue;
                    }
                    PreBasicBlock preBasicBlock2 = this.nodeToBlock.get(cAstNode);
                    this.addEdge(preBasicBlock, this.unwind.findOrCreateCode(preBasicBlock, preBasicBlock2, bl));
                }
                this.delayedEdges.remove(cAstNode);
            }
        }

        private void checkForRealizedExitEdges(PreBasicBlock preBasicBlock) {
            if (this.delayedEdges.containsKey(this.exitMarker)) {
                for (Pair<PreBasicBlock, Boolean> pair : this.delayedEdges.get(this.exitMarker)) {
                    PreBasicBlock preBasicBlock2 = (PreBasicBlock)pair.fst;
                    boolean bl = (Boolean)pair.snd;
                    this.addEdge(preBasicBlock2, preBasicBlock);
                    if (bl) {
                        this.exceptionalToExit.add(preBasicBlock2);
                        continue;
                    }
                    this.normalToExit.add(preBasicBlock2);
                }
                this.delayedEdges.remove(this.exitMarker);
            }
        }

        private void setUnwindState(CAstNode cAstNode, UnwindState unwindState) {
            if (this.unwind == null) {
                this.unwind = new Unwind();
            }
            this.unwind.setUnwindState(cAstNode, unwindState);
        }

        public void addPreNode(CAstNode cAstNode) {
            this.addPreNode(cAstNode, null);
        }

        public void addPreNode(CAstNode cAstNode, UnwindState unwindState) {
            this.nodeToBlock.put(cAstNode, this.currentBlock);
            this.deadBlocks.remove(this.currentBlock);
            if (unwindState != null) {
                this.setUnwindState(cAstNode, unwindState);
            }
            this.checkForRealizedEdges(cAstNode);
        }

        public void addPreEdge(CAstNode cAstNode, CAstNode cAstNode2, boolean bl) {
            assert (this.nodeToBlock.containsKey(cAstNode));
            this.addPreEdge(this.nodeToBlock.get(cAstNode), cAstNode2, bl);
        }

        public void addPreEdge(PreBasicBlock preBasicBlock, CAstNode cAstNode, boolean bl) {
            if (cAstNode == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                assert (bl);
                this.addPreEdgeToExit(preBasicBlock, bl);
            } else if (this.nodeToBlock.containsKey(cAstNode)) {
                PreBasicBlock preBasicBlock2 = this.nodeToBlock.get(cAstNode);
                if (this.unwind == null) {
                    this.addEdge(preBasicBlock, preBasicBlock2);
                } else {
                    this.addEdge(preBasicBlock, this.unwind.findOrCreateCode(preBasicBlock, preBasicBlock2, bl));
                }
            } else {
                this.addDelayedEdge(preBasicBlock, cAstNode, bl);
            }
        }

        public void addPreEdgeToExit(CAstNode cAstNode, boolean bl) {
            assert (this.nodeToBlock.containsKey(cAstNode));
            this.addPreEdgeToExit(this.nodeToBlock.get(cAstNode), bl);
        }

        public void addPreEdgeToExit(PreBasicBlock preBasicBlock, boolean bl) {
            PreBasicBlock preBasicBlock2;
            if (this.unwind != null && (preBasicBlock2 = this.unwind.findOrCreateCode(preBasicBlock, null, bl)) != null) {
                this.addEdge(preBasicBlock, preBasicBlock2);
                return;
            }
            this.addDelayedEdge(preBasicBlock, this.exitMarker, bl);
        }

        public void addEdge(PreBasicBlock preBasicBlock, PreBasicBlock preBasicBlock2) {
            super.addEdge((Object)preBasicBlock, (Object)preBasicBlock2);
            this.deadBlocks.remove(preBasicBlock2);
        }

        boolean isDeadBlock(PreBasicBlock preBasicBlock) {
            return this.deadBlocks.contains(preBasicBlock);
        }

        public PreBasicBlock getBlock(CAstNode cAstNode) {
            return this.nodeToBlock.get(cAstNode);
        }

        private void noteLinePosition(int n) {
            if (this.linePositions.length < n + 1) {
                CAstSourcePositionMap.Position[] positionArray = new CAstSourcePositionMap.Position[n * 2 + 1];
                System.arraycopy(this.linePositions, 0, positionArray, 0, this.linePositions.length);
                this.linePositions = positionArray;
            }
            this.linePositions[n] = this.currentPosition;
        }

        public void addInstruction(SSAInstruction sSAInstruction) {
            this.deadBlocks.remove(this.currentBlock);
            int n = this.currentInstruction++;
            this.noteLinePosition(n);
            if (this.currentBlock.instructions().size() == 0) {
                this.currentBlock.setFirstIndex(n);
            } else assert (!(sSAInstruction instanceof SSAGetCaughtExceptionInstruction));
            if (sSAInstruction instanceof SSAMonitorInstruction) {
                this.hasMonitorOp = true;
            }
            this.currentBlock.instructions().add(sSAInstruction);
            this.currentBlock.setLastIndex(n);
        }

        protected class Unwind {
            private final Map<PreBasicBlock, UnwindState> unwindData = new LinkedHashMap<PreBasicBlock, UnwindState>();
            private final Map<Pair<UnwindState, Pair<PreBasicBlock, Boolean>>, PreBasicBlock> code = new LinkedHashMap<Pair<UnwindState, Pair<PreBasicBlock, Boolean>>, PreBasicBlock>();

            protected Unwind() {
            }

            void setUnwindState(PreBasicBlock preBasicBlock, UnwindState unwindState) {
                this.unwindData.put(preBasicBlock, unwindState);
            }

            void setUnwindState(CAstNode cAstNode, UnwindState unwindState) {
                this.unwindData.put((PreBasicBlock)IncipientCFG.this.nodeToBlock.get(cAstNode), unwindState);
            }

            public PreBasicBlock findOrCreateCode(PreBasicBlock preBasicBlock, PreBasicBlock preBasicBlock2, final boolean bl) {
                Object object;
                CAstNode cAstNode;
                UnwindState unwindState = this.unwindData.get(preBasicBlock);
                CAstNode cAstNode2 = cAstNode = bl ? new CAstImpl().makeNode(19) : null;
                if (unwindState == null) {
                    return preBasicBlock2;
                }
                WalkContext walkContext = unwindState.astContext;
                UnwindState unwindState2 = null;
                if (preBasicBlock2 != null) {
                    unwindState2 = this.unwindData.get(preBasicBlock2);
                }
                if (unwindState2 != null && unwindState2.covers(unwindState)) {
                    return preBasicBlock2;
                }
                Pair pair = Pair.make((Object)unwindState, (Object)Pair.make((Object)preBasicBlock2, (Object)(bl ? Boolean.TRUE : Boolean.FALSE)));
                if (this.code.containsKey(pair)) {
                    return this.code.get(pair);
                }
                int n = -1;
                PreBasicBlock preBasicBlock3 = IncipientCFG.this.getCurrentBlock();
                if (!IncipientCFG.this.isDeadBlock(preBasicBlock3)) {
                    IncipientCFG.this.addInstruction((SSAInstruction)((IncipientCFG)IncipientCFG.this).AstTranslator.this.insts.GotoInstruction());
                    IncipientCFG.this.newBlock(false);
                }
                PreBasicBlock preBasicBlock4 = IncipientCFG.this.getCurrentBlock();
                if (bl) {
                    IncipientCFG.this.setCurrentBlockAsHandler();
                    n = unwindState.astContext.currentScope().allocateTempValue();
                    IncipientCFG.this.addInstruction((SSAInstruction)((IncipientCFG)IncipientCFG.this).AstTranslator.this.insts.GetCaughtExceptionInstruction(preBasicBlock4.getNumber(), n));
                    unwindState.astContext.setCatchType(preBasicBlock4.getNumber(), AstTranslator.this.defaultCatchType());
                }
                while (!(unwindState == null || unwindState2 != null && unwindState2.covers(unwindState))) {
                    object = new CAstCloner(new CAstImpl()){

                        @Override
                        protected CAstNode flowOutTo(Map<Pair, CAstNode> map, CAstNode cAstNode3, Object object, CAstNode cAstNode2, CAstControlFlowMap cAstControlFlowMap, CAstSourcePositionMap cAstSourcePositionMap) {
                            if (bl && !AstTranslator.this.isExceptionLabel(object)) {
                                return cAstNode;
                            }
                            return cAstNode2;
                        }
                    }.copy(unwindState.unwindAst, unwindState.astContext.getControlFlow(), unwindState.astContext.getSourceMap(), unwindState.astContext.top().getNodeTypeMap(), unwindState.astContext.top().getAllScopedEntities());
                    unwindState.astVisitor.visit(object.newRoot(), new DelegatingContext(AstTranslator.this, unwindState.astContext, (CAstRewriter.Rewrite)object){
                        private final /* synthetic */ CAstRewriter.Rewrite val$ast;
                        {
                            this.val$ast = rewrite;
                            super(walkContext);
                        }

                        public CAstSourcePositionMap getSourceMap() {
                            return this.val$ast.newPos();
                        }

                        public CAstControlFlowMap getControlFlow() {
                            return this.val$ast.newCfg();
                        }
                    }, unwindState.astVisitor);
                    unwindState = unwindState.getParent();
                }
                object = IncipientCFG.this.getCurrentBlock();
                if (bl) {
                    IncipientCFG.this.addPreNode(cAstNode);
                    AstTranslator.this.doThrow(walkContext, n);
                } else {
                    IncipientCFG.this.addInstruction((SSAInstruction)((IncipientCFG)IncipientCFG.this).AstTranslator.this.insts.GotoInstruction());
                }
                IncipientCFG.this.newBlock(false);
                IncipientCFG.this.addEdge(preBasicBlock3, IncipientCFG.this.getCurrentBlock());
                if (preBasicBlock2 != null) {
                    IncipientCFG.this.addEdge((PreBasicBlock)object, preBasicBlock2);
                } else {
                    IncipientCFG.this.addDelayedEdge((PreBasicBlock)object, IncipientCFG.this.exitMarker, bl);
                }
                this.code.put((Pair<UnwindState, Pair<PreBasicBlock, Boolean>>)pair, preBasicBlock4);
                return preBasicBlock4;
            }
        }
    }

    public static class InternalCAstSymbol
    extends CAstSymbolImplBase {
        public InternalCAstSymbol(String string) {
            super(string, false, false, null);
        }

        public InternalCAstSymbol(String string, boolean bl) {
            super(string, bl, false, null);
        }

        public InternalCAstSymbol(String string, boolean bl, boolean bl2) {
            super(string, bl, bl2, null);
        }

        public InternalCAstSymbol(String string, boolean bl, boolean bl2, Object object) {
            super(string, bl, bl2, object);
        }

        public boolean isInternalName() {
            return true;
        }
    }

    private class LocalContext
    extends DelegatingContext {
        private final Scope localScope;

        LocalContext(WalkContext walkContext, Scope scope) {
            super(walkContext);
            this.localScope = scope;
            walkContext.entityScopes().add(scope);
        }

        public Scope currentScope() {
            return this.localScope;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class PreBasicBlock
    implements INodeWithNumber,
    IBasicBlock<SSAInstruction> {
        private static final int NORMAL = 0;
        private static final int HANDLER = 1;
        private static final int ENTRY = 2;
        private static final int EXIT = 3;
        private int kind = 0;
        private int number = -1;
        private int firstIndex = -1;
        private int lastIndex = -2;
        private final List<SSAInstruction> instructions = new ArrayList<SSAInstruction>();

        protected PreBasicBlock() {
        }

        public int getNumber() {
            return this.getGraphNodeId();
        }

        public int getGraphNodeId() {
            return this.number;
        }

        public void setGraphNodeId(int n) {
            this.number = n;
        }

        public int getFirstInstructionIndex() {
            return this.firstIndex;
        }

        void setFirstIndex(int n) {
            this.firstIndex = n;
        }

        public int getLastInstructionIndex() {
            return this.lastIndex;
        }

        void setLastIndex(int n) {
            this.lastIndex = n;
        }

        void makeExitBlock() {
            this.kind = 3;
        }

        void makeEntryBlock() {
            this.kind = 2;
        }

        void makeHandlerBlock() {
            this.kind = 1;
        }

        public boolean isEntryBlock() {
            return this.kind == 2;
        }

        public boolean isExitBlock() {
            return this.kind == 3;
        }

        public boolean isHandlerBlock() {
            return this.kind == 1;
        }

        public String toString() {
            return "PreBB" + this.number + ":" + this.firstIndex + ".." + this.lastIndex;
        }

        List<SSAInstruction> instructions() {
            return this.instructions;
        }

        public boolean isCatchBlock() {
            return this.lastIndex > -1 && this.instructions.get(0) instanceof SSAGetCaughtExceptionInstruction;
        }

        public IMethod getMethod() {
            return null;
        }

        public Iterator<SSAInstruction> iterator() {
            return this.instructions.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Scope {
        public int type();

        public int allocateTempValue();

        public int getConstantValue(Object var1);

        public boolean isConstant(int var1);

        public Object getConstantObject(int var1);

        public void declare(CAstSymbol var1);

        public void declare(CAstSymbol var1, int var2);

        public boolean isCaseInsensitive(String var1);

        public boolean contains(String var1);

        public Symbol lookup(String var1);

        public Iterator<String> getAllNames();

        public int size();

        public boolean isGlobal(Symbol var1);

        public boolean isLexicallyScoped(Symbol var1);

        public CAstEntity getEntity();

        public Scope getParent();
    }

    protected static interface Symbol {
        public int valueNumber();

        public Scope getDefiningScope();

        public boolean isParameter();

        public Object constant();

        public void setConstant(Object var1);

        public boolean isFinal();

        public boolean isInternalName();

        public Object defaultInitValue();
    }

    private final class TypeContext
    extends EntityContext {
        private TypeContext(WalkContext walkContext, CAstEntity cAstEntity) {
            super(walkContext, cAstEntity);
        }

        public CAstControlFlowMap getControlFlow() {
            Assertions.UNREACHABLE((String)"TypeContext.getControlFlow()");
            return null;
        }

        public IncipientCFG cfg() {
            Assertions.UNREACHABLE((String)"TypeContext.cfg()");
            return null;
        }

        public UnwindState getUnwindState() {
            Assertions.UNREACHABLE((String)"TypeContext.getUnwindState()");
            return null;
        }
    }

    private class UnwindContext
    extends DelegatingContext {
        private final UnwindState state;

        UnwindContext(CAstNode cAstNode, WalkContext walkContext, CAstVisitor cAstVisitor) {
            super(walkContext);
            this.state = new UnwindState(cAstNode, walkContext, cAstVisitor);
        }

        public UnwindState getUnwindState() {
            return this.state;
        }
    }

    protected final class UnwindState {
        final CAstNode unwindAst;
        final WalkContext astContext;
        final CAstVisitor astVisitor;

        UnwindState(CAstNode cAstNode, WalkContext walkContext, CAstVisitor cAstVisitor) {
            this.unwindAst = cAstNode;
            this.astContext = walkContext;
            this.astVisitor = cAstVisitor;
        }

        public UnwindState getParent() {
            return this.astContext.getUnwindState();
        }

        public int hashCode() {
            return this.astContext.hashCode() * this.unwindAst.hashCode() * this.astVisitor.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof UnwindState) {
                if (((UnwindState)object).unwindAst != this.unwindAst) {
                    return false;
                }
                if (((UnwindState)object).astVisitor != this.astVisitor) {
                    return false;
                }
                if (this.getParent() == null) {
                    return ((UnwindState)object).getParent() == null;
                }
                return this.getParent().equals(((UnwindState)object).getParent());
            }
            return false;
        }

        boolean covers(UnwindState unwindState) {
            if (this.equals(unwindState)) {
                return true;
            }
            if (this.getParent() != null) {
                return this.getParent().covers(unwindState);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface WalkContext
    extends CAstVisitor.Context {
        public String getName();

        public String file();

        public CAstSourcePositionMap getSourceMap();

        public CAstControlFlowMap getControlFlow();

        public Scope currentScope();

        public Set<Scope> entityScopes();

        public IncipientCFG cfg();

        public UnwindState getUnwindState();

        public void setCatchType(int var1, TypeReference var2);

        public void setCatchType(CAstNode var1, TypeReference var2);

        public TypeReference[][] getCatchTypes();
    }
}

