/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.ClassConstants;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstClass
implements IClass,
ClassConstants {
    private final CAstSourcePositionMap.Position sourcePosition;
    private final TypeName typeName;
    private final IClassLoader loader;
    private final short modifiers;
    protected final Map<Atom, IField> declaredFields;
    protected final Map<Selector, IMethod> declaredMethods;

    protected AstClass(CAstSourcePositionMap.Position position, TypeName typeName, IClassLoader iClassLoader, short s, Map<Atom, IField> map, Map<Selector, IMethod> map2) {
        this.sourcePosition = position;
        this.typeName = typeName;
        this.loader = iClassLoader;
        this.modifiers = s;
        this.declaredFields = map;
        this.declaredMethods = map2;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isReferenceType() {
        return true;
    }

    public boolean isArrayClass() {
        return false;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public CAstSourcePositionMap.Position getSourcePosition() {
        return this.sourcePosition;
    }

    public URL getSourceURL() {
        return this.sourcePosition.getURL();
    }

    public String getSourceFileName() {
        return this.sourcePosition.getURL().getFile();
    }

    public InputStream getSource() {
        return null;
    }

    public TypeName getName() {
        return this.typeName;
    }

    public TypeReference getReference() {
        return TypeReference.findOrCreate((ClassLoaderReference)this.loader.getReference(), (TypeName)this.typeName);
    }

    public IClassLoader getClassLoader() {
        return this.loader;
    }

    public abstract IClass getSuperclass();

    private Collection<IClass> gatherInterfaces() {
        HashSet hashSet = HashSetFactory.make();
        hashSet.addAll(this.getDirectInterfaces());
        if (this.getSuperclass() != null) {
            hashSet.addAll(this.getSuperclass().getAllImplementedInterfaces());
        }
        return hashSet;
    }

    public abstract Collection<IClass> getDirectInterfaces();

    public Collection<IClass> getAllImplementedInterfaces() {
        return this.gatherInterfaces();
    }

    public IMethod getClassInitializer() {
        return this.getMethod(MethodReference.clinitSelector);
    }

    public IMethod getMethod(Selector selector) {
        if (this.declaredMethods.containsKey(selector)) {
            return this.declaredMethods.get(selector);
        }
        if (this.getSuperclass() != null) {
            return this.getSuperclass().getMethod(selector);
        }
        return null;
    }

    public IField getField(Atom atom) {
        if (this.declaredFields.containsKey(atom)) {
            return this.declaredFields.get(atom);
        }
        if (this.getSuperclass() != null) {
            return this.getSuperclass().getField(atom);
        }
        return null;
    }

    public Collection<IMethod> getDeclaredMethods() {
        return this.declaredMethods.values();
    }

    public Collection<IField> getDeclaredInstanceFields() {
        HashSet hashSet = HashSetFactory.make();
        for (IField iField : this.declaredFields.values()) {
            if (iField.isStatic()) continue;
            hashSet.add(iField);
        }
        return hashSet;
    }

    public Collection<IField> getDeclaredStaticFields() {
        HashSet hashSet = HashSetFactory.make();
        for (IField iField : this.declaredFields.values()) {
            if (!iField.isStatic()) continue;
            hashSet.add(iField);
        }
        return hashSet;
    }

    public Collection<IField> getAllInstanceFields() {
        HashSet hashSet = HashSetFactory.make();
        hashSet.addAll(this.getDeclaredInstanceFields());
        if (this.getSuperclass() != null) {
            hashSet.addAll(this.getSuperclass().getAllInstanceFields());
        }
        return hashSet;
    }

    public Collection<IField> getAllStaticFields() {
        HashSet hashSet = HashSetFactory.make();
        hashSet.addAll(this.getDeclaredStaticFields());
        if (this.getSuperclass() != null) {
            hashSet.addAll(this.getSuperclass().getAllStaticFields());
        }
        return hashSet;
    }

    public Collection<IField> getAllFields() {
        HashSet hashSet = HashSetFactory.make();
        hashSet.addAll(this.getAllInstanceFields());
        hashSet.addAll(this.getAllStaticFields());
        return hashSet;
    }

    public Collection<IMethod> getAllMethods() {
        HashSet hashSet = HashSetFactory.make();
        Iterator<IMethod> iterator = this.getDeclaredMethods().iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        if (this.getSuperclass() != null) {
            hashSet.addAll(this.getSuperclass().getAllMethods());
        }
        return hashSet;
    }
}

