/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.loader.AstClass;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.warnings.Warning;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CAstAbstractLoader
implements IClassLoader {
    protected final Map<TypeName, IClass> types = HashMapFactory.make();
    protected final IClassHierarchy cha;
    protected final IClassLoader parent;
    private final Map<ModuleEntry, Set<Warning>> errors = new HashMap<ModuleEntry, Set<Warning>>();

    public CAstAbstractLoader(IClassHierarchy iClassHierarchy, IClassLoader iClassLoader) {
        this.cha = iClassHierarchy;
        this.parent = iClassLoader;
    }

    public CAstAbstractLoader(IClassHierarchy iClassHierarchy) {
        this(iClassHierarchy, null);
    }

    protected void addMessage(ModuleEntry moduleEntry, Warning warning) {
        if (!this.errors.containsKey(moduleEntry)) {
            this.errors.put(moduleEntry, new HashSet());
        }
        this.errors.get(moduleEntry).add(warning);
    }

    private Iterator<ModuleEntry> getMessages(final byte by) {
        return new MapIterator((Iterator)new FilterIterator(this.errors.entrySet().iterator(), (Filter)new Filter<Map.Entry<ModuleEntry, Set<Warning>>>(){

            public boolean accepts(Map.Entry<ModuleEntry, Set<Warning>> entry) {
                for (Warning warning : entry.getValue()) {
                    if (warning.getLevel() != by) continue;
                    return true;
                }
                return false;
            }
        }), (Function)new Function<Map.Entry<ModuleEntry, Set<Warning>>, ModuleEntry>(){

            public ModuleEntry apply(Map.Entry<ModuleEntry, Set<Warning>> entry) {
                return entry.getKey();
            }
        });
    }

    public Iterator<ModuleEntry> getModulesWithParseErrors() {
        return this.getMessages((byte)2);
    }

    public Iterator<ModuleEntry> getModulesWithWarnings() {
        return this.getMessages((byte)0);
    }

    public Set<Warning> getMessages(ModuleEntry moduleEntry) {
        return this.errors.get(moduleEntry);
    }

    public IClass lookupClass(String string, IClassHierarchy iClassHierarchy) {
        assert (this.cha == iClassHierarchy);
        return this.types.get(TypeName.string2TypeName((String)string));
    }

    public IClass lookupClass(TypeName typeName) {
        return this.types.get(typeName);
    }

    public Iterator<IClass> iterateAllClasses() {
        return this.types.values().iterator();
    }

    public int getNumberOfClasses() {
        return this.types.size();
    }

    public Atom getName() {
        return this.getReference().getName();
    }

    public int getNumberOfMethods() {
        int n = 0;
        Iterator<IClass> iterator = this.types.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = iterator.next().getDeclaredMethods().iterator();
            while (iterator2.hasNext()) {
                ++n;
                iterator2.next();
            }
        }
        return n;
    }

    public String getSourceFileName(IMethod iMethod, int n) {
        if (!(iMethod instanceof AstMethod)) {
            return null;
        }
        CAstSourcePositionMap.Position position = ((AstMethod)iMethod).getSourcePosition(n);
        if (position == null) {
            return null;
        }
        return position.getURL().getFile();
    }

    public String getSourceFileName(IClass iClass) {
        return ((AstClass)iClass).getSourcePosition().getURL().getFile();
    }

    public InputStream getSource(IClass iClass) {
        try {
            return ((AstClass)iClass).getSourcePosition().getInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public InputStream getSource(IMethod iMethod, int n) {
        try {
            return ((AstMethod)iMethod).getSourcePosition(n).getInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IClassLoader getParent() {
        assert (this.parent != null);
        return this.parent;
    }

    public void removeAll(Collection<IClass> collection) {
        HashSet hashSet = HashSetFactory.make();
        for (Map.Entry<TypeName, IClass> entry : this.types.entrySet()) {
            if (!collection.contains(entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        Iterator<Map.Entry<Object, Object>> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.types.remove(iterator.next());
        }
    }
}

