/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.impl;

import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CAstControlFlowRecorder
implements CAstControlFlowMap {
    private final CAstSourcePositionMap src;
    private final Map<CAstNode, Object> CAstToNode = new LinkedHashMap<CAstNode, Object>();
    private final Map<Object, CAstNode> nodeToCAst = new LinkedHashMap<Object, CAstNode>();
    private final Map<Key, Object> table = new LinkedHashMap<Key, Object>();
    private final Map<Object, Set<Object>> labelMap = new LinkedHashMap<Object, Set<Object>>();
    private final Map<Object, Set<Object>> sourceMap = new LinkedHashMap<Object, Set<Object>>();

    public CAstControlFlowRecorder(CAstSourcePositionMap cAstSourcePositionMap) {
        this.src = cAstSourcePositionMap;
        this.map(EXCEPTION_TO_EXIT, EXCEPTION_TO_EXIT);
    }

    @Override
    public CAstNode getTarget(CAstNode cAstNode, Object object) {
        assert (this.CAstToNode.get(cAstNode) != null);
        Key key = new Key(object, this.CAstToNode.get(cAstNode));
        if (this.table.containsKey(key)) {
            Object object2 = this.table.get(key);
            assert (this.nodeToCAst.containsKey(object2));
            return this.nodeToCAst.get(object2);
        }
        return null;
    }

    @Override
    public Collection<Object> getTargetLabels(CAstNode cAstNode) {
        if (this.labelMap.containsKey(this.CAstToNode.get(cAstNode))) {
            return this.labelMap.get(this.CAstToNode.get(cAstNode));
        }
        return Collections.emptySet();
    }

    @Override
    public Collection getSourceNodes(CAstNode cAstNode) {
        if (this.sourceMap.containsKey(this.CAstToNode.get(cAstNode))) {
            return this.sourceMap.get(this.CAstToNode.get(cAstNode));
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public Collection<CAstNode> getMappedNodes() {
        LinkedHashSet<CAstNode> linkedHashSet = new LinkedHashSet<CAstNode>();
        for (Key key : this.table.keySet()) {
            linkedHashSet.add(this.nodeToCAst.get(key.from));
            linkedHashSet.add(this.nodeToCAst.get(this.table.get(key)));
        }
        return linkedHashSet;
    }

    public void add(Object object, Object object2, Object object3) {
        assert (object != null);
        assert (object2 != null);
        this.table.put(new Key(object3, object), object2);
        Set<Object> set = this.labelMap.get(object);
        if (set == null) {
            set = new LinkedHashSet<Object>(2);
            this.labelMap.put(object, set);
        }
        set.add(object3);
        Set<Object> set2 = this.sourceMap.get(object2);
        if (set2 == null) {
            set2 = new LinkedHashSet<Object>(2);
            this.sourceMap.put(object2, set2);
        }
        set2.add(object);
    }

    public void map(Object object, CAstNode cAstNode) {
        assert (object != null);
        assert (cAstNode != null);
        assert (!this.nodeToCAst.containsKey(object)) : object + " already mapped:\n" + this;
        assert (!this.CAstToNode.containsKey(cAstNode)) : cAstNode + " already mapped:\n" + this;
        this.nodeToCAst.put(object, cAstNode);
        this.CAstToNode.put(cAstNode, object);
    }

    public void addAll(CAstControlFlowMap cAstControlFlowMap) {
        for (CAstNode cAstNode : cAstControlFlowMap.getMappedNodes()) {
            for (Object object : cAstControlFlowMap.getTargetLabels(cAstNode)) {
                this.add(cAstNode, object, cAstControlFlowMap.getTarget(cAstNode, object));
            }
        }
    }

    public boolean isMapped(Object object) {
        return this.nodeToCAst.containsKey(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("control flow map\n");
        for (Key key : this.table.keySet()) {
            stringBuffer.append(key.from);
            if (this.src != null && this.nodeToCAst.get(key.from) != null && this.src.getPosition(this.nodeToCAst.get(key.from)) != null) {
                stringBuffer.append(" (").append(this.src.getPosition(this.nodeToCAst.get(key.from))).append(") ");
            }
            stringBuffer.append(" -- ");
            stringBuffer.append(key.label);
            stringBuffer.append(" --> ");
            stringBuffer.append(this.table.get(key));
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private static class Key {
        private final Object label;
        private final Object from;

        Key(Object object, Object object2) {
            assert (object2 != null);
            this.from = object2;
            this.label = object;
        }

        public int hashCode() {
            if (this.label != null) {
                return this.from.hashCode() * this.label.hashCode();
            }
            return this.from.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof Key && this.from == ((Key)object).from && (this.label == null ? ((Key)object).label == null : this.label.equals(((Key)object).label));
        }

        public String toString() {
            return "<key " + this.label + " : " + this.from + ">";
        }
    }
}

