/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.impl;

import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import com.ibm.wala.cast.tree.impl.LineNumberPosition;
import com.ibm.wala.util.collections.HashMapFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CAstSourcePositionRecorder
implements CAstSourcePositionMap {
    private final HashMap<CAstNode, CAstSourcePositionMap.Position> positions = HashMapFactory.make();

    @Override
    public CAstSourcePositionMap.Position getPosition(CAstNode cAstNode) {
        return this.positions.get(cAstNode);
    }

    @Override
    public Iterator<CAstNode> getMappedNodes() {
        return this.positions.keySet().iterator();
    }

    public void setPosition(CAstNode cAstNode, CAstSourcePositionMap.Position position) {
        this.positions.put(cAstNode, position);
    }

    public void setPosition(CAstNode cAstNode, int n, int n2, int n3, int n4, String string, String string2) throws MalformedURLException {
        this.setPosition(cAstNode, n, n2, n3, n4, new URL(string), new URL(string2));
    }

    public void setPosition(CAstNode cAstNode, final int n, final int n2, final int n3, final int n4, final URL uRL, final URL uRL2) {
        this.setPosition(cAstNode, new AbstractSourcePosition(){

            public int getFirstLine() {
                return n;
            }

            public int getLastLine() {
                return n3;
            }

            public int getFirstCol() {
                return n2;
            }

            public int getLastCol() {
                return n4;
            }

            public int getFirstOffset() {
                return -1;
            }

            public int getLastOffset() {
                return -1;
            }

            public URL getURL() {
                return uRL;
            }

            public InputStream getInputStream() throws IOException {
                return uRL2.openConnection().getInputStream();
            }

            public String toString() {
                return "[" + n + ":" + n2 + "]->[" + n3 + ":" + n4 + "]";
            }
        });
    }

    public void setPosition(CAstNode cAstNode, int n, String string, String string2) throws MalformedURLException {
        this.setPosition(cAstNode, n, new URL(string), new URL(string2));
    }

    public void setPosition(CAstNode cAstNode, int n, URL uRL, URL uRL2) {
        this.setPosition(cAstNode, new LineNumberPosition(uRL, uRL2, n));
    }

    public void addAll(CAstSourcePositionMap cAstSourcePositionMap) {
        Iterator<CAstNode> iterator = cAstSourcePositionMap.getMappedNodes();
        while (iterator.hasNext()) {
            CAstNode cAstNode = iterator.next();
            this.setPosition(cAstNode, cAstSourcePositionMap.getPosition(cAstNode));
        }
    }
}

