/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.visit;

import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.util.CAstPrinter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class CAstVisitor {
    private final Map<CAstEntity, CAstEntity> entityParents = HashMapFactory.make();

    protected Context makeFileContext(Context context, CAstEntity cAstEntity) {
        return context;
    }

    protected Context makeTypeContext(Context context, CAstEntity cAstEntity) {
        return context;
    }

    protected Context makeCodeContext(Context context, CAstEntity cAstEntity) {
        return context;
    }

    protected Context makeLocalContext(Context context, CAstNode cAstNode) {
        return context;
    }

    protected Context makeUnwindContext(Context context, CAstNode cAstNode, CAstVisitor cAstVisitor) {
        return context;
    }

    protected CAstEntity getParent(CAstEntity cAstEntity) {
        return this.entityParents.get(cAstEntity);
    }

    protected void setParent(CAstEntity cAstEntity, CAstEntity cAstEntity2) {
        this.entityParents.put(cAstEntity, cAstEntity2);
    }

    protected boolean doVisitEntity(CAstEntity cAstEntity, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    public final void visitScopedEntities(CAstEntity cAstEntity, Map map, Context context, CAstVisitor cAstVisitor) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            this.visitScopedEntities(cAstEntity, ((Collection)iterator.next()).iterator(), context, cAstVisitor);
        }
    }

    public final void visitScopedEntities(CAstEntity cAstEntity, Iterator iterator, Context context, CAstVisitor cAstVisitor) {
        while (iterator.hasNext()) {
            CAstEntity cAstEntity2 = (CAstEntity)iterator.next();
            this.setParent(cAstEntity2, cAstEntity);
            cAstVisitor.visitEntities(cAstEntity2, context, cAstVisitor);
        }
    }

    public final void visitEntities(CAstEntity cAstEntity, Context context, CAstVisitor cAstVisitor) {
        if (cAstVisitor.enterEntity(cAstEntity, context, cAstVisitor)) {
            return;
        }
        switch (cAstEntity.getKind()) {
            case 5: {
                Context context2 = cAstVisitor.makeFileContext(context, cAstEntity);
                if (cAstVisitor.visitFileEntity(cAstEntity, context, context2, cAstVisitor)) break;
                cAstVisitor.visitScopedEntities(cAstEntity, cAstEntity.getAllScopedEntities(), context2, cAstVisitor);
                cAstVisitor.leaveFileEntity(cAstEntity, context, context2, cAstVisitor);
                break;
            }
            case 4: {
                if (cAstVisitor.visitFieldEntity(cAstEntity, context, cAstVisitor)) break;
                cAstVisitor.leaveFieldEntity(cAstEntity, context, cAstVisitor);
                break;
            }
            case 8: {
                if (cAstVisitor.visitGlobalEntity(cAstEntity, context, cAstVisitor)) break;
                cAstVisitor.leaveGlobalEntity(cAstEntity, context, cAstVisitor);
                break;
            }
            case 3: {
                Context context3 = cAstVisitor.makeTypeContext(context, cAstEntity);
                if (cAstVisitor.visitTypeEntity(cAstEntity, context, context3, cAstVisitor)) break;
                cAstVisitor.visitScopedEntities(cAstEntity, cAstEntity.getAllScopedEntities(), context3, cAstVisitor);
                cAstVisitor.leaveTypeEntity(cAstEntity, context, context3, cAstVisitor);
                break;
            }
            case 1: {
                Context context4 = cAstVisitor.makeCodeContext(context, cAstEntity);
                if (cAstVisitor.visitFunctionEntity(cAstEntity, context, context4, cAstVisitor)) break;
                if (cAstEntity.getAST() != null) {
                    cAstVisitor.visit(cAstEntity.getAST(), context4, cAstVisitor);
                }
                cAstVisitor.visitScopedEntities(cAstEntity, cAstEntity.getScopedEntities(null), context4, cAstVisitor);
                cAstVisitor.leaveFunctionEntity(cAstEntity, context, context4, cAstVisitor);
                break;
            }
            case 7: {
                Context context5 = cAstVisitor.makeCodeContext(context, cAstEntity);
                if (cAstVisitor.visitMacroEntity(cAstEntity, context, context5, cAstVisitor)) break;
                if (cAstEntity.getAST() != null) {
                    cAstVisitor.visit(cAstEntity.getAST(), context5, cAstVisitor);
                }
                cAstVisitor.visitScopedEntities(cAstEntity, cAstEntity.getScopedEntities(null), context5, cAstVisitor);
                cAstVisitor.leaveMacroEntity(cAstEntity, context, context5, cAstVisitor);
                break;
            }
            case 2: {
                Context context6 = cAstVisitor.makeCodeContext(context, cAstEntity);
                if (cAstVisitor.visitScriptEntity(cAstEntity, context, context6, cAstVisitor)) break;
                if (cAstEntity.getAST() != null) {
                    cAstVisitor.visit(cAstEntity.getAST(), context6, cAstVisitor);
                }
                cAstVisitor.visitScopedEntities(cAstEntity, cAstEntity.getScopedEntities(null), context6, cAstVisitor);
                cAstVisitor.leaveScriptEntity(cAstEntity, context, context6, cAstVisitor);
                break;
            }
            default: {
                if (cAstVisitor.doVisitEntity(cAstEntity, context, cAstVisitor)) break;
                System.err.println("No handler for entity " + cAstEntity.getName());
                Assertions.UNREACHABLE((String)("cannot handle entity of kind" + cAstEntity.getKind()));
            }
        }
        cAstVisitor.postProcessEntity(cAstEntity, context, cAstVisitor);
    }

    protected boolean enterEntity(CAstEntity cAstEntity, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void postProcessEntity(CAstEntity cAstEntity, Context context, CAstVisitor cAstVisitor) {
    }

    public boolean visitEntity(CAstEntity cAstEntity, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    public void leaveEntity(CAstEntity cAstEntity, Context context, CAstVisitor cAstVisitor) {
    }

    protected boolean visitFileEntity(CAstEntity cAstEntity, Context context, Context context2, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitEntity(cAstEntity, context, cAstVisitor);
    }

    protected void leaveFileEntity(CAstEntity cAstEntity, Context context, Context context2, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveEntity(cAstEntity, context, cAstVisitor);
    }

    protected boolean visitFieldEntity(CAstEntity cAstEntity, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitEntity(cAstEntity, context, cAstVisitor);
    }

    protected void leaveFieldEntity(CAstEntity cAstEntity, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveEntity(cAstEntity, context, cAstVisitor);
    }

    protected boolean visitGlobalEntity(CAstEntity cAstEntity, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitEntity(cAstEntity, context, cAstVisitor);
    }

    protected void leaveGlobalEntity(CAstEntity cAstEntity, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveEntity(cAstEntity, context, cAstVisitor);
    }

    protected boolean visitTypeEntity(CAstEntity cAstEntity, Context context, Context context2, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitEntity(cAstEntity, context, cAstVisitor);
    }

    protected void leaveTypeEntity(CAstEntity cAstEntity, Context context, Context context2, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveEntity(cAstEntity, context, cAstVisitor);
    }

    protected boolean visitFunctionEntity(CAstEntity cAstEntity, Context context, Context context2, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitEntity(cAstEntity, context, cAstVisitor);
    }

    protected void leaveFunctionEntity(CAstEntity cAstEntity, Context context, Context context2, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveEntity(cAstEntity, context, cAstVisitor);
    }

    protected boolean visitMacroEntity(CAstEntity cAstEntity, Context context, Context context2, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitEntity(cAstEntity, context, cAstVisitor);
    }

    protected void leaveMacroEntity(CAstEntity cAstEntity, Context context, Context context2, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveEntity(cAstEntity, context, cAstVisitor);
    }

    protected boolean visitScriptEntity(CAstEntity cAstEntity, Context context, Context context2, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitEntity(cAstEntity, context, cAstVisitor);
    }

    protected void leaveScriptEntity(CAstEntity cAstEntity, Context context, Context context2, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveEntity(cAstEntity, context, cAstVisitor);
    }

    protected boolean doVisit(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected boolean doVisitAssignNodes(CAstNode cAstNode, Context context, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor cAstVisitor) {
        return false;
    }

    public final void visitChildren(CAstNode cAstNode, int n, Context context, CAstVisitor cAstVisitor) {
        int n2 = cAstNode.getChildCount();
        int n3 = n;
        while (n3 < n2) {
            cAstVisitor.visit(cAstNode.getChild(n3), context, cAstVisitor);
            ++n3;
        }
    }

    public final void visitAllChildren(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.visitChildren(cAstNode, 0, context, cAstVisitor);
    }

    public final void visit(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        if (cAstVisitor.enterNode(cAstNode, context, cAstVisitor)) {
            return;
        }
        int n = cAstNode.getKind();
        switch (n) {
            case 100: {
                if (cAstVisitor.visitFunctionExpr(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveFunctionExpr(cAstNode, context, cAstVisitor);
                break;
            }
            case 13: {
                if (cAstVisitor.visitFunctionStmt(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveFunctionStmt(cAstNode, context, cAstVisitor);
                break;
            }
            case 200: {
                if (cAstVisitor.visitLocalScope(cAstNode, context, cAstVisitor)) break;
                Context context2 = cAstVisitor.makeLocalContext(context, cAstNode);
                cAstVisitor.visit(cAstNode.getChild(0), context2, cAstVisitor);
                cAstVisitor.leaveLocalScope(cAstNode, context, cAstVisitor);
                break;
            }
            case 104: {
                if (cAstVisitor.visitBlockExpr(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visitAllChildren(cAstNode, context, cAstVisitor);
                cAstVisitor.leaveBlockExpr(cAstNode, context, cAstVisitor);
                break;
            }
            case 3: {
                if (cAstVisitor.visitBlockStmt(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visitAllChildren(cAstNode, context, cAstVisitor);
                cAstVisitor.leaveBlockStmt(cAstNode, context, cAstVisitor);
                break;
            }
            case 2: {
                if (cAstVisitor.visitLoop(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveLoopHeader(cAstNode, context, cAstVisitor);
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                cAstVisitor.leaveLoop(cAstNode, context, cAstVisitor);
                break;
            }
            case 103: {
                if (cAstVisitor.visitGetCaughtException(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveGetCaughtException(cAstNode, context, cAstVisitor);
                break;
            }
            case 116: {
                if (cAstVisitor.visitThis(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveThis(cAstNode, context, cAstVisitor);
                break;
            }
            case 115: {
                if (cAstVisitor.visitSuper(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveSuper(cAstNode, context, cAstVisitor);
                break;
            }
            case 102: {
                if (cAstVisitor.visitCall(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.visitChildren(cAstNode, 2, context, cAstVisitor);
                cAstVisitor.leaveCall(cAstNode, context, cAstVisitor);
                break;
            }
            case 111: {
                if (cAstVisitor.visitVar(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveVar(cAstNode, context, cAstVisitor);
                break;
            }
            case 300: {
                if (cAstVisitor.visitConstant(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveConstant(cAstNode, context, cAstVisitor);
                break;
            }
            case 105: {
                if (cAstVisitor.visitBinaryExpr(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                cAstVisitor.visit(cAstNode.getChild(2), context, cAstVisitor);
                cAstVisitor.leaveBinaryExpr(cAstNode, context, cAstVisitor);
                break;
            }
            case 106: {
                if (cAstVisitor.visitUnaryExpr(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                cAstVisitor.leaveUnaryExpr(cAstNode, context, cAstVisitor);
                break;
            }
            case 121: {
                if (cAstVisitor.visitArrayLength(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveArrayLength(cAstNode, context, cAstVisitor);
                break;
            }
            case 120: {
                if (cAstVisitor.visitArrayRef(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.visitChildren(cAstNode, 2, context, cAstVisitor);
                cAstVisitor.leaveArrayRef(cAstNode, context, cAstVisitor);
                break;
            }
            case 6: {
                if (cAstVisitor.visitDeclStmt(cAstNode, context, cAstVisitor)) break;
                if (cAstNode.getChildCount() == 2) {
                    cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                }
                cAstVisitor.leaveDeclStmt(cAstNode, context, cAstVisitor);
                break;
            }
            case 7: {
                if (cAstVisitor.visitReturn(cAstNode, context, cAstVisitor)) break;
                if (cAstNode.getChildCount() > 0) {
                    cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                }
                cAstVisitor.leaveReturn(cAstNode, context, cAstVisitor);
                break;
            }
            case 18: {
                if (cAstVisitor.visitIfgoto(cAstNode, context, cAstVisitor)) break;
                if (cAstNode.getChildCount() == 1) {
                    cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                } else if (cAstNode.getChildCount() == 3) {
                    cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                    cAstVisitor.visit(cAstNode.getChild(2), context, cAstVisitor);
                } else {
                    Assertions.UNREACHABLE();
                }
                cAstVisitor.leaveIfgoto(cAstNode, context, cAstVisitor);
                break;
            }
            case 8: {
                if (cAstVisitor.visitGoto(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveGoto(cAstNode, context, cAstVisitor);
                break;
            }
            case 17: {
                if (cAstVisitor.visitLabelStmt(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                if (cAstNode.getChildCount() == 2) {
                    cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                } else assert (cAstNode.getChildCount() < 2);
                cAstVisitor.leaveLabelStmt(cAstNode, context, cAstVisitor);
                break;
            }
            case 11: {
                if (cAstVisitor.visitIfStmt(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveIfStmtCondition(cAstNode, context, cAstVisitor);
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                cAstVisitor.leaveIfStmtTrueClause(cAstNode, context, cAstVisitor);
                if (cAstNode.getChildCount() == 3) {
                    cAstVisitor.visit(cAstNode.getChild(2), context, cAstVisitor);
                }
                cAstVisitor.leaveIfStmt(cAstNode, context, cAstVisitor);
                break;
            }
            case 107: {
                if (cAstVisitor.visitIfExpr(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveIfExprCondition(cAstNode, context, cAstVisitor);
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                cAstVisitor.leaveIfExprTrueClause(cAstNode, context, cAstVisitor);
                if (cAstNode.getChildCount() == 3) {
                    cAstVisitor.visit(cAstNode.getChild(2), context, cAstVisitor);
                }
                cAstVisitor.leaveIfExpr(cAstNode, context, cAstVisitor);
                break;
            }
            case 109: 
            case 130: {
                if (cAstVisitor.visitNew(cAstNode, context, cAstVisitor)) break;
                int n2 = 1;
                while (n2 < cAstNode.getChildCount()) {
                    cAstVisitor.visit(cAstNode.getChild(n2), context, cAstVisitor);
                    ++n2;
                }
                cAstVisitor.leaveNew(cAstNode, context, cAstVisitor);
                break;
            }
            case 110: {
                if (cAstVisitor.visitObjectLiteral(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                int n3 = 1;
                while (n3 < cAstNode.getChildCount()) {
                    cAstVisitor.visit(cAstNode.getChild(n3), context, cAstVisitor);
                    cAstVisitor.visit(cAstNode.getChild(n3 + 1), context, cAstVisitor);
                    cAstVisitor.leaveObjectLiteralFieldInit(cAstNode, n3, context, cAstVisitor);
                    n3 += 2;
                }
                cAstVisitor.leaveObjectLiteral(cAstNode, context, cAstVisitor);
                break;
            }
            case 117: {
                if (cAstVisitor.visitArrayLiteral(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveArrayLiteralObject(cAstNode, context, cAstVisitor);
                int n4 = 1;
                while (n4 < cAstNode.getChildCount()) {
                    cAstVisitor.visit(cAstNode.getChild(n4), context, cAstVisitor);
                    cAstVisitor.leaveArrayLiteralInitElement(cAstNode, n4, context, cAstVisitor);
                    ++n4;
                }
                cAstVisitor.leaveArrayLiteral(cAstNode, context, cAstVisitor);
                break;
            }
            case 112: {
                if (cAstVisitor.visitObjectRef(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveObjectRef(cAstNode, context, cAstVisitor);
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                if (cAstVisitor.visitAssign(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                if (cAstVisitor.visitAssignNodes(cAstNode.getChild(0), context, cAstNode.getChild(1), cAstNode, cAstVisitor)) break;
                cAstVisitor.leaveAssign(cAstNode, context, cAstVisitor);
                break;
            }
            case 1: {
                if (cAstVisitor.visitSwitch(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveSwitchValue(cAstNode, context, cAstVisitor);
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                cAstVisitor.leaveSwitch(cAstNode, context, cAstVisitor);
                break;
            }
            case 12: {
                if (cAstVisitor.visitThrow(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveThrow(cAstNode, context, cAstVisitor);
                break;
            }
            case 21: {
                if (cAstVisitor.visitCatch(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visitChildren(cAstNode, 1, context, cAstVisitor);
                cAstVisitor.leaveCatch(cAstNode, context, cAstVisitor);
                break;
            }
            case 22: {
                if (cAstVisitor.visitUnwind(cAstNode, context, cAstVisitor)) break;
                Context context3 = cAstVisitor.makeUnwindContext(context, cAstNode.getChild(1), cAstVisitor);
                cAstVisitor.visit(cAstNode.getChild(0), context3, cAstVisitor);
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                cAstVisitor.leaveUnwind(cAstNode, context, cAstVisitor);
                break;
            }
            case 4: {
                if (cAstVisitor.visitTry(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveTryBlock(cAstNode, context, cAstVisitor);
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                cAstVisitor.leaveTry(cAstNode, context, cAstVisitor);
                break;
            }
            case 19: {
                if (cAstVisitor.visitEmpty(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveEmpty(cAstNode, context, cAstVisitor);
                break;
            }
            case 400: {
                if (cAstVisitor.visitPrimitive(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leavePrimitive(cAstNode, context, cAstVisitor);
                break;
            }
            case 402: {
                if (cAstVisitor.visitVoid(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveVoid(cAstNode, context, cAstVisitor);
                break;
            }
            case 118: {
                if (cAstVisitor.visitCast(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                cAstVisitor.leaveCast(cAstNode, context, cAstVisitor);
                break;
            }
            case 119: {
                if (cAstVisitor.visitInstanceOf(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                cAstVisitor.leaveInstanceOf(cAstNode, context, cAstVisitor);
                break;
            }
            case 403: {
                if (cAstVisitor.visitAssert(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveAssert(cAstNode, context, cAstVisitor);
                break;
            }
            case 124: {
                if (cAstVisitor.visitEachElementGet(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveEachElementGet(cAstNode, context, cAstVisitor);
                break;
            }
            case 123: {
                if (cAstVisitor.visitEachElementHasNext(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveEachElementHasNext(cAstNode, context, cAstVisitor);
                break;
            }
            case 127: {
                if (cAstVisitor.visitTypeLiteralExpr(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                cAstVisitor.leaveTypeLiteralExpr(cAstNode, context, cAstVisitor);
                break;
            }
            case 128: {
                if (cAstVisitor.visitIsDefinedExpr(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                if (cAstNode.getChildCount() == 2) {
                    cAstVisitor.visit(cAstNode.getChild(1), context, cAstVisitor);
                }
                cAstVisitor.leaveIsDefinedExpr(cAstNode, context, cAstVisitor);
                break;
            }
            case 404: {
                if (cAstVisitor.visitInclude(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveInclude(cAstNode, context, cAstVisitor);
                break;
            }
            case 129: {
                if (cAstVisitor.visitMacroVar(cAstNode, context, cAstVisitor)) break;
                cAstVisitor.leaveMacroVar(cAstNode, context, cAstVisitor);
                break;
            }
            case 25: {
                if (cAstVisitor.visitEcho(cAstNode, context, cAstVisitor)) break;
                int n5 = 0;
                while (n5 < cAstNode.getChildCount()) {
                    cAstVisitor.visit(cAstNode.getChild(n5), context, cAstVisitor);
                    ++n5;
                }
                cAstVisitor.leaveEcho(cAstNode, context, cAstVisitor);
                break;
            }
            default: {
                if (cAstVisitor.doVisit(cAstNode, context, cAstVisitor)) break;
                System.err.println("looking at unhandled " + cAstNode + "(" + n + ")" + " of " + cAstNode.getClass());
                Assertions.UNREACHABLE((String)("cannot handle node of kind " + n));
            }
        }
        if (context != null) {
            cAstVisitor.visitScopedEntities(context.top(), context.top().getScopedEntities(cAstNode), context, cAstVisitor);
        }
        cAstVisitor.postProcessNode(cAstNode, context, cAstVisitor);
    }

    protected boolean doVisitArrayRefNode(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, boolean bl2, Context context, CAstVisitor cAstVisitor) {
        if (bl ? cAstVisitor.visitArrayRefAssign(cAstNode, cAstNode2, cAstNode3, context, cAstVisitor) : cAstVisitor.visitArrayRefAssignOp(cAstNode, cAstNode2, cAstNode3, bl2, context, cAstVisitor)) {
            return true;
        }
        cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
        cAstVisitor.visitChildren(cAstNode, 2, context, cAstVisitor);
        if (bl) {
            cAstVisitor.leaveArrayRefAssign(cAstNode, cAstNode2, cAstNode3, context, cAstVisitor);
        } else {
            cAstVisitor.leaveArrayRefAssignOp(cAstNode, cAstNode2, cAstNode3, bl2, context, cAstVisitor);
        }
        return false;
    }

    protected boolean visitAssignNodes(CAstNode cAstNode, Context context, CAstNode cAstNode2, CAstNode cAstNode3, CAstVisitor cAstVisitor) {
        int n = cAstNode3.getKind();
        boolean bl = n == 14;
        boolean bl2 = n == 15;
        switch (cAstNode.getKind()) {
            case 120: {
                if (!this.doVisitArrayRefNode(cAstNode, cAstNode2, cAstNode3, bl, bl2, context, cAstVisitor)) break;
                return true;
            }
            case 112: {
                if (bl ? cAstVisitor.visitObjectRefAssign(cAstNode, cAstNode2, cAstNode3, context, cAstVisitor) : cAstVisitor.visitObjectRefAssignOp(cAstNode, cAstNode2, cAstNode3, bl2, context, cAstVisitor)) {
                    return true;
                }
                cAstVisitor.visit(cAstNode.getChild(0), context, cAstVisitor);
                if (bl) {
                    cAstVisitor.leaveObjectRefAssign(cAstNode, cAstNode2, cAstNode3, context, cAstVisitor);
                    break;
                }
                cAstVisitor.leaveObjectRefAssignOp(cAstNode, cAstNode2, cAstNode3, bl2, context, cAstVisitor);
                break;
            }
            case 104: {
                if (bl ? cAstVisitor.visitBlockExprAssign(cAstNode, cAstNode2, cAstNode3, context, cAstVisitor) : cAstVisitor.visitBlockExprAssignOp(cAstNode, cAstNode2, cAstNode3, bl2, context, cAstVisitor)) {
                    return true;
                }
                if (cAstVisitor.visitAssignNodes(cAstNode.getChild(cAstNode.getChildCount() - 1), context, cAstNode2, cAstNode3, cAstVisitor)) {
                    return true;
                }
                if (bl) {
                    cAstVisitor.leaveBlockExprAssign(cAstNode, cAstNode2, cAstNode3, context, cAstVisitor);
                    break;
                }
                cAstVisitor.leaveBlockExprAssignOp(cAstNode, cAstNode2, cAstNode3, bl2, context, cAstVisitor);
                break;
            }
            case 111: {
                if (bl ? cAstVisitor.visitVarAssign(cAstNode, cAstNode2, cAstNode3, context, cAstVisitor) : cAstVisitor.visitVarAssignOp(cAstNode, cAstNode2, cAstNode3, bl2, context, cAstVisitor)) {
                    return true;
                }
                if (bl) {
                    cAstVisitor.leaveVarAssign(cAstNode, cAstNode2, cAstNode3, context, cAstVisitor);
                    break;
                }
                cAstVisitor.leaveVarAssignOp(cAstNode, cAstNode2, cAstNode3, bl2, context, cAstVisitor);
                break;
            }
            default: {
                if (cAstVisitor.doVisitAssignNodes(cAstNode, context, cAstNode2, cAstNode3, cAstVisitor)) break;
                System.err.println("cannot handle assign to kind " + cAstNode.getKind());
                throw new UnsupportedOperationException("cannot handle assignment: " + CAstPrinter.print(cAstNode3, context.top().getSourceMap()));
            }
        }
        return false;
    }

    protected boolean enterNode(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void postProcessNode(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
    }

    public boolean visitNode(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    public void leaveNode(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
    }

    protected boolean visitFunctionExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveFunctionExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitFunctionStmt(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveFunctionStmt(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitLocalScope(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveLocalScope(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitBlockExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveBlockExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitBlockStmt(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveBlockStmt(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitLoop(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveLoopHeader(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
    }

    protected void leaveLoop(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitGetCaughtException(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveGetCaughtException(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitThis(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveThis(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitSuper(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveSuper(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitCall(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveCall(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitVar(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveVar(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitConstant(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveConstant(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitBinaryExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveBinaryExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitUnaryExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveUnaryExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitArrayLength(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveArrayLength(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitArrayRef(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveArrayRef(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitDeclStmt(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveDeclStmt(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitReturn(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveReturn(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitIfgoto(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveIfgoto(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitGoto(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveGoto(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitLabelStmt(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveLabelStmt(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitIfStmt(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveIfStmtCondition(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
    }

    protected void leaveIfStmtTrueClause(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
    }

    protected void leaveIfStmt(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitIfExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveIfExprCondition(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
    }

    protected void leaveIfExprTrueClause(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
    }

    protected void leaveIfExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitNew(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveNew(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitObjectLiteral(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveObjectLiteralFieldInit(CAstNode cAstNode, int n, Context context, CAstVisitor cAstVisitor) {
    }

    protected void leaveObjectLiteral(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitArrayLiteral(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveArrayLiteralObject(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
    }

    protected void leaveArrayLiteralInitElement(CAstNode cAstNode, int n, Context context, CAstVisitor cAstVisitor) {
    }

    protected void leaveArrayLiteral(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitObjectRef(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveObjectRef(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    public boolean visitAssign(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    public void leaveAssign(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitArrayRefAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void leaveArrayRefAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, Context context, CAstVisitor cAstVisitor) {
    }

    protected boolean visitArrayRefAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void leaveArrayRefAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, Context context, CAstVisitor cAstVisitor) {
    }

    protected boolean visitObjectRefAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void leaveObjectRefAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, Context context, CAstVisitor cAstVisitor) {
    }

    protected boolean visitObjectRefAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void leaveObjectRefAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, Context context, CAstVisitor cAstVisitor) {
    }

    protected boolean visitBlockExprAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void leaveBlockExprAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, Context context, CAstVisitor cAstVisitor) {
    }

    protected boolean visitBlockExprAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void leaveBlockExprAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, Context context, CAstVisitor cAstVisitor) {
    }

    protected boolean visitVarAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void leaveVarAssign(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, Context context, CAstVisitor cAstVisitor) {
    }

    protected boolean visitVarAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, Context context, CAstVisitor cAstVisitor) {
        return false;
    }

    protected void leaveVarAssignOp(CAstNode cAstNode, CAstNode cAstNode2, CAstNode cAstNode3, boolean bl, Context context, CAstVisitor cAstVisitor) {
    }

    protected boolean visitSwitch(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveSwitchValue(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
    }

    protected void leaveSwitch(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitThrow(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveThrow(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitCatch(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveCatch(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitUnwind(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveUnwind(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitTry(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveTryBlock(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
    }

    protected void leaveTry(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitEmpty(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveEmpty(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitPrimitive(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leavePrimitive(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitVoid(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveVoid(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitCast(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveCast(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitInstanceOf(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveInstanceOf(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitAssert(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveAssert(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitEachElementHasNext(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveEachElementHasNext(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitEachElementGet(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveEachElementGet(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitTypeLiteralExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveTypeLiteralExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitIsDefinedExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveIsDefinedExpr(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitEcho(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveEcho(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitInclude(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveInclude(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    protected boolean visitMacroVar(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        return cAstVisitor.visitNode(cAstNode, context, cAstVisitor);
    }

    protected void leaveMacroVar(CAstNode cAstNode, Context context, CAstVisitor cAstVisitor) {
        cAstVisitor.leaveNode(cAstNode, context, cAstVisitor);
    }

    public static interface Context {
        public CAstEntity top();
    }
}

