/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.AbstractReflectionInterpreter;
import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.SetType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FactoryBypassInterpreter
extends AbstractReflectionInterpreter {
    private final Map<Context, Set<TypeReference>> map = HashMapFactory.make();
    private final Map<Context, SpecializedFactoryMethod> syntheticMethodCache = HashMapFactory.make();

    public FactoryBypassInterpreter(AnalysisOptions analysisOptions, AnalysisCache analysisCache) {
        this.options = analysisOptions;
        this.cache = analysisCache;
    }

    @Override
    public IR getIR(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        return this.cache.getSSACache().findOrCreateIR(specializedFactoryMethod, cGNode.getContext(), this.options.getSSAOptions());
    }

    private Set<TypeReference> getTypesForContext(Context context) {
        Set<TypeReference> set = this.map.get(context);
        return set;
    }

    @Override
    public int getNumberOfStatements(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        return specializedFactoryMethod.allInstructions.size();
    }

    @Override
    public boolean understands(CGNode cGNode) {
        SyntheticMethod syntheticMethod;
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (cGNode.getMethod().isSynthetic() && (syntheticMethod = (SyntheticMethod)cGNode.getMethod()).isFactoryMethod()) {
            return this.getTypesForContext(cGNode.getContext()) != null;
        }
        return false;
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        HashSet hashSet = HashSetFactory.make(5);
        for (SSANewInstruction sSANewInstruction : specializedFactoryMethod.getAllocationStatements()) {
            hashSet.add(sSANewInstruction.getNewSite());
        }
        return hashSet.iterator();
    }

    public Iterator<SSAInstruction> getInvokeStatements(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        return specializedFactoryMethod.getInvokeStatements().iterator();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode cGNode) {
        final Iterator<SSAInstruction> iterator = this.getInvokeStatements(cGNode);
        return new Iterator<CallSiteReference>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public CallSiteReference next() {
                SSAInvokeInstruction sSAInvokeInstruction = (SSAInvokeInstruction)iterator.next();
                return sSAInvokeInstruction.getCallSite();
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public boolean recordType(IClassHierarchy iClassHierarchy, Context context, TypeReference typeReference) {
        Set<TypeReference> set = this.map.get(context);
        if (set == null) {
            set = HashSetFactory.make(2);
            this.map.put(context, set);
        }
        if (set.contains(typeReference)) {
            return false;
        }
        set.add(typeReference);
        SpecializedFactoryMethod specializedFactoryMethod = this.syntheticMethodCache.get(context);
        if (specializedFactoryMethod != null) {
            TypeAbstraction typeAbstraction = this.typeRef2TypeAbstraction(iClassHierarchy, typeReference);
            specializedFactoryMethod.addStatementsForTypeAbstraction(typeAbstraction);
            this.cache.getSSACache().invalidate(specializedFactoryMethod, context);
        }
        return true;
    }

    @Override
    public boolean recordFactoryType(CGNode cGNode, IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        return this.recordType(cGNode.getMethod().getClassHierarchy(), cGNode.getContext(), iClass.getReference());
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        try {
            return CodeScanner.getFieldsRead(specializedFactoryMethod).iterator();
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        try {
            return CodeScanner.getFieldsWritten(specializedFactoryMethod).iterator();
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    private SpecializedFactoryMethod findOrCreateSpecializedFactoryMethod(CGNode cGNode) {
        SpecializedFactoryMethod specializedFactoryMethod = this.syntheticMethodCache.get(cGNode.getContext());
        if (specializedFactoryMethod == null) {
            Set<TypeReference> set = this.getTypesForContext(cGNode.getContext());
            specializedFactoryMethod = new SpecializedFactoryMethod((SummarizedMethod)cGNode.getMethod(), cGNode.getContext(), set);
            this.syntheticMethodCache.put(cGNode.getContext(), specializedFactoryMethod);
        }
        return specializedFactoryMethod;
    }

    public Set getCaughtExceptions(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        try {
            return CodeScanner.getCaughtExceptions(specializedFactoryMethod);
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public boolean hasObjectArrayLoad(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        try {
            return CodeScanner.hasObjectArrayLoad(specializedFactoryMethod);
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return false;
        }
    }

    public boolean hasObjectArrayStore(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        try {
            return CodeScanner.hasObjectArrayStore(specializedFactoryMethod);
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return false;
        }
    }

    public Iterator iterateCastTypes(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        try {
            return CodeScanner.iterateCastTypes(specializedFactoryMethod);
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode cGNode) {
        return this.getIR(cGNode).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod specializedFactoryMethod = this.findOrCreateSpecializedFactoryMethod(cGNode);
        return this.cache.getSSACache().findOrCreateDU(specializedFactoryMethod, cGNode.getContext(), this.options.getSSAOptions());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecializedFactoryMethod
    extends AbstractReflectionInterpreter.SpecializedMethod {
        private final ArrayList<SSAInstruction> calls;
        private final IMethod method;
        private final Context context;
        private int nextLocal;
        private int valueNumberForConstantOne;
        private final SSAInstructionFactory insts;

        private void initValueNumberForConstantOne() {
            if (this.valueNumberForConstantOne == -1) {
                this.valueNumberForConstantOne = this.nextLocal++;
            }
        }

        protected SpecializedFactoryMethod(SummarizedMethod summarizedMethod, Context context, Set set) {
            super(summarizedMethod, summarizedMethod.getDeclaringClass(), summarizedMethod.isStatic(), true);
            this.calls = new ArrayList();
            this.valueNumberForConstantOne = -1;
            this.insts = this.declaringClass.getClassLoader().getInstructionFactory();
            this.context = context;
            this.method = summarizedMethod;
            assert (set != null);
            assert (summarizedMethod.getDeclaringClass() != null) : "null declaring class for " + summarizedMethod;
            this.nextLocal = this.addOriginalStatements(summarizedMethod);
            for (TypeReference typeReference : set) {
                TypeAbstraction typeAbstraction = FactoryBypassInterpreter.this.typeRef2TypeAbstraction(summarizedMethod.getClassHierarchy(), typeReference);
                this.addStatementsForTypeAbstraction(typeAbstraction);
            }
        }

        protected void addStatementsForTypeAbstraction(TypeAbstraction typeAbstraction) {
            if ((typeAbstraction = this.interceptType(typeAbstraction)) == null) {
                return;
            }
            if (typeAbstraction instanceof PointType || typeAbstraction instanceof ConeType) {
                TypeReference typeReference = typeAbstraction.getType().getReference();
                NewSiteReference newSiteReference = NewSiteReference.make(0, typeReference);
                if (typeAbstraction instanceof PointType) {
                    if (!this.typesAllocated.contains(typeReference)) {
                        this.addStatementsForConcreteType(typeReference);
                    }
                } else if (typeAbstraction instanceof ConeType) {
                    if (((ConeType)typeAbstraction).isInterface()) {
                        Set<IClass> set = typeAbstraction.getType().getClassHierarchy().getImplementors(typeReference);
                        if (set.isEmpty()) {
                            Warnings.add(AbstractReflectionInterpreter.NoSubtypesWarning.create(typeAbstraction));
                        }
                        if (set.size() > 10) {
                            Warnings.add(AbstractReflectionInterpreter.ManySubtypesWarning.create(typeAbstraction, set.size()));
                        }
                        this.addStatementsForSetOfTypes(set.iterator());
                    } else {
                        Collection<IClass> collection = typeAbstraction.getType().getClassHierarchy().computeSubClasses(typeReference);
                        if (collection.isEmpty()) {
                            Warnings.add(AbstractReflectionInterpreter.NoSubtypesWarning.create(typeAbstraction));
                        }
                        if (collection.size() > 10) {
                            Warnings.add(AbstractReflectionInterpreter.ManySubtypesWarning.create(typeAbstraction, collection.size()));
                        }
                        this.addStatementsForSetOfTypes(collection.iterator());
                    }
                } else {
                    Assertions.UNREACHABLE("Unexpected type " + typeAbstraction.getClass());
                }
            } else if (typeAbstraction instanceof SetType) {
                Assertions.UNREACHABLE();
            } else {
                Assertions.UNREACHABLE("Unexpected type " + typeAbstraction.getClass());
            }
        }

        private TypeAbstraction interceptType(TypeAbstraction typeAbstraction) {
            TypeReference typeReference = typeAbstraction.getType().getReference();
            if (typeReference.equals(TypeReference.JavaIoSerializable)) {
                Warnings.add(AbstractReflectionInterpreter.IgnoreSerializableWarning.create());
                return null;
            }
            return typeAbstraction;
        }

        private void addStatementsForConcreteType(TypeReference typeReference) {
            int n = this.addStatementsForConcreteSimpleType(typeReference);
            if (n == -1) {
                return;
            }
            if (typeReference.isArrayType()) {
                MethodReference methodReference = MethodReference.findOrCreate(typeReference, MethodReference.initAtom, MethodReference.defaultInitDesc);
                CallSiteReference callSiteReference = CallSiteReference.make(FactoryBypassInterpreter.this.getCallSiteForType(typeReference), methodReference, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
                int[] nArray = new int[]{n};
                int n2 = FactoryBypassInterpreter.this.getExceptionsForType(typeReference);
                SSAInvokeInstruction sSAInvokeInstruction = this.insts.InvokeInstruction(nArray, n2, callSiteReference);
                this.calls.add(sSAInvokeInstruction);
                this.allInstructions.add(sSAInvokeInstruction);
            }
        }

        private int addOriginalStatements(SummarizedMethod summarizedMethod) {
            SSAInstruction[] sSAInstructionArray = summarizedMethod.getStatements(FactoryBypassInterpreter.this.options.getSSAOptions());
            int n = 2;
            int n2 = 0;
            while (n2 < sSAInstructionArray.length) {
                int n3;
                SSAInstruction sSAInstruction = sSAInstructionArray[n2];
                this.allInstructions.add(sSAInstruction);
                if (sSAInstruction instanceof SSAInvokeInstruction) {
                    this.calls.add(sSAInstruction);
                }
                if (sSAInstruction instanceof SSANewInstruction) {
                    this.allocations.add(sSAInstruction);
                }
                int n4 = 0;
                while (n4 < sSAInstruction.getNumberOfDefs()) {
                    n3 = sSAInstruction.getDef(n4);
                    if (n3 >= n) {
                        n = n3 + 1;
                    }
                    ++n4;
                }
                n4 = 0;
                while (n4 < sSAInstruction.getNumberOfUses()) {
                    n3 = sSAInstruction.getUse(n4);
                    if (n3 >= n) {
                        n = n3 + 1;
                    }
                    ++n4;
                }
                ++n2;
            }
            return n;
        }

        private void addStatementsForSetOfTypes(Iterator<IClass> iterator) {
            Object object;
            if (!iterator.hasNext()) {
                object = this.insts.ReturnInstruction(this.nextLocal, false);
                this.allInstructions.add(object);
            }
            while (iterator.hasNext()) {
                Object object2;
                object = iterator.next();
                TypeReference typeReference = object.getReference();
                if (object.isAbstract() || object.isInterface() || this.typesAllocated.contains(typeReference)) continue;
                this.typesAllocated.add(typeReference);
                int n = FactoryBypassInterpreter.this.getLocalForType(typeReference);
                NewSiteReference newSiteReference = NewSiteReference.make(FactoryBypassInterpreter.this.getNewSiteForType(typeReference), typeReference);
                SSANewInstruction sSANewInstruction = null;
                if (typeReference.isArrayType()) {
                    object2 = new int[typeReference.getDimensionality()];
                    this.initValueNumberForConstantOne();
                    Arrays.fill(object2, this.valueNumberForConstantOne);
                    sSANewInstruction = this.insts.NewInstruction(n, newSiteReference, (int[])object2);
                } else {
                    sSANewInstruction = this.insts.NewInstruction(n, newSiteReference);
                }
                this.allocations.add(sSANewInstruction);
                this.allInstructions.add(sSANewInstruction);
                object2 = this.insts.ReturnInstruction(n, false);
                this.allInstructions.add(object2);
                MethodReference methodReference = MethodReference.findOrCreate(typeReference, MethodReference.initAtom, MethodReference.defaultInitDesc);
                CallSiteReference callSiteReference = CallSiteReference.make(FactoryBypassInterpreter.this.getCallSiteForType(typeReference), methodReference, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
                int[] nArray = new int[]{n};
                SSAInvokeInstruction sSAInvokeInstruction = this.insts.InvokeInstruction(nArray, FactoryBypassInterpreter.this.getExceptionsForType(typeReference), callSiteReference);
                this.calls.add(sSAInvokeInstruction);
                this.allInstructions.add(sSAInvokeInstruction);
            }
        }

        public List<SSAInstruction> getAllocationStatements() {
            return this.allocations;
        }

        public List<SSAInstruction> getInvokeStatements() {
            return this.calls;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public SSAInstruction[] getStatements() {
            SSAInstruction[] sSAInstructionArray = new SSAInstruction[this.allInstructions.size()];
            int n = 0;
            Iterator iterator = this.allInstructions.iterator();
            while (iterator.hasNext()) {
                sSAInstructionArray[n++] = (SSAInstruction)iterator.next();
            }
            return sSAInstructionArray;
        }

        @Override
        public IClass getDeclaringClass() {
            assert (this.method.getDeclaringClass() != null) : "null declaring class for original method " + this.method;
            return this.method.getDeclaringClass();
        }

        @Override
        public int getNumberOfParameters() {
            return this.method.getNumberOfParameters();
        }

        @Override
        public TypeReference getParameterType(int n) {
            return this.method.getParameterType(n);
        }

        @Override
        public IR makeIR(Context context, SSAOptions sSAOptions) {
            SSAInstruction[] sSAInstructionArray = this.getStatements();
            HashMap<Integer, ConstantValue> hashMap = null;
            if (this.valueNumberForConstantOne > -1) {
                hashMap = HashMapFactory.make(1);
                hashMap.put(new Integer(this.valueNumberForConstantOne), new ConstantValue(new Integer(1)));
            }
            return new SyntheticIR(this, this.context, new InducedCFG(sSAInstructionArray, this, this.context), sSAInstructionArray, sSAOptions, hashMap);
        }
    }
}

