/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.AbstractReflectionInterpreter;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveInvocationInterpreter
extends AbstractReflectionInterpreter {
    public static final MethodReference CTOR_NEW_INSTANCE = MethodReference.findOrCreate(TypeReference.JavaLangReflectConstructor, "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;");
    public static final MethodReference METHOD_INVOKE = MethodReference.findOrCreate(TypeReference.JavaLangReflectMethod, "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");

    @Override
    public IR getIR(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(cGNode));
        ReceiverInstanceContext receiverInstanceContext = (ReceiverInstanceContext)cGNode.getContext();
        ConstantKey constantKey = (ConstantKey)receiverInstanceContext.getReceiver();
        IMethod iMethod = (IMethod)constantKey.getValue();
        IR iR = this.makeIR(cGNode.getMethod(), iMethod, receiverInstanceContext);
        return iR;
    }

    @Override
    public int getNumberOfStatements(CGNode cGNode) {
        assert (this.understands(cGNode));
        return this.getIR(cGNode).getInstructions().length;
    }

    @Override
    public boolean understands(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!(cGNode.getContext() instanceof ReceiverInstanceContext)) {
            return false;
        }
        ReceiverInstanceContext receiverInstanceContext = (ReceiverInstanceContext)cGNode.getContext();
        if (!(receiverInstanceContext.getReceiver() instanceof ConstantKey)) {
            return false;
        }
        return cGNode.getMethod().getReference().equals(METHOD_INVOKE) || cGNode.getMethod().getReference().equals(CTOR_NEW_INSTANCE);
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(cGNode));
        return this.getIR(cGNode).iterateNewSites();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode cGNode) {
        assert (this.understands(cGNode));
        return this.getIR(cGNode).iterateCallSites();
    }

    private IR makeIR(IMethod iMethod, IMethod iMethod2, ReceiverInstanceContext receiverInstanceContext) {
        int n;
        TypeReference typeReference;
        SSAInstructionFactory sSAInstructionFactory = iMethod.getDeclaringClass().getClassLoader().getInstructionFactory();
        AbstractReflectionInterpreter.SpecializedMethod specializedMethod = (AbstractReflectionInterpreter)this.new AbstractReflectionInterpreter.SpecializedMethod(iMethod, iMethod.getDeclaringClass(), iMethod.isStatic(), false);
        HashMap<Integer, ConstantValue> hashMap = HashMapFactory.make();
        int n2 = iMethod.getNumberOfParameters() + 1;
        int n3 = iMethod2.getNumberOfParameters();
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = -1;
        if (iMethod.getReference().equals(CTOR_NEW_INSTANCE)) {
            typeReference = iMethod2.getDeclaringClass().getReference();
            nArray[0] = n2++;
            specializedMethod.addInstruction(typeReference, sSAInstructionFactory.NewInstruction(nArray[0], NewSiteReference.make(n4++, typeReference)), true);
            n5 = 2;
        } else {
            n5 = 3;
            if (!iMethod2.isStatic()) {
                nArray[0] = n2++;
                typeReference = iMethod2.getParameterType(0);
                SSACheckCastInstruction sSACheckCastInstruction = sSAInstructionFactory.CheckCastInstruction(nArray[0], 2, typeReference);
                specializedMethod.addInstruction(null, sSACheckCastInstruction, false);
            }
        }
        int n6 = iMethod2.isStatic() ? 0 : 1;
        int n7 = 0;
        int n8 = n6;
        while (n8 < n3) {
            n = n2++;
            hashMap.put(new Integer(n), new ConstantValue(n7++));
            int n9 = n2++;
            specializedMethod.addInstruction(null, sSAInstructionFactory.ArrayLoadInstruction(n9, n5, n, TypeReference.JavaLangObject), false);
            ++n4;
            nArray[n8] = n2++;
            TypeReference typeReference2 = iMethod2.getParameterType(n8);
            SSACheckCastInstruction sSACheckCastInstruction = sSAInstructionFactory.CheckCastInstruction(nArray[n8], n9, typeReference2);
            specializedMethod.addInstruction(null, sSACheckCastInstruction, false);
            ++n4;
            ++n8;
        }
        n8 = n2++;
        n = -1;
        if (iMethod.getReference().equals(CTOR_NEW_INSTANCE)) {
            specializedMethod.addInstruction(null, sSAInstructionFactory.InvokeInstruction(nArray, n8, CallSiteReference.make(n4++, iMethod2.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL)), false);
            specializedMethod.addInstruction(null, sSAInstructionFactory.ReturnInstruction(nArray[0], false), false);
        } else {
            IInvokeInstruction.Dispatch dispatch;
            IInvokeInstruction.Dispatch dispatch2 = dispatch = iMethod2.isStatic() ? IInvokeInstruction.Dispatch.STATIC : IInvokeInstruction.Dispatch.VIRTUAL;
            if (iMethod2.getReturnType().equals(TypeReference.Void)) {
                specializedMethod.addInstruction(null, sSAInstructionFactory.InvokeInstruction(nArray, n8, CallSiteReference.make(n4++, iMethod2.getReference(), (IInvokeInstruction.IDispatch)dispatch)), false);
            } else {
                n = n2++;
                specializedMethod.addInstruction(null, sSAInstructionFactory.InvokeInstruction(n, nArray, n8, CallSiteReference.make(n4++, iMethod2.getReference(), (IInvokeInstruction.IDispatch)dispatch)), false);
                specializedMethod.addInstruction(null, sSAInstructionFactory.ReturnInstruction(n, false), false);
            }
        }
        SSAInstruction[] sSAInstructionArray = new SSAInstruction[specializedMethod.allInstructions.size()];
        specializedMethod.allInstructions.toArray(sSAInstructionArray);
        return new SyntheticIR(iMethod, receiverInstanceContext, new InducedCFG(sSAInstructionArray, iMethod, receiverInstanceContext), sSAInstructionArray, SSAOptions.defaultOptions(), hashMap);
    }

    @Override
    public boolean recordFactoryType(CGNode cGNode, IClass iClass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode cGNode) {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode cGNode) {
        return EmptyIterator.instance();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode cGNode) {
        return this.getIR(cGNode).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode cGNode) {
        return new DefUse(this.getIR(cGNode));
    }
}

