/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeVariable;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dataflow.ssa.SSAInference;
import com.ibm.wala.fixedpoint.impl.AbstractOperator;
import com.ibm.wala.fixedpoint.impl.NullaryOperator;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IVisitorWithAddresses;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadIndirectInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAStoreIndirectInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInference
extends SSAInference<TypeVariable>
implements FixedPointConstants {
    private static final boolean DEBUG = false;
    protected final IR ir;
    protected final IClassHierarchy cha;
    protected final Language language;
    private static final AbstractOperator<TypeVariable> phiOp = new PhiOperator();
    private static final AbstractOperator<TypeVariable> primitivePropagateOp = new PrimitivePropagateOperator();
    protected final TypeAbstraction BOTTOM;
    private static final PiOperator piOp = new PiOperator();
    protected final boolean doPrimitives;
    private boolean solved = false;

    public static TypeInference make(IR iR, boolean bl) {
        return new TypeInference(iR, bl);
    }

    protected TypeInference(IR iR, boolean bl) {
        if (iR == null) {
            throw new IllegalArgumentException("ir is null");
        }
        this.language = iR.getMethod().getDeclaringClass().getClassLoader().getLanguage();
        this.cha = iR.getMethod().getDeclaringClass().getClassHierarchy();
        this.ir = iR;
        this.doPrimitives = bl;
        this.BOTTOM = new ConeType(this.cha.getRootClass());
        this.initialize();
        this.solve();
    }

    public boolean solve() {
        return this.solve(null);
    }

    @Override
    public boolean solve(IProgressMonitor iProgressMonitor) {
        block3: {
            try {
                if (!this.solved) break block3;
                return false;
            }
            catch (CancelException cancelException) {
                throw new CancelRuntimeException(cancelException);
            }
        }
        boolean bl = super.solve(null);
        this.solved = true;
        return bl;
    }

    protected void initialize() {
        this.init(this.ir, new TypeVarFactory(), new TypeOperatorFactory());
    }

    @Override
    protected void initializeVariables() {
        Object object;
        Object object2;
        Object object3;
        int[] nArray = this.ir.getParameterValueNumbers();
        int n = 0;
        while (n < nArray.length) {
            object3 = (TypeVariable)this.getVariable(nArray[n]);
            object2 = this.ir.getParameterType(n);
            if (((TypeReference)object2).isReferenceType()) {
                object = this.cha.lookupClass((TypeReference)object2);
                if (object != null) {
                    ((TypeVariable)object3).setType(new ConeType((IClass)object));
                } else {
                    ((TypeVariable)object3).setType(this.BOTTOM);
                }
            } else if (this.doPrimitives) {
                ((TypeVariable)object3).setType(this.language.getPrimitive((TypeReference)object2));
            }
            ++n;
        }
        SymbolTable symbolTable = this.ir.getSymbolTable();
        if (symbolTable != null) {
            int n2 = 0;
            while (n2 <= symbolTable.getMaxValueNumber()) {
                if (symbolTable.isConstant(n2)) {
                    object2 = (TypeVariable)this.getVariable(n2);
                    ((TypeVariable)object2).setType(this.getConstantType(n2));
                }
                ++n2;
            }
        }
        object3 = this.ir.iterateNormalInstructions();
        while (object3.hasNext()) {
            object2 = (SSAInstruction)object3.next();
            if (!(object2 instanceof SSAAbstractInvokeInstruction)) continue;
            object = (SSAAbstractInvokeInstruction)object2;
            TypeVariable typeVariable = (TypeVariable)this.getVariable(((SSAAbstractInvokeInstruction)object).getException());
            Collection<TypeReference> collection = ((SSAInstruction)object).getExceptionTypes();
            if (collection.size() == 0) continue;
            Iterator<TypeReference> iterator = collection.iterator();
            TypeReference typeReference = iterator.next();
            IClass iClass = this.cha.lookupClass(typeReference);
            if (iClass == null) {
                typeVariable.setType(this.BOTTOM);
            } else {
                typeVariable.setType(new PointType(iClass));
            }
            while (iterator.hasNext()) {
                typeReference = iterator.next();
                iClass = this.cha.lookupClass(typeReference);
                if (iClass == null) continue;
                typeVariable.setType(typeVariable.getType().meet(new PointType(iClass)));
            }
            IMethod iMethod = this.cha.resolveMethod(((SSAAbstractInvokeInstruction)object).getDeclaredTarget());
            if (iMethod == null) continue;
            TypeReference[] typeReferenceArray = null;
            try {
                typeReferenceArray = iMethod.getDeclaredExceptions();
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                typeReferenceArray = new TypeReference[]{this.language.getThrowableType()};
            }
            if (typeReferenceArray == null) continue;
            int n3 = 0;
            while (n3 < typeReferenceArray.length) {
                TypeReference typeReference2 = typeReferenceArray[n3];
                IClass iClass2 = this.cha.lookupClass(typeReference2);
                if (iClass2 != null) {
                    typeVariable.setType(typeVariable.getType().meet(new ConeType(iClass2)));
                }
                ++n3;
            }
        }
    }

    @Override
    protected void initializeWorkList() {
        this.addAllStatementsToWorkList();
    }

    public IR getIR() {
        return this.ir;
    }

    public TypeAbstraction getType(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("bad value number " + n);
        }
        assert (this.getVariable(n) != null) : "null variable for value number " + n;
        return ((TypeVariable)this.getVariable(n)).getType();
    }

    public TypeAbstraction getConstantType(int n) {
        if (this.ir.getSymbolTable().isStringConstant(n)) {
            return new PointType(this.cha.lookupClass(this.language.getStringType()));
        }
        return this.getConstantPrimitiveType(n);
    }

    public TypeAbstraction getConstantPrimitiveType(int n) {
        SymbolTable symbolTable = this.ir.getSymbolTable();
        if (!symbolTable.isConstant(n) || symbolTable.isNullConstant(n)) {
            return TypeAbstraction.TOP;
        }
        return this.language.getPrimitive(this.language.getConstantType(symbolTable.getConstantValue(n)));
    }

    public boolean isUndefined(int n) {
        if (this.getVariable(n) == null) {
            return true;
        }
        TypeAbstraction typeAbstraction = ((TypeVariable)this.getVariable(n)).getType();
        return typeAbstraction == this.BOTTOM || typeAbstraction.getType() == null;
    }

    public TypeAbstraction[] extractAllResults() {
        int n = this.ir.getSymbolTable().getMaxValueNumber() + 1;
        TypeAbstraction[] typeAbstractionArray = new TypeAbstraction[n];
        int n2 = 0;
        while (n2 < n) {
            TypeVariable typeVariable = (TypeVariable)this.getVariable(n2);
            typeAbstractionArray[n2] = typeVariable == null ? null : typeVariable.getType();
            ++n2;
        }
        return typeAbstractionArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class DeclaredTypeOperator
    extends NullaryOperator<TypeVariable> {
        private final TypeAbstraction type;

        public DeclaredTypeOperator(TypeAbstraction typeAbstraction) {
            assert (typeAbstraction != null);
            this.type = typeAbstraction;
        }

        @Override
        public byte evaluate(TypeVariable typeVariable) {
            if (typeVariable.type.equals(this.type)) {
                return 2;
            }
            typeVariable.setType(this.type);
            return 3;
        }

        @Override
        public String toString() {
            return "delared type := " + this.type;
        }

        public boolean isNullary() {
            return true;
        }

        @Override
        public int hashCode() {
            return 9931 * this.type.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof DeclaredTypeOperator) {
                DeclaredTypeOperator declaredTypeOperator = (DeclaredTypeOperator)object;
                return this.type.equals(declaredTypeOperator.type);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GetElementType
    extends AbstractOperator<TypeVariable> {
        private final SSAArrayLoadInstruction load;

        GetElementType(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            this.load = sSAArrayLoadInstruction;
        }

        @Override
        public byte evaluate(TypeVariable typeVariable, IVariable[] iVariableArray) {
            TypeAbstraction typeAbstraction = TypeInference.this.getType(this.load.getArrayRef());
            if (typeAbstraction == null || typeAbstraction.equals(TypeAbstraction.TOP)) {
                return 0;
            }
            TypeReference typeReference = null;
            if (typeAbstraction instanceof PointType) {
                typeReference = ((PointType)typeAbstraction).getType().getReference().getArrayElementType();
            } else if (typeAbstraction instanceof ConeType) {
                typeReference = ((ConeType)typeAbstraction).getType().getReference().getArrayElementType();
            } else {
                Assertions.UNREACHABLE("Unexpected type " + typeAbstraction.getClass());
            }
            if (typeReference.isPrimitiveType()) {
                if (TypeInference.this.doPrimitives && typeVariable.getType() == TypeAbstraction.TOP) {
                    typeVariable.setType(PrimitiveType.getPrimitive(typeReference));
                    return 1;
                }
                return 0;
            }
            if (typeVariable.getType() != TypeAbstraction.TOP) {
                TypeReference typeReference2 = null;
                if (typeVariable.getType() instanceof PointType) {
                    typeReference2 = ((PointType)typeVariable.getType()).getType().getReference();
                } else if (typeVariable.getType() instanceof ConeType) {
                    typeReference2 = ((ConeType)typeVariable.getType()).getType().getReference();
                } else {
                    Assertions.UNREACHABLE("Unexpected type " + typeVariable.getType().getClass());
                }
                if (typeReference2.equals(typeReference)) {
                    return 0;
                }
                IClass iClass = TypeInference.this.cha.lookupClass(typeReference);
                assert (iClass != null);
                typeVariable.setType(new ConeType(iClass));
                return 1;
            }
            IClass iClass = TypeInference.this.cha.lookupClass(typeReference);
            if (iClass != null) {
                typeVariable.setType(new ConeType(iClass));
            } else {
                typeVariable.setType(TypeAbstraction.TOP);
            }
            return 1;
        }

        @Override
        public String toString() {
            return "getElementType " + this.load;
        }

        @Override
        public int hashCode() {
            return 9923 * this.load.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof GetElementType) {
                GetElementType getElementType = (GetElementType)object;
                return this.load.equals(getElementType.load);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PhiOperator
    extends AbstractOperator<TypeVariable> {
        private PhiOperator() {
        }

        @Override
        public byte evaluate(TypeVariable typeVariable, IVariable[] iVariableArray) {
            TypeAbstraction typeAbstraction = typeVariable.getType();
            TypeAbstraction typeAbstraction2 = TypeAbstraction.TOP;
            int n = 0;
            while (n < iVariableArray.length) {
                if (iVariableArray[n] != null && ((TypeVariable)iVariableArray[n]).getType() != null) {
                    TypeVariable typeVariable2 = (TypeVariable)iVariableArray[n];
                    typeAbstraction2 = typeAbstraction2.meet(typeVariable2.getType());
                }
                ++n;
            }
            if (typeAbstraction.equals(typeAbstraction2)) {
                return 0;
            }
            typeVariable.setType(typeAbstraction2);
            return 1;
        }

        @Override
        public String toString() {
            return "phi meet";
        }

        @Override
        public int hashCode() {
            return 9929;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof PhiOperator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PiOperator
    extends AbstractOperator<TypeVariable> {
        private PiOperator() {
        }

        @Override
        public byte evaluate(TypeVariable typeVariable, IVariable[] iVariableArray) {
            TypeVariable typeVariable2;
            TypeAbstraction typeAbstraction;
            TypeAbstraction typeAbstraction2 = typeVariable.getType();
            if (typeAbstraction2.equals(typeAbstraction = (typeVariable2 = (TypeVariable)iVariableArray[0]).getType())) {
                return 0;
            }
            typeVariable.setType(typeAbstraction);
            return 1;
        }

        @Override
        public String toString() {
            return "pi";
        }

        @Override
        public int hashCode() {
            return 129077;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof PiOperator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrimitivePropagateOperator
    extends AbstractOperator<TypeVariable> {
        protected PrimitivePropagateOperator() {
        }

        @Override
        public byte evaluate(TypeVariable typeVariable, IVariable[] iVariableArray) {
            TypeAbstraction typeAbstraction = typeVariable.getType();
            TypeAbstraction typeAbstraction2 = TypeAbstraction.TOP;
            int n = 0;
            while (n < iVariableArray.length) {
                if (iVariableArray[n] != null && ((TypeVariable)iVariableArray[n]).getType() != null) {
                    TypeVariable typeVariable2 = (TypeVariable)iVariableArray[n];
                    typeAbstraction2 = typeAbstraction2.meet(typeVariable2.getType());
                }
                ++n;
            }
            if (typeAbstraction.equals(typeAbstraction2)) {
                return 0;
            }
            typeVariable.setType(typeAbstraction2);
            return 1;
        }

        @Override
        public String toString() {
            return "propagate";
        }

        @Override
        public int hashCode() {
            return 99292;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object.getClass().equals(this.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TypeOperatorFactory
    extends SSAInstruction.Visitor
    implements IVisitorWithAddresses,
    SSAInference.OperatorFactory<TypeVariable> {
        protected AbstractOperator<TypeVariable> result = null;

        protected TypeOperatorFactory() {
        }

        @Override
        public AbstractOperator<TypeVariable> get(SSAInstruction sSAInstruction) {
            sSAInstruction.visit(this);
            AbstractOperator<TypeVariable> abstractOperator = this.result;
            this.result = null;
            return abstractOperator;
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            this.result = new GetElementType(sSAArrayLoadInstruction);
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction sSAArrayLengthInstruction) {
            this.result = !TypeInference.this.doPrimitives ? null : new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(TypeInference.this.language.getConstantType(new Integer(1))));
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction sSALoadMetadataInstruction) {
            IClass iClass = TypeInference.this.cha.lookupClass(TypeInference.this.language.getMetadataType());
            assert (iClass != null);
            this.result = new DeclaredTypeOperator(new ConeType(iClass));
        }

        @Override
        public void visitGet(SSAGetInstruction sSAGetInstruction) {
            IClass iClass;
            TypeReference typeReference = sSAGetInstruction.getDeclaredFieldType();
            this.result = TypeInference.this.doPrimitives && typeReference.isPrimitiveType() ? new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(typeReference)) : ((iClass = TypeInference.this.cha.lookupClass(typeReference)) == null ? new DeclaredTypeOperator(TypeInference.this.BOTTOM) : new DeclaredTypeOperator(new ConeType(iClass)));
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction sSAInvokeInstruction) {
            IClass iClass;
            TypeReference typeReference = sSAInvokeInstruction.getDeclaredResultType();
            this.result = typeReference.isReferenceType() ? ((iClass = TypeInference.this.cha.lookupClass(typeReference)) == null ? new DeclaredTypeOperator(TypeInference.this.BOTTOM) : new DeclaredTypeOperator(new ConeType(iClass))) : (TypeInference.this.doPrimitives && typeReference.isPrimitiveType() ? new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(typeReference)) : null);
        }

        @Override
        public void visitNew(SSANewInstruction sSANewInstruction) {
            TypeReference typeReference = sSANewInstruction.getConcreteType();
            IClass iClass = TypeInference.this.cha.lookupClass(typeReference);
            this.result = iClass == null ? new DeclaredTypeOperator(TypeInference.this.BOTTOM) : new DeclaredTypeOperator(new PointType(iClass));
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction sSACheckCastInstruction) {
            TypeAbstraction typeAbstraction = null;
            TypeReference[] typeReferenceArray = sSACheckCastInstruction.getDeclaredResultTypes();
            int n = typeReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeReference typeReference = typeReferenceArray[n2];
                IClass iClass = TypeInference.this.cha.lookupClass(typeReference);
                typeAbstraction = iClass == null ? TypeInference.this.BOTTOM : (typeAbstraction == null ? new ConeType(iClass) : typeAbstraction.meet(new ConeType(iClass)));
                ++n2;
            }
            this.result = new DeclaredTypeOperator(typeAbstraction);
        }

        @Override
        public void visitConversion(SSAConversionInstruction sSAConversionInstruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(sSAConversionInstruction.getToType()));
            }
        }

        @Override
        public void visitComparison(SSAComparisonInstruction sSAComparisonInstruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(TypeInference.this.language.getConstantType(new Integer(0))));
            }
        }

        @Override
        public void visitBinaryOp(SSABinaryOpInstruction sSABinaryOpInstruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = primitivePropagateOp;
            }
        }

        @Override
        public void visitUnaryOp(SSAUnaryOpInstruction sSAUnaryOpInstruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = primitivePropagateOp;
            }
        }

        @Override
        public void visitInstanceof(SSAInstanceofInstruction sSAInstanceofInstruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(TypeInference.this.language.getConstantType(Boolean.TRUE)));
            }
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
            TypeAbstraction typeAbstraction = this.meetDeclaredExceptionTypes(sSAGetCaughtExceptionInstruction);
            this.result = new DeclaredTypeOperator(typeAbstraction);
        }

        @Override
        public void visitPhi(SSAPhiInstruction sSAPhiInstruction) {
            this.result = phiOp;
        }

        @Override
        public void visitPi(SSAPiInstruction sSAPiInstruction) {
            this.result = piOp;
        }

        private TypeAbstraction meetDeclaredExceptionTypes(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
            SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)TypeInference.this.ir.getControlFlowGraph().getNode(sSAGetCaughtExceptionInstruction.getBasicBlockNumber());
            Iterator<TypeReference> iterator = exceptionHandlerBasicBlock.getCaughtExceptionTypes();
            TypeReference typeReference = iterator.next();
            IClass iClass = TypeInference.this.cha.lookupClass(typeReference);
            TypeAbstraction typeAbstraction = null;
            typeAbstraction = iClass == null ? TypeInference.this.BOTTOM : new ConeType(iClass);
            while (iterator.hasNext()) {
                typeReference = iterator.next();
                IClass iClass2 = TypeInference.this.cha.lookupClass(typeReference);
                typeAbstraction = iClass2 == null ? TypeInference.this.BOTTOM : typeAbstraction.meet(new ConeType(iClass2));
            }
            return typeAbstraction;
        }

        private DeclaredTypeOperator getPointerTypeOperator(TypeReference typeReference) {
            if (typeReference.isPrimitiveType()) {
                return new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(typeReference));
            }
            IClass iClass = TypeInference.this.cha.lookupClass(typeReference);
            if (iClass == null) {
                return new DeclaredTypeOperator(TypeInference.this.BOTTOM);
            }
            return new DeclaredTypeOperator(new ConeType(iClass));
        }

        @Override
        public void visitAddressOf(SSAAddressOfInstruction sSAAddressOfInstruction) {
            TypeReference typeReference = TypeInference.this.language.getPointerType(sSAAddressOfInstruction.getType());
            this.result = this.getPointerTypeOperator(typeReference);
        }

        @Override
        public void visitLoadIndirect(SSALoadIndirectInstruction sSALoadIndirectInstruction) {
            this.result = this.getPointerTypeOperator(sSALoadIndirectInstruction.getLoadedType());
        }

        @Override
        public void visitStoreIndirect(SSAStoreIndirectInstruction sSAStoreIndirectInstruction) {
            Assertions.UNREACHABLE();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TypeVarFactory
    implements SSAInference.VariableFactory {
        @Override
        public IVariable makeVariable(int n) {
            SymbolTable symbolTable = TypeInference.this.ir.getSymbolTable();
            if (TypeInference.this.doPrimitives && symbolTable.isConstant(n) && symbolTable.isBooleanConstant(n)) {
                return new TypeVariable(TypeInference.this.language.getPrimitive(TypeInference.this.language.getConstantType(Boolean.TRUE)));
            }
            return new TypeVariable(TypeAbstraction.TOP);
        }
    }
}

